#pragma once

#include "Shader.h"
#include "geometrybuffer.h"
#include "vertexformats.h"

class Shader_Postprocess : public Shader
{
private:
	static GeometryBuffer *quadGeometryBuffer;
	static ID3D10InputLayout *quadInputLayout;
	static ID3D10EffectPool *pool;

	struct _variables
	{		
		ID3D10EffectShaderResourceVariable* inputTexture;		
		ID3D10EffectVectorVariable* viewPort;
		ID3D10EffectVectorVariable* inputTextureOffset;
		ID3D10EffectScalarVariable* elapsedTime;
	};
	
protected:
	void setViewPort(int x, int y) const;

	
public:
	static _variables variables;

	Shader_Postprocess(ID3D10Device *device);
	~Shader_Postprocess();
	bool compile(const D3D10_SHADER_MACRO *macros, DWORD shaderFlags);
	bool compilePostProcessingShader(const wchar_t* filename, const D3D10_SHADER_MACRO *macros, DWORD shaderFlags);
	virtual void setInputTexture(ID3D10ShaderResourceView *texture);	
	void setElapsedTime(float t);
	void setInputTextureOffset(int left, int top) const;
};