#pragma once

#include "shader_unreal.h"
#include "texturecache.h"

class Shader_ComplexSurface : public Shader_Unreal
{
private:
	struct 
	{
		ID3D10EffectScalarVariable* useTexturePass; /**< Bool whether to use each texture pass (shader side) */
		ID3D10EffectShaderResourceVariable* textures;
	} variables;
	static const int numBools = TextureCache::DUMMY_NUM_TEXTURE_PASSES -1; //-1 because diffuse is always enabled
	bool enableChanged;
	BOOL useTexturePass[numBools];
	
public:	
	bool compile(const D3D10_SHADER_MACRO *macros, DWORD shaderFlags);
	Shader_ComplexSurface(ID3D10Device *device);
	void switchPass(TextureCache::TexturePass pass,BOOL val) ;
	void apply();	
	void Shader_ComplexSurface::setTexture(int pass,ID3D10ShaderResourceView *texture) const;	
};