/*=============================================================================
	OpenGLFuncs.h: OpenGL function-declaration macros.

	Copyright 1999 Epic Games, Inc. All Rights Reserved.

	Revision history:
		* Created by Daniel Vogel (based on XMesaGLDrv)
		* GLX function declarations removed by  Daniel Vogel
		* WGL function re-introduced Fredrik Gustafsson
		* Unified by Daniel Vogel
=============================================================================*/

/*-----------------------------------------------------------------------------
	Standard OpenGL functions.
-----------------------------------------------------------------------------*/

#ifndef WIN32
#define DYNAMIC_BIND 1
#endif

#if DYNAMIC_BIND

GL_EXT(_GL)

// OpenGL.
GL_PROC(_GL,void,glAccum,(GLenum,GLfloat))
GL_PROC(_GL,void,glAlphaFunc,(GLenum,GLclampf))
GL_PROC(_GL,GLboolean,glAreTexturesResident,(GLsizei,const GLuint*,GLboolean*))
GL_PROC(_GL,void,glArrayElement,(GLint))
GL_PROC(_GL,void,glBegin,(GLenum))
GL_PROC(_GL,void,glBindTexture,(GLenum,GLuint))
GL_PROC(_GL,void,glBitmap,(GLsizei,GLsizei,GLfloat,GLfloat,GLfloat,GLfloat,const GLubyte*))
GL_PROC(_GL,void,glBlendFunc,(GLenum,GLenum))
GL_PROX(_GL,void,glCallList,(GLuint))
GL_PROX(_GL,void,glCallLists,(GLsizei,GLenum,const GLvoid*))
GL_PROC(_GL,void,glClear,(GLbitfield))
GL_PROC(_GL,void,glClearAccum,(GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL,void,glClearColor,(GLclampf,GLclampf,GLclampf,GLclampf))
GL_PROC(_GL,void,glClearDepth,(GLclampd))
GL_PROX(_GL,void,glClearIndex,(GLfloat))
GL_PROC(_GL,void,glClearStencil,(GLint))
GL_PROC(_GL,void,glClipPlane,(GLenum,const GLdouble*))
GL_PROX(_GL,void,glColor3b,(GLbyte,GLbyte,GLbyte))
GL_PROX(_GL,void,glColor3bv,(const GLbyte*))
GL_PROX(_GL,void,glColor3d,(GLdouble,GLdouble,GLdouble))
GL_PROX(_GL,void,glColor3dv,(const GLdouble*))
GL_PROC(_GL,void,glColor3f,(GLfloat,GLfloat,GLfloat))
GL_PROC(_GL,void,glColor3fv,(const GLfloat*))
GL_PROX(_GL,void,glColor3i,(GLint,GLint,GLint))
GL_PROX(_GL,void,glColor3iv,(const GLint*))
GL_PROX(_GL,void,glColor3s,(GLshort,GLshort,GLshort))
GL_PROX(_GL,void,glColor3sv,(const GLshort*))
GL_PROC(_GL,void,glColor3ub,(GLubyte,GLubyte,GLubyte))
GL_PROC(_GL,void,glColor3ubv,(const GLubyte*))
GL_PROX(_GL,void,glColor3ui,(GLuint,GLuint,GLuint))
GL_PROX(_GL,void,glColor3uiv,(const GLuint*))
GL_PROX(_GL,void,glColor3us,(GLushort,GLushort,GLushort))
GL_PROX(_GL,void,glColor3usv,(const GLushort*))
GL_PROX(_GL,void,glColor4b,(GLbyte,GLbyte,GLbyte,GLbyte))
GL_PROX(_GL,void,glColor4bv,(const GLbyte*))
GL_PROX(_GL,void,glColor4d,(GLdouble,GLdouble,GLdouble,GLdouble))
GL_PROX(_GL,void,glColor4dv,(const GLdouble*))
GL_PROC(_GL,void,glColor4f,(GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL,void,glColor4fv,(const GLfloat*))
GL_PROX(_GL,void,glColor4i,(GLint,GLint,GLint,GLint))
GL_PROX(_GL,void,glColor4iv,(const GLint*))
GL_PROX(_GL,void,glColor4s,(GLshort,GLshort,GLshort,GLshort))
GL_PROX(_GL,void,glColor4sv,(const GLshort*))
GL_PROC(_GL,void,glColor4ub,(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha))
GL_PROC(_GL,void,glColor4ubv,(const GLubyte *v))
GL_PROX(_GL,void,glColor4ui,(GLuint red, GLuint green, GLuint blue, GLuint alpha))
GL_PROX(_GL,void,glColor4uiv,(const GLuint *v))
GL_PROX(_GL,void,glColor4us,(GLushort red, GLushort green, GLushort blue, GLushort alpha))
GL_PROX(_GL,void,glColor4usv,(const GLushort *v))
GL_PROC(_GL,void,glColorMask,(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
GL_PROX(_GL,void,glColorMaterial,(GLenum face, GLenum mode))
GL_PROC(_GL,void,glColorPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glCopyPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type))
GL_PROC(_GL,void,glCopyTexImage1D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border))
GL_PROC(_GL,void,glCopyTexImage2D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GL_PROC(_GL,void,glCopyTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
GL_PROC(_GL,void,glCopyTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GL_PROC(_GL,void,glCullFace,(GLenum mode))
GL_PROX(_GL,void,glDeleteLists,(GLuint list, GLsizei range))
GL_PROC(_GL,void,glDeleteTextures,(GLsizei n, const GLuint *textures))
GL_PROC(_GL,void,glDepthFunc,(GLenum func))
GL_PROC(_GL,void,glDepthMask,(GLboolean flag))
GL_PROC(_GL,void,glDepthRange,(GLclampd zNear, GLclampd zFar))
GL_PROC(_GL,void,glDisable,(GLenum cap))
GL_PROC(_GL,void,glDisableClientState,(GLenum array))
GL_PROC(_GL,void,glDrawArrays,(GLenum mode, GLint first, GLsizei count))
GL_PROC(_GL,void,glDrawBuffer,(GLenum mode))
GL_PROC(_GL,void,glDrawElements,(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices))
GL_PROC(_GL,void,glDrawPixels,(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROX(_GL,void,glEdgeFlag,(GLboolean flag))
GL_PROX(_GL,void,glEdgeFlagPointer,(GLsizei stride, const GLvoid *pointer))
GL_PROX(_GL,void,glEdgeFlagv,(const GLboolean *flag))
GL_PROC(_GL,void,glEnable,(GLenum cap))
GL_PROC(_GL,void,glEnableClientState,(GLenum array))
GL_PROC(_GL,void,glEnd,(void))
GL_PROX(_GL,void,glEndList,(void))
GL_PROX(_GL,void,glEvalCoord1d,(GLdouble u))
GL_PROX(_GL,void,glEvalCoord1dv,(const GLdouble *u))
GL_PROX(_GL,void,glEvalCoord1f,(GLfloat u))
GL_PROX(_GL,void,glEvalCoord1fv,(const GLfloat *u))
GL_PROX(_GL,void,glEvalCoord2d,(GLdouble u, GLdouble v))
GL_PROX(_GL,void,glEvalCoord2dv,(const GLdouble *u))
GL_PROX(_GL,void,glEvalCoord2f,(GLfloat u, GLfloat v))
GL_PROX(_GL,void,glEvalCoord2fv,(const GLfloat *u))
GL_PROX(_GL,void,glEvalMesh1,(GLenum mode, GLint i1, GLint i2))
GL_PROX(_GL,void,glEvalMesh2,(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2))
GL_PROX(_GL,void,glEvalPoint1,(GLint i))
GL_PROX(_GL,void,glEvalPoint2,(GLint i, GLint j))
GL_PROC(_GL,void,glFeedbackBuffer,(GLsizei size, GLenum type, GLfloat *buffer))
GL_PROC(_GL,void,glFinish,(void))
GL_PROC(_GL,void,glFlush,(void))
#ifdef UTGLR_RUNE_BUILD
GL_PROC(_GL,void,glFogf,(GLenum pname, GLfloat param))
GL_PROC(_GL,void,glFogfv,(GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glFogi,(GLenum pname, GLint param))
GL_PROC(_GL,void,glFogiv,(GLenum pname, const GLint *params))
#else
GL_PROX(_GL,void,glFogf,(GLenum pname, GLfloat param))
GL_PROX(_GL,void,glFogfv,(GLenum pname, const GLfloat *params))
GL_PROX(_GL,void,glFogi,(GLenum pname, GLint param))
GL_PROX(_GL,void,glFogiv,(GLenum pname, const GLint *params))
#endif
GL_PROC(_GL,void,glFrontFace,(GLenum mode))
GL_PROC(_GL,void,glFrustum,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GL_PROX(_GL,GLuint,glGenLists,(GLsizei range))
GL_PROC(_GL,void,glGenTextures,(GLsizei n, GLuint *textures))
GL_PROC(_GL,void,glGetBooleanv,(GLenum pname, GLboolean *params))
GL_PROC(_GL,void,glGetClipPlane,(GLenum plane, GLdouble *equation))
GL_PROC(_GL,void,glGetDoublev,(GLenum pname, GLdouble *params))
GL_PROC(_GL,GLenum,glGetError,(void))
GL_PROC(_GL,void,glGetFloatv,(GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetIntegerv,(GLenum pname, GLint *params))
GL_PROX(_GL,void,glGetLightfv,(GLenum light, GLenum pname, GLfloat *params))
GL_PROX(_GL,void,glGetLightiv,(GLenum light, GLenum pname, GLint *params))
GL_PROX(_GL,void,glGetMapdv,(GLenum target, GLenum query, GLdouble *v))
GL_PROX(_GL,void,glGetMapfv,(GLenum target, GLenum query, GLfloat *v))
GL_PROX(_GL,void,glGetMapiv,(GLenum target, GLenum query, GLint *v))
GL_PROX(_GL,void,glGetMaterialfv,(GLenum face, GLenum pname, GLfloat *params))
GL_PROX(_GL,void,glGetMaterialiv,(GLenum face, GLenum pname, GLint *params))
GL_PROX(_GL,void,glGetPixelMapfv,(GLenum map, GLfloat *values))
GL_PROX(_GL,void,glGetPixelMapuiv,(GLenum map, GLuint *values))
GL_PROX(_GL,void,glGetPixelMapusv,(GLenum map, GLushort *values))
GL_PROC(_GL,void,glGetPointerv,(GLenum pname, GLvoid* *params))
GL_PROX(_GL,void,glGetPolygonStipple,(GLubyte *mask))
GL_PROC(_GL,const GLubyte *,glGetString,(GLenum name))
GL_PROC(_GL,void,glGetTexEnvfv,(GLenum target, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetTexEnviv,(GLenum target, GLenum pname, GLint *params))
GL_PROX(_GL,void,glGetTexGendv,(GLenum coord, GLenum pname, GLdouble *params))
GL_PROX(_GL,void,glGetTexGenfv,(GLenum coord, GLenum pname, GLfloat *params))
GL_PROX(_GL,void,glGetTexGeniv,(GLenum coord, GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetTexImage,(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels))
GL_PROC(_GL,void,glGetTexLevelParameterfv,(GLenum target, GLint level, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetTexLevelParameteriv,(GLenum target, GLint level, GLenum pname, GLint *params))
GL_PROC(_GL,void,glGetTexParameterfv,(GLenum target, GLenum pname, GLfloat *params))
GL_PROC(_GL,void,glGetTexParameteriv,(GLenum target, GLenum pname, GLint *params))
GL_PROC(_GL,void,glHint,(GLenum target, GLenum mode))
GL_PROX(_GL,void,glIndexMask,(GLuint mask))
GL_PROX(_GL,void,glIndexPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROX(_GL,void,glIndexd,(GLdouble c))
GL_PROX(_GL,void,glIndexdv,(const GLdouble *c))
GL_PROX(_GL,void,glIndexf,(GLfloat c))
GL_PROX(_GL,void,glIndexfv,(const GLfloat *c))
GL_PROX(_GL,void,glIndexi,(GLint c))
GL_PROX(_GL,void,glIndexiv,(const GLint *c))
GL_PROX(_GL,void,glIndexs,(GLshort c))
GL_PROX(_GL,void,glIndexsv,(const GLshort *c))
GL_PROX(_GL,void,glIndexub,(GLubyte c))
GL_PROX(_GL,void,glIndexubv,(const GLubyte *c))
GL_PROC(_GL,void,glInitNames,(void))
GL_PROX(_GL,void,glInterleavedArrays,(GLenum format, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,GLboolean,glIsEnabled,(GLenum cap))
GL_PROX(_GL,GLboolean,glIsList,(GLuint list))
GL_PROC(_GL,GLboolean,glIsTexture,(GLuint texture))
GL_PROX(_GL,void,glLightModelf,(GLenum pname, GLfloat param))
GL_PROX(_GL,void,glLightModelfv,(GLenum pname, const GLfloat *params))
GL_PROX(_GL,void,glLightModeli,(GLenum pname, GLint param))
GL_PROX(_GL,void,glLightModeliv,(GLenum pname, const GLint *params))
GL_PROX(_GL,void,glLightf,(GLenum light, GLenum pname, GLfloat param))
GL_PROX(_GL,void,glLightfv,(GLenum light, GLenum pname, const GLfloat *params))
GL_PROX(_GL,void,glLighti,(GLenum light, GLenum pname, GLint param))
GL_PROX(_GL,void,glLightiv,(GLenum light, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glLineStipple,(GLint factor, GLushort pattern))
GL_PROC(_GL,void,glLineWidth,(GLfloat width))
GL_PROX(_GL,void,glListBase,(GLuint base))
GL_PROC(_GL,void,glLoadIdentity,(void))
GL_PROX(_GL,void,glLoadMatrixd,(const GLdouble *m))
GL_PROC(_GL,void,glLoadMatrixf,(const GLfloat *m))
GL_PROC(_GL,void,glLoadName,(GLuint name))
GL_PROX(_GL,void,glLogicOp,(GLenum opcode))
GL_PROX(_GL,void,glMap1d,(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points))
GL_PROX(_GL,void,glMap1f,(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points))
GL_PROX(_GL,void,glMap2d,(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points))
GL_PROX(_GL,void,glMap2f,(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points))
GL_PROX(_GL,void,glMapGrid1d,(GLint un, GLdouble u1, GLdouble u2))
GL_PROX(_GL,void,glMapGrid1f,(GLint un, GLfloat u1, GLfloat u2))
GL_PROX(_GL,void,glMapGrid2d,(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2))
GL_PROX(_GL,void,glMapGrid2f,(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2))
GL_PROX(_GL,void,glMaterialf,(GLenum face, GLenum pname, GLfloat param))
GL_PROX(_GL,void,glMaterialfv,(GLenum face, GLenum pname, const GLfloat *params))
GL_PROX(_GL,void,glMateriali,(GLenum face, GLenum pname, GLint param))
GL_PROX(_GL,void,glMaterialiv,(GLenum face, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glMatrixMode,(GLenum mode))
GL_PROX(_GL,void,glMultMatrixd,(const GLdouble *m))
GL_PROC(_GL,void,glMultMatrixf,(const GLfloat *m))
GL_PROX(_GL,void,glNewList,(GLuint list, GLenum mode))
GL_PROX(_GL,void,glNormal3b,(GLbyte nx, GLbyte ny, GLbyte nz))
GL_PROX(_GL,void,glNormal3bv,(const GLbyte *v))
GL_PROX(_GL,void,glNormal3d,(GLdouble nx, GLdouble ny, GLdouble nz))
GL_PROX(_GL,void,glNormal3dv,(const GLdouble *v))
GL_PROC(_GL,void,glNormal3f,(GLfloat nx, GLfloat ny, GLfloat nz))
GL_PROC(_GL,void,glNormal3fv,(const GLfloat *v))
GL_PROX(_GL,void,glNormal3i,(GLint nx, GLint ny, GLint nz))
GL_PROX(_GL,void,glNormal3iv,(const GLint *v))
GL_PROX(_GL,void,glNormal3s,(GLshort nx, GLshort ny, GLshort nz))
GL_PROX(_GL,void,glNormal3sv,(const GLshort *v))
GL_PROC(_GL,void,glNormalPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glOrtho,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GL_PROC(_GL,void,glPassThrough,(GLfloat token))
GL_PROX(_GL,void,glPixelMapfv,(GLenum map, GLsizei mapsize, const GLfloat *values))
GL_PROX(_GL,void,glPixelMapuiv,(GLenum map, GLsizei mapsize, const GLuint *values))
GL_PROX(_GL,void,glPixelMapusv,(GLenum map, GLsizei mapsize, const GLushort *values))
GL_PROC(_GL,void,glPixelStoref,(GLenum pname, GLfloat param))
GL_PROC(_GL,void,glPixelStorei,(GLenum pname, GLint param))
GL_PROC(_GL,void,glPixelTransferf,(GLenum pname, GLfloat param))
GL_PROC(_GL,void,glPixelTransferi,(GLenum pname, GLint param))
GL_PROC(_GL,void,glPixelZoom,(GLfloat xfactor, GLfloat yfactor))
GL_PROC(_GL,void,glPointSize,(GLfloat size))
GL_PROC(_GL,void,glPolygonMode,(GLenum face, GLenum mode))
GL_PROC(_GL,void,glPolygonOffset,(GLfloat factor, GLfloat units))
GL_PROX(_GL,void,glPolygonStipple,(const GLubyte *mask))
GL_PROC(_GL,void,glPopAttrib,(void))
GL_PROC(_GL,void,glPopClientAttrib,(void))
GL_PROC(_GL,void,glPopMatrix,(void))
GL_PROC(_GL,void,glPopName,(void))
GL_PROC(_GL,void,glPrioritizeTextures,(GLsizei n, const GLuint *textures, const GLclampf *priorities))
GL_PROC(_GL,void,glPushAttrib,(GLbitfield mask))
GL_PROC(_GL,void,glPushClientAttrib,(GLbitfield mask))
GL_PROC(_GL,void,glPushMatrix,(void))
GL_PROC(_GL,void,glPushName,(GLuint name))
GL_PROX(_GL,void,glRasterPos2d,(GLdouble x, GLdouble y))
GL_PROX(_GL,void,glRasterPos2dv,(const GLdouble *v))
GL_PROX(_GL,void,glRasterPos2f,(GLfloat x, GLfloat y))
GL_PROX(_GL,void,glRasterPos2fv,(const GLfloat *v))
GL_PROX(_GL,void,glRasterPos2i,(GLint x, GLint y))
GL_PROX(_GL,void,glRasterPos2iv,(const GLint *v))
GL_PROX(_GL,void,glRasterPos2s,(GLshort x, GLshort y))
GL_PROX(_GL,void,glRasterPos2sv,(const GLshort *v))
GL_PROX(_GL,void,glRasterPos3d,(GLdouble x, GLdouble y, GLdouble z))
GL_PROX(_GL,void,glRasterPos3dv,(const GLdouble *v))
GL_PROX(_GL,void,glRasterPos3f,(GLfloat x, GLfloat y, GLfloat z))
GL_PROX(_GL,void,glRasterPos3fv,(const GLfloat *v))
GL_PROX(_GL,void,glRasterPos3i,(GLint x, GLint y, GLint z))
GL_PROX(_GL,void,glRasterPos3iv,(const GLint *v))
GL_PROX(_GL,void,glRasterPos3s,(GLshort x, GLshort y, GLshort z))
GL_PROX(_GL,void,glRasterPos3sv,(const GLshort *v))
GL_PROX(_GL,void,glRasterPos4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GL_PROX(_GL,void,glRasterPos4dv,(const GLdouble *v))
GL_PROX(_GL,void,glRasterPos4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GL_PROX(_GL,void,glRasterPos4fv,(const GLfloat *v))
GL_PROX(_GL,void,glRasterPos4i,(GLint x, GLint y, GLint z, GLint w))
GL_PROX(_GL,void,glRasterPos4iv,(const GLint *v))
GL_PROX(_GL,void,glRasterPos4s,(GLshort x, GLshort y, GLshort z, GLshort w))
GL_PROX(_GL,void,glRasterPos4sv,(const GLshort *v))
GL_PROC(_GL,void,glReadBuffer,(GLenum mode))
GL_PROC(_GL,void,glReadPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels))
GL_PROX(_GL,void,glRectd,(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2))
GL_PROX(_GL,void,glRectdv,(const GLdouble *v1, const GLdouble *v2))
GL_PROX(_GL,void,glRectf,(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2))
GL_PROX(_GL,void,glRectfv,(const GLfloat *v1, const GLfloat *v2))
GL_PROX(_GL,void,glRecti,(GLint x1, GLint y1, GLint x2, GLint y2))
GL_PROX(_GL,void,glRectiv,(const GLint *v1, const GLint *v2))
GL_PROX(_GL,void,glRects,(GLshort x1, GLshort y1, GLshort x2, GLshort y2))
GL_PROX(_GL,void,glRectsv,(const GLshort *v1, const GLshort *v2))
GL_PROC(_GL,GLint,glRenderMode,(GLenum mode))
GL_PROX(_GL,void,glRotated,(GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
GL_PROX(_GL,void,glRotatef,(GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
GL_PROX(_GL,void,glScaled,(GLdouble x, GLdouble y, GLdouble z))
GL_PROC(_GL,void,glScalef,(GLfloat x, GLfloat y, GLfloat z))
GL_PROC(_GL,void,glScissor,(GLint x, GLint y, GLsizei width, GLsizei height))
GL_PROC(_GL,void,glSelectBuffer,(GLsizei size, GLuint *buffer))
GL_PROC(_GL,void,glShadeModel,(GLenum mode))
GL_PROC(_GL,void,glStencilFunc,(GLenum func, GLint ref, GLuint mask))
GL_PROC(_GL,void,glStencilMask,(GLuint mask))
GL_PROC(_GL,void,glStencilOp,(GLenum fail, GLenum zfail, GLenum zpass))
GL_PROX(_GL,void,glTexCoord1d,(GLdouble s))
GL_PROX(_GL,void,glTexCoord1dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord1f,(GLfloat s))
GL_PROC(_GL,void,glTexCoord1fv,(const GLfloat *v))
GL_PROX(_GL,void,glTexCoord1i,(GLint s))
GL_PROX(_GL,void,glTexCoord1iv,(const GLint *v))
GL_PROX(_GL,void,glTexCoord1s,(GLshort s))
GL_PROX(_GL,void,glTexCoord1sv,(const GLshort *v))
GL_PROX(_GL,void,glTexCoord2d,(GLdouble s, GLdouble t))
GL_PROX(_GL,void,glTexCoord2dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord2f,(GLfloat s, GLfloat t))
GL_PROC(_GL,void,glTexCoord2fv,(const GLfloat *v))
GL_PROX(_GL,void,glTexCoord2i,(GLint s, GLint t))
GL_PROX(_GL,void,glTexCoord2iv,(const GLint *v))
GL_PROX(_GL,void,glTexCoord2s,(GLshort s, GLshort t))
GL_PROX(_GL,void,glTexCoord2sv,(const GLshort *v))
GL_PROX(_GL,void,glTexCoord3d,(GLdouble s, GLdouble t, GLdouble r))
GL_PROX(_GL,void,glTexCoord3dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord3f,(GLfloat s, GLfloat t, GLfloat r))
GL_PROC(_GL,void,glTexCoord3fv,(const GLfloat *v))
GL_PROX(_GL,void,glTexCoord3i,(GLint s, GLint t, GLint r))
GL_PROX(_GL,void,glTexCoord3iv,(const GLint *v))
GL_PROX(_GL,void,glTexCoord3s,(GLshort s, GLshort t, GLshort r))
GL_PROX(_GL,void,glTexCoord3sv,(const GLshort *v))
GL_PROX(_GL,void,glTexCoord4d,(GLdouble s, GLdouble t, GLdouble r, GLdouble q))
GL_PROX(_GL,void,glTexCoord4dv,(const GLdouble *v))
GL_PROC(_GL,void,glTexCoord4f,(GLfloat s, GLfloat t, GLfloat r, GLfloat q))
GL_PROC(_GL,void,glTexCoord4fv,(const GLfloat *v))
GL_PROX(_GL,void,glTexCoord4i,(GLint s, GLint t, GLint r, GLint q))
GL_PROX(_GL,void,glTexCoord4iv,(const GLint *v))
GL_PROX(_GL,void,glTexCoord4s,(GLshort s, GLshort t, GLshort r, GLshort q))
GL_PROX(_GL,void,glTexCoord4sv,(const GLshort *v))
GL_PROC(_GL,void,glTexCoordPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glTexEnvf,(GLenum target, GLenum pname, GLfloat param))
GL_PROC(_GL,void,glTexEnvfv,(GLenum target, GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glTexEnvi,(GLenum target, GLenum pname, GLint param))
GL_PROC(_GL,void,glTexEnviv,(GLenum target, GLenum pname, const GLint *params))
GL_PROX(_GL,void,glTexGend,(GLenum coord, GLenum pname, GLdouble param))
GL_PROX(_GL,void,glTexGendv,(GLenum coord, GLenum pname, const GLdouble *params))
GL_PROX(_GL,void,glTexGenf,(GLenum coord, GLenum pname, GLfloat param))
GL_PROX(_GL,void,glTexGenfv,(GLenum coord, GLenum pname, const GLfloat *params))
GL_PROX(_GL,void,glTexGeni,(GLenum coord, GLenum pname, GLint param))
GL_PROX(_GL,void,glTexGeniv,(GLenum coord, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glTexImage1D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glTexImage2D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glTexParameterf,(GLenum target, GLenum pname, GLfloat param))
GL_PROC(_GL,void,glTexParameterfv,(GLenum target, GLenum pname, const GLfloat *params))
GL_PROC(_GL,void,glTexParameteri,(GLenum target, GLenum pname, GLint param))
GL_PROC(_GL,void,glTexParameteriv,(GLenum target, GLenum pname, const GLint *params))
GL_PROC(_GL,void,glTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROC(_GL,void,glTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
GL_PROX(_GL,void,glTranslated,(GLdouble x, GLdouble y, GLdouble z))
GL_PROX(_GL,void,glTranslatef,(GLfloat x, GLfloat y, GLfloat z))
GL_PROX(_GL,void,glVertex2d,(GLdouble x, GLdouble y))
GL_PROX(_GL,void,glVertex2dv,(const GLdouble *v))
GL_PROC(_GL,void,glVertex2f,(GLfloat x, GLfloat y))
GL_PROC(_GL,void,glVertex2fv,(const GLfloat *v))
GL_PROX(_GL,void,glVertex2i,(GLint x, GLint y))
GL_PROX(_GL,void,glVertex2iv,(const GLint *v))
GL_PROX(_GL,void,glVertex2s,(GLshort x, GLshort y))
GL_PROX(_GL,void,glVertex2sv,(const GLshort *v))
GL_PROX(_GL,void,glVertex3d,(GLdouble x, GLdouble y, GLdouble z))
GL_PROX(_GL,void,glVertex3dv,(const GLdouble *v))
GL_PROC(_GL,void,glVertex3f,(GLfloat x, GLfloat y, GLfloat z))
GL_PROC(_GL,void,glVertex3fv,(const GLfloat *v))
GL_PROX(_GL,void,glVertex3i,(GLint x, GLint y, GLint z))
GL_PROX(_GL,void,glVertex3iv,(const GLint *v))
GL_PROX(_GL,void,glVertex3s,(GLshort x, GLshort y, GLshort z))
GL_PROX(_GL,void,glVertex3sv,(const GLshort *v))
GL_PROX(_GL,void,glVertex4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GL_PROX(_GL,void,glVertex4dv,(const GLdouble *v))
GL_PROC(_GL,void,glVertex4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GL_PROC(_GL,void,glVertex4fv,(const GLfloat *v))
GL_PROX(_GL,void,glVertex4i,(GLint x, GLint y, GLint z, GLint w))
GL_PROX(_GL,void,glVertex4iv,(const GLint *v))
GL_PROX(_GL,void,glVertex4s,(GLshort x, GLshort y, GLshort z, GLshort w))
GL_PROX(_GL,void,glVertex4sv,(const GLshort *v))
GL_PROC(_GL,void,glVertexPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL_PROC(_GL,void,glViewport,(GLint x, GLint y, GLsizei width, GLsizei height))

#ifdef WIN32
// WGL functions.
GL_PROC(_GL,BOOL,wglCopyContext,(HGLRC,HGLRC,UINT))
GL_PROC(_GL,HGLRC,wglCreateContext,(HDC))
GL_PROC(_GL,HGLRC,wglCreateLayerContext,(HGLRC))
GL_PROC(_GL,BOOL,wglDeleteContext,(HGLRC))
GL_PROC(_GL,HGLRC,wglGetCurrentContext,(VOID))
GL_PROC(_GL,HDC,wglGetCurrentDC,(VOID))
GL_PROC(_GL,PROC,wglGetProcAddress,(LPCSTR))
GL_PROC(_GL,BOOL,wglMakeCurrent,(HDC, HGLRC))
GL_PROC(_GL,BOOL,wglShareLists,(HGLRC,HGLRC))

// GDI functions.
GL_PROC(_GL,INT,ChoosePixelFormat,(HDC hDC,CONST PIXELFORMATDESCRIPTOR*))
GL_PROC(_GL,INT,DescribePixelFormat,(HDC,INT,UINT,PIXELFORMATDESCRIPTOR*))
GL_PROC(_GL,BOOL,GetPixelFormat,(HDC))
GL_PROC(_GL,BOOL,SetPixelFormat,(HDC,INT,CONST PIXELFORMATDESCRIPTOR*))
GL_PROC(_GL,BOOL,SwapBuffers,(HDC hDC))
#endif

#endif

/*-----------------------------------------------------------------------------
	OpenGL extensions.
-----------------------------------------------------------------------------*/

// BGRA textures.
GL_EXT(_GL_EXT_bgra)

// Paletted textures.
GL_EXT(_GL_EXT_paletted_texture)
GL_PROC(_GL_EXT_paletted_texture,void,glColorTableEXT,(GLenum target,GLenum internalFormat,GLsizei width,GLenum format,GLenum type,const void *data))
GL_PROC(_GL_EXT_paletted_texture,void,glColorSubTableEXT,(GLenum target,GLsizei start,GLsizei count,GLenum format,GLenum type,const void *data))
GL_PROC(_GL_EXT_paletted_texture,void,glGetColorTableEXT,(GLenum target,GLenum format,GLenum type,void *data))
GL_PROC(_GL_EXT_paletted_texture,void,glGetColorTableParameterivEXT,(GLenum target,GLenum pname,int *params))
GL_PROC(_GL_EXT_paletted_texture,void,glGetColorTableParameterfvEXT,(GLenum target,GLenum pname,float *params))

// Generic texture compression.
GL_EXT(_GL_ARB_texture_compression)
GL_PROC(_GL_ARB_texture_compression,void,glCompressedTexSubImage2DARB,(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid *))
GL_PROC(_GL_ARB_texture_compression,void,glCompressedTexImage2DARB,(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid *))

// S3TC texture compression.
GL_EXT(_GL_EXT_texture_compression_s3tc)

// Used for detail textures
GL_EXT(_GL_EXT_texture_env_combine)
GL_EXT(_GL_ARB_texture_env_combine)

// Anisotropic filtering
GL_EXT(_GL_EXT_texture_filter_anisotropic)

// SGIS texture lod
//GL_EXT(_GL_SGIS_texture_lod)

// Used for single pass fog
GL_EXT(_GL_ATI_texture_env_combine3)
GL_EXT(_GL_NV_texture_env_combine4)

// Texture LOD bias
GL_EXT(_GL_EXT_texture_lod_bias)

// Compiled vertex arrays.
GL_EXT(_GL_EXT_compiled_vertex_array)
GL_PROC(_GL_EXT_compiled_vertex_array,void,glLockArraysEXT,(GLint first, GLsizei count))
GL_PROC(_GL_EXT_compiled_vertex_array,void,glUnlockArraysEXT,(void))

// Fog Coord
//GL_EXT(_GL_EXT_fog_coord)
//GL_PROC(_GL_EXT_fog_coord,void,glFogCoordPointerEXT,(GLenum type, GLsizei stride, GLvoid *pointer))

// Secondary Color
GL_EXT(_GL_EXT_secondary_color)
GL_PROC(_GL_EXT_secondary_color,void,glSecondaryColorPointerEXT,(GLint size, GLenum type, GLsizei stride, GLvoid *pointer))

// ARB multitexture.
GL_EXT(_GL_ARB_multitexture)
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord1fARB,(GLenum target,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord2fARB,(GLenum target,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord3fARB,(GLenum target,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord4fARB,(GLenum target,GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord1fvARB,(GLenum target,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord2fvARB,(GLenum target,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord3fvARB,(GLenum target,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glMultiTexCoord4fvARB,(GLenum target,GLfloat,GLfloat,GLfloat,GLfloat))
GL_PROC(_GL_ARB_multitexture,void,glActiveTextureARB,(GLenum target))
GL_PROC(_GL_ARB_multitexture,void,glClientActiveTextureARB,(GLenum target))

// SGIS generate mipmap
GL_EXT(_GL_SGIS_generate_mipmap)

// NV_multisample_filter_hint
GL_EXT(_GL_NV_multisample_filter_hint)

// GL_EXT_multi_draw_arrays
GL_EXT(_GL_EXT_multi_draw_arrays)
GL_PROC(_GL_EXT_multi_draw_arrays,void,glMultiDrawArraysEXT,(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount))
GL_PROC(_GL_EXT_multi_draw_arrays,void,glMultiDrawElementsEXT,(GLenum mode, GLsizei *count, GLenum type, const GLvoid **indices, GLsizei primcount))

// ARB_vertex_program
GL_EXT(_GL_ARB_vertex_program)
GL_PROC(_GL_ARB_vertex_program,void,glProgramStringARB,(GLenum target, GLenum format, GLsizei len, const GLvoid *string))
GL_PROC(_GL_ARB_vertex_program,void,glBindProgramARB,(GLenum target, GLuint program))
GL_PROC(_GL_ARB_vertex_program,void,glDeleteProgramsARB,(GLsizei n, const GLuint *programs))
GL_PROC(_GL_ARB_vertex_program,void,glGenProgramsARB,(GLsizei n, GLuint *programs))

GL_PROC(_GL_ARB_vertex_program,void,glProgramEnvParameter4fARB,(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GL_PROC(_GL_ARB_vertex_program,void,glProgramLocalParameter4fARB,(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))

GL_PROC(_GL_ARB_vertex_program,void,glVertexAttrib4fARB,(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))

// ATI_pn_triangles
GL_EXT(_GL_ATI_pn_triangles)
GL_PROC(_GL_ATI_pn_triangles,void,glPNTrianglesiATI,(GLenum pname, GLint param))
GL_PROC(_GL_ATI_pn_triangles,void,glPNTrianglesfATI,(GLenum pname, GLfloat param))

// ARB_fragment_program
GL_EXT(_GL_ARB_fragment_program)

/*-----------------------------------------------------------------------------
	The End.
-----------------------------------------------------------------------------*/


