//=============================================================================
// ASC Ath Server Controller
// Version 7
// October 2004
// By 'ATHoS' Mickal DEHEZ && Cedric MEGNAT
//=============================================================================
//=============================================================================
// ascPPW.
//=============================================================================
class ascPPW expands UWindowPageWindow;
struct aPlayer
{
	var string PlayerName;
	var string PlayerFrags;
	var string PlayerDeaths;
	var string Playerlvl;
	var color Couleur;
	var int PlayerID;
	var int PlayerRate;
	var bool branked;
	var String Team;
};
var aPlayer aP[32];

var UMenuLabelControl PlayerName[32],PlayerFrags[32],PlayerDeaths[32],Playerlvl[32],PlayerRate[32],PlayerTeam[32];
var color rouge,bleu,vert,jaune,blanc,gris;
var int nb,orderedplayer[32];

function Created()
{
	local int i;
	Super.Created();
	for(i=0;i<32;i++){
		Playerlvl[i] = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 20, (i*20)+10, 60, 16));
		PlayerName[i] = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 80, (i*20)+10, 120, 16));
		PlayerTeam[i] = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 200, (i*20)+10, 200, 16));
		PlayerFrags[i] = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 400, (i*20)+10, 60, 16));
		PlayerDeaths[i] = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 460, (i*20)+10, 60, 16));
		PlayerRate[i] = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 520, (i*20)+10, 60, 16));
	}
	rouge.R=255;
	bleu.B=255;
	vert.G=255;
	jaune.R=255;
	jaune.G=255;
	blanc.R=255;
	blanc.G=255;
	blanc.B=255;
	gris.R=128;
	gris.G=128;
	gris.B=128;
	set_list();
}
function add_player(PlayerReplicationInfo PRI,int lvl,bool bspec,String Team)
{
	local color couleur;
	if(bspec)
		couleur=blanc;
	else if(PRI.Team==0)
		couleur=rouge;
	else if(PRI.Team==1)
		couleur=bleu;
	else if(PRI.Team==2)
		couleur=vert;
	else if(PRI.Team==3)
		couleur=jaune;
	else
		couleur=gris;

	aP[nb].PlayerName=PRI.PlayerName;
	aP[nb].PlayerFrags=string(int(PRI.Score));
	aP[nb].PlayerDeaths=string(int(PRI.Deaths));
	aP[nb].Playerlvl=string(lvl);
	aP[nb].Couleur=couleur;
	aP[nb].PlayerID=PRI.PlayerID;
	aP[nb].PlayerRate=int(PRI.Score-PRI.Deaths);
	aP[nb].Team=Team;
	nb++;
	set_list();
}
function remove_player(byte ID)
{
	local int i,j;
	local bool bfound;
	for(i=0;i<nb;i++){
		if(aP[i].PlayerID==ID)
			bfound=true;
		else if(bfound)
			aP[i]=aP[i+1];
	}
	if(bfound)
		nb--;
	set_list();
}
function set_list()
{
	local int i,k;
	DesiredHeight=10;
	orderplayers();
	for(i=0;i<nb;i++){
		k=orderedplayer[i];
		PlayerName[i].SetText(aP[k].PlayerName);
		PlayerName[i].SetTextColor(aP[k].Couleur);
		PlayerFrags[i].SetText(aP[k].PlayerFrags);
		PlayerFrags[i].SetTextColor(aP[k].Couleur);
		PlayerDeaths[i].SetText(aP[k].PlayerDeaths);
		PlayerDeaths[i].SetTextColor(aP[k].Couleur);
		Playerlvl[i].SetText(aP[k].Playerlvl);
		Playerlvl[i].SetTextColor(aP[k].Couleur);
		PlayerTeam[i].SetText(aP[k].Team);
		PlayerTeam[i].SetTextColor(aP[k].Couleur);
		PlayerRate[i].SetText(string(aP[k].PlayerRate));
		PlayerRate[i].SetTextColor(aP[k].Couleur);
		DesiredHeight+=20;
	}
	for(i=nb;i<32;i++){
		PlayerName[i].SetText("");
		PlayerFrags[i].SetText("");
		PlayerDeaths[i].SetText("");
		Playerlvl[i].SetText("");	
		PlayerRate[i].SetText("");
		PlayerTeam[i].SetText("");
	}
}
function orderplayers()
{
	local int i,j,k,max;
	for(i=0;i<nb;i++)
		aP[i].branked=false;
	for(i=0;i<nb;i++){
		max=-200;		
		for(j=0;j<nb;j++)
			if(aP[j].PlayerRate >= max && !aP[j].branked){
				k=j;
				max=aP[j].PlayerRate;
			}
		aP[k].branked=true;
		orderedplayer[i]=k;
	}
}
function Close(optional bool bByParent)
{
		WindowConsole(GetPlayerOwner().Player.Console).CloseUWindow();
        Super.Close(bByParent);
}

defaultproperties
{
}
