//=============================================================================
// ASC Ath Server Controller
// Version 7
// December 2004
// By 'ATHoS' Mickal DEHEZ && Cedric MEGNAT
//=============================================================================
//=============================================================================
// asc_HUD.
//=============================================================================
class asc_HUD expands asc_root;

#exec TEXTURE IMPORT NAME=rsguard FILE=ASCTX\RSGUARD.BMP GROUP="ASCIcons" FLAGS=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=asc FILE=ASCTX\ASC.BMP GROUP="ASCIcons" FLAGS=2 MIPS=OFF

struct messages
{
	var string S;
	var color C;
	var int time;
};
var messages m[2],cm;

var color colors[10];
var bool bIsRespawning,bIsStarted;
var int DrawTime;
var String auth;
var Font F1,F2;

replication
{
	reliable if( Role==ROLE_Authority )
		m,ah_new;
	reliable if( Role<ROLE_Authority )
		auth,cm,bIsRespawning,bIsStarted;
}

simulated function ah_new(String Message,byte c)
{
	if(c==1){
		cm.S=Message;
		cm.C=colors[1];
		cm.time=16;
		return;
	}
	m[0]=m[1];
	m[1].S=Message;
	m[1].C=colors[c];
	m[1].time=16;
}
simulated function PostRender(Canvas Canvas)
{
	local int X,Y;
 	Canvas.Font = F1;
	X = 8 * ChallengeHUD(Canvas.Viewport.Actor.myHUD).Scale;
	Y = 140 * ChallengeHUD(Canvas.Viewport.Actor.myHUD).Scale;
	Canvas.SetPos(X,Y);
	Canvas.DrawColor = m[0].C;
	Canvas.DrawText(m[0].S);
	Y+=16;
	Canvas.SetPos(X,Y);
	Canvas.DrawColor = m[1].C;
	Canvas.DrawText(m[1].S);
	Y+=16;	
	Canvas.SetPos(X,Y);
	Canvas.DrawColor = cm.C;
	Canvas.DrawText(cm.S);
	Y+=16;
	if(bIsRespawning){
		Canvas.DrawColor = colors[8];
		Canvas.SetPos(X+4,Y);
		Canvas.DrawIcon(texture'rsguard', 1);
		Canvas.SetPos(X+8+texture'rsguard'.USize,Y+texture'rsguard'.VSize/4);
		Canvas.DrawText("> Protected <");
	}
	Y+=16+texture'rsguard'.VSize;
	if(!bIsStarted){
		DrawTime+=1;
		if((colors[9] * (255/255*DrawTime)).R == 0)
			bIsStarted=True;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = colors[9] * (255/255*DrawTime);
		Canvas.SetPos(X+4,Y);
		Canvas.DrawIcon(texture'asc', 1);
		Y+=texture'asc'.VSize;
		Canvas.DrawColor = colors[1] * (255/255*DrawTime);	
		Canvas.Font = F2;
		Canvas.SetPos(X+8,Y);
 		if(DrawTime > 80)
			Canvas.DrawText(auth);
		else if(DrawTime > 50)
			Canvas.DrawText("LOADING 100% : LOGGED !");
		else
			Canvas.DrawText("LOADING"@(DrawTime*2)$"% : CHECKING...");
	}
	if ( NextHUDMutator != None )
		NextHUDMutator.PostRender(Canvas);
}
simulated event Timer()
{
	local int i;
	if(m[1].S!="")
		for(i=0;i<2;i++){
   			if( m[i].time >= 0 ) 
				m[i].time--;
			if( m[i].time == 0 ) 
				m[i].S="";
		}
	if( cm.time >= 0 ) 
 		cm.time--;
	if( cm.time == 0 )
	 	cm.S="";
}
simulated function PreBeginPlay()
{
	RemoteRole=ROLE_SimulatedProxy;
	bAlwaysRelevant=True;
	//metal, default
	colors[0].R=150;
	colors[0].G=150;
	colors[0].B=255;
	//bleu ciel, client
	colors[1].G=255;
	colors[1].B=255;
	//jaune, enter spec
	colors[2].R=255;
	colors[2].G=255;
	//orange, enter player
	colors[3].R=255;
	colors[3].G=150;
	//red foncer pour crash
	colors[4].R=255;
	//violet, tk
	colors[5].R=190;
	colors[5].B=190;
	//rose, kick
	colors[6].R=255;
	colors[6].B=255;
	//blue, spec
	colors[7].B=255;
	//vert respawn
	colors[8].G=255;
	//blanc
	colors[9].R=255;
	colors[9].G=255;
	colors[9].B=255;
	//font
	F1 = Font(DynamicLoadObject("LadderFonts.UTLadder14", class'Font'));	
	F2 = Font(DynamicLoadObject("LadderFonts.UTLadder10", class'Font'));	
	SetTimer(1,true);
}
simulated function Tick(float DeltaTime)
{
    if ( !bHUDMutator && Level.NetMode != NM_DedicatedServer )
        RegisterHUDMutator();
}

defaultproperties
{
}
