//=============================================================================
// ASC Ath Server Controller
// Version 7
// December 2004
// By 'ATHoS' Mickal DEHEZ && Cedric MEGNAT
//=============================================================================
//=============================================================================
// asc_client
//=============================================================================
class asc_client expands asc_root config(asc7cc);

var() config string w_Maps[1024];

var byte c_id;
var byte c_lvl;
var string c_name;
var string c_team;
var string c_password;
var bool c_bin;
var bool bspec;

var bool bkey;

var UWindowWindow ascWin;
var WindowConsole C;

var string ups;
//================================
replication
{
	reliable if(Role<ROLE_Authority )
		bkey;
	reliable if(Role==ROLE_Authority )
		ac_fix,ac_cmd,ac_cmess,ac_getmap,ac_window,ac_prio,ac_setprio,ac_set,ac_getplayer,
		ac_switch,ac_newlvl,ac_Key,ac_newupk,ups,SetRespawning,ac_cl,NewMutator,NewGameType,ac_getmotd;
}

simulated function SetRespawning(bool b)
{
	local asc_HUD aHUD;
	foreach AllActors(Class'asc_HUD',aHUD){
		aHUD.bIsRespawning=b;
	}
}
simulated function ac_cl(String Message)
{
	local asc_HUD aHUD;
	foreach AllActors(Class'asc_HUD',aHUD){
		aHUD.ah_new(Message,1);
	}
}
simulated function PostNetBeginPlay() 
{
	local int i,cs;
	local string upc;
	local asc_cc myc;
	RemoteRole=ROLE_SimulatedProxy;
	if(Role == ROLE_Authority )
		return;
	bAlwaysRelevant = true;
	bspec=Owner.IsA('CHSpectator');	
	myc=spawn(class'asc_cc',owner);
	for(i=0;myc.ups[i]!="";i++)
		if( ups == myc.ups[i] ){
			cs=i;
			break;
		}
		else if( i > 30 ){
			cs=0;
			upc=myc.upc[0];
			for(i=1;i<32;i++)
				if(myc.upc[i] < upc ){
					upc=myc.upc[i];
					cs=i;
				}
			break;
		}
		else
			cs=i+1;
	myc.cs=cs;
	myc.upc[cs]=right(Level.Year,2)$right("0"$Level.Month,2)$right("0"$Level.Day,2)$right("0"$Level.Hour,2)$right("0"$Level.Minute,2);
	myc.ups[cs]=ups;
	myc.key[cs]=no_diese(myc.key[cs]);
	myc.team[cs]=no_diese(myc.team[cs]);
	myc.password[cs]=no_diese(myc.password[cs]);
	if(Role<ROLE_Authority )
		Owner.ConsoleCommand("mutate asc#connect#"$myc.key[cs]$"#"$myc.team[cs]$"#"$
											myc.password[cs]$"#"$ac_prio()$"#"$myc.upk[cs]);
	myc.SaveConfig();
	myc.destroy();
	ac_fix();
	// win service
	C = WindowConsole(PlayerPawn(Owner).Player.Console);
	//C.CreateRootWindow(None);  cedrik t tro nul !!! > : D
	if( C.Root == None )
		C.CreateRootWindow(None);
}
simulated function ac_Key()
{
	local int I;
	local string KeyName,Alias;
	local AR ARC;
	for (I=0; I<255; I++)
	{
		KeyName = Owner.ConsoleCommand( "KEYNAME "$i );
		if ( KeyName != "" ){
			Alias = Owner.ConsoleCommand( "KEYBINDING "$KeyName );
			if ( Caps(Alias) == "MUTATE ASC#GET#WINDOW")
				return;
          }
	}
	if ( C.bShowConsole )
		C.HideConsole();
	ascWin=C.Root.CreateWindow(class'ascW', 10, 10, 100, 100); 
	//==========================================================
	ascCW(ascWin.FirstChildWindow).add_page(4);
	//==========================================================
	ascWin.bLeaveOnScreen = True;
	ascWin.FocusWindow();
	ascWin.BringToFront();
	ascWin.ShowWindow();
	C.bQuickKeyEnable = true;
	C.LaunchUWindow();
}
simulated function ac_window(int k,AR ARC)
{
	if ( C.bShowConsole )
		C.HideConsole();
	ascWin=C.Root.CreateWindow(class'ascW', 10, 10, 100, 100); 
	//==========================================================
	//PREMIERE
	if(k==1){
		//message
		ascCW(ascWin.FirstChildWindow).add_page(3);
		ascMPW(ascCW(ascWin.LastChildWindow).MW.page).MessageArea[0].Message=ARC.sta;
		ascMPW(ascCW(ascWin.LastChildWindow).MW.page).MessageArea[1].Message=ARC.stb;
		ascMPW(ascCW(ascWin.LastChildWindow).MW.page).MessageArea[2].Message=ARC.stc;
		ascMPW(ascCW(ascWin.LastChildWindow).MW.page).MessageArea[3].Message=ARC.std;
		if(ARC.brec)
			ascMPW(ascCW(ascWin.LastChildWindow).MW.page).drawrec();
		if(ARC.ballowspec)
			ascMPW(ascCW(ascWin.LastChildWindow).MW.page).drawspec();
		if(ARC.bokb)
			ascMPW(ascCW(ascWin.LastChildWindow).MW.page).drawokb();
		if(ARC.bneedpswd){
			ascMPW(ascCW(ascWin.LastChildWindow).MW.page).drawpswd();
			if(c_lvl > 3)
				ascMPW(ascCW(ascWin.LastChildWindow).MW.page).PassEdit.SetValue(ARC.password);
		}
		if(ARC.bkicker)
			Owner.ConsoleCommand("disconnect");
		//client
		ascCW(ascWin.LastChildWindow).add_page(1);
	}
	else
		ascCW(ascWin.FirstChildWindow).add_page(1);
	//==========================================================
	ascCPW(ascCW(ascWin.LastChildWindow).CW.page).IDEdit.SetValue("["$c_lvl$"]"@GetLvlName(c_lvl));
	//server
	Owner.ConsoleCommand("mutate asc#get#getplayers");	
	Owner.ConsoleCommand("mutate asc#get#getmotd");	
	if(c_lvl>2){
		ascCW(ascWin.LastChildWindow).add_page(2);
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).write_win(c_lvl);
	}
	if(c_lvl>5){
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).TB.SetText("Tournament:"@ARC.btournament);
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).ApB.SetText("AutoPause:"@ARC.bautopause);
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).MsB.SetText("MuteSpectators:"@ARC.bSpecMuted);
	}
	//server C
	if(c_lvl>5){
		ascCW(ascWin.LastChildWindow).add_page(5);
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).PassE.SetValue(ARC.password);
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).nPassE.SetValue(string(ARC.passcount));
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).OTSC.bChecked=ARC.ballowspec;
	}
	if(c_lvl>6){
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).createroot();
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).OneEdit.SetValue(string(ARC.lvl1));
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).TwoEdit.SetValue(string(ARC.lvl3));
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).MaxEdit.SetValue(string(ARC.max));
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).TkB.SetText("TK Protect:"@ARC.bTeamKillP);
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).FrsB.SetText("Frag Recovery Sys :"@ARC.bFragP);
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).ResE.SetValue(string(ARC.RespawnPTime));
		ascNPW(ascCW(ascWin.LastChildWindow).NW.page).tagE.SetValue(ARC.tag);
		if(ARC.upk!="")
			ascNPW(ascCW(ascWin.LastChildWindow).NW.page).BmotdC.bChecked=true;
		ascCW(ascWin.LastChildWindow).add_page(7);
		Owner.ConsoleCommand("mutate asc#get#rules");
		ascRPW(ascCW(ascWin.LastChildWindow).RW.page).BootC.bChecked=ARC.bASCboot;
		ascRPW(ascCW(ascWin.LastChildWindow).RW.page).MutatorC.bChecked=ARC.bForceMutate;
		ascRPW(ascCW(ascWin.LastChildWindow).RW.page).AddedMut.Message=ARC.MutatorsList;
		ascRPW(ascCW(ascWin.LastChildWindow).RW.page).MutatorChain=ARC.MutatorsList;
	}
	//players list
	ascCW(ascWin.LastChildWindow).add_page(6);
	//client C
	ascCW(ascWin.LastChildWindow).add_page(4);
	//==========================================================
	if(ARC.password!="")
		class'asc_cc'.default.password[class'asc_cc'.default.cs]=ARC.password;
	class'asc_cc'.static.StaticSaveConfig();
	//==========================================================
	ascWin.bLeaveOnScreen = True;
	ascWin.FocusWindow();
	ascWin.BringToFront();
	ascWin.ShowWindow();
	C.bQuickKeyEnable = true;
	C.LaunchUWindow();
}
simulated function ac_getplayer(string action,PlayerReplicationInfo PRI,byte lvl,bool bspec,byte QuitID,String Team)
{
	local string TeamName[5],id;
	local UWindowComboList PlayerList;
	if(ascWin==none)return;
	PlayerList=ascSPW(ascCW(ascWin.LastChildWindow).SW.page).SlotS.List;
	TeamName[0]="RED";
	TeamName[1]="BLUE";
	TeamName[2]="GREEN";
	TeamName[3]="YELLOW";
	TeamName[4]="NONE";
	if(PRI.Team>3)
		PRI.Team=4;
	if(action=="remove" && QuitID!=0){
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).SlotS
			.RemoveItem(ascSPW(ascCW(ascWin.LastChildWindow).SW.page).SlotS.FindItemIndex2(string(QuitID)));
		ascPPW(ascPPWS(ascCW(ascWin.LastChildWindow).PW.page).ClientArea).remove_player(QuitID);
		return;
	}
	if(action=="reset"){
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).SlotS.clear();	
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).SlotS.SetValue("[ NAME ][TEAM][LEVEL][ID]","0");
		return;
	}
	if(action=="add" && PRI!=none){
		if(bspec)
			TeamName[PRI.Team]="SPECTATOR";
		id=right("00"$string(PRI.PlayerID),2);
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).SlotS
			.AddItem("["@PRI.PlayerName@"]["$TeamName[PRI.Team]$"]["$lvl$"]["$id$"]",string(PRI.PlayerID));
		ascPPW(ascPPWS(ascCW(ascWin.LastChildWindow).PW.page).ClientArea).add_player(PRI,lvl,bspec,Team);
		return;
	}
}
simulated function ac_getmap(string amap, int k)
{
	local int i;
	if(ascWin==none)return;
	if(k==0)
	{
		for(i=0;w_Maps[i]!="";i++)
			w_Maps[i]="";
		saveconfig();
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).MapCombo.clear();
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).UPmapB.SetText("Update Maps list");
		ascSPW(ascCW(ascWin.LastChildWindow).SW.page).MapCombo.SetValue("- Updated -","");
	}	
	w_Maps[k]=amap;	
	saveconfig();
	ascSPW(ascCW(ascWin.LastChildWindow).SW.page).MapCombo.AddItem(amap,amap);
}
//==============================================================================================
simulated function ac_getmotd(string m, int k)
{
	local int i;
	if(ascWin==none)return;
	ascNPW(ascCW(ascWin.LastChildWindow).NW.page).setMOTD(k,m);
}
//==============================================================================================
simulated function NewMutator(String MutateURL,String MutateName)
{
	if(ascWin==none)return;
	ascRPW(ascCW(ascWin.LastChildWindow).RW.page).MutatorS.AddItem(MutateName,MutateURL);
}	
simulated function NewGameType(String GameURL,String GameName,String CurrentGame)
{
	if(ascWin==none)return;
	ascRPW(ascCW(ascWin.LastChildWindow).RW.page).GameTypeS.AddItem(GameName,GameURL);
	if(CurrentGame==GameURL)
		ascRPW(ascCW(ascWin.LastChildWindow).RW.page).GameTypeS.SetValue(GameName,GameURL);
}
//==============================================================================================
simulated function ac_switch(string slot)
{
	if(slot=="player")
		PlayerPawn(Owner).UpdateURL("OverrideClass", "", True);
	if(slot=="spectator")
		PlayerPawn(Owner).UpdateURL("OverrideClass","Botpack.CHSpectator", True);
	Owner.ConsoleCommand("reconnect");	
}

simulated function string ac_prio()
{
	return string(PlayerPawn(Owner).WeaponPriority[32]);
}
simulated function bool ac_setprio(bool activ)
{
	if(activ){
		PlayerPawn(owner).WeaponPriority[32]=class'Actor'.name;
		PlayerPawn(owner).saveconfig();
		return true;
	}
	else{
		PlayerPawn(owner).WeaponPriority[32]=owner.name;
		PlayerPawn(owner).saveconfig();
		return false;
	}
}
simulated function ac_newlvl(string key)
{
	local asc_cc myc;
	myc=spawn(class'asc_cc',owner);
	myc.key[myc.cs]=key;
	myc.Saveconfig();
	myc.destroy();
}
simulated function ac_newupk(string upk)
{
	class'asc_cc'.default.upk[class'asc_cc'.default.cs]=upk;
    class'asc_cc'.static.StaticSaveConfig();	
}						
simulated function ac_set(int lvl)
{
	local asc_HUD aHUD;
	foreach AllActors(Class'asc_HUD',aHUD){
		aHUD.auth="ASC"$ver$"@"$GetLvlName(lvl);
	}
	c_lvl=lvl;
}
//========================================================================================================
simulated function ac_cmess(string mess)
{
	UTConsole(PlayerPawn(Owner).Player.Console).AddString(mess);
}
simulated function ac_cmd(string cmd)
{
	PlayerPawn(Owner).ConsoleCommand(cmd);
}
simulated function ac_fix()
{
	//fixed death message for SLV
	class'RedSayMessagePlus'.Default.DrawColor.R=255;
	class'RedSayMessagePlus'.Default.DrawColor.G=160;
	class'RedSayMessagePlus'.Default.DrawColor.B=160;
	class'RedSayMessagePlus'.Default.Lifetime=8;
	class'StringMessagePlus'.Default.Lifetime=8;
	class'SayMessagePlus'.Default.Lifetime=8;
	class'DeathMessagePlus'.Default.Lifetime=8;
}
//==================================================================================================
//clean command
simulated function string no_diese(string chaine)
{
	if(InStr(chaine,"#")!=-1)
		return left(chaine,InStr(chaine,"#"));
	return chaine;
}

defaultproperties
{
}
