//=============================================================================
// ASC Ath Server Controller
// Version 7.39
// February 2005
// By 'ATHoS' Mickal DEHEZ && Cedric MEGNAT
//=============================================================================
class asc_root expands Mutator;
const ver=741;
//================================
struct AR
{
	//window
	var string sta,stb,stc,std;
	//var string mla,mlb,mlc,mld;
	var bool bkicker,bokb,brec,bneedpswd;
	//server setting
	var string upk;
	var string tag;
	var bool bTeamKillP;
	var bool bFragP;
	var byte RespawnPTime;
	var bool bASCboot,bForceMutate;
	var String MutatorsList,GameType;
	var string password;
	var byte passcount;
	var bool btournament,bautopause,bSpecMuted,ballowspec;
	var byte lvl1,lvl3;
	var byte max;
};
//==================================================================================================
//broadcast
function br(String Message,byte c)
{
	local asc_HUD aHUD;
	foreach AllActors(Class'asc_HUD',aHUD){
		aHUD.ah_new(Message,c);
	}
	broadcastmessage(Message);
}
//==================================================================================================
//client message
function cl(String Message, PlayerPawn Receiver)
{
	local asc_client AC;
	foreach AllActors(Class'asc_client',AC){
		if(AC.Owner == Receiver)
			AC.ac_cl(Message);
	}
	Receiver.ClientMessage(Message);
}
//==================================================================================================
//logout
function ac_cleanup()
{
	local asc_client AC;
	local Pawn P;
	local bool bin;
	local byte lastID;
	foreach AllActors(Class'asc_client',AC){
		if(AC.Owner == none){
			if(AC.c_bin){	
				if(AC.bspec)
					br(AC.c_name@"left the server",2);
				else
					br(AC.c_name@"left the server",3);
			}
			lastID=AC.c_id;
			bin=AC.c_bin;
			AC.destroy();
			if(bin)	
				foreach AllActors(Class'asc_client',AC){
					AC.ac_getplayer("remove",none,0,false,lastID,"");
				}
		}
		else if(AC.c_lvl<1)
			AC.PostNetBeginPlay();
	}
}
//==================================================================================================
//get teams
function int GetMaxTeams()
{
	if(Level.game.IsA('Assault'))
		return 2;
	if(Level.game.IsA('CTFGame'))
		return 2;
	if(Level.game.IsA('Domination'))
		return Domination(Level.game).MaxTeams;
	if(Level.game.IsA('TeamGamePlus'))
		return TeamGamePlus(Level.game).MaxTeams;
	return 0;
}
//==================================================================================================
//number of mutator
function int nMutate()
{
	local Mutator M;
	local int N;
	For (M = Level.Game.BaseMutator; M.NextMutator != None; M = M.NextMutator)
		if( !M.IsA('asc_command') && !M.IsA('asc_rsprotector') && !M.IsA('asc_tkprotector') )
			n++;
	return N;
}

//==================================================================================================
//pawntoac
function asc_client get_ac(actor A)
{
	local asc_client AC;
	foreach AllActors(Class'asc_client',AC){
		if(A==Pawn(AC.owner))
			return AC;
	}
	return none;
}
//==================================================================================================
//idtopawn
function Pawn get_pawn(int ID)
{
	local Pawn P;
	for(P=level.pawnlist; P!=none ; P=P.nextpawn)
		if(P.PlayerReplicationInfo.PlayerID == ID)
			return P;
	return none;
}
simulated function String GetLvlName(int Lvl)
{
	local string lvlname[8];
	if( Lvl < 0 || Lvl > 7 )
		return "";
	lvlname[0]="NOT LOGGED IN";
	lvlname[1]="PUBLIC";
	lvlname[2]="VIP";
	lvlname[3]="SUPERVISOR";
	lvlname[4]="OPERATOR";
	lvlname[5]="MODERATOR";
	lvlname[6]="ADMINISTRATOR";
	lvlname[7]="ROOT USER";
	return lvlname[Lvl];
}
