//=============================================================================
// ASC Ath Server Controller
// Version 7
// October 2004
// By 'ATHoS' Mickal DEHEZ && Cedric MEGNAT
//=============================================================================
//=============================================================================
// asc_rsprotector.
//=============================================================================
class asc_rsprotector expands asc_root;

var bool Initialized;
var int RespawnedIDs[32];
function PreBeginPlay();
function PostBeginPlay()
{
	if (Initialized) return;
        Initialized = True;
	SetTimer(1,true);
	Level.Game.RegisterDamageMutator( Self );
}
event Timer()
{
	ProtStatusUpdate();
}
//---------------------------------------------------------------
// Register a protected player
//---------------------------------------------------------------
function ModifyPlayer(Pawn Other)
{
	super.ModifyPlayer(Other);
	Protect(Other);
}
//---------------------------------------------------------------------------------
// Do not damage protected players and their victims
//---------------------------------------------------------------------------------
function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation,
	out Vector Momentum, name DamageType)
{
	if(InstigatedBy!=none)
	if (InstigatedBy.IsA('PlayerPawn') && Victim.IsA('PlayerPawn'))
	{
		if (isProtected(Victim) || isProtected(InstigatedBy))
			{
					ActualDamage = 0;
					momentum = vect(0,0,0);
			}
	}
	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, 

DamageType );
}
//---------------------------------------------------------------
//  Set properties of protected player
//---------------------------------------------------------------
function Protect(Pawn Other)
{
	RespawnedIDs[Other.PlayerReplicationInfo.PlayerID] = class'asc_server'.default.RespawnPTime;
	if( other.IsA('TournamentPlayer') ){
		get_ac(Other).SetRespawning(True);
		Other.Style=STY_Modulated;
	}
}
//--------------------------------------------------------------
// Expire protection in advance
//--------------------------------------------------------------
function bool HandlePickupQuery(Pawn Other, Inventory item, out byte bAllowPickup)
{
	local int k;
	if (IsProtected(Other))
	{	
		if (item.IsA('Weapon')          ||
		   	item.IsA('Udamage')         ||
		   	item.IsA('Healthpack')      ||
		   	item.IsA('Armor2')          || 
		   	item.IsA('ThightPad')       ||
		   	item.IsA('UT_Invisibility') ||
		   	item.IsA('UT_Shieldbelt')   )
		{
			k = Other.PlayerReplicationInfo.PlayerID;
			RespawnedIDs[k] = 1;
		}
	}
	if ( NextMutator != None )
		return NextMutator.HandlePickupQuery(Other, item, bAllowPickup);
	return false;
}
//---------------------------------------------------------------
//  Return protection status
//---------------------------------------------------------------
function bool isProtected(Pawn Other)
{
	if( Other.PlayerReplicationInfo != None )
		return (RespawnedIDs[Other.PlayerReplicationInfo.PlayerID] > 0);
	return false;
}
//---------------------------------------------------------------
//  Update protection status for all players
//---------------------------------------------------------------
function ProtStatusUpdate()
{ 
	local Pawn P;
	for( P=Level.PawnList; P!=None; P=P.nextPawn )     
	{
		if(P.bIsPlayer)
		if(RespawnedIDs[P.PlayerReplicationInfo.playerID] > 0)
		{	
			RespawnedIDs[P.PlayerReplicationInfo.playerID] --;
			if (RespawnedIDs[P.PlayerReplicationInfo.playerID] < 1 && P.IsA('TournamentPlayer') ){
				get_ac(P).SetRespawning(False);
				P.Style=STY_Normal;
			}
		}
	}
}

defaultproperties
{
}
