//=============================================================================
// ASC Ath Server Controller
// Version 7
// December 2004
// By 'ATHoS' Mickal DEHEZ && Cedric MEGNAT
//=============================================================================
//=============================================================================
// asc_server.
//=============================================================================
class asc_server expands asc_root config(asc7);
//slots
var() config byte SuperLvl;
var() config byte Lvl1Limit;
var() config byte Lvl3Limit;
var() config string PasswordLvl[8];
//boot
var() config bool bASCboot;
var() config string GameType;
var() config string MutatorsList;
var() config bool bForceMutate;
var() config string LastMap;
//Protections
var() config byte RespawnPTime;
var() config bool bTeamKillP;
var() config bool bFragP;
var() config string PTag;
//MOTD
var() config string MessageLine[4];
var() config string upk;
//Password
var() config string s_password;
var() config byte s_passcount;
var() config bool bAllowSpec;
//Match
var() config byte s_MaxPlayers;
var() config bool bAutoPause;
var() config bool bAllowBanned;
var() config bool bIsStarted;
//================================
var bool Initialized,bInitialized,abpaused,bfixed;
var int datime,dotime;
var byte CurrentID,NumPlayers,NumSpectators;
var string LastMsg;
var class<GameInfo> GameClass;
//================================
//anti spam
struct pl_say
{
	var string PlayerName;
	var string m1;  
	var string m2;   
	var string m3;
	var string m4;           
};
var pl_say pl[33];
var int nbpl;
var string lastpl[4];
//================================
function PreBeginPlay()
{
	if(bInitialized)return;bInitialized=True;
	if(bASCboot){
		GameClass = Class<GameInfo>(DynamicLoadObject(GameType, class'Class'));
		Level.ServerTravel(Level.GetMapName(GameClass.default.MapPrefix,LastMap,1)$"?game="$GameType$"?mutator="$MutatorsList,false);
		if(Level.GetMapName(GameClass.default.MapPrefix,LastMap,1) == (Left(string(Level), InStr(string(Level), "."))$".unr"))
			log("[ASC][ Booting the server : "$Level.GetMapName(GameClass.default.MapPrefix,LastMap,1)$" ]");
	}
	log("###############################");
	log("#    Ath Server Controller    #");
	log("#        version"@ver@"         #");
	log("###############################");
}
function PostBeginPlay()
{
	local Mutator B,M;
	if(Initialized)return;Initialized=True;
	spawn(class'asc_login');
	spawn(class'asc_HUD');
	//additional mutator
	B=Level.Game.BaseMutator;
	M=B.NextMutator;
	B.NextMutator=spawn(class'asc_command');
	asc_command(B.NextMutator).S=self;
	B=B.NextMutator;
	if(RespawnPTime>0){	
		B.NextMutator=spawn(class'asc_rsprotector');
		B=B.NextMutator;
	}
	if(Level.game.bTeamGame && bTeamKillP){
		B.NextMutator=spawn(class'asc_tkprotector');
		B=B.NextMutator;
	}
	B.NextMutator=M;
	lastpl[0]="player1";
	lastpl[1]="joueur2";
	lastpl[2]="gamer3";
	bAllowBanned=false;
	Level.Game.CurrentID=1;
	Level.Game.RegisterMessageMutator( Self );
	SetTimer(1,true);
	bIsStarted=False;
	if( s_MaxPlayers < 1 )
		s_MaxPlayers = Level.game.MaxPlayers;
	SaveConfig();
}
event Timer()
{
	local int i,pll;
	if( datime < (class'DeathMatchPlus'.default.NetWait+10) )
		datime++;
	if(datime == class'DeathMatchPlus'.default.NetWait)
		br("ATH Server Controller enabled",0);
	if(datime == (class'DeathMatchPlus'.default.NetWait+1))
		br("Loading...",0);
	if(datime == (class'DeathMatchPlus'.default.NetWait+4) && bASCboot){
		if( bForceMutate && nMutate() < 1 || Left(string(Level),InStr(string(Level),"-")) != Level.Game.default.MapPrefix ){
			br("The Server seems to be crashed. restarting...",4);
			Level.ServerTravel(Level.GetMapName(GameClass.default.MapPrefix,LastMap,1)$"?game="$GameType$"?mutator="$MutatorsList,false);
		}
		else if( Level.GetMapName(GameClass.default.MapPrefix,LastMap,1) == (Left(string(Level), InStr(string(Level), "."))$".unr") )
			br("The Server has crashed / has been reloaded",4);
		else
			br("Successfully loaded",0);
		LastMap=Left(string(Level), InStr(string(Level), "."))$".unr";
		SaveConfig();
	}
	if(datime == (class'DeathMatchPlus'.default.NetWait+6))
		br("Now playing"@Left(string(Level), InStr(string(Level), ".")),0);
	if(datime == (class'DeathMatchPlus'.default.NetWait+8)){
		if(s_password!="")
			if(s_passcount>0)s_passcount--;
			else if(s_passcount==0){
				s_password="";
				br("Password was automatically disabled",4);
			}
		SaveConfig();
	}
	//============================================================================================
	//ANTISPAM
	if(dotime>6){
		for(i=0;i<nbpl;i++)
			pl[i].m1="#FAKE#";
		lastpl[1]="#FAKE#";
		dotime=0;
	}
	else dotime++;
	//============================================================================================
	//MAXKEEPITALIVE
	if(Level.game.MaxPlayers != s_MaxPlayers && !DeathMatchPlus(Level.Game).bTournament){
		Level.game.MaxPlayers = s_MaxPlayers;
		br("MaxPlayers is now"@Level.game.MaxPlayers,0);
	}
	//============================================================================================
	//LOGOUT
	if(Level.Game.CurrentID != CurrentID 
		|| Level.Game.NumPlayers != NumPlayers 
		|| NumSpectators!=Level.Game.NumSpectators ){	
			ac_cleanup();
			CurrentID=Level.Game.CurrentID;
			NumPlayers=Level.Game.NumPlayers;
			NumSpectators=Level.Game.NumSpectators;
	}
	//============================================================================================
	//AUTOPAUSE
	if( Level.Game.NumPlayers != Level.game.MaxPlayers && Level.Pauser=="" && !Level.Game.bGameEnded && bAutoPause && bIsStarted ){
			br("A player has left, the game is stopped",0);
			Level.Pauser="ASC";
	}
	//============================================================================================
	//ANTI - LOOP
	if( Level.Game.bGameEnded && !bfixed )
		fix_spec();	
}
//==================================================================================================
function fix_spec()
{
	local pawn P;
	bfixed=true;
	for (P=Level.PawnList; P!=None; P=P.NextPawn)
		if(P.IsA('CHSpectator'))
			PlayerPawn(P).ViewTarget=none;
}
//==================================================================================================
function bool MutatorTeamMessage( Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep )
{
	if( Receiver != none && Receiver == Sender){
		antispam(Pawn(Sender),S);
		tagcheck(Pawn(Sender));
		if(S ~= "!open")
			get_ac(Sender).ac_cmd("mutate asc#get#window");
		if(S ~= "!team")
			get_ac(Sender).ac_cmd("mutate asc#self#balanceteams");
		if(S ~= "!vote")
			get_ac(Sender).ac_cmd("mutate asc#self#mapvote");
	}
	if ( NextMessageMutator != None )
		return NextMessageMutator.MutatorTeamMessage( Sender, Receiver, PRI, S, Type, bBeep );
  return true;
}
//==================================================================================================
function bool MutatorBroadcastMessage( Actor Sender, Pawn Receiver, out coerce string Msg, optional bool bBeep, out optional name Type )
{
 	//fix disc/connection 
	if( InStr ( Msg ,"entered the game.")!=-1 || InStr ( Msg ,"left the game.")!=-1 || Sender == none || Msg == LastMsg )
		return false;
	if(Sender.IsA('PlayerPawn'))
		tagcheck(Pawn(Sender));
	if( NextMessageMutator != None && !Sender.IsA('CHSpectator') )
		return NextMessageMutator.MutatorBroadcastMessage( Sender, Receiver, Msg, bBeep, Type );
	if(!Sender.IsA('CHSpectator'))
			return true;
	if(Receiver.NextPawn != none)
		if( Receiver.NextPawn.IsA('PlayerPawn') || Receiver.NextPawn.IsA('Bot') )
			return false;
	antispam(Pawn(Sender),Msg);	 
	br(Msg,7);
	LastMsg=Msg;
	BroadCastMessage(Msg);
	if( right(Msg, Len(Msg) - Len(PlayerPawn(Sender).PlayerReplicationInfo.PlayerName)-1) == "!open" )
		get_ac(Sender).ac_cmd("mutate asc#get#window");
	if( right(Msg, Len(Msg) - Len(PlayerPawn(Sender).PlayerReplicationInfo.PlayerName)-1) == "!team" )
		get_ac(Sender).ac_cmd("mutate asc#self#balanceteams");
	if( right(Msg, Len(Msg) - Len(PlayerPawn(Sender).PlayerReplicationInfo.PlayerName)-1) == "!vote" )
		get_ac(Sender).ac_cmd("mutate asc#self#mapvote");
	if( NextMessageMutator != None )
		return NextMessageMutator.MutatorBroadcastMessage( Sender, Receiver, Msg, bBeep, Type );
	return false;
}
//==================================================================================================
//anti spam
function antispam( pawn P, coerce string S)
{
	local int i;
	local bool bfound;
	local AR ARS;
	if(bautopause)
		return;
	lastpl[3]=lastpl[2];
	lastpl[2]=lastpl[1];
	lastpl[1]=lastpl[0];
	lastpl[0]=P.PlayerReplicationInfo.PlayerName;
	if(lastpl[3] == lastpl[2] && lastpl[2] == lastpl[1] && lastpl[1] == lastpl[0] && P.IsA('PlayerPawn'))
	{
		br(P.PlayerReplicationInfo.PlayerName@"was kicked for spamming",6);
		ARS.sta="You have got kicked for spamming.";	
		ARS.bkicker=true; 
		ARS.brec=true;   
		get_ac(P).ac_window(1,ARS);
		nbpl=0;
	}
	bfound=False;
	if(nbpl!=0)
		do
		{
			//update of messages
			if(P.PlayerReplicationInfo.PlayerName == pl[i].PlayerName)
			{
				pl[i].m4=pl[i].m3;				
				pl[i].m3=pl[i].m2;
				pl[i].m2=pl[i].m1;		
				pl[i].m1=S;
				bfound=True;
				
				if( pl[i].m1 == pl[i].m2 && pl[i].m2 == pl[i].m3 && pl[i].m3 == pl[i].m4 
					&& P.bIsPlayer && !P.PlayerReplicationInfo.bIsSpectator)
				{
					br(P.PlayerReplicationInfo.PlayerName@"was kicked for spamming",6);
					ARS.sta="You have got kicked for spamming.";	
					ARS.bkicker=true; 
					ARS.brec=true;   
					get_ac(P).ac_window(1,ARS);
					nbpl=0;
				}
			}
			else i++;
		}until(P.PlayerReplicationInfo.PlayerName == pl[i].PlayerName || i >= nbpl);
	if(nbpl >= 32)
		nbpl=0;
	if(!bfound)
	{
		//addplayers
		pl[nbpl].PlayerName=P.PlayerReplicationInfo.PlayerName;
		pl[nbpl].m1=S;
		pl[nbpl].m2="yo";
		pl[nbpl].m3="da";
		nbpl++;
	}
}
//==================================================================================================
//checking for tag :D
function tagcheck(Pawn P)
{
	local AR ARS;
	if( P.IsA('PlayerPawn') && InStr(P.PlayerReplicationInfo.PlayerName,Ptag)!=-1 && Ptag!="")
		if(get_ac(P).c_lvl < 3 ){
			ARS.sta="You are trying to wear a protected tag ("@Ptag@"), change your name and come back.";	
			ARS.bkicker=true;
			get_ac(P).ac_window(1,ARS);
		}
}
//==================================================================================================

defaultproperties
{
     SuperLvl=7
     Lvl1Limit=10
     Lvl3Limit=12
     bForceMutate=True
     RespawnPTime=4
     bTeamKillP=True
     bFragP=True
     s_MaxPlayers=16
}
