class TestMutator extends Mutator;

function PreBeginPlay()
{
	local int i;
	local LinkedList listTest;
	local TestClassA testObject1, testObject2, testObject3, testObject4;

	super.PreBeginPlay();

	log("Test mutator started");

	log( "Instantiating TestClass" );
	testObject1 = new class'TestClassA';
	if( testObject1 != none )
		log("testObject1 instantiation succesful");
	testObject2 = new class'TestClassB';
	if( testObject2 != none )
		log("testObject2 instantiation succesful");
	testObject3 = new class'TestClassC';
	if( testObject3 != none )
		log("testObject3 instantiation succesful");
	testObject4 = new class'TestClassD';
	if( testObject4 != none )
		log("testObject4 instantiation succesful");

	log( "Testing function in test objects" );
	testObject1.testfunction( "first" );
	testObject2.testfunction( "second" );
	testObject3.testfunction( "third" );
	testObject4.testfunction( "fourth" );

	log( "Instantiating LinkedList" );
	listTest = new class'LinkedList';
	if( listTest != none )
		log("listTest instantiation succesful");

	log( "Adding test objects to linked list" );
	listTest.add( testObject1 );
	listTest.add( testObject2 );
	listTest.add( testObject3 );
	listTest.add( testObject4 );

	log( "isEmpty() test" );
	log( "listTest.isEmpty() returned" @ listTest.isEmpty() );

	log( "size() test" );
	log( "listTest.size() returned" @ listTest.size() );

	log( "Message to test contains() method" );
	log( "listTest.contains(testObject1) returned" @  listTest.contains(testObject1) );
	log( "listTest.contains(testObject2) returned" @  listTest.contains(testObject2) );
	log( "listTest.contains(testObject3) returned" @  listTest.contains(testObject3) );
	log( "listTest.contains(testObject4) returned" @  listTest.contains(testObject4) );

	log( "Do...until loop to test get(integer i) method and show all stored objects" );

	i=1;
	do
	{
		log("i=" $ i );
		log( "listTest.get( i ) returned" @  listTest.get( i ) );
		i++;
	}
	until( listTest.get( i ) == none )

	log( "Attempt to retrieve test object and call it's test function using typecasting" );
	TestClassA( listTest.get( 1 ) ).testfunction( "first" );

	log( "Attempt to remove one of the test objects" );
	listTest.removeObject( 3 );

	log( "listTest.size() returned" @ listTest.size() );

	log( "Show all stored objects" );

	i=1;
	do
	{
		log("i=" $ i );
		log( "listTest.get( i ) returned" @  listTest.get( i ) );
		i++;
	}
	until( listTest.get( i ) == none )

	log( "Attempt to set position 3 in linked list to testObject2(TestClassB)" );
	listTest.set( TestObject2, 2 );

	log( "Show all stored objects" );

	i=1;
	do
	{
		log("i=" $ i );
		log( "listTest.get( i ) returned" @  listTest.get( i ) );
		i++;
	}
	until( listTest.get( i ) == none )

	log( "Attempt to clear linked list" );
	listTest.clear();
	log( "listTest.isEmpty() returned" @ listTest.isEmpty() );
}

defaultproperties
{

}
