// ============================================================
// PlayerCnt.PC v2.0 (c) 2011 Mr.Loathsome
//
// Counts number of times player joins a game.  By player name.
// Counts both Human and Bot players.
// ============================================================
class PC extends Mutator config(PlayerCnt);

var bool Initialized;
struct PlyrInfoType
{
	var string PlayersName;
	var int	Count;
	var string PlayerType;
};

const MaxPlayers = 1023;

var() config int NumGames;
var() config int NumPlayers;
var() config PlyrInfoType PInfo[1024];  // Set array size to MaxPlayers + 1


function ModifyPlayer(Pawn Other)
{
	local playerpawn NewPlayer;
	local bot B;
	local int i;
	local string PName, PType;

	if (!Initialized)
	{
		Initialized = True;  NumGames++;
	}
	NewPlayer = playerpawn(Other);
	B = bot(Other);
	if ( (Other == None) || (Other.PlayerReplicationInfo.Score != 0) || (Other.PlayerReplicationInfo.Deaths != 0) )
		return;
	if (Other.IsA('Bot'))
	{
		PName = B.GetHumanName();  PType="Bot";
	} 
	else
	{
		PName = NewPlayer.PlayerReplicationInfo.PlayerName;  PType="Human";
	}
	for( i=0; i < NumPlayers; i++ )
	{
		if ( PName == PInfo[i].PlayersName )
		{
			PInfo[i].Count++; break;
		}
	}
	if ((i >= NumPlayers) && (i != MaxPlayers))
	{
		NumPlayers++; PInfo[i].Count = 1;
		PInfo[i].PlayersName = PName;
		PInfo[i].PlayerType = PType;
	}
	if (i == MaxPlayers) { PInfo[MaxPlayers].Count++; PInfo[MaxPlayers].PlayersName = "Player Array is full"; log("PlayerCnt - Warning! Array is full"); }

	SaveConfig();
	Super.ModifyPlayer(Other);
}

defaultproperties
{
	NumGames=0
	NumPlayers=0
}
