/***************************************************************************************************
 *
 *  SendTo standalone by {LSN}Meindratheal
 *
 *  $CLASS        STWClient
 *  $VERSION      1.01 (15-04-2011 18:38)
 *  $AUTHOR       {LSN}Meindratheal
 *  $DESCRIPTION  SendTo clientside actor. Responsible for passing on the command.
 *
 **************************************************************************************************/
class STWClient extends Actor;

var STWClient NextClient; //Link to next in linked list
var STWMut Control;


/***************************************************************************************************
 *
 *  $DESCRIPTION  Replication properties block.
 *
 **************************************************************************************************/
replication
{
	reliable if (role == ROLE_Authority) // Replicate to client...
		ClientWebConnect;
}

/***************************************************************************************************
 *
 *  $DESCRIPTION  Adds this client instance to the linked list, to prevent
 *                unnecessary spawns (and possible lag).
 *  $PARAM        Mut    The main mutator instance containing te linked list.
 *
 **************************************************************************************************/
function Link(STWMut Mut)
{
	local STWClient C;
	Control = Mut;
	//Add to linked list.
	C = Control.ClientList;
	if(C == None)
	{
		//Add at the head of the chain.
		Control.ClientList = self;
		return;
	}
	//else
	while(C.NextClient != None)
	{
		C = C.NextClient;
	}
	//Add here.
	C.NextClient = self;
}

/***************************************************************************************************
 *
 *  $DESCRIPTION  Does the connecting.
 *  $PARAM        U   The URL to connect to.
 *
 **************************************************************************************************/
simulated function ClientWebConnect(string U)
{
	PlayerPawn(Owner).ConsoleCommand("start "$U);
	Destroy();
}

/***************************************************************************************************
 *
 *  $DESCRIPTION  Default properties block.
 *
 **************************************************************************************************/
defaultproperties
{
  RemoteRole=ROLE_SimulatedProxy
  bHidden=True
}