<?



/****

* a very simplistic attempt to enable you (and other people) http access to remote

* screenshots created by UTDCv17 on your server. 

* compatibility with future versions of UTDC are uncertain.

*

*

* this script is meant to be installed on a server which has access to a directory

* in which UTDC's .enc files are stored. this can be access through the local filesystem, or access via FTP.

*

* by default most webservers DO NOT allow PHP scripts to access directories which are beyond

* the "web root" directory (open_basedir restriction). you can disable this setting, but i certainly do not 

* suggest doing so. on the one hand this script can be considered rather safe (my own judgement), but 

* by disabling the open_basedir restriction you also lower the security precautions for all other scripts

* that might be running on your webserver.

* as a solution i suggest a cronjob which copies the files from the gameserver's Log directory  

* into a directory that is accessible for the webserver. another secure solution might be using a *local*

* FTP connection to access the files.

*

* accessing the log directory via ftp:

* simply specify a alid FTP address in the $logdir config variable. valid FTP addresses have the following format: 

* ftp://user:password@hostname/directory

* be careful, tho. whenever someone is browsing the screenshots the files are re-requested from the FTP server, 

* because no caching will be done. i suggest *not* using remote FTP connections.

* also keep in mind that "normal" FTP connections are not encrypted.

*

* distribution of this script:

* feel free to use and distribute it. also feel free to use parts of this script in your own projects.

* however, charging money for anything that is related to this script is pretty awkward. 

* if you nevertheless intend to do so, drop me a line, and i will probably grant permission.

*

*

*

* @author Tim 'tsr' Rietmann < tsr at the-truth.de >

* @copyright see author. 

*/



/*

 *   configuration begins here

 */















/* directory in which UTDC's .enc files are placed (absolute/relative or anything that is supported by PHPs wrappers) */



$logdir = ".";























/*

 *   configuration ends here (wasnt much, was it?)

 */





if (substr($logdir, strlen($logdir)-1) != "/")	// add tailing slash

	$logdir .= "/";





/***

* scans a directory and returns its contents as an array

*

* @param string $strPath directory to scan

* @param string $strExtension filter out all files that don't have this extension

* @return array list of files

*/



function getDir($strPath, $strExtension = null)

{

	$resDir = @opendir($strPath);

	if (!is_resource($resDir))

		die("unable to access log directory. either it does not exist or this php process does not have access. (open_basedir restriction?)");



	$arrReturn = array();



	for ($strFile = readdir($resDir); $strFile !== false; $strFile = readdir($resDir))

	{

		if ($strExtension != null)

		{

			$strCurrentExt = substr($strFile, strlen($strFile) - strlen($strExtension));

			if (strtolower($strExtension) != strtolower($strCurrentExt))

				continue;

		}



		$arrResult[] = $strFile;

	}

	@closedir($resDir);



	return $arrResult;

}



/***

* reads the contents of a screenshot file created with UTDCv17

* and returns its decoded content as a string.

* @param string $strFileName encoded screenshot file

* @return string binary contents of the source file

*/



function readUTDCPic($strFileName)

{



	$resSource = @fopen($strFileName, r);		// open source

	if (!$resSource)

		return null;



	$strContent = "";

	while(is_resource($resSource))

	{

		$strContent .= fread($resSource,1);	// read one byte

		if (feof($resSource))

			break;

	

		fseek($resSource, 1, SEEK_CUR);		// skip one byte

		if (feof($resSource))

			break;

	}

	@closedir($resSource);



	return @base64_decode($strContent);

}





/***

* callback function for usort() that lets us sort the file list according to their "last modified" attribute

* this function is not generic, since it relies on $logdir

*/

function compareMTime($strA, $strB)

{

	global $logdir;

	return @filemtime($logdir.$strA) < @filemtime($logdir.$strB);

}







/******************

*  program begin  *

******************/





// get a list of .enc files

$arrFiles = getDir($logdir, ".enc");





if (!is_array($arrFiles))

	die ("there are no files to display.");



usort ($arrFiles, compareMTime);	// sort file list





// if the user wants to view a file, display it and exit.

$strRequest = get_magic_quotes_gpc() == 1 ? stripslashes($_GET['file']) : $_GET['file'];

if ($strRequest != "")

{

	// check if the requested file really exists.

	// i dont know how Troublesome deals with metacharacters within player's ingame names.

	// to be on the safe side, lets filter out all slashes and double-check if the requested file is one 

	// of the files that our getDir function returned.

	

	if (strpos($strRequest, "/") !== false || strpos($strRequest, "\\") !== false)

		die("fuck off.");



	if (!in_array($strRequest, $arrFiles, true))

		die("the requested file does not exist.");



	header("content-type: image/jpeg");

	header('Content-Disposition: filename="'.$strRequest.'.jpg"');

	echo readUTDCPic($strRequest);

	exit;

}





// no file requested ? lets display the list.



?>



<html>

<head>

<style>

<!--

body

{	

	font-size: 8pt;

 	background-color: #FFFFFF;

	color:gray;

	text-align: left;

}

a

{

        color:white;

        color:gray;

        text-decoration:none;

}



a:hover

{

        color: #000000;

}

-->

</style>



<body>

<?



$me = basename($_SERVER['PHP_SELF']);

foreach ($arrFiles as $strFile)

{

	echo '<a href="'.$me.'?file='.urlencode($strFile).'">'.htmlentities($strFile).'</a> <br />'."\n";

}



?>



</body>

</html>

