class EventActor extends IUTDCEvent;

var ActionMut MyMut;

function Init()
{
	while (true)
	{
		if (FindUTDC())
		{
			DCMut.AddEventCatcher(Self);

			// Set config.
			SetConfig();

			// Start.
			Log("[ActionMan] Starting UTDC.");
			StartUTDC();
			break;
		}
	}
}

function SetConfig()
{
	if (DCMut != None)
	{
		DCMut.bUTDCActive			= MyMut.bUTDCActive;
		DCMut.bOSCare				= false;
		DCMut.bAllowWinampControl	= MyMut.bAllowWinampControl;
		DCMut.DownloadUrl			= MyMut.DownloadUrl;
		DCMut.ReconnectUrl			= MyMut.ReconnectUrl;
		DCMut.bForceNativeSpawn		= MyMut.bForceNativeSpawn;
		DCMut.bExternalLog			= MyMut.bExternalLog;
		DCMut.LogPath				= MyMut.LogPath;
		DCMut.bShowLogo				= MyMut.bShowLogo;
		DCMut.LogoXpos				= MyMut.LogoXpos;
		DCMut.LogoYpos				= MyMut.LogoYpos;
		DCMut.ShotPassword			= MyMut.ShotPassword;
		DCMut.bDisableTrace			= MyMut.bDisableTrace;
		DCMut.bDetectTraceCalls		= MyMut.bDetectTraceCalls;
		DCMut.bDisableDraw			= MyMut.bDisableDraw;
		DCMut.bDetectDrawCalls		= MyMut.bDetectDrawCalls;
		DCMut.TraceAllowList		= MyMut.TraceAllowList;
		DCMut.DrawAllowList			= MyMut.DrawAllowList;
		DCMut.SendMode				= MyMut.SendMode;
		DCMut.ImageServerPort		= MyMut.ImageServerPort;
		DCMut.ImageServerIp			= MyMut.ImageServerIp;
		DCMut.ConnectionTimeout		= MyMut.ConnectionTimeout;
		DCMut.JpgQuality			= MyMut.JpgQuality;
	}
}

// Screen shot started, Change file name.
function ScreenShotStarted(PlayerPawn Player, out string FilePath, out string FileName)
{

}

// Player joined. If not checked return true to kick player.
function bool PlayerJoin(PlayerPawn Player, string OS, bool bIsChecked)
{
	if (!bIsChecked && MyMut.bOSCare)
	{
		if ((InStr(OS,"MACDRV.MACCLIENT") > -1) || 
			(InStr(OS,"XDRV.XCLIENT") > -1) || 
			(InStr(OS,"SDLDRV.SDLCLIENT") > -1))
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	return true;
}

// Player initialized and finished initial check.
function PlayerInitialized(PlayerPawn Player, IUTDCCheck Check)
{
	local ActionMan AM;

	UTDCLog("UT:"@Check.UTSpeed$"MHz - Measured:"@Check.MeasuredSpeed$"Mhz - Commandline:"@"\""$Check.CommandLine$"\""@"-"@Check.WindowsVersion@"- Render:"@Check.RenderFile@"/"@Check.RenderMD5, false, Player);

	if ((Check.MeasuredSpeed < (Check.UTSpeed-50)) || (Check.MeasuredSpeed > (Check.UTSpeed+MyMut.SpeedHL)))
	{
		PlayerFailedProcessCheck(Player, Check, false, true, false, "CPU:"$string(Check.MeasuredSpeed)@"- UT:"$string(Check.UTSpeed)@"/"@Check.CpuInfo@"- Commandline: "@"\""$Check.CommandLine$"\"");
	}


	if (Check.ClientUTVersion == Check.UT440 && !MyMut.bAllow440 || 
		Check.ClientUTVersion == Check.UT451a && !MyMut.bAllow451a || 
		Check.ClientUTVersion == Check.UT451b && !MyMut.bAllow451b)
	{
		Player.ClientMessage("[UTDC] Your UT version is not allowed on this server.");
		Check.OpenConsole();
		IncompatibleVersion(Player);
		Check.KickPlayer(1);
		return;
	}

	// Start further checks.
	AM = Spawn(class'ActionMan', Player);
	if (AM != None)
	{
		AM.Check = Check;
		AM.DCMut = DCMut;
		AM.MyMut = MyMut;
		AM.EA	 = self;
	}
	else
	{
		Level.BroadcastMessage("[UTDC] " $ Player.PlayerReplicationInfo.PlayerName $ " have been kicked because of failing to spawn action man!");
		Check.KickPlayer(1);
	}
}

function IncompatibleVersion(PlayerPawn Player)
{
	local private string Versions;

	Versions = "";
	if (MyMut.bAllow440)
		Versions = Versions $ ", 4.40";
	if (MyMut.bAllow451a)
		Versions = Versions $ ", 4.51a";
	if (MyMut.bAllow451b)
	 	Versions = Versions $ " or 4.51b";
	Player.ClientMessage("[UTDC] You need UT version 4.36" $ Versions);
}

function LearnedUFunctionCall(PlayerPawn Player, IUTDCCheck Check, string IllegalFuncCaller, string IllegalFuncCallee, string DrawAllowList, string TraceAllowList)
{
	MyMut.DrawAllowList = DrawAllowList;
	MyMut.TraceAllowList = TraceAllowList;
	MyMut.SaveConfig();
}

// Cheat detected events.
// Player failed the memory check.
function PlayerFailedMemoryCheck(PlayerPawn Player, IUTDCCheck Check, int LogType, string Addrs, string Hash)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	if (LogType == CheckType.ExtraInfo)
	{
		UTDCLog("+---------------------------------------------------+", true);
		UTDCLog("Additional memory scan information for player:" @ PlayerName $"/"$ Check.GetIpAdress(Player), true);
		UTDCLog("Corruption hash..: " $ Hash, true);
		UTDCLog("Altered addresses: " $ Addrs, true);
		UTDCLog("+---------------------------------------------------+", true);
		return;
	}

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have corrupt memory", true);
	UTDCLog("Player name......: " $ PlayerName, true);
	UTDCLog("Player IP........: " $ Check.GetIpAdress(Player), true);
	UTDCLog("Client UT version: " $ Check.ClientUtVersion, true);
	UTDCLog("Client OS........: " $ Check.WindowsVersion, true);
	UTDCLog("Corruption hash..: " $ Hash, true);
	UTDCLog("Altered addresses: " $ Addrs, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickForCorruptMemory)
	{
		Player.ClientMessage("[UTDC] Your computer memory is corrupt. Try restarting UT to solve this.");
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of corrupt memory.");
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

// Player failed the Server / Client check.
function PlayerFailedCheck(PlayerPawn Player, IUTDCCheck Check, string ServerReceived, string AlteredInfo, string ProcessNames, string AlteredId, string ExtraInfo, string HookMatch)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have hooked functions", true);
	UTDCLog("Player Name......: " $ PlayerName, true);
	UTDCLog("Player IP........: " $ Check.GetIpAdress(Player), true);
	UTDCLog("Client UT Version: " $ Check.ClientUtVersion, true);
	UTDCLog("Client OS........: " $ Check.WindowsVersion, true);
	UTDCLog("Server Received..: " $ ServerReceived, true);
	UTDCLog("Altered addresses: " $ AlteredInfo, true);
	UTDCLog("Hook Match.......: " $ HookMatch, true);
	if (Len(ProcessNames) > 0)
		UTDCLog("Suspect Processes: " $ ProcessNames, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickPlayer && (!MyMut.bSafeKick || (MyMut.bSafeKick && HookMatch != "Unknown" && HookMatch != "Custom")))
	{
		if (MyMut.bBanPlayer)
		{
			DCMut.BanPlayer(Player);
		}

		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of an illegal hook.");
		Check.KickPlayer(6);
		Check.OpenConsole();
	}

	Check.MemoryCheck(CheckType.ExtraInfo);
}

// Player failed file check.
function PlayerFailedFileCheck(PlayerPawn Player, IUTDCCheck Check, int FileIndex, string Hash)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have failed integrity check", true);
	UTDCLog("Player Name......: " $ PlayerName, true);
	UTDCLog("Player IP........: " $ Check.GetIpAdress(Player), true);
	UTDCLog("Client UT Version: " $ Check.ClientUtVersion, true);
	UTDCLog("Client OS........: " $ Check.WindowsVersion, true);
	UTDCLog("Altered File.....: " $ MyMut.Package[FileIndex], true);
	UTDCLog("Server Received..: " $ Hash, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bBanPlayer)
	{
		DCMut.BanPlayer(Player);
	}

	if (MyMut.bKickForCorruptFile)
	{
		Player.ClientMessage("[UTDC] " $ "The file:"@MyMut.Package[FileIndex]@"have failed the integrity check. Contact the server admin and/or try removing the file to solve the problem.");
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of failed integrity check.");
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

// Player failed process check.
function PlayerFailedProcessCheck(PlayerPawn Player, IUTDCCheck Check, bool bTimer, bool bSpeedHack, bool bHook, string CheatTrace)
{
	local private string TypeOfCheat;
	local private string PlayerName;

	TypeOfCheat = "";
	if (bTimer)
	{
		TypeOfCheat = "Timer, ";
	}
	if (bSpeedHack)
	{
		TypeOfCheat = TypeOfCheat $ "Speed Hack, ";
	}
	if (bHook)
	{
		TypeOfCheat = TypeOfCheat $ "Hook, ";
	}
	TypeOfCheat = Left(TypeOfCheat, Len(TypeOfCheat)-2);

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client is using a cheat", true);
	UTDCLog("Player Name......: " $ PlayerName, true);
	UTDCLog("Player IP........: " $ Check.GetIpAdress(Player), true);
	UTDCLog("Client UT Version: " $ Check.ClientUtVersion, true);
	UTDCLog("Client OS........: " $ Check.WindowsVersion, true);
	UTDCLog("Cheat Type.......: " $ TypeOfCheat, true);
	UTDCLog("Cheat Trace......: " $ CheatTrace, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickForSpeedHack && bSpeedHack || 
		MyMut.bKickForTimer && bTimer || 
		MyMut.bKickForHook && bHook)
	{
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of a cheat trace:"@TypeOfCheat);
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
	else if ((!bTimer && !bSpeedHack && !bHook) || CheatTrace == "")
	{
		UTDCLog(PlayerName@"- Abnormal state.", true);
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

// Illegal UFunction call detected.
function IllegalUFunctionCall(PlayerPawn Player, IUTDCCheck Check, string IllegalFuncCaller, string IllegalFuncCallee, string IllegalCallerClass)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have made an illegal ufunction call", true);
	UTDCLog("Player name......: " $ PlayerName, true);
	UTDCLog("Player IP........: " $ Check.GetIpAdress(Player), true);
	UTDCLog("Client UT version: " $ Check.ClientUtVersion, true);
	UTDCLog("Client OS........: " $ Check.WindowsVersion, true);
	UTDCLog("Function called..: " $ IllegalFuncCallee, true);
	UTDCLog("Function caller..: " $ IllegalCallerClass $ "," $ IllegalFuncCaller, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickForUBot)
	{
		Player.ClientMessage("[UTDC] You have been kicked because of an illegal ufunction call.");
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of an illegal ufunction call.");
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

//------------------------------------------------//

defaultproperties
{
	bAlwaysRelevant=True	
}