class IUTDC extends Mutator;

//////////////////////////////////////////////////
// Configuration vars.
//////////////////////////////////////////////////
var bool bUTDCActive;			// True when UTDC is active.
var bool bAllowWinampControl;	// True if winamp control is allowed.
var string DownloadUrl;			// UTDC download URL.
var string ReconnectUrl;		// Reconnect URL.
var bool bForceNativeSpawn;		// True if native actor should always be spawned.
var bool bOSCare;				// True if mac and linux client should be allowed.
var bool bShowLogo;				// True if badge should be shown.
var bool bExternalLog;			// True if external log should be made.
var string LogPath;				// External log path.
var int LogoXpos;				// Horizontal position of logo.
var int LogoYpos;				// Vertical position of logo.
var string ShotPassword;		// Password to do client screenshot.
var bool bDisableTrace;			// If true trace functions are disabled.
var bool bDetectTraceCalls;		// If true trace function calls are detected.
var bool bDisableDraw;			// If true draw functions are disabled.
var bool bDetectDrawCalls;		// If true draw function calls are detected.
var string TraceAllowList;
var string DrawAllowList;

// Screen shoot.
var int SendMode;				// Send mode.
var int ImageServerPort;		// Screenshot server port.
var string ImageServerIp;		// Screenshot server ip.
var int ConnectionTimeout;		// Connection timeout.
var int JpgQuality;				// Picture quality.

//////////////////////////////////////////////////
// Vars.
//////////////////////////////////////////////////
var bool bInitialized;			// Starts spawning checks when this is true.

// List of check types.
enum CheckType
{
	Request,
	Initial,
	ExtraInfo
};

//////////////////////////////////////////////////
// Functions.
//////////////////////////////////////////////////

function AddEventCatcher(IUTDCEvent Check);

// Process check.
function ProcessCheck(PlayerPawn MsgReceiver);

// Process check player.
function ProcessCheckPlayer(PlayerPawn MsgReceiver, int PlayerId);

// Screenshot all players.
function ScreenShot(PlayerPawn MsgReceiver);

// Screenshot player.
function ScreenShotPlayer(PlayerPawn MsgReceiver, int PlayerId);

// Memory check all players.
function MemoryCheck(PlayerPawn MsgReceiver, CheckType CheckType);

// Memory check player.
function MemoryCheckPlayer(PlayerPawn MsgReceiver, int PlayerId, CheckType CheckType);

// Learn allowed ufunction calls.
function LearnAllowedFunctions();

// Log message.
function UTDCLog(coerce string Msg, bool bExternal, optional PlayerPawn Player, optional bool bAdminNotice);

// Ban player.
function BanPlayer(PlayerPawn Player);

// Get package name for the package the object resides in.
function string GetPackageName(Actor Obj);

// Get checksum from a server package.
function string GetFileChecksum(string FileName);