class IUTDCCheck extends UTDCCommon;

var int		MeasuredSpeed;			// UTDC measured CPU speed.
var int		UTSpeed;				// UT measured CPU speed.
var string	WindowsVersion;			// Windows version.
var string	CommandLine;			// Client command line.
var string	ClientUTVersion;		// Client UT version.

var int		CoreBaseAddr;			// Core.dll base address.
var int		EngineBaseAddr;			// Engine.dll base address.
var int		RenderBaseAddr;			// Render.dll base address.
var int		GalaxyBaseAddr;			// Galaxy.dll base address.
var int		UTDCBaseAddr;			// UTDCx.dll base address.
var string	RenderFile;				// Render dll.
var string	RenderMD5;				// Render MD5 hash.

var string	CpuInfo;

function AddEventCatcher(IUTDCCheckEvent Check);

function ScreenShot();

function MemoryCheckWithTimeout(int RetryInterval, int TryCount, int CheckType);
function MemoryCheck(int CheckType);

function ProcessCheckWithTimeout(int RetryInterval, int TryCount);
function ProcessCheck();

function FileCheckWithTimeout(int RetryInterval, int TryCount, string FileName, int Index);
function FileCheck(string FileName, int Index);

function ModuleCheckWithTimeout(int RetryInterval, int TryCount, string Module, int Index, bool bCheckCode, bool bCheckImports, bool bCheckExports, bool bCheckVTBL);
function ModuleCheck(string Module, int Index, bool bCheckCode, bool bCheckImports, bool bCheckExports, bool bCheckVTBL);

function CheckAddrWithTimeout(int RetryInterval, int TryCount, int Addr, int Index);
function CheckAddr(int Addr, int Index);

function FadeUTDCLogo();

function StartServerCheck(int CheckInterval);
function StartClientCheck(int CheckInterval);

function KickPlayer(int KickInSeconds);


