class ActionMan extends IUTDCCheckEvent;

var IUTDCCheck Check;
var IUTDC DCMut;
var ActionMut MyMut;
var EventActor EA;

var int ChkFileIndex;

const FileCheckTryCount	= 3;
const MemoryTryCount	= 3;
const ProcessTryCount	= 3;

const FileCheckPollInterval	= 5;
const MemoryPollInterval	= 8;
const ProcessPollInterval	= 8;

function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);

	if (Owner == None)
	{
		Disable('Tick');
		Destroy();
	}
}

auto state StartInit
{
	Begin:
		if (Check != None)
		{
			// Init.
			ChkFileIndex = 0;

			Check.AddEventCatcher(self);

			// Start check.
			Check.ProcessCheckWithTimeout(ProcessPollInterval, ProcessTryCount);
		}
}

function ProcessCheckFinished(bool bCalledFromPlayerCheck)
{
	if (bCalledFromPlayerCheck)
	{
		DoFileCheck();
	}
}

function DoFileCheck()
{
	if (MyMut.Package[ChkFileIndex] != "" && ChkFileIndex < MyMut.MAXFILESTOCHECK)
	{
		Check.FileCheckWithTimeout(FileCheckPollInterval, FileCheckTryCount, MyMut.Package[ChkFileIndex], ChkFileIndex);
	}
	else
	{
		DoMemoryCheck();
	}
}

function FileCheckResponse(string FileHash, int FileIndex)
{
	if (Len(FileHash) != 32)
	{
		EA.PlayerFailedFileCheck(PlayerPawn(Owner), Check, FileIndex, FileHash);
	}
	else if (InStr(CAPS(MyMut.MD5[FileIndex]), CAPS(FileHash)) == -1)
	{
		EA.PlayerFailedFileCheck(PlayerPawn(Owner), Check, FileIndex, FileHash);
	}
	
	ChkFileIndex++;
	DoFileCheck();
}

function DoMemoryCheck()
{
	Check.MemoryCheckWithTimeout(MemoryPollInterval, MemoryTryCount, CheckType.Request);
}

function MemoryCheckFinished(bool bCalledFromPlayerCheck)
{
	if (bCalledFromPlayerCheck)
	{
		if (MyMut.bClientCheck)
		{
			Check.StartClientCheck(MyMut.ClientCheckInterval);
		}
		Check.FadeUTDCLogo();
		if (MyMut.bServerCheck)
		{
			Check.StartServerCheck(MyMut.CheckInterval);
		}
	}
}