class EventActor extends IUTDCEvent;

var ActionMut MyMut;

function Init()
{
	while (true)
	{
		if (FindUTDC())
		{
			DCMut.AddEventCatcher(Self);

			// Set config.
			SetConfig();

			// Start.
			Log("[ActionMan] Starting UTDC.");
			StartUTDC();
			break;
		}
	}
}

function SetConfig()
{
	if (DCMut != None)
	{
		DCMut.bUTDCActive			= MyMut.bUTDCActive;
		DCMut.bOSCare				= MyMut.bOSCare;
		DCMut.bAllowWinampControl	= MyMut.bAllowWinampControl;
		DCMut.DownloadUrl			= MyMut.DownloadUrl;
		DCMut.ReconnectUrl			= MyMut.ReconnectUrl;
		DCMut.bForceNativeSpawn		= MyMut.bForceNativeSpawn;
		DCMut.bExternalLog			= MyMut.bExternalLog;
		DCMut.LogPath				= MyMut.LogPath;
		DCMut.ShotPath				= MyMut.ShotPath;
		DCMut.bShowLogo				= MyMut.bShowLogo;
		DCMut.LogoXpos				= MyMut.LogoXpos;
		DCMut.LogoYpos				= MyMut.LogoYpos;
		DCMut.ShotPassword			= MyMut.ShotPassword;
		DCMut.bDisableTrace			= MyMut.bDisableTrace;
		DCMut.bDetectTraceCalls		= MyMut.bDetectTraceCalls;
		DCMut.bDisableDraw			= MyMut.bDisableDraw;
		DCMut.bDetectDrawCalls		= MyMut.bDetectDrawCalls;
		DCMut.TraceAllowList		= MyMut.TraceAllowList;
		DCMut.DrawAllowList			= MyMut.DrawAllowList;
		DCMut.SendMode				= MyMut.SendMode;
		DCMut.ImageServerPort		= MyMut.ImageServerPort;
		DCMut.ImageServerIp			= MyMut.ImageServerIp;
		DCMut.ConnectionTimeout		= MyMut.ConnectionTimeout;
		DCMut.JpgQuality			= MyMut.JpgQuality;
	}
}

// Screen shot started, Change file name.
function ScreenShotStarted(PlayerPawn Player, out string FilePath, out string FileName)
{

}

// Player joined. If not checked return true to kick player.
function bool PlayerJoin(PlayerPawn Player, string OS, bool bIsChecked)
{
	UTDCLog("PlayerJoin:" @ OS, false, Player);
	return false;
}

// Player initialized and finished initial check.
function PlayerInitialized(PlayerPawn Player, IUTDCCheck Check)
{
	local ActionMan AM;

	UTDCLog("UT VERSION:" @ Check.ClientUTVersion @ "OS:" @ Check.WindowsVersion, false, Player);
	UTDCLog("UT:" @ Check.UTSpeed $ "MHz - MEASURED:" @ Check.MeasuredSpeed $ "Mhz - COMMANDLINE:" @"\""$Check.CommandLine$"\"", false, Player);


	if (MyMut.UTDCMD5 != "")
	{
		if (Check.UTDCMD5 != MyMut.UTDCMD5)
		{
			LogFailedFileCheck(Player, Check, "UTDCvXX.dll", Check.UTDCMD5);
		}
	}
/*
	UTDCLog(Check.RenderDrvFile @ "MD5.:" @ Check.RenderDrvMD5, false, Player);
	UTDCLog("Core.dll MD5....:" @ Check.CoreMD5, false, Player);
	UTDCLog("Engine.dll MD5..:" @ Check.EngineMD5, false, Player);
	UTDCLog("Render.dll MD5..:" @ Check.RenderMD5, false, Player);
	UTDCLog("Galaxy.dll MD5..:" @ Check.GalaxyMD5, false, Player);
	UTDCLog("UTDCx.dll MD5...:" @ Check.UTDCMD5, false, Player);
	UTDCLog("MAC hash........:" @ Check.MACHash, false, Player);
	UTDCLog("NIC desc. hash..:" @ Check.NICDescHash, false, Player);
	UTDCLog("NIC Count.......:" @ Check.NICCount, false, Player);
	UTDCLog("Memory NTDLL image:" @ Check.bNtDllMemCopy, false, Player);
*/
/*
	if ((Check.MeasuredSpeed < (Check.UTSpeed-50)) || (Check.MeasuredSpeed > (Check.UTSpeed+MyMut.SpeedHL)))
	{
		PlayerFailedProcessCheck(Player, Check, false, true, false, "CPU:"$string(Check.MeasuredSpeed)@"- UT:"$string(Check.UTSpeed)@"/"@Check.CpuInfo@"- Commandline: "@"\""$Check.CommandLine$"\"");
	}
*/

	if (Check.ClientUTVersion == Check.UT440 && !MyMut.bAllow440 || 
		Check.ClientUTVersion == Check.UT451a && !MyMut.bAllow451a || 
		Check.ClientUTVersion == Check.UT451b && !MyMut.bAllow451b)
	{
		Player.ClientMessage("[UTDC] Your UT version is not allowed on this server.");
		Check.OpenConsole();
		IncompatibleVersion(Player);
		Check.KickPlayer(1);
		return;
	}

	// Start further checks.
	AM = Spawn(class'ActionMan', Player);
	if (AM != None)
	{
		AM.Check = Check;
		AM.DCMut = DCMut;
		AM.MyMut = MyMut;
		AM.EA	 = self;
	}
	else
	{
		Level.BroadcastMessage("[UTDC] " $ Player.PlayerReplicationInfo.PlayerName $ " have been kicked because of failing to spawn action man!");
		Check.KickPlayer(1);
	}
}

function IncompatibleVersion(PlayerPawn Player)
{
	local private string Versions;

	Versions = "";
	if (MyMut.bAllow440)
		Versions = Versions $ ", 4.40";
	if (MyMut.bAllow451a)
		Versions = Versions $ ", 4.51a";
	if (MyMut.bAllow451b)
	 	Versions = Versions $ " or 4.51b";
	Player.ClientMessage("[UTDC] You need UT version 4.36" $ Versions);
}

function LearnedUFunctionCall(PlayerPawn Player, IUTDCCheck Check, string IllegalFuncCaller, string IllegalFuncCallee, string DrawAllowList, string TraceAllowList)
{
	MyMut.DrawAllowList = DrawAllowList;
	MyMut.TraceAllowList = TraceAllowList;
	MyMut.SaveConfig();
}

function string GetCoreVersion(string MD5)
{
	switch (MD5)
	{
		case "CCF104341C7452B06295D421167DBA95" : return "v4.36";
		case "CCF104341C7452B06295D421167DBA95" : return "v4.36creative";
		case "FF54CB77F322CE9E89CDD1E4CD11E626" : return "v4.40";
		case "918F7E877A9740993DB2B60E6F410B59" : return "v4.51a";
		case "4AAEDF0CF49CF7B3CAD8B126A50A2962" : return "v4.51b";
		case "6AC677426A03FAEC24FECE284D0D652B" : return "v4.36GOTY";
		case "8C073BE3D16668721236F996CA894137" : return "v4.36GOTY";// unknown
		default : return "Unknown";
	}
}

function string GetRenderVersion(string MD5)
{
	switch (MD5)
	{
		case "6F18D6BB2B3DC12D0D2E5AD5CC66586B" : return "v4.36";
		case "6F18D6BB2B3DC12D0D2E5AD5CC66586B" : return "v4.36creative";
		case "6F18D6BB2B3DC12D0D2E5AD5CC66586B" : return "v4.40";
		case "826C57919CEB23009C98D7FB4E51D350" : return "v4.51a";
		case "B38D04964E4F2EA681A1A15C2BD9E614" : return "v4.51b";
		case "F6487EFE25997FE5843D2178FE3BEC07" : return "v4.36GOTY";
		default : return "Unknown";
	}
}

function string GetGalaxyVersion(string MD5)
{
	switch (MD5)
	{
		case "CB246E9A387CC002E6EA13264AC0DC08" : return "v4.36";
		case "F3D4D4D956A3F82B8BFF1BB4958D27A7" : return "v4.36creative";
		case "CB246E9A387CC002E6EA13264AC0DC08" : return "v4.40";
		case "AB8D834F97F7532E2CFAC1BB6EF4F613" : return "v4.51a";
		case "64F733A15A18644584B8C2895B431CD5" : return "v4.51b";
		case "FDAC609BE71693E9102E5F38165D0678" : return "v4.36GOTY";
		default : return "Unknown";
	}
}

function string GetEngineVersion(string MD5)
{
	switch (MD5)
	{
		case "30E34C2A9E0EAB908C5DA6F322F4E2D7" : return "v4.36";
		case "7FCED6475943F2457B1483F0AE64EC17" : return "v4.36creative";
		case "CACED1EE932D1C7CF6EDCDF1572DCBAB" : return "v4.40";
		case "039F49159DBE8A7C4516BE26DC618AD4" : return "v4.51a";
		case "2E43AC725D9055475BF71D8C850B10F6" : return "v4.51a";
		case "CDA75950ECEBB2E1E4A404A48FA39A45" : return "v4.51b";
		case "07447166E4443EA945CD7470CC50720A" : return "v4.36GOTY";
		default : return "Unknown";
	}
}

// Cheat detected events.
function LogPlayerInfo(PlayerPawn Player, IUTDCCheck Check)
{
	UTDCLog("Player name......: " $ Check.GetPlayerName(Player), true);
	UTDCLog("Player IP........: " $ Check.GetIpAdress(Player), true);
	UTDCLog("Client UT version: " $ Check.ClientUtVersion, true);
	UTDCLog("Client OS........: " $ Check.WindowsVersion, true);

	UTDCLog(Check.PostPad(Check.RenderDrvFile@"MD5", ".", 17) $ ": " $ Check.RenderDrvMD5, true);
	UTDCLog("Core.dll MD5.....: " $ Check.CoreMD5 @ "("$GetCoreVersion(Check.CoreMD5)$")", true);
	UTDCLog("Engine.dll MD5...: " $ Check.EngineMD5 @ "("$GetEngineVersion(Check.EngineMD5)$")", true);
	UTDCLog("Render.dll MD5...: " $ Check.RenderMD5 @ "("$GetRenderVersion(Check.RenderMD5)$")", true);
	UTDCLog("Galaxy.dll MD5...: " $ Check.GalaxyMD5 @ "("$GetGalaxyVersion(Check.GalaxyMD5)$")", true);
	UTDCLog("UTDCx.dll MD5....: " $ Check.UTDCMD5, true);
	UTDCLog("MAC hash.........: " $ Check.MACHash, true);
	UTDCLog("Mem NTDLL image..: " $ Check.bNtDllMemCopy, true);
}

// Player failed the memory check.
function PlayerFailedMemoryCheck(PlayerPawn Player, IUTDCCheck Check, int LogType, string Addrs, string Hash)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	if (LogType == CheckType.ExtraInfo)
	{
		UTDCLog("+---------------------------------------------------+", true);
		UTDCLog("Additional memory scan information for player:" @ PlayerName $"/"$ Check.GetIpAdress(Player), true);
		UTDCLog("Corruption hash..: " $ Hash, true);
		UTDCLog("Altered addresses: " $ Addrs, true);
		UTDCLog("+---------------------------------------------------+", true);
		return;
	}

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have corrupt memory", true);
	LogPlayerInfo(Player, Check);
	UTDCLog("Corruption hash..: " $ Hash, true);
	UTDCLog("Altered addresses: " $ Addrs, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickForCorruptMemory)
	{
		Player.ClientMessage("[UTDC] Your computer memory is corrupt. Try restarting UT to solve this.");
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of corrupt memory.");
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

// Player failed the Server / Client check.
function PlayerFailedCheck(PlayerPawn Player, IUTDCCheck Check, string ServerReceived, string AlteredInfo, string ProcessNames, string AlteredId, string ExtraInfo, string HookMatch)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have hooked functions", true);
	LogPlayerInfo(Player, Check);
	UTDCLog("Server Received..: " $ ServerReceived, true);
	UTDCLog("Altered addresses: " $ AlteredInfo, true);
	UTDCLog("Hook Match.......: " $ HookMatch, true);
	if (Len(ProcessNames) > 0)
		UTDCLog("Suspect Processes: " $ ProcessNames, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickPlayer && (!MyMut.bSafeKick || (MyMut.bSafeKick && HookMatch != "Unknown" && HookMatch != "Custom")))
	{
		if (MyMut.bBanPlayer)
		{
			DCMut.BanPlayer(Player);
		}

		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of an illegal hook.");
		Check.KickPlayer(6);
		Check.OpenConsole();
	}

	Check.MemoryCheck(CheckType.ExtraInfo);
}

// Player failed file check.
function PlayerFailedFileCheck(PlayerPawn Player, IUTDCCheck Check, int FileIndex, string Hash)
{
	LogFailedFileCheck(Player, Check, MyMut.Package[FileIndex], Hash);
}

function LogFailedFileCheck(PlayerPawn Player, IUTDCCheck Check, string FileName, string Hash)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have failed integrity check", true);
	LogPlayerInfo(Player, Check);
	UTDCLog("Altered File.....: " $ FileName, true);
	UTDCLog("Server Received..: " $ Hash, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bBanPlayer)
	{
		DCMut.BanPlayer(Player);
	}

	if (MyMut.bKickForCorruptFile)
	{
		Player.ClientMessage("[UTDC] " $ "The file:"@FileName@"have failed the integrity check. Contact the server admin and/or try removing the file to solve the problem.");
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of failed integrity check.");
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

// Player failed process check.
function PlayerFailedProcessCheck(PlayerPawn Player, IUTDCCheck Check, bool bTimer, bool bSpeedHack, bool bHook, string CheatTrace)
{
	local private string TypeOfCheat;
	local private string PlayerName;

	TypeOfCheat = "";
	if (bTimer)
	{
		TypeOfCheat = "Timer, ";
	}
	if (bSpeedHack)
	{
		TypeOfCheat = TypeOfCheat $ "Speed Hack, ";
	}
	if (bHook)
	{
		TypeOfCheat = TypeOfCheat $ "Hook, ";
	}
	TypeOfCheat = Left(TypeOfCheat, Len(TypeOfCheat)-2);

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client is using a cheat", true);
	LogPlayerInfo(Player, Check);
	UTDCLog("Cheat Type.......: " $ TypeOfCheat, true);
	UTDCLog("Cheat Trace......: " $ CheatTrace, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickForSpeedHack && bSpeedHack || 
		MyMut.bKickForTimer && bTimer || 
		MyMut.bKickForHook && bHook)
	{
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of a cheat trace:"@TypeOfCheat);
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
	else if ((!bTimer && !bSpeedHack && !bHook) || CheatTrace == "")
	{
		UTDCLog(PlayerName@"- Abnormal state.", true);
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

// Illegal UFunction call detected.
function IllegalUFunctionCall(PlayerPawn Player, IUTDCCheck Check, string IllegalFuncCaller, string IllegalFuncCallee, string IllegalCallerClass)
{
	local private string PlayerName;

	PlayerName = Player.PlayerReplicationInfo.PlayerName;

	UTDCLog("+---------------------------------------------------+", true);
	UTDCLog("Client have made an illegal ufunction call", true);
	LogPlayerInfo(Player, Check);
	UTDCLog("Function called..: " $ IllegalFuncCallee, true);
	UTDCLog("Function caller..: " $ IllegalCallerClass $ "," $ IllegalFuncCaller, true);
	UTDCLog("Date/Time........: " $ Check.GetDateString(), true);
	UTDCLog("+---------------------------------------------------+", true);

	if (MyMut.bKickForUBot)
	{
		Player.ClientMessage("[UTDC] You have been kicked because of an illegal ufunction call.");
		Level.BroadcastMessage("[UTDC] " $ PlayerName $ " have been kicked because of an illegal ufunction call.");
		Check.KickPlayer(3);
		Check.OpenConsole();
	}
}

//------------------------------------------------//

defaultproperties
{
	bAlwaysRelevant=True	
}