class ActionMan extends IUTDCCheckEvent;

var IUTDCCheck Check;
var IUTDC DCMut;
var ActionMut MyMut;
var EventActor EA;

var int ChkProcessIndex;
var int ChkFileIndex;
var string WinTitleList[4];
var int WinTitleCount;

const FileCheckTryCount	= 3;
const MemoryTryCount	= 3;
const ProcessTryCount	= 3;

const FileCheckPollInterval	= 5;
const MemoryPollInterval	= 8;
const ProcessPollInterval	= 8;

function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);

	if (Owner == None)
	{
		Disable('Tick');
		Destroy();
	}
}

auto state StartInit
{
	Begin:
		if (Check != None)
		{
			// Init.
			ChkFileIndex = 0;
			ChkProcessIndex = 0;
			WinTitleList[0] = "mastertimer v";
			WinTitleList[1] = "timer pro 5.0 -";
			WinTitleList[2] = "by |n|prd!g";
			WinTitleCount = 3;


			Check.AddEventCatcher(self);

			// Start check.
			DoProcessCheck();
		}
}

function DoProcessCheck()
{
	if (ChkProcessIndex < WinTitleCount)
	{
		Check.FindWindowWithTimeout(ProcessPollInterval, ProcessTryCount, WinTitleList[ChkProcessIndex], ChkProcessIndex);
	}
	else
	{
		DoFileCheck();
	}
}

function FindWindowResponse(bool bFound, string Info, int Index)
{
	if (bFound)
	{
		EA.PlayerFailedProcessCheck(PlayerPawn(Owner), Check, true, false, false, Info);
	}
	
	ChkProcessIndex++;
	DoProcessCheck();
}

function DoFileCheck()
{
	if (ChkFileIndex < MyMut.MAXFILESTOCHECK && MyMut.Package[ChkFileIndex] != "")
	{
		Check.FileCheckWithTimeout(FileCheckPollInterval, FileCheckTryCount, MyMut.Package[ChkFileIndex], ChkFileIndex);
	}
	else
	{
		DoMemoryCheck();
	}
}

function FileCheckResponse(string FileHash, int FileIndex)
{
	if (Len(FileHash) != 32)
	{
		EA.PlayerFailedFileCheck(PlayerPawn(Owner), Check, FileIndex, FileHash);
	}
	else if (InStr(CAPS(MyMut.MD5[FileIndex]), CAPS(FileHash)) == -1)
	{
		EA.PlayerFailedFileCheck(PlayerPawn(Owner), Check, FileIndex, FileHash);
	}
	
	ChkFileIndex++;
	DoFileCheck();
}

function DoMemoryCheck()
{
	Check.MemoryCheckWithTimeout(MemoryPollInterval, MemoryTryCount, CheckType.Request);
}

function MemoryCheckFinished(bool bCalledFromPlayerCheck)
{
	if (bCalledFromPlayerCheck)
	{
		if (MyMut.bClientCheck)
		{
			Check.StartClientCheck(MyMut.ClientCheckInterval);
		}
		Check.FadeUTDCLogo();
		if (MyMut.bServerCheck)
		{
			Check.StartServerCheck(MyMut.CheckInterval);
		}
	}
}