//================================================================================
// AdminMovePlayer for Unreal Tournament 4.36 by James P.
// Version 0.1 (20090124)
// Please give credit to the author if you modify this mutator
//================================================================================

class AdminMovePlayer extends Mutator
	config( AdminMovePlayer );

var private bool bInitialized;

// Internal class variables
var private Pawn destPawn, sendPawn;

function PreBeginPlay()
{
	Super.PreBeginPlay();

	// Necessary to get round a bug that causes PreBeginPlay() to get called twice
	if ( !bInitialized )
		bInitialized = true;
	else
		return;

	log("Starting AdminMovePlayer (Beta)",'AdminMovePlayer');

	// Save ini settings and create ini file in the same go
	SaveConfig();
}

function Mutate( string mutateString, PlayerPawn pp )
{
	local int i, paramNumber;
    local Pawn p;
	local string paramString;

	Super.Mutate( mutateString, pp );

	if ( pp.PlayerReplicationInfo.bAdmin )
	{
		if ( Caps(MutateString) == "ADMINMOVEPLAYER" || Caps(MutateString) == "AMP" )
		{
			pp.ClientMessage( "AdminMovePlayer 0.1" );
			pp.ClientMessage( "- Type \"AMP getplayerlist\" to get the list of players and their playerIDs." );
			pp.ClientMessage( "- Type \"AMP playerdest <playerID>\" to choose the destination player." );
			pp.ClientMessage( "- Type \"AMP playersend <playerID>\" to choose the player to be sent." );
		}
		else if( Caps(MutateString) == "AMP GETPLAYERLIST" )
		{
			p = Level.PawnList;

			if( p == none )
			{
				pp.ClientMessage( "No players found" );

				return;
			}

			while ( p != none )
			{
				if( ( p.IsA('PlayerPawn') || p.IsA('Bot') ) && !p.PlayerReplicationInfo.bIsSpectator )
				{
					pp.ClientMessage( "PID:" @ P.PlayerReplicationInfo.PlayerID @ "Name:" @ p.PlayerReplicationInfo.PlayerName );
				}

				p = p.nextPawn;
			}
		}
		else if( Left( Caps( MutateString ), 14 ) == "AMP PLAYERDEST" )
		{
			paramNumber = int( Mid(MutateString, 14) ); // get parameters only


			if( paramNumber >= 0 && paramNumber <= 32 )
			{
				p = getPawnFromPID( paramNumber );

				if( p == none )
				{
					pp.ClientMessage( "This playerID doesn't seem to correspond to an existing player. Please try again" );

					return;
				}
				else
				{
					pp.ClientMessage( p.PlayerReplicationInfo.PlayerName @ "was chosen as destination" );
					destPawn = p;

					/* if( p.GetStateName() == 'Dying' )
					{
						pp.ClientMessage( "Destination player seems to be dying. Please choose another destination player" );

						return;
					} */

					if( sendPawn != none )
					{
						p.SetCollision( true, true, false );
						p.SetDisplayProperties( STY_Translucent, p.Texture, p.bUnLit, p.bMeshEnviromap );

						sendPawn.ClientSetLocation( destPawn.Location, destPawn.ViewRotation );
						pp.ClientMessage( "Player has been sent." );

						destPawn = none;
						sendPawn = none;
					}
					else
						pp.ClientMessage( "Please choose a player to send." );
				}
			}
		}
		else if( Left( Caps( MutateString ), 14 ) == "AMP PLAYERSEND" )
		{
			paramNumber = int( Mid(MutateString, 14) );

			if( paramNumber >= 0 && paramNumber <= 32 )
			{
				p = getPawnFromPID( paramNumber );

				if( p == none )
				{
					pp.ClientMessage( "This playerID doesn't seem to correspond to an existing player. Please try again" );

					return;
				}
				else
				{
					pp.ClientMessage( p.PlayerReplicationInfo.PlayerName @ "was chosen as player to be sent." );
					sendPawn = p;

					if( destPawn != none )
					{
						p.SetCollision( true, true, false );
						p.SetDisplayProperties( STY_Translucent, p.Texture, p.bUnLit, p.bMeshEnviromap );

						sendPawn.ClientSetLocation( destPawn.Location, destPawn.ViewRotation );
						pp.ClientMessage( "Player has been sent." );

						destPawn = none;
						sendPawn = none;
					}
					else
						pp.ClientMessage( "Please choose a player as a destination." );
				}
			}
		}
	}
}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	Super.PreventDeath(Killed,Killer,DamageType,HitLocation);

	if( Killer.Style == STY_Translucent && Killer.bBlockPlayers == false )
	{
		Killer.SetDisplayProperties( STY_Normal, Killer.Texture, Killer.bUnLit, Killer.bMeshEnviromap );
		Killer.SetCollision( true, true, true );

		return true;
	}

	return false;
}

function Pawn getPawnFromPID( int PlayerID )
{
    local Pawn p;

    p = Level.PawnList;

    while ( p != none )
    {
        if( p.IsA('PlayerPawn') || P.IsA('Bot') )
        {
            if( P.PlayerReplicationInfo.PlayerID == PlayerID )
                return p;
        }

        p = p.nextPawn;
    }

	return none;
}
