/*##################################################################################################
##
##  BTCheckPoints 1.0
##  Copyright (C) 2010 Patrick "Sp0ngeb0b" Peltzer
##
##  This program is free software; you can redistribute and/or modify
##  it under the terms of the Open Unreal Mod License version 1.1.
##
##  Contact: spongebobut@yahoo.com | www.unrealriders.de
##
####################################################################################################
##
## Class: Checkpoint
##
##################################################################################################*/
class Checkpoint extends Decoration;

#exec TEXTURE IMPORT NAME=blue FILE=Resources\blue.pcx

var int CPType;               // Checkpoint type

var texture TeamTex[4];       // Team-colored marking-textures

var vector OrgLocation;       // Original Player Location
var rotator OrgRotation;      // Original Player Rotation

/*##################################################################################################
##
## PostBeginPlay -> Set mesh, skin, and animation
##
##################################################################################################*/
function PostBeginPlay() {
  local vector currLocation;
  local int i;

  // Save original location and rotation
  OrgLocation = Location;
  OrgRotation = Rotation;
  
  // Set type
  if(CPType == 1) {  // Marking
  
    currLocation = Location;
    currLocation.Z -= 40.0;   // Put the marking on the ground
  
    setLocation(currLocation);
    setRotation(rot(0, 0, 0));

    Mesh = LodMesh'Botpack.CircleStud';
    Skin = TeamTex[PlayerPawn(Owner).PlayerReplicationInfo.Team];
    
  } else {           // Player ghost

    // Set mesh
    mesh = owner.mesh;

    // Set multiskins
    for(i=0;i<8;i++) {
      if(owner.multiskins[i] != none) {
        multiskins[i] = owner.multiskins[i];
      }
    }

    // Loop animation
    if(Region.Zone.bWaterZone) LoopAnim('TreadLg');
    else LoopAnim('Breath1');
  }

}


/*##################################################################################################
##
## defaultproperties
##
##################################################################################################*/
defaultproperties
{
    DrawType=DT_Mesh
    Style=STY_Translucent
    Skin=Texture'Botpack.FacePanel0'
    bUnlit=True
    bStatic=False
    bCollideActors=True
    CollisionRadius=17.000000
    CollisionHeight=39.000000
    TeamTex(0)=Texture'Botpack.Ammocount.AmmoCountJunk'
    TeamTex(1)=Texture'blue'
    TeamTex(2)=Texture'Botpack.Ammocount.AmmoCountBar'
    TeamTex(3)=Texture'Botpack.Skins.JUT_Tracer_01'
}