/*
    BTPlusPlus 0.97
    Copyright (C) 2004-2006 Damian "Rush" Kaczmarek

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class FlagDisposer extends Actor;

var BTPlusPlus Controller;
var byte Team;
var FlagBase	HomeBase;
var CTFFlag Flag;
var Pawn Holder;
var CTFFlag NewFlag;

function SetHolderLighting()
{
	Holder.AmbientGlow = 254;
	LightType = LT_None;
	Holder.LightEffect=LE_NonIncidence;
	Holder.LightBrightness=255;
	//red light for red flag and blue for blue flag
	if(Team==0)
		Holder.LightHue=0;
	else
		Holder.LightHue=170;
	Holder.LightRadius=6;
	Holder.LightSaturation=LightSaturation;
	Holder.LightType=LT_Steady;
}

function ScoreFlag(Pawn Scorer, CTFFlag theFlag, int time)
{
	local pawn TeamMate;
	local Actor A;

 	if ( ( time > Scorer.PlayerReplicationInfo.Score && Scorer.PlayerReplicationInfo.Score > 0 ) || Scorer.PlayerReplicationInfo.Score == 0)
		Scorer.PlayerReplicationInfo.Score=time;

	CTFGame(Level.Game).Teams[Scorer.PlayerReplicationInfo.Team].Score += 1.0;

	BroadcastLocalizedMessage( class'CTFMessage', 0, Scorer.PlayerReplicationInfo, None, TheFlag );

	for ( TeamMate=Level.PawnList; TeamMate!=None; TeamMate=TeamMate.NextPawn )
	{
		if ( TeamMate.IsA('PlayerPawn') )
			PlayerPawn(TeamMate).ClientPlaySound(CTFGame(Level.Game).CaptureSound[Scorer.PlayerReplicationInfo.Team]);
	}
	if ( theFlag.HomeBase.Event != '' )
		foreach allactors(class'Actor', A, theFlag.HomeBase.Event )
			A.Trigger(theFlag.HomeBase,	Scorer);
      if ( (CTFGame(Level.Game).bOverTime || (CTFGame(Level.Game).GoalTeamScore != 0)) && (CTFGame(Level.Game).Teams[Scorer.PlayerReplicationInfo.Team].Score >= CTFGame(Level.Game).GoalTeamScore) )
		CTFGame(Level.Game).EndGame("teamscorelimit");
	else if ( CTFGame(Level.Game).bOverTime )
		CTFGame(Level.Game).EndGame("timelimit");
}

function Touch(Actor Other)
{
	local CTFFlag aFlag;
	local Pawn aPawn;
	local NavigationPoint StartSpot;
	local int i, ID;
	local CTFFlag F;
	local int BestTime, BestTimeClient;
	local int NewTime;
	local Pawn Temp;
	local int OldScore;

	aPawn = Pawn(Other);
	if ( (aPawn != None) && aPawn.bIsPlayer && (aPawn.Health > 0) )
	{
		// check if scored capture
		if ( aPawn.PlayerReplicationInfo.Team == Team )
		{
			if ( aPawn.PlayerReplicationInfo.HasFlag != None)
			{
				//Score!
				aFlag = CTFFlag(aPawn.PlayerReplicationInfo.HasFlag);
				NewTime = 2000 - (Level.TimeSeconds - aPawn.PlayerReplicationInfo.StartTime);
				BestTime = Controller.GetBestTimeServer(aPawn); // on the current map
				BestTimeClient = Controller.GetBestTimeClient(aPawn); // set in client's user.ini
				OldScore=PlayerPawn(aPawn).PlayerReplicationInfo.Score;
				if(Controller.bNoCapSuicide && InStr(Caps(string(Level.Game.class)), Caps("BunnyTrack")) != -1)
					ScoreFlag(aPawn, aFlag, NewTime);
				else
					CTFGame(Level.Game).ScoreFlag(aPawn, aFlag);
				Controller.PlayerCapped(aPawn);
				aFlag.SendHome();
				aPawn.PlayerReplicationInfo.HasFlag = None;
				Controller.SetNoneFlag(aPawn); // in case the original replication won't work
				if(Controller.bMultiFlags)
				{
					aFlag.SetCollision(false, false, false);
					aFlag.bHidden=True;
					aFlag.Destroy(); // sometimes this destroy doesn't seem to work, that's way the previous operations in this statement code
				}

				// make the lights around the player normal
				aPawn.AmbientGlow = aPawn.Default.AmbientGlow;
				aPawn.LightType = LT_None;

				Controller.SendEvent("cap", aPawn.PlayerReplicationInfo.PlayerID, NewTime, Controller.CurTimestamp());
				if(!Controller.GetSTFU(aPawn))
				{
					PlayerPawn(aPawn).ClearProgressMessages();
	    			PlayerPawn(aPawn).SetProgressTime(8);
					if(NewTime>BestTime)
			    	{
						PlayerPawn(aPawn).SetProgressColor(Controller.GreenColor, 0);
						PlayerPawn(aPawn).SetProgressMessage("Cap Time: "$FormatScore(NewTime), 0);
						if(NewTime > Controller.MapBestTime && Controller.MapBestTime != 0)
						{
							if(Controller.CheckIfBoosted(aPawn) && (Controller.RecordsWithoutBoost == 1 || (Controller.RecordsWithoutBoost == 2 && !Controller.bCooperationMap)))
							{

								PlayerPawn(aPawn).PlayerReplicationInfo.Score=OldScore;
								PlayerPawn(aPawn).SetProgressColor(Controller.RedColor, 2);
								PlayerPawn(aPawn).SetProgressMessage("You were boosted, this cap does not count !!!", 2);
								if(BestTimeClient!=0)
									PlayerPawn(aPawn).SetProgressMessage("Your record is: "$FormatScore(BestTimeClient),3);
								if(Controller.MapBestTime != 0)
									PlayerPawn(aPawn).SetProgressMessage("Server record is: "$FormatScore(Controller.MapBestTime)$"(set by "$Controller.MapBestPlayer$")",4);
							}
							else
							{
								PlayerPawn(aPawn).SetProgressMessage("You have beaten the map record !!!", 2);
								PlayerPawn(aPawn).SetProgressMessage("Previous was: "$FormatScore(Controller.MapBestTime)$"(set by "$Controller.MapBestPlayer$")", 3);
								if(BestTimeClient!=0 && BestTimeClient != -1 && NewTime > BestTimeClient)
								{
									PlayerPawn(aPawn).SetProgressMessage("You have also beaten your own record !", 4);
									PlayerPawn(aPawn).SetProgressMessage("Previous was: "$FormatScore(BestTimeClient), 5);
								}
							}
						}
						else if(BestTimeClient!=0 && BestTimeClient != -1 && NewTime > BestTimeClient)
						{
							if(Controller.CheckIfBoosted(aPawn) && (Controller.RecordsWithoutBoost == 1 || (Controller.RecordsWithoutBoost == 2 && !Controller.bCooperationMap)))
							{
								PlayerPawn(aPawn).PlayerReplicationInfo.Score=OldScore;
								PlayerPawn(aPawn).SetProgressColor(Controller.RedColor, 2);
								PlayerPawn(aPawn).SetProgressMessage("You were boosted, this cap does not count !!!", 2);
								if(BestTimeClient!=0)
									PlayerPawn(aPawn).SetProgressMessage("Your record is: "$FormatScore(BestTimeClient),3);
								if(Controller.MapBestTime != 0)
									PlayerPawn(aPawn).SetProgressMessage("Server record is: "$FormatScore(Controller.MapBestTime)$"(set by "$Controller.MapBestPlayer$")",4);
							}
							else
							{
								PlayerPawn(aPawn).SetProgressMessage("You have beaten your record !", 2);
								PlayerPawn(aPawn).SetProgressMessage("Previous was: "$FormatScore(BestTimeClient), 3);
								if(Controller.MapBestTime != 0)
									PlayerPawn(aPawn).SetProgressMessage("Server record is: "$FormatScore(Controller.MapBestTime)$"(set by "$Controller.MapBestPlayer$")",4);
							}
						}
						else if(Controller.MapBestTime != 0)
							PlayerPawn(aPawn).SetProgressMessage("Server record is: "$FormatScore(Controller.MapBestTime)$"(set by "$Controller.MapBestPlayer$")",2);
					}
					else
					{
						PlayerPawn(aPawn).SetProgressColor(Controller.GreenColor, 0);
						PlayerPawn(aPawn).SetProgressMessage("Cap Time: "$FormatScore(NewTime), 0);
						if(BestTimeClient!=0)
							PlayerPawn(aPawn).SetProgressMessage("Your record is: "$FormatScore(BestTimeClient),2);
						if(Controller.MapBestTime != 0)
							PlayerPawn(aPawn).SetProgressMessage("Map record is: "$FormatScore(Controller.MapBestTime)$"(set by "$Controller.MapBestPlayer$")",3);
					}
				}
				if(!Controller.CheckIfBoosted(aPawn) || !(Controller.RecordsWithoutBoost == 1 || (Controller.RecordsWithoutBoost == 2 && Controller.bCooperationMap)))
					Controller.SetBestTime(aPawn, NewTime);

				//BlockMulticaps in CTF, teleports a player to the respawn point after a cap
				if(Controller.bRespawnAfterCap)
				{
					aPawn.Weapon.bCanThrow = false; // just in case someone doesn't play with Insta
					Level.Game.DiscardInventory(aPawn);
					if(aPawn.PlayerReplicationInfo.HasFlag != None) // dunno why but sometimes the flag still remains at this point :F
						aPawn.PlayerReplicationInfo.HasFlag.Destroy();
					Controller.UpdatePlayerStartTimes(aPawn);

					/* if not the end of game, teleport the player to the start point */
					if(!Level.Game.bGameEnded)
					{
						Level.Game.PlayTeleportEffect(aPawn, True, True);
						aPawn.bHidden=True;
						PlayerPawn(aPawn).GoToState('Dying');
					}
				}
			}
		}
		// no flag ? please take one :)
		else if(aPawn.PlayerReplicationInfo.HasFlag == None && Controller.bMultiFlags)
		{
			// Let me see .... which one to spawn ? Red or blue one ?
			if(Team==1)
				NewFlag = Spawn(class'BTPPFlagBlue');
			else
				NewFlag = Spawn(class'BTPPFlagRed');
			// Spawning from external package failure ....
			if(NewFlag==None)
			{
				log("BTPlusPlus: Error, you haven't added BTPlusPlusv097test1_C to ServerPackages !!!");
				if(Team==1)
					NewFlag = Spawn(class'CTFFlag');
				else
					NewFlag = Spawn(class'RedFlag');
			}
			//Need to set a few variables to avoid Accessed Nones
			NewFlag.Skin = Flag.Skin;
			NewFlag.Team = Team;
			NewFlag.HomeBase = HomeBase;
			NewFlag.Holder = aPawn;
			NewFlag.GotoState('Held');
			Flag.bHome = True;  //Fixes the CTFHud
			HomeBase.bHidden = false;  //Changes the variable set by GoToState('Held')
			NewFlag.Skin = Flag.Skin; //Compatibility with custom flag textures
			Holder = aPawn;
			Holder.MoveTimer = -1;
			Holder.PlayerReplicationInfo.HasFlag = NewFlag;
			//Do everything as the normal flag script do ....
			Holder.MakeNoise(2.0);
			SetHolderLighting();
			if ( Holder.IsA('TournamentPlayer') && TournamentPlayer(Holder).bAutoTaunt )
				Holder.SendTeamMessage(None, 'OTHER', 2, 10);

			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogSpecialEvent("flag_taken", Holder.PlayerReplicationInfo.PlayerID, CTFGame(Level.Game).Teams[Team].TeamIndex);
			BroadcastLocalizedMessage( class'CTFMessage', 6, Holder.PlayerReplicationInfo, None, CTFGame(Level.Game).Teams[Team] );
		}
	}
}

function string FormatScore(int Score)
{
	local int secs;
	local string sec;

	if(Score==0 || Score==2000)
		return "-:--";
	else if ( Score > 1 && Score < 1999 )
	{
		Score = 2000 - Score;
		secs = int(Score % 60);
		if ( secs < 10 )
                	sec = "0" $string(secs);
            	else
			sec = "" $string(secs);
		return string(Score / 60) $":"$sec;
	}
}

defaultproperties
{
     CollisionRadius=48.000000
     CollisionHeight=30.000000
     bStatic=False
     bHidden=True
     bCollideActors=True
     NetPriority=3.000000
}
