/*
    BTPlusPlus 0.97
    Copyright (C) 2004-2006 Damian "Rush" Kaczmarek

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class RecordData expands Actor config(BTRecords);

var config string Record[255];
var config int RecordsNum;
var BTPlusPlus Main;

//====================================
// CheckRecord - returns a record info for a specified map
// Triggered in: class'BTPlusPlus'.PostBeginPlay, class'BTPlusPlus'.SetSaveRecords
//====================================
function string CheckRecord(string MapName)
{
	local int i, j;
	local string temp;
	local string date;

	for(i=0;i<255;i++)
	{
		if(Record[i]=="")
			continue;
		if(InStr(Record[i], MapName) != -1)
		{
			for( j=1;j<=Main.ElementsNum(Record[i], chr(11));j++)
			{
				temp=Main.SelElem(Record[i], j, chr(11));
				if(InStr(temp, MapName) != -1)
				{
					if(Main.SelElem(temp, 1, chr(9)) == MapName)
					{
						return Main.SelElem(temp, 2, chr(9))$chr(9)$Main.SelElem(temp, 3, chr(9))$chr(9)$Main.SelElem(temp, 4, chr(9));
					}
				}
			}
		}
	}
}

//====================================
// AddRecord - alters or adds a new record for the specified map
// Triggered in: class'BTPlusPlus'.SetBestTime, class'BTPlusPlus'.SetSaveRecords
//====================================
function AddRecord(string MapName, int time, string Player, optional int timestamp)
{
	local int i, j, k;
	local string temp, temp2, temp3;

	for(i=0;i<255;i++)
	{
		if(Record[i]=="")
			continue;
		if(InStr(Record[i], MapName) != -1)
		{
			for( j=1;j<=Main.ElementsNum(Record[i], chr(11));j++)
			{
				temp=Main.SelElem(Record[i], j, chr(11));
				if(Main.SelElem(temp, 1, chr(9)) == MapName)
				{
					temp=string(time);
					while(len(temp) < 4)
						temp=temp$" ";
					temp2=Player;
					while(len(temp2) < 25)
						temp2=temp2$" ";

					if(timestamp > 0)
						temp3=chr(9)$string(timestamp);

					Record[i]=SetElem(Record[i], j, MapName$chr(9)$temp$chr(9)$temp2$temp3, chr(11) );
					SaveConfig();
					return;
				}
			}
		}
	}
	for(i=0;i<255;i++)
	{
		if( (len(Record[i]) + len(MapName) + 31) > 255)
			continue;
		temp=string(time);
		while(len(temp) < 4)
			temp=temp$" ";
		temp2=Player;
		while(len(temp2) < 25)
			temp2=temp2$" ";

		if(timestamp > 0)
			temp3=chr(9)$string(timestamp);

		if(Record[i]=="")
			Record[i]=MapName$chr(9)$temp$chr(9)$temp2$temp3;
		else
			Record[i]=Record[i]$chr(11)$MapName$chr(9)$temp$chr(9)$temp2$temp3;
		RecordsNum++;
		SaveConfig();
		return;
	}
}

//====================================
// FindByPlayer - Searches database for map records by player name and send messages to the player
// Triggered in: class'BTPlusPlus'.Mutate
//====================================
function FindByPlayer(Pawn P, string Player)
{
	local int i, j;
	local string temp, Time, MapName, PlayerName;
	local bool bFound;

	for(i=0;i<255;i++)
	{
		if(Record[i]=="")
			continue;
		if(InStr(Caps(Record[i]), Caps(Player)) != -1)
		{
			for( j=1;j<=Main.ElementsNum(Record[i], chr(11));j++)
			{
				temp=Main.SelElem(Record[i], j, chr(11));

				PlayerName=Main.SelElem(temp, 3, chr(9));
				if(InStr(Caps(PlayerName), Caps(Player)) != -1 )
				{
					Time=Main.FormatScore(int(Main.SelElem(temp, 2, chr(9))));
					MapName=Main.SelElem(temp, 1, chr(9));
					P.ClientMessage(MapName$" - "$Time$" set by "$PlayerName);
					bFound=True;
				}
			}
		}
	}
	if(!bFound)
			P.ClientMessage("Sorry, no records found.");
}

//====================================
// FindByMap - Searches database for map records by map name and send messages to the player
// Triggered in: class'BTPlusPlus'.Mutate
//====================================
function FindByMap(Pawn P, string MapName)
{
	local int i, j;
	local string temp, Player, Time;
	local bool bFound;

	if(Left(Caps(MapName), 4) == "CTF-") // remove confusion with different naming conventions CTF-BT/BT-
		MapName=Mid(MapName, 4);

	for(i=0;i<255;i++)
	{
		if(Record[i]=="")
			continue;
		if(InStr(Caps(Record[i]), Caps(MapName)) != -1)
		{
			for( j=1;j<=Main.ElementsNum(Record[i], chr(11));j++)
			{
				temp=Main.SelElem(Record[i], j, chr(11));
				if(InStr(Caps(Main.SelElem(temp, 1, chr(9))), Caps(MapName)) != -1)
				{
					Player=Main.SelElem(temp, 3, chr(9));
					Time=Main.FormatScore(int(Main.SelElem(temp, 2, chr(9))));
					P.ClientMessage(Main.SelElem(temp, 1, chr(9))$" - "$Time$" set by "$Player);
					bFound=True;
				}
			}
		}
	}
	if(!bFound)
		P.ClientMessage("Sorry, no records found. Maybe you made a typo ?");
}

function ConvertToNewFormat ()
{
	local int i;
	log("Converting BTRecords.ini file to the new format, it might need some manual corrections though.");
	RecordsNum=0;
	for(i=0;i<255;i++)
	{
		if(Record[i] == "")
			continue;
		Record[i]=ReplaceText(Record[i], ",", chr(11));
		Record[i]=ReplaceText(Record[i], ":", chr(9));
		// NOTE: recurency is known to be slower than this way

		RecordsNum+=Main.ElementsNum(Record[i], chr(11));
	}
	SaveConfig();
}


//#########################################################################
//### TEXT FUNCTIONS - used all over the place :)
//#########################################################################
//====================================
// SetElem - Replace an element in a string with elements separated by Char
//====================================
static final function string SetElem(string Str, int Elem, string SetStr, optional string Char)
{
	local int pos;
	local string LeftSide, RightSide, Temp, OneElem;
	if(Char=="")
		Char=chr(9);

	Temp=Str;

	while(Elem>1)
	{
		pos=InStr(Temp, Char);
		OneElem=Left(Temp, pos+1);
		Temp=Right(Temp, len(Temp)-pos-1);
		Leftside=Leftside$OneElem;
		Elem--;
	}
	pos=InStr(Temp, Char);
	if(pos != -1)
		RightSide=Right(Temp, len(Temp)-pos);
	else // last element, not containing char
		RightSide="";

    return Leftside$SetStr$Rightside;
}

//====================================
// ReplaceText - Replace one text string with another text string in a text string :)
//====================================
static final function string ReplaceText(coerce string Text, coerce string Replace, coerce string With)
{
    local int i;
    local string Output;

    i = InStr(Text, Replace);
    while (i != -1)
	{
        Output = Output$Left(Text, i)$With;
        Text = Mid(Text, i+Len(Replace));
        i = InStr(Text, Replace);
    }
    Output = Output$Text;
    return Output;
}
//### END OF TEXT FUNCTIONS

DefaultProperties
{
	bHidden=True
	RecordsNum=-1
}
