/*
    BTPlusPlus 0.97
    Copyright (C) 2004-2006 Damian "Rush" Kaczmarek

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class BTPPReplicationInfo expands ReplicationInfo;

var bool bBoosted;

var int PlayerID; // used to identify the owner

var float StartTime;

var float JoinTime; // works just as the original PlayerReplicationInfo.StartTime, but the original can be messed up by BunnyTruck.u
var int Runs;
var int Caps;

var int BestTime; // in current game

// IpToCountry stuff
var string CountryPrefix;
var Actor IpToCountry;

var float TimeVariance;
var float LocalStartTime;

var bool bReadyToPlay;
var bool bTournament;

replication {
reliable if (Role == ROLE_Authority)
	PlayerID, bBoosted, StartTime, SetVariance, BestTime, JoinTime, Runs, Caps, CountryPrefix, bReadyToPlay, SetNoneFlag;
}

simulated function SetVariance(float ServerTime)
{
	if(Role < ROLE_Authority)
		TimeVariance=ServerTime-Level.TimeSeconds;
}

function SetStartTime(optional coerce float Modifier)
{
	StartTime=Level.TimeSeconds-Modifier;
	SetVariance(Level.TimeSeconds);
}

event Spawned()
{
	if(ROLE == ROLE_Authority)
	{
		SetTimer(0.5, true);
		bTournament=DeathMatchPlus(Level.Game).bTournament;
	}
}

// sometimes the original replicatin doesn't properly work .. we have to help it
simulated function SetNoneFlag()
{
	if(Owner != None)
	{
		if(PlayerPawn(Owner).PlayerReplicationInfo != None)
			PlayerPawn(Owner).PlayerReplicationInfo.HasFlag=None;
	}
}

function Timer()
{
	local string temp;
	local PlayerPawn P;

	if(Owner == None)
		Destroy();
	else if(IpToCountry != None)
	{
		if(CountryPrefix == "")
		{
			P=PlayerPawn(Owner);
			if(NetConnection(P.Player) != None)
			{
				temp=P.GetPlayerNetworkAddress();
				temp=Left(temp, InStr(temp, ":"));
				temp=IpToCountry.GetItemName(temp);
				if(temp == "!Disabled") /* after this return, iptocountry won't resolve anything anyway */
					IpToCountry=None;
				else if(Left(temp, 1) != "!") /* good response */
				{
					CountryPrefix=SelElem(temp, 5);
					if(CountryPrefix=="") /* the country is probably unknown(maybe LAN), so as the prefix */
						IpToCountry=None;
				}
			}
			else
				IpToCountry=None;
		}
		else
			IpToCountry=None;
	}
	if(Owner != None && bTournament)
	{
		if(PlayerPawn(Owner).bReadyToPlay != bReadyToPlay)
		{
			bReadyToPlay = PlayerPawn(Owner).bReadyToPlay; // replicate this variable normally being serverside only
		}
	}
}

static final function string SelElem(string Str, int Elem, optional string Char)
{
	local int pos;
	if(Char=="")
		Char=":";

	while(Elem>1)
	{
		Str=Mid(Str, InStr(Str, Char)+1);
		Elem--;
	}
	pos=InStr(Str, Char);
	if(pos != -1)
    	Str=Left(Str, pos);
    return Str;
}

defaultproperties
{
  NetPriority=9.0
  PlayerID=-1
}
