/*
    BTPlusPlus 0.97
    Copyright (C) 2004-2006 Damian "Rush" Kaczmarek

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class BTScoreBoard extends UnrealCTFScoreBoard;

struct PlayerInfo
{
   var PlayerReplicationInfo PRI;
   var BTPPReplicationInfo RI;
   var string LastTime;
};
var BTPPGameReplicationInfo GRI;
var PlayerInfo PI[32];
var int Index;
var BTPPReplicationInfo OwnerRI;



struct FlagData {
	var string Prefix;
	var texture Tex;
};
var FlagData FD[32]; // there can be max 32 so max 32 different flags
var int saveindex; // new loaded flags will be saved in FD[index]

var string Spectators[32];

//refreshes spectator list
function Timer()
{
	local int i;
	local PlayerReplicationInfo PRI;

	foreach AllActors(class'PlayerReplicationInfo', PRI)
		if(PRI.bIsSpectator && !PRI.bWaitingPlayer && PRI.PlayerName != "Player")
			Spectators[i++]=PRI.PlayerName;
	while(i<32)
		Spectators[i++]="";
}

function int GetFlagIndex(string Prefix)
{
	local int i;
	for(i=0;i<32;i++)
		if(FD[i].Prefix == Prefix)
			return i;
	FD[saveindex].Prefix=Prefix;
	FD[saveindex].Tex=texture(DynamicLoadObject(GRI.CountryFlagsPackage$"."$Prefix, class'Texture'));
	i=saveindex;
	saveindex = (saveindex+1) % 256;
	return i;
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float LoopCountTeam[4];
	local float XL, YL, XOffset, YOffset, XStart;
	local int PlayerCounts[4];
	local int LongLists[4];
	local int BottomSlot[4];
	local font CanvasFont;
	local bool bCompressed;
	local float r;

	if(GRI == None)
		foreach AllActors(class'BTPPGameReplicationInfo', GRI)
		{
			SetTimer(1.0, true); // good place to initialize our timer
			break;
		}
	OwnerInfo = Pawn(Owner).PlayerReplicationInfo;
	OwnerGame = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	Canvas.Style = ERenderStyle.STY_Normal;
	DrawSpectators(Canvas);

	CanvasFont = Canvas.Font;

	// Header
	DrawHeader(Canvas);

	for ( i=0; i<32; i++ )
		Ordered[i] = None;

	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				PlayerCounts[PRI.Team]++;
			}
		}
	}
	SortScores(PlayerCount);
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("TEXT", XL, YL);
	ScoreStart = Canvas.CurY + YL*2;
	if ( ScoreStart + PlayerCount * YL + 2 > Canvas.ClipY )
	{
		bCompressed = true;
		CanvasFont = Canvas.Font;
		Canvas.Font = font'SmallFont';
		r = YL;
		Canvas.StrLen("TEXT", XL, YL);
		r = YL/r;
		Canvas.Font = CanvasFont;
	}
	for ( I=0; I<PlayerCount; I++ )
	{
		if ( Ordered[I].Team < 4 )
		{
			if ( Ordered[I].Team % 2 == 0 )
				XOffset = (Canvas.ClipX / 4) - (Canvas.ClipX / 8);
			else
				XOffset = ((Canvas.ClipX / 4) * 3) - (Canvas.ClipX / 8);

			Canvas.StrLen("TEXT", XL, YL);
			Canvas.DrawColor = AltTeamColor[Ordered[I].Team];
			YOffset = ScoreStart + (LoopCountTeam[Ordered[I].Team] * YL) + 2;
			if (( Ordered[I].Team > 1 ) && ( PlayerCounts[Ordered[I].Team-2] > 0 ))
			{
				BottomSlot[Ordered[I].Team] = 1;
				YOffset = ScoreStart + YL*11 + LoopCountTeam[Ordered[I].Team]*YL;
			}

			// Draw Name and Ping
			if ( (Ordered[I].Team < 2) && (BottomSlot[Ordered[I].Team] == 0) && (PlayerCounts[Ordered[I].Team+2] == 0))
			{
				LongLists[Ordered[I].Team] = 1;

				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			}
			else if (LoopCountTeam[Ordered[I].Team] < 8)
				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			if ( bCompressed )
				LoopCountTeam[Ordered[I].Team] += 1;
			else
				LoopCountTeam[Ordered[I].Team] += 2;
		}
	}
	for ( i=0; i<4; i++ )
	{
		Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
		if ( PlayerCounts[i] > 0 )
		{
			if ( i % 2 == 0 )
				XOffset = (Canvas.ClipX / 4) - (Canvas.ClipX / 8);
			else
				XOffset = ((Canvas.ClipX / 4) * 3) - (Canvas.ClipX / 8);
			YOffset = ScoreStart - YL + 2;

			if ( i > 1 )
				if (PlayerCounts[i-2] > 0)
					YOffset = ScoreStart + YL*10;

			Canvas.DrawColor = TeamColor[i];
			Canvas.SetPos(XOffset, YOffset);
			Canvas.StrLen(TeamName[i], XL, YL);
			DrawShadowText(Canvas, TeamName[i], false, true);
			Canvas.StrLen(int(OwnerGame.Teams[i].Score), XL, YL);
			if(Canvas.ClipX <= 800)
				Canvas.SetPos(XOffset + (Canvas.ClipX*0.30) - XL, YOffset);
			else
				Canvas.SetPos(XOffset + (Canvas.ClipX*0.26) - XL, YOffset);
			DrawShadowText(Canvas, int(OwnerGame.Teams[i].Score), false, true);

			if ( PlayerCounts[i] > 4 )
			{
				if ( i < 2 )
					YOffset = ScoreStart + YL*8;
				else
					YOffset = ScoreStart + YL*19;
				Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
				Canvas.SetPos(XOffset, YOffset);
				if (LongLists[i] == 0)
					DrawShadowText(Canvas, PlayerCounts[i] - 4 @ PlayersNotShown, false, true);
			}
		}
	}

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.Font = CanvasFont;
	Canvas.DrawColor = WhiteColor;
}

function DrawSpectators(Canvas Canvas)
{
	local float XL, YL;
	local Color OldColor;
	local int i;

	Canvas.Font = font'SmallFont';
	Canvas.StrLen("SPECTATORS:", XL, YL);
	Canvas.SetPos(Canvas.ClipX-XL-2, Canvas.ClipY/15);
	DrawShadowText(Canvas, "SPECTATORS:", False, true);
	if(Spectators[0] == "")
	{
		Canvas.StrLen("NONE", XL, YL);
		Canvas.SetPos(Canvas.ClipX-XL-2, Canvas.CurY);
		DrawShadowText(Canvas, "NONE", False, true);
	}
	else
	{
		Canvas.DrawColor=GreenColor;
		for(i=0;i<32;i++)
		{
			if(Spectators[i] == "")
				break;
			Canvas.StrLen(Spectators[i], XL, YL);
			Canvas.SetPos(Canvas.ClipX-XL-2, Canvas.CurY);
			DrawShadowText(Canvas, Spectators[i], False, true);
		}
	}
}

function DrawCapsAndTime(Canvas Canvas, int Caps, string Time, float XOffset, float YOffset)
{
	local float XL, YL, XL2, YL2;
	local Color OldColor;

	OldColor=Canvas.DrawColor;
	Canvas.DrawColor=GreenColor;
	Canvas.StrLen(Time, XL, YL);
	if(Canvas.ClipX <= 800)
      Canvas.SetPos(XOffset + (Canvas.ClipX*0.30) - XL, YOffset);
	else
		 Canvas.SetPos(XOffset + (Canvas.ClipX*0.26) - XL, YOffset);
	DrawShadowText(Canvas, Time, False, true);
	if(Canvas.ClipX < 640)
		 return;
	Canvas.DrawColor=GoldColor;
	Canvas.Font = font'SmallFont';
	Canvas.StrLen("CAPS:"@Caps, XL2, YL2);
	if(Canvas.ClipX <= 800)
	   Canvas.SetPos(XOffset + (Canvas.ClipX*0.30) - XL/2 -XL2/2, YOffset+YL);
	else
		 Canvas.SetPos(XOffset + (Canvas.ClipX*0.26) - XL/2 -XL2/2, YOffset+YL);
	DrawShadowText(Canvas, "CAPS:"@Caps, False, true);
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, YB, XL3;
	local BotReplicationInfo BRI;
	local String S, L, tempL;
	local Font CanvasFont;
	local bool bAdminPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local BTPPReplicationInfo RI;
	local int Eff;
	local color OldColor;
	local int i;
	local string T;
	local int FlagShift;

	local int lenstrip; // used for stripping the ZoneInfo to an appropriate width
	local float stripmod; // a modifier dependant on resolution

	RI=FindInfo(PRI, i);
	PlayerOwner = PlayerPawn(Owner);

	if(OwnerRI == None)
	{
		if(PlayerOwner.PlayerReplicationInfo.bIsSpectator && !PlayerOwner.PlayerReplicationInfo.bWaitingPlayer)
		{
			foreach Level.AllActors(class'BTPPReplicationInfo', OwnerRI)
				if(PlayerOwner.PlayerReplicationInfo.PlayerID == OwnerRI.PlayerID)
					break;
				else
					OwnerRI=None;
		}
	}
	if(i==-1) // this sucks, FindInfo couldn't have found PRI
		return;

	bAdminPlayer = PRI.bAdmin;

	// Draw Name
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;

	if ( bAdminPlayer )
		Canvas.DrawColor = WhiteColor;


	Canvas.StrLen(PRI.PlayerName, XL, YB);
	// Draw the country flag
	if(RI != None && GRI != None && Canvas.ClipX>=512)
		if(RI.CountryPrefix != "")
		{
			OldColor=Canvas.DrawColor;
			Canvas.SetPos(XOffset-6, YOffset+YB/2-4);
			Canvas.DrawColor = WhiteColor;
			Canvas.DrawIcon(FD[GetFlagIndex(RI.CountryPrefix)].Tex, 1.0);
			Canvas.DrawColor=OldColor;
			FlagShift=12;
		}
		else
			FlagShift=0;


	Canvas.SetPos(XOffset+FlagShift, YOffset);
	DrawShadowText(Canvas, PRI.PlayerName, False, true);

	if ( Canvas.ClipX > 512 )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		Canvas.DrawColor = WhiteColor;

		if (Level.NetMode != NM_Standalone)
		{
			if (Canvas.ClipX >= 640 && RI != None && OwnerRI != None)
			{
				// Draw Time
				Time = Max(1, (Level.TimeSeconds + OwnerRI.JoinTime - RI.JoinTime)/60);
				Canvas.StrLen("T:    ", XL, YL);
				Canvas.SetPos(XOffset - XL - 6, YOffset);
				DrawShadowText(Canvas, "T:"$Time, false, true);

				if(PRI.HasFlag != None)
				{
					// Flag icon
					Canvas.SetPos(XOffset - XL - 35, YOffset);
					Canvas.DrawIcon(FlagIcon[CTFFlag(PRI.HasFlag).Team], 1.0);
				}
				else if(RI.bReadyToPlay && PRI.bWaitingPlayer)
				{
					Canvas.DrawColor = WhiteColor;
					Canvas.Style = ERenderStyle.STY_Masked;
					Canvas.SetPos(XOffset -XL - 35, YOffset);
					Canvas.DrawIcon(FlagIcon[2], 1.0); // draw a green flag
				}
			}

			// Draw Ping
			Canvas.StrLen("P:    ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + (YL+1));
			DrawShadowText(Canvas, "P:"$PRI.Ping, false, true);

			Canvas.StrLen("L:    ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + 2*(YL+1));
			DrawShadowText(Canvas, "L:"$PRI.PacketLoss$"%", false, true);

			if(Canvas.ClipX > 640)
			{
				// Draw Eff
				Canvas.StrLen("E:    ", XL2, YL2);
				Canvas.SetPos(XOffset - XL2 - 6, YOffset + 3*(YL+1));
				if(RI.Runs > 0)
					Eff=int(float(RI.Caps)/float(RI.Runs)*100.0);
				DrawShadowText(Canvas, "E:"$string(Eff)$"%", false, true);
			}
		}
		Canvas.Font = CanvasFont;
	}
	// Draw Score
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = TeamColor[PRI.Team];
	if(RI != None && RI.Caps != 0)
		DrawCapsAndTime(Canvas, RI.Caps, FormatScore(RI.BestTime), XOffset, YOffset);
	Canvas.Font=CanvasFont;

	Canvas.DrawColor=GoldColor;
	if (Canvas.ClipX < 512)
		return;

	// Draw location
	if ( !bCompressed )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';

		Canvas.StrLen("TIMER: ", XL, YL);

		if(PRI.Team == OwnerInfo.Team)
		{
			if ( PRI.PlayerLocation != None )
				L = PRI.PlayerLocation.LocationName;
			else if ( PRI.PlayerZone != None )
				L = PRI.PlayerZone.ZoneName;
			else
				L = "";
			if ( L != "" )
			{
				L = InString@L;

				Canvas.SetPos(XOffset, YOffset + YB + YL + 1);

				lenstrip = 0;

				if(Canvas.ClipX <= 800)
					stripmod = 0.3;
				else
					stripmod = 0.26;
				do {
					tempL = Left(L, len(L)-lenstrip++);
					Canvas.StrLen(tempL, XL2, YL2);
				} until(XL2 <= Canvas.ClipX*stripmod)
				L=tempL;
				DrawShadowText(Canvas, L, False, true);
			}
		}
		Canvas.SetPos(XOffset, YOffset + YB);
		if(OwnerRI != None)
			T=FormatScore(2000 - ( (Level.TimeSeconds+OwnerRI.TimeVariance) - RI.StartTime ));

	if(RI != None)
	{
		DrawShadowText(Canvas, "TIMER: ", False, true);
		OldColor=Canvas.DrawColor;
		Canvas.DrawColor=GreenColor;
		Canvas.SetPos(XOffset + XL, YOffset + YB);
		if(PlayerPawn(RI.Owner).IsInState('GameEnded'))
			DrawShadowText(Canvas, PI[i].LastTime, False, true);
		else if(PRI.bIsSpectator && PRI.bWaitingPlayer)
			DrawShadowText(Canvas, "0:00", False, true);
		else
			DrawShadowText(Canvas, T, False, true);
		if(!PlayerPawn(RI.Owner).IsInState('GameEnded'))
			PI[i].LastTime=T;
		Canvas.DrawColor=OldColor;
	}
	else if(PRI.bIsABot)
			DrawShadowText(Canvas, "STUPID BOT", False, true);


		Canvas.StrLen("TIMER:       ", XL, YL);
		if(Canvas.ClipX > 640)
			XL*=(Canvas.ClipX)/750.0;
		Canvas.SetPos(XOffset + XL, YOffset + YB);
		DrawShadowText(Canvas, "DEATHS:"@int(PRI.Deaths), False, true);

		Canvas.Font = CanvasFont;
	}
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	DrawShadowText(Canvas, GRI.BoardLabel, true);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);

	if( TGRI.GoalTeamScore > 0 && TGRI.TimeLimit > 0)
	{
		Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
		DrawShadowText(Canvas, FragGoal@TGRI.GoalTeamScore@"/"@TimeLimit@TGRI.TimeLimit$":00", true);
		Canvas.SetPos(0, Canvas.CurY - YL);
	}
	else if ( TGRI.GoalTeamScore > 0 )
	{
		DrawShadowText(Canvas, FragGoal@TGRI.GoalTeamScore, true);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
	}
	else if ( TGRI.TimeLimit > 0 )
	{
		DrawShadowText(Canvas, TimeLimit@TGRI.TimeLimit$":00", true);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
	}
	if(GRI.MapBestTime != "0:00")
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.SetPos(0, Canvas.CurY);
	   Canvas.StrLen("Test", XL, YL);
		DrawShadowText(Canvas, "Server record is "$GRI.MapBestTime$" set by "$GRI.MapBestPlayer, true, true);
	   Canvas.SetPos(0, Canvas.CurY - YL);
	}

}

// idea and function from UTPro by AnthraX
function DrawShadowText (Canvas Canvas, coerce string Text, optional bool Param,optional bool bSmall, optional bool bGrayShadow)
{
	local Color OldColor;
	local float XL,YL;
	local float X, Y;

	OldColor = Canvas.DrawColor;

	if (bGrayShadow)
	{
		Canvas.DrawColor.R = 127;
		Canvas.DrawColor.G = 127;
		Canvas.DrawColor.B = 127;
	}
	else
	{
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
	}
	if (bSmall)
	{
		XL = 1;
		YL = 1;
	}
	else
	{
		XL = 2;
		YL = 2;
	}
	X=Canvas.CurX;
	Y=Canvas.CurY;
	Canvas.SetPos(X+XL,Y+YL);
	Canvas.DrawText(Text, Param);
	Canvas.DrawColor = OldColor;
	Canvas.SetPos(X,Y);
	Canvas.DrawText(Text, Param);
}

function BTPPReplicationInfo FindInfo (PlayerReplicationInfo PRI, optional out int ident)
{
   local int i;
   local BTPPReplicationInfo RI;
   local bool bFound;

   // See if it's already initialized
   for (i=0;i<Index;++i)
   {
       if (PI[i].PRI == PRI)
       {
       		ident=i;
           return PI[i].RI;
       }
   }

   // Not initialized, find the RI and init a new slot
   foreach Level.AllActors(class'BTPPReplicationInfo',RI)
   {
      if (RI.PlayerID == PRI.PlayerID)
      {
        bFound = true;
        break;
      }
    }
   // Couldn't find RI, this sucks
   if (!bFound)
       return None;
   // Init the slot
   if (Index < 32)
   {
       InitInfo(Index, PRI, RI);
       ident=Index;
       Index++;
       return RI;
   }
   else
   {
       for (i=0;i<32;++i)
       {
           if (PI[i].RI == None)
               break;
       }
       InitInfo(i, PRI, RI);
       ident=i;
       return RI;
   }
}

function InitInfo (int i, PlayerReplicationInfo PRI, BTPPReplicationInfo RI)
{
    local Pawn Target;

    PI[i].PRI = PRI;
    PI[i].RI = RI;

    if (PRI == PlayerPawn(Owner).PlayerReplicationInfo)
      OwnerRI = RI;
}

static final function string FormatScore(coerce int Score)
{
	local int secs;
	local string sec;

	if(Score==0 || Score==2000)
		return "0:00";
	else if ( Score > 1 && Score <= 1999 )
	{
		Score = 2000 - Score;
		secs = int(Score % 60);
		if ( secs < 10 )
                	sec = "0" $string(secs);
            	else
			sec = "" $string(secs);
		return string(Score / 60) $":"$sec;
	}
}

defaultproperties
{
}
