/*
    BTPlusPlus 0.97
    Copyright (C) 2004-2006 Damian "Rush" Kaczmarek

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class SuperShockRifleBT extends SuperShockRifle;
/* custom shock rifle spawning blue ray instead of red if a hit actor is a playerpawn with either antiboost status on or being a mamber of an opposite team with killing blocked */

var Actor Controller;

function BindController()
{
	local Mutator temp;
	if(Controller == None)
	{
		foreach AllActors(class'Mutator', temp)
		{
			if(Mid(string(temp.class), InStr(string(temp.class), ".")+1) == "BTPlusPlus")
			{
				Controller=temp;
				break;
			}
		}
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
/*	local UT_RingExplosion explo;*/
	local string info;
	local vector StartTrace, EndTrace;

	BindController();

	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}
	if(Controller != None)
 	{
 		if(Other != None)
 			if(Other.IsA('PlayerPawn'))
 			{
				info = Controller.GetItemName("get shockrifleinfo "$string(PlayerPawn(Other).PlayerReplicationInfo.PlayerID));
 				if((PlayerPawn(Other).PlayerReplicationInfo.Team == PlayerPawn(Owner).PlayerReplicationInfo.Team && Left(info, 1) == "1") || (Right(info, 1) == "1" && PlayerPawn(Other).PlayerReplicationInfo.Team != PlayerPawn(Owner).PlayerReplicationInfo.Team))
				{
					SpawnEffectBlue(HitLocation, Owner.Location + CalcDrawOffset() + (FireOffset.X + 20) * X + FireOffset.Y * Y + FireOffset.Z * Z);
					return;
				}
 			}
 	}
	SpawnEffect(HitLocation, Owner.Location + CalcDrawOffset() + (FireOffset.X + 20) * X + FireOffset.Y * Y + FireOffset.Z * Z);

	Spawn(class'ut_SuperRing2',,, HitLocation+HitNormal*8,rotator(HitNormal));

	if ( (Other != self) && (Other != Owner) && (Other != None) )
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 60000.0*X, MyDamageType);
}

function SpawnEffectBlue(vector HitLocation, vector SmokeLocation)
{
	local ShockBeam Smoke;;
	local Vector DVector;
	local int NumPoints;
	local rotator SmokeRotation;

	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/135.0;
	if ( NumPoints < 1 )
		return;
	SmokeRotation = rotator(DVector);
	SmokeRotation.roll = Rand(65535);

	Smoke = Spawn(class'ShockBeam',,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints - 1;
}

defaultproperties
{
}
