/*
    BTPlusPlus 0.97
    Copyright (C) 2004-2006 Damian "Rush" Kaczmarek

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class UserConfig expands Info config(BTRecords);
/* class holding information(records, config) clientside  */

var config bool bSet; // is set to true after the first antiboost status change, if it is false, BT++ will send a more detailed help
var config bool bAntiBoost; // for storing AntiBoost status between switching servers
var config bool bBTHud; // indicates showing BTPPHudMutator
var config bool bSTFU; // prevents from recieving BT++ messages
var config string Record[255];

var int BestTime; // record read from the ini
var string BestTimeStr;

replication {
	reliable if(Role == ROLE_Authority)
		SetBTHudClient, SetSTFUClient, SetAntiBoostClient, AddRecord;
	reliable if(Role < ROLE_Authority)
		SetServerVars;
}

// destroy selft if owner leaves the server
function Tick(float DeltaTime)
{
	if(PlayerPawn(Owner) == None)
		Destroy();
}

//====================================
// PostNetBeginPlay - Checks a remote client's record and set client's vars to the server
//====================================
simulated function PostNetBeginPlay()
{
	if(ROLE < ROLE_Authority)
	{
		BestTime=int(CheckRecord(GetLevelName()));
		BestTimeStr=FormatScore(BestTime);
		SetServerVars(BestTime, bSet, bAntiBoost, bSTFU);
	}
}

//====================================
// SetServerVars - Set server vars with client vars
// Triggered in: PostNetBeginPlay
//====================================
simulated function SetServerVars(int ClientBestTime, bool bClientSet, bool bClientAntiBoost, bool bClientSTFU)
{
	if(ROLE == ROLE_Authority && bNetOwner)
	{
		BestTime=ClientBestTime;
		bSet=bClientSet;
		bAntiBoost=bClientAntiBoost;
		bSTFU=bClientSTFU;
	}
}
//====================================
// SetAntiBoostClient - Updates antiboost status clientside
// Triggered in: SetAntiBoost
//====================================
simulated function SetAntiBoostClient(bool Status)
{
	bAntiBoost=Status;
	bSet=True; // meaning that it will do it only once if bSet is false
	SaveConfig();
}

//====================================
// SetAntiBoostClient - Updates antiboost status serverside and triggers the clientside update
// Triggered in: class'BTPlusPlus': SetAntiBoostOn, SetAntiBoostOff, Mutate, MutatorTeamMessage
//====================================
function SetAntiBoost(bool Status)
{
	bAntiBoost=Status;
	bSet=True;
	SetAntiBoostClient(Status);
}

// similiar to the uppper SetAntiBoost and SetAntiBoostClient
simulated function SetBTHudClient(bool Status)
{
	bBTHud=Status;
	SaveConfig();
}

// similiar to the uppper SetAntiBoost and SetAntiBoostClient
function SetBTHud(bool Status)
{
	bBTHud=Status;
	SetBTHudClient(Status);
}

// similiar to the uppper SetAntiBoost and SetAntiBoostClient
simulated function SetSTFUClient(bool Status)
{
	bSTFU=Status;
	SaveConfig();
}

// similiar to the uppper SetAntiBoost and SetAntiBoostClient
function SetSTFU(bool Status)
{
	bSTFU=Status;
	SetSTFUClient(Status);
}

simulated function AddRecord(int time, optional int timestamp)
{
	local int i, j, k;
	local string temp, temp3, MapName;

	if(ROLE == ROLE_Authority) // runs only on client
		return;

	MapName=GetLevelName();

	BestTime=time;
	BestTimeStr=FormatScore(time);

	for(i=0;i<255;i++)
	{
		if(Record[i]=="")
			continue;
		if(InStr(Record[i], MapName) != -1)
		{
			for( j=1;j<=ElementsNum(Record[i], chr(11));j++)
			{
				temp=SelElem(Record[i], j, chr(11));
				if(SelElem(temp, 1, chr(9)) == MapName)
				{
					temp=string(time);
					while(len(temp) < 4)
						temp=temp$" ";

					if(timestamp > 0)
						temp3=chr(9)$string(timestamp);

					Record[i]=SetElem(Record[i], j, MapName$chr(9)$temp$temp3, chr(11) );
					SaveConfig();
					return;
				}
			}
		}
	}
	for(i=0;i<255;i++)
	{
		if( (len(Record[i]) + len(MapName) + 31) > 255)
			continue;
		temp=string(time);
		while(len(temp) < 4)
			temp=temp$" ";

		if(timestamp > 0)
			temp3=chr(9)$string(timestamp);

		if(Record[i]=="")
			Record[i]=MapName$chr(9)$temp$temp3;
		else
			Record[i]=Record[i]$chr(11)$MapName$chr(9)$temp$temp3;
		SaveConfig();
		return;
	}
}

simulated function string GetLevelName()
{
	local string Str;
	local int Pos;

	Str=string(Level);
	Pos = InStr(Str, ".");
	if(Pos != -1)
		return Left(Str, Pos);
	else
		return Str;
}

simulated function string CheckRecord(string MapName)
{
	local int i, j;
	local string temp;

	for(i=0;i<255;i++)
	{
		if(Record[i]=="")
			continue;
		if(InStr(Record[i], MapName) != -1)
		{
			for( j=1;j<=ElementsNum(Record[i], chr(11));j++)
			{
				temp=SelElem(Record[i], j, chr(11));
				if(InStr(temp, MapName) != -1)
					if(SelElem(temp, 1, chr(9)) == MapName)
						return SelElem(temp, 2, chr(9));
			}
		}
	}
}

//#########################################################################
//### TEXT FUNCTIONS - these are clientside clones of text functions in class'BTPlusPlus' and class'RecordData'
//#########################################################################
static final function string SetElem(string Str, int Elem, string SetStr, optional string Char)
{
	local int pos;
	local string LeftSide, RightSide, Temp, OneElem;
	if(Char=="")
		Char=chr(9);

	Temp=Str;

	while(Elem>1)
	{
		pos=InStr(Temp, Char);
		OneElem=Left(Temp, pos+1);
		Temp=Right(Temp, len(Temp)-pos-1);
		Leftside=Leftside$OneElem;
		Elem--;
	}
	pos=InStr(Temp, Char);
	if(pos != -1)
		RightSide=Right(Temp, len(Temp)-pos);
	else // last element, not containing char
		RightSide="";

    return Leftside$SetStr$Rightside;
}

static final function int ElementsNum(string Str, optional string Char)
{
	local int count, pos;

	if(Char=="")
		Char=chr(9);

	while(true)
	{
		pos = InStr(Str, Char);
		if(pos == -1)
			break;
		Str=Mid(Str, pos+1);
		count++;
	}
	return count+1;
}

static final function string SelElem(string Str, int Elem, optional string Char)
{
	local int pos;
	if(Char=="")
		Char=chr(9);

	while(Elem>1)
	{
		Str=Mid(Str, InStr(Str, Char)+1);
		Elem--;
	}
	pos=InStr(Str, Char);
	if(pos != -1)
    	Str=Left(Str, pos);
    return Str;
}

static final function string FormatScore(coerce int Score)
{
	local int secs;
	local string sec;

	if(Score==0 || Score==2000)
		return "-:--";
	else if ( Score >= 1 && Score <= 1999 )
	{
		Score = 2000 - Score;
		secs = int(Score % 60);
		if ( secs < 10 )
                	sec = "0" $string(secs);
            	else
			sec = "" $string(secs);
		return string(Score / 60) $":"$sec;
	}
}

DefaultProperties
{
	BestTimeStr="0:00"
	BestTime=-1
	bBTHud=True
}
