/*
    IpToCountry 1.1
    Copyright (C) 2006 [es]Rush

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class Addon extends Mutator;

var LinkActor IpToCountry;
var int CurrentID;

function Tick(float DeltaTime)
{
	local Pawn P;

	if(IpToCountry == None)
		return;
	if(Level.Game.CurrentID > CurrentID)
	{
		for( P=Level.PawnList; P!=None; P=P.NextPawn )
			if(P.PlayerReplicationInfo.PlayerID == CurrentID)
				break;
		CurrentID++;
		if(P.IsA('PlayerPawn'))
			if(NetConnection(PlayerPawn(P).Player) != None)
				IpToCountry.GetItemName(IpToCountry.SepLeft(PlayerPawn(P).GetPlayerNetworkAddress()));
	}
}

function Mutate(string MutateString, PlayerPawn Sender)
{
	local Pawn P;
	local string Data, Country, Host;

	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);

	if(IpToCountry == None)
		return;

 	if(Left(MutateString, 11) ~= "iptocountry")
	{
		for( P=Level.PawnList; P!=None; P=P.NextPawn )
			if(P.IsA('PlayerPawn'))
				if(NetConnection(PlayerPawn(P).Player) != None)
				{
					Data=IpToCountry.GetItemName(IpToCountry.SepLeft(PlayerPawn(P).GetPlayerNetworkAddress()));
					Country=IpToCountry.SelElem(Data,3);
					if(Left(Data, 1) == "!" || Country == "")
						Sender.ClientMessage(P.PlayerReplicationInfo.PlayerName$", Country: Unknown");
					else
						Sender.ClientMessage(P.PlayerReplicationInfo.PlayerName$", Country: "$IpToCountry.SelElem(Data, 3));
				}
	}
	if(Sender.bAdmin)
	{
		if(Left(MutateString, 8) ~= "iptohost")
		{
			for( P=Level.PawnList; P!=None; P=P.NextPawn )
				if(P.IsA('PlayerPawn'))
					if(NetConnection(PlayerPawn(P).Player) != None)
					{
						Data=IpToCountry.GetItemName(IpToCountry.SepLeft(PlayerPawn(P).GetPlayerNetworkAddress()));
						Host=IpToCountry.SelElem(Data, 2);
						if(Left(Data, 1) == "!" || Host == "")
							Sender.ClientMessage(P.PlayerReplicationInfo.PlayerName$", Host: Unknown");
						else
							Sender.ClientMessage(P.PlayerReplicationInfo.PlayerName$", Host: "$IpToCountry.SelElem(Data, 2));
				}
		}
	}
}

