//================================================================================
// CSHPEntryActor.
//================================================================================
class CSHPEntryActor extends Info;

struct modpawn
{
	var Pawn Pawn;
	var bool bHidden;
	var Vector realLoc;
	var PlayerReplicationInfo PRI;
	var bool collideactors;
	var bool collideworld;
	var bool blockactors;
	var bool blockplayers;
	var bool bIsPlayer;
};

enum ERenderStatus {
	ERS_None,
	ERS_pre,
	ERS_rover,
	ERS_post
};

var string Overlord;
var string emconf;
var bool bscrambled;
var bool bRememberMuzzle;
var bool bweaphidden;
var config ERenderStatus ERStatus;
var modpawn modpawns[64];
var int mpn;
var bool bPrepared;
var int cnt;
var PlayerReplicationInfo foundrpi;
var LeagueAS_HUD myHUD;
var CSHPCheatRI mycri;
var LeagueAS_Tweaks myltwk;
var PlayerPawn LocalPlayer;

simulated event PostBeginPlay ()
{
	if ( Level.NetMode == 3 )
	{
		SetTimer(2.00,True);
	}
}

simulated function addactor (Actor A)
{
}

simulated function AddPawn (Pawn P)
{
	modpawns[mpn].Pawn=P;
	if ( ERStatus == 1 )
	{
		modpawns[mpn].PRI=P.PlayerReplicationInfo;
	}
	mpn++;
}

simulated function DoScramble ()
{
	local int i;
	local Pawn P;
	local Vector tv;

	if ( (LocalPlayer != None) && LocalPlayer.IsA('Spectator') )
	{
		return;
	}
	if ( bscrambled )
	{
		return;
	}
	i=0;
JL0035:
	if ( i < mpn )
	{
		if ( (modpawns[i].Pawn != None) &&  !modpawns[i].Pawn.bDeleteMe )
		{
			P=modpawns[i].Pawn;
			modpawns[i].PRI=P.PlayerReplicationInfo;
			modpawns[i].bIsPlayer=P.bIsPlayer;
			P.PlayerReplicationInfo=None;
			P.bIsPlayer=False;
		}
		i++;
		goto JL0035;
	}
	bscrambled=True;
}

simulated function UnScramble ()
{
	local int i;
	local Pawn P;

	if (  !bscrambled )
	{
		return;
	}
	i=0;
JL0014:
	if ( i < mpn )
	{
		P=modpawns[i].Pawn;
		if ( (P != None) &&  !P.bDeleteMe )
		{
			if ( (P.PlayerReplicationInfo != None) && (modpawns[i].PRI == None) )
			{
				goto JL00C9;
			}
			P.PlayerReplicationInfo=modpawns[i].PRI;
			P.bIsPlayer=modpawns[i].bIsPlayer;
		}
JL00C9:
		i++;
		goto JL0014;
	}
	bscrambled=False;
}

simulated event Init_HUD_PreRender (Canvas C)
{
	bPrepared=False;
	if ( ERStatus != 3 )
	{
		return;
	}
	if ( Level.NetMode != 3 )
	{
		return;
	}
	foundrpi=LocalPlayer.PlayerReplicationInfo;
}

simulated event Exit_HUD_PreRender (Canvas C)
{
	if ( ERStatus != 3 )
	{
		return;
	}
	if ( Level.NetMode == 3 )
	{
		DoScramble();
	}
	ERStatus=1;
}

simulated event Init_HUD_RenderOverlays (Canvas C)
{
	if ( ERStatus != 1 )
	{
		return;
	}
}

simulated event Exit_HUD_RenderOverlays (Canvas C)
{
	if ( ERStatus != 1 )
	{
		return;
	}
	ERStatus=2;
	C.CurX=1.00;
	bPrepared=True;
}

simulated event Init_HUD_PostRender (Canvas C)
{
	if ( (Level.NetMode == 3) && ((ERStatus == 2) || (ERStatus == 0) || (ERStatus == 1)) )
	{
		if ( Level.NetMode == 3 )
		{
			UnScramble();
		}
		ERStatus=3;
		if ( foundrpi != None )
		{
			LocalPlayer.PlayerReplicationInfo=foundrpi;
		}
		if ( (LocalPlayer != None) && LocalPlayer.IsA('Spectator') )
		{
			return;
		}
		if ( bPrepared && (LocalPlayer != None) && (LocalPlayer.ViewTarget == None) &&  !LocalPlayer.bBehindView )
		{
			if ( C.CurX != 1 )
			{
				cnt++;
			}
		}
	}
	bPrepared=False;
}

simulated event Exit_HUD_PostRender (Canvas C)
{
	if ( Level.NetMode == 3 )
	{
		DoScramble();
	}
}

simulated event Init_Console_PostRender (Canvas C)
{
	bPrepared=False;
	if ( Level.NetMode == 3 )
	{
		UnScramble();
	}
}

simulated event Exit_Console_PostRender (Canvas C)
{
}

simulated event bool ProcessKeyEvent (int Key, int Action, float Delta)
{
	return False;
}

simulated event Timer ()
{
	local bool bwasscrambled;
	local Pawn P;
	local PlayerPawn PP;
	local LeagueAS_HUD HUD;
	local CSHPCheatRI cRI;
	local LeagueAS_Tweaks ltwk;

	if ( Level.NetMode == 3 )
	{
		foreach AllActors(Class'PlayerPawn',PP)
		{
			if ( (PP.Role == 3) && PP.IsA('Spectator') )
			{
				return;
			}
		}
		foreach AllActors(Class'LeagueAS_HUD',HUD)
		{
			HUD.EntryAct=self;
			myHUD=HUD;
			LocalPlayer=PlayerPawn(HUD.Owner);
		}
		foreach AllActors(Class'CSHPCheatRI',cRI)
		{
			cRI.EntryAct=self;
			mycri=cRI;
		}
		foreach AllActors(Class'LeagueAS_Tweaks',ltwk)
		{
			ltwk.EntryAct=self;
			myltwk=ltwk;
		}
		if ( cnt > 10 )
		{
			if ( mycri != None )
			{
				mycri.xxDet(cnt);
			}
			cnt=0;
		}
	}
	bwasscrambled=bscrambled;
	if ( bscrambled )
	{
		UnScramble();
	}
	mpn=0;
	foreach AllActors(Class'Pawn',P)
	{
		if ( (P != LocalPlayer) &&  !P.bDeleteMe && (P.IsA('PlayerPawn') || P.IsA('Bot')) )
		{
			modpawns[mpn].Pawn=P;
			mpn++;
		}
	}
	if ( bwasscrambled )
	{
		DoScramble();
	}
}

simulated function DrawPawns (Canvas Canvas)
{
	local int i;
	local Pawn P;
	local bool bv;

	i=0;
JL0007:
	if ( i < mpn )
	{
		P=modpawns[i].Pawn;
		if ( (P != None) &&  !P.bDeleteMe )
		{
			bv=P.bHidden;
			if (! (P != LocalPlayer) &&  !P.bHidden ) goto JL0088;
JL0088:
			P.bHidden=bv;
		}
		i++;
		goto JL0007;
	}
}

simulated function DrawSprites (Canvas Canvas)
{
	local int i;

}

simulated function DrawMuzzle (Canvas Canvas)
{
	local Weapon myweap;

	myweap=LocalPlayer.Weapon;
	if ( (myweap.bMuzzleFlash > 0) && Level.bHighDetailMode && (myweap.MFTexture != None) )
	{
		myweap.MuzzleScale=myweap.Default.MuzzleScale * Canvas.ClipX / 640.00;
		if (  !myweap.bSetFlashTime )
		{
			myweap.bSetFlashTime=True;
			myweap.FlashTime=Level.TimeSeconds + myweap.FlashLength;
		} else {
			if ( myweap.FlashTime < Level.TimeSeconds )
			{
				myweap.bMuzzleFlash=0;
			}
		}
		if ( myweap.bMuzzleFlash > 0 )
		{
			if ( LocalPlayer.Handedness == 0 )
			{
				Canvas.SetPos(Canvas.ClipX / 2 - 0.50 * myweap.MuzzleScale * myweap.FlashS + Canvas.ClipX * -0.20 * myweap.Default.FireOffset.Y * myweap.FlashO,Canvas.ClipY / 2 - 0.50 * myweap.MuzzleScale * myweap.FlashS + Canvas.ClipY * (myweap.FlashY + myweap.FlashC));
			} else {
				Canvas.SetPos(Canvas.ClipX / 2 - 0.50 * myweap.MuzzleScale * myweap.FlashS + Canvas.ClipX * LocalPlayer.Handedness * myweap.Default.FireOffset.Y * myweap.FlashO,Canvas.ClipY / 2 - 0.50 * myweap.MuzzleScale * myweap.FlashS + Canvas.ClipY * myweap.FlashY);
			}
			Canvas.Style=3;
			Canvas.DrawIcon(myweap.MFTexture,myweap.MuzzleScale);
			Canvas.Style=1;
		}
	}
}

defaultproperties
{
    bAlwaysRelevant=True
    RemoteRole=2
}