//================================================================================
// EmoteWindow.
//================================================================================
class EmoteWindow extends SpeechWindow;

var emoticon emotList[256];
var int EmoticonCount;
var bool bIsParentWindow;
var int EmotesPerCategory;

function Created ()
{
	local int i;
	local int MinValue;
	local int MaxValue;

	if ( bIsParentWindow )
	{
		InitEmoticonArray();
		NumOptions=EmoticonCount / EmotesPerCategory;
		if ( NumOptions * EmotesPerCategory < EmoticonCount )
		{
			NumOptions++;
		}
		i=0;
JL0045:
		if ( i < NumOptions )
		{
			MinValue=EmotesPerCategory * i + 1;
			MaxValue=Min(EmotesPerCategory * (i + 1),EmoticonCount);
			Options[i]=string(MinValue) @ "-" @ string(MaxValue);
			i++;
			goto JL0045;
		}
	}
	Super.Created();
	if ( bIsParentWindow )
	{
		i=0;
JL00C4:
		if ( i < NumOptions )
		{
			OptionButtons[i].bLeftJustify=False;
			i++;
			goto JL00C4;
		}
	}
}

function SlideInWindow ()
{
	local int W;
	local int H;
	local float XWidth;
	local float YHeight;
	local float XMod;
	local float YMod;
	local float XPos;
	local float YPos;
	local float YOffset;
	local float BottomTop;
	local Color TextColor;
	local int i;

	W=Root.WinWidth / 4;
	H=W;
	if ( (W > 256) || (H > 256) )
	{
		W=256;
		H=256;
	}
	XMod=4.00 * W;
	YMod=3.00 * H;
	XOffset=-256.00 / 1024.00 * XMod;
	bSlideIn=True;
	bSlideOut=False;
	ShowWindow();
}

function SlideOutWindow ()
{
	SetButtonTextures(-1,False,False);
	XOffset=0.00;
	bSlideOut=True;
	bSlideIn=False;
	if ( SpeechChild != None )
	{
		SpeechChild.FadeOut();
	}
	SpeechChild=None;
	currentkey=-1;
	if ( ChallengeHUD(GetPlayerOwner().myHUD) != None )
	{
		ChallengeHUD(GetPlayerOwner().myHUD).bHideCenterMessages=False;
	}
}

function WindowEvent (WinMessage Msg, Canvas C, float X, float Y, int Key)
{
	if ( (Msg == 6) && bIsParentWindow )
	{
		SlideOutWindow();
	} else {
		Super.WindowEvent(Msg,C,X,Y,Key);
	}
}

function Notify (UWindowWindow B, byte E)
{
	switch (E)
	{
		case 2:
		GetPlayerOwner().PlaySound(Sound'SpeechWindowClick',3);
		SetButtonTextures(SpeechButton(B).Type,False,True);
		HideChildren();
		CurrentType=SpeechButton(B).Type;
		SpeechChild=SpeechWindow(CreateWindow(Class'EmoteChildWindow',100.00,100.00,100.00,100.00));
		EmoteChildWindow(SpeechChild).EmoteParent=self;
		SpeechChild.FadeIn();
		break;
		default:
	}
}

function int InitEmoticonArray ()
{
	local int i;
	local int emotCount;

	i=1;
JL0007:
	if ( i < 256 )
	{
		if ( (Class'Emotelist'.gete(i) != None) && (Class'Emotelist'.gete(i).dim != 0) )
		{
			emotList[emotCount]=Class'Emotelist'.gete(i);
			emotCount++;
		}
		i++;
		goto JL0007;
	}
	Log("EmoteWindow: EmoticonCount: " $ string(emotCount));
	EmoticonCount=emotCount;
}

function emoticon GetEmote (int Index)
{
	return emotList[Index];
}

defaultproperties
{
    bIsParentWindow=True
    EmotesPerCategory=14
    Options=""
    NumOptions=8
    WindowTitle="Emoticons"
}