//================================================================================
// LeagueAS_AutoPauser.
//================================================================================
class LeagueAS_AutoPauser extends Actor
	NoNativeReplication;

var LeagueAssault LeagueAssaultGame;
var int StartCount;
var int CurrentCount;
var int TeamSize[2];
var int PausePerMapCountRemaining[2];
var bool bPausedBy0;
var stcPlayerInfo savedPlayers[12];
var int SavedPlayerCount;
var bool bHaveToRestorePositions;
struct stcPlayerInfo
{
	var string IP;
	var Vector Location;
};


auto state Waiting
{
	event Timer ()
	{
		if ( LeagueAssaultGame.bMapStarted )
		{
			GotoState('Playing');
		}
	}
	
	function CheckPause ()
	{
	}
	
}

state Playing
{
	event Tick (float Delta)
	{
		if ( bHaveToRestorePositions )
		{
			RestorePlayerPositions();
			bHaveToRestorePositions=False;
		}
		if ( LeagueAssaultGame.Level.Pauser != "" )
		{
			GotoState('Paused');
			return;
		}
		if ( LeagueAssaultGame.bMapEnded )
		{
			GotoState('Ended');
			return;
		}
		CheckPause();
	}
	
}

state Pausing
{
	function CheckPause ()
	{
		local bool DontPause;
	
		DontPause=False;
		if ( bPausedBy0 && (LeagueAssaultGame.Teams[0].Size > TeamSize[0]) )
		{
			DontPause=True;
		} else {
			if (  !bPausedBy0 && (LeagueAssaultGame.Teams[1].Size > TeamSize[1]) )
			{
				DontPause=True;
			}
		}
		if ( DontPause )
		{
			ClearProgress();
			GotoState('Playing');
		}
	}
	
	event Tick (float Delta)
	{
		if ( LeagueAssaultGame.Level.Pauser != "" )
		{
			ClearProgress();
			GotoState('Paused');
			return;
		}
		if ( LeagueAssaultGame.bMapEnded )
		{
			ClearProgress();
			GotoState('Ended');
			return;
		}
		CheckPause();
	}
	
	event Timer ()
	{
		local Pawn P;
	
		if ( CurrentCount <= 0 )
		{
			P=Level.PawnList;
	JL001F:
			if ( P != None )
			{
				if ( P.IsA('MessagingSpectator') )
				{
					P.ClientMessage("Game Auto Paused.",'CriticalEvent');
				}
				P=P.nextPawn;
				goto JL001F;
			}
			GotoState('Paused');
			return;
		}
		P=LeagueAssaultGame.Level.PawnList;
	JL00A2:
		if ( P != None )
		{
			if ( P.IsA('TournamentPlayer') )
			{
				TournamentPlayer(P).ClientMessage("Autopausing in" @ string(CurrentCount));
				if ( CurrentCount <= 2 )
				{
					TournamentPlayer(P).TimeMessage(CurrentCount);
				}
				if ( CurrentCount == 2 )
				{
					if ( bPausedBy0 )
					{
						Log("LeagueAssault: Autopause: Team 0 used one pause count");
						LeagueAssaultGame.PauseCountRemaining[0]--;
						PausePerMapCountRemaining[0]--;
					} else {
						Log("LeagueAssault: Autopause: Team 1 used one pause count");
						LeagueAssaultGame.PauseCountRemaining[1]--;
						PausePerMapCountRemaining[1]--;
					}
				}
			}
			P=P.nextPawn;
			goto JL00A2;
		}
		CurrentCount--;
	}
	
	event BeginState ()
	{
		TeamSize[0]=LeagueAssaultGame.Teams[0].Size;
		TeamSize[1]=LeagueAssaultGame.Teams[1].Size;
		ClearProgress();
		ShowPausingMessage();
		SetTimer(1.00 * LeagueAssaultGame.Level.TimeDilation,True);
		CurrentCount=StartCount;
	}
	
}

state Paused
{
	function CheckPause ()
	{
		local bool UnPause;
		local Pawn P;
	
		UnPause=False;
		if ( bPausedBy0 && (LeagueAssaultGame.Teams[0].Size > TeamSize[0]) )
		{
			UnPause=True;
		} else {
			if ( LeagueAssaultGame.PauseTimeRemaining[0] <= StartCount )
			{
				UnPause=True;
			}
		}
		if (  !bPausedBy0 && (LeagueAssaultGame.Teams[1].Size > TeamSize[1]) )
		{
			UnPause=True;
		} else {
			if ( LeagueAssaultGame.PauseTimeRemaining[1] <= StartCount )
			{
				UnPause=True;
			}
		}
		if ( UnPause )
		{
			GotoState('Unpausing');
		}
	}
	
	event Tick (float Delta)
	{
		if ( LeagueAssaultGame.Level.Pauser == "" )
		{
			ClearProgress();
			GotoState('Playing');
			return;
		}
		if ( LeagueAssaultGame.bMapEnded )
		{
			ClearProgress();
			GotoState('Ended');
			return;
		}
	}
	
	function Timer ()
	{
		ShowPausedMessage();
		CheckPause();
		if ( bPausedBy0 )
		{
			LeagueAssaultGame.PauseTimeRemaining[0]--;
		} else {
			LeagueAssaultGame.PauseTimeRemaining[1]--;
		}
	}
	
	event BeginState ()
	{
		TeamSize[0]=LeagueAssaultGame.Teams[0].Size;
		TeamSize[1]=LeagueAssaultGame.Teams[1].Size;
		ClearProgress();
		ShowPausedMessage();
		Pause();
		SetTimer(1.00 * LeagueAssaultGame.Level.TimeDilation,True);
	}
	
}

state Unpausing
{
	function CheckPause ()
	{
		if ( LeagueAssaultGame.Teams[0].Size < TeamSize[0] )
		{
			if ( LeagueAssaultGame.PauseTimeRemaining[0] > StartCount )
			{
				if ( LeagueAssaultGame.PauseCountRemaining[0] > 0 )
				{
					bPausedBy0=True;
					GotoState('Paused');
				}
			}
		} else {
			TeamSize[0]=LeagueAssaultGame.Teams[0].Size;
		}
		if ( LeagueAssaultGame.Teams[1].Size < TeamSize[1] )
		{
			if ( LeagueAssaultGame.PauseTimeRemaining[1] > StartCount )
			{
				if ( LeagueAssaultGame.PauseCountRemaining[1] > 0 )
				{
					bPausedBy0=False;
					GotoState('Paused');
				}
			}
		} else {
			TeamSize[1]=LeagueAssaultGame.Teams[1].Size;
		}
	}
	
	event Tick (float Delta)
	{
		if ( LeagueAssaultGame.Level.Pauser == "" )
		{
			ClearProgress();
			GotoState('Playing');
			return;
		}
		if ( LeagueAssaultGame.bMapEnded )
		{
			ClearProgress();
			GotoState('Ended');
			return;
		}
		CheckPause();
	}
	
	event Timer ()
	{
		local Pawn P;
	
		if ( CurrentCount <= 0 )
		{
			P=Level.PawnList;
	JL001F:
			if ( P != None )
			{
				if ( P.IsA('MessagingSpectator') )
				{
					P.ClientMessage("Game Resumed.",'CriticalEvent');
				}
				P=P.nextPawn;
				goto JL001F;
			}
			GotoState('Playing');
			return;
		}
		P=LeagueAssaultGame.Level.PawnList;
	JL009E:
		if ( P != None )
		{
			if ( P.IsA('TournamentPlayer') )
			{
				TournamentPlayer(P).TimeMessage(CurrentCount);
			}
			P=P.nextPawn;
			goto JL009E;
		}
		CurrentCount--;
	}
	
	event BeginState ()
	{
		if ( bPausedBy0 )
		{
			LeagueAssaultGame.PauseTimeRemaining[0]=LeagueAssaultGame.PauseTimeRemaining[0] - StartCount - 2;
		} else {
			LeagueAssaultGame.PauseTimeRemaining[1]=LeagueAssaultGame.PauseTimeRemaining[1] - StartCount - 2;
		}
		ClearProgress();
		TeamSize[0]=LeagueAssaultGame.Teams[0].Size;
		TeamSize[1]=LeagueAssaultGame.Teams[1].Size;
		ShowUnPausingMessage();
		SetTimer(1.00 * LeagueAssaultGame.Level.TimeDilation,True);
		CurrentCount=StartCount;
	}
	
	event EndState ()
	{
		TeamSize[0]=LeagueAssaultGame.Teams[0].Size;
		TeamSize[1]=LeagueAssaultGame.Teams[1].Size;
		ClearProgress();
		UnPause();
	}
	
}

state Ended
{
	function CheckPause ()
	{
	}
	
}

event PostBeginPlay ()
{
	if ( Level.Game.IsA('LeagueAssault') )
	{
		LeagueAssaultGame=LeagueAssault(Level.Game);
		SetTimer(1.00 * LeagueAssaultGame.Level.TimeDilation,True);
		StartCount=LeagueAssaultGame.PauseLeadInOutTime;
	} else {
		Destroy();
	}
}

function CheckPause ()
{
	if ( LeagueAssaultGame.Teams[0].Size < TeamSize[0] )
	{
		if ( LeagueAssaultGame.PauseTimeRemaining[0] > StartCount )
		{
			if ( LeagueAssaultGame.PauseCountRemaining[0] > 0 )
			{
				if ( PausePerMapCountRemaining[0] > 0 )
				{
					bPausedBy0=True;
					GotoState('Pausing');
				}
			}
		}
	} else {
		TeamSize[0]=LeagueAssaultGame.Teams[0].Size;
	}
	if ( LeagueAssaultGame.Teams[1].Size < TeamSize[1] )
	{
		if ( LeagueAssaultGame.PauseTimeRemaining[1] > StartCount )
		{
			if ( LeagueAssaultGame.PauseCountRemaining[1] > 0 )
			{
				if ( PausePerMapCountRemaining[1] > 0 )
				{
					bPausedBy0=False;
					GotoState('Pausing');
				}
			}
		}
	} else {
		TeamSize[1]=LeagueAssaultGame.Teams[1].Size;
	}
}

function ClearProgress ()
{
	local Pawn P;

	P=LeagueAssaultGame.Level.PawnList;
JL001D:
	if ( P != None )
	{
		if ( P.IsA('PlayerPawn') )
		{
			PlayerPawn(P).SetProgressTime(0.00);
			PlayerPawn(P).ClearProgressMessages();
		}
		P=P.nextPawn;
		goto JL001D;
	}
}

function ShowUnPausingMessage ()
{
	local Pawn P;

	P=LeagueAssaultGame.Level.PawnList;
JL001D:
	if ( P != None )
	{
		if ( P.IsA('TournamentPlayer') )
		{
			TournamentPlayer(P).SetProgressTime(4.00);
			TournamentPlayer(P).SetProgressMessage("Resuming Game...",3);
		}
		P=P.nextPawn;
		goto JL001D;
	}
}

function ShowPausingMessage ()
{
	local Pawn P;

	P=LeagueAssaultGame.Level.PawnList;
JL001D:
	if ( P != None )
	{
		if ( P.IsA('TournamentPlayer') )
		{
			if ( bPausedBy0 && (P.PlayerReplicationInfo.Team == 0) ||  !bPausedBy0 && (P.PlayerReplicationInfo.Team == 1) )
			{
				TournamentPlayer(P).SetProgressMessage("Auto Pausing (Type: 'CancelPause' to abort)...",3);
			} else {
				TournamentPlayer(P).SetProgressMessage("Auto Pausing...",3);
			}
		}
		P=P.nextPawn;
		goto JL001D;
	}
}

function ShowPausedMessage ()
{
	local Pawn P;
	local int minsleft;
	local int secsleft;
	local string TimeString;

	P=LeagueAssaultGame.Level.PawnList;
JL001D:
	if ( P != None )
	{
		if ( P.IsA('TournamentPlayer') )
		{
			TournamentPlayer(P).SetProgressTime(10000.00);
			if ( bPausedBy0 && (P.PlayerReplicationInfo.Team == 0) ||  !bPausedBy0 && (P.PlayerReplicationInfo.Team == 1) )
			{
				TournamentPlayer(P).SetProgressMessage("Game auto Paused (Type: 'CancelPause' to resume game).",1);
			} else {
				TournamentPlayer(P).SetProgressMessage("Game auto Paused.",1);
			}
			TournamentPlayer(P).SetProgressColor(Class'ChallengeTeamHUD'.Default.TeamColor[0],2);
			minsleft=LeagueAssaultGame.PauseTimeRemaining[0] / 60;
			secsleft=LeagueAssaultGame.PauseTimeRemaining[0] - LeagueAssaultGame.PauseTimeRemaining[0] / 60 * 60;
			if ( secsleft < 10 )
			{
				TimeString=string(minsleft) $ ":0" $ string(secsleft);
			} else {
				TimeString=string(minsleft) $ ":" $ string(secsleft);
			}
			TournamentPlayer(P).SetProgressMessage(LeagueAssaultGame.Teams[1].TeamName @ "pause Time/Count/CountPerMap remaining:" @ TimeString $ " / " $ string(LeagueAssaultGame.PauseCountRemaining[0]) $ " / " $ string(PausePerMapCountRemaining[0]),2);
			TournamentPlayer(P).SetProgressColor(Class'ChallengeTeamHUD'.Default.TeamColor[1],3);
			minsleft=LeagueAssaultGame.PauseTimeRemaining[1] / 60;
			secsleft=LeagueAssaultGame.PauseTimeRemaining[1] - LeagueAssaultGame.PauseTimeRemaining[1] / 60 * 60;
			if ( secsleft < 10 )
			{
				TimeString=string(minsleft) $ ":0" $ string(secsleft);
			} else {
				TimeString=string(minsleft) $ ":" $ string(secsleft);
			}
			TournamentPlayer(P).SetProgressMessage(LeagueAssaultGame.Teams[1].TeamName @ "pause Time/Count/CountPerMap remaining:" @ TimeString $ " / " $ string(LeagueAssaultGame.PauseCountRemaining[1]) $ " / " $ string(PausePerMapCountRemaining[1]),3);
		}
		P=P.nextPawn;
		goto JL001D;
	}
}

function TeamMessage (int Team, string Message)
{
	local Pawn P;

	P=Level.PawnList;
JL0014:
	if ( (P != None) && P.IsA('PlayerPawn') && P.bIsPlayer )
	{
		if ( PlayerPawn(P).PlayerReplicationInfo.TeamID == Team )
		{
			P.ClientMessage(Message);
		}
		P=P.nextPawn;
		goto JL0014;
	}
}

function Pause ()
{
	if ( bPausedBy0 )
	{
		Log("LeagueAssault: AutoPauser: Game is autopaused for Team 0");
	} else {
		Log("LeagueAssault: AutoPauser: Game is autopaused for Team 1");
	}
	SavePlayerPositions();
	LeagueAssaultGame.Level.Pauser="League Assault AutoPauser";
}

function UnPause ()
{
	LeagueAssaultGame.Level.Pauser="";
	bHaveToRestorePositions=True;
}

function RequestPause (PlayerPawn Sender)
{
}

function RequestCancelPause (PlayerPawn Sender)
{
	if ( bPausedBy0 && (Sender.PlayerReplicationInfo.Team == 0) )
	{
		TeamSize[0]=LeagueAssaultGame.Teams[0].Size - 1;
		Log("LeagueAssault: AutoPauser: RequestCancelPause from Team 0 Player:" @ Sender.PlayerReplicationInfo.PlayerName);
	} else {
		if (  !bPausedBy0 && (Sender.PlayerReplicationInfo.Team == 1) )
		{
			TeamSize[1]=LeagueAssaultGame.Teams[1].Size - 1;
			Log("LeagueAssault: AutoPauser: RequestCancelPause from Team 1 Player:" @ Sender.PlayerReplicationInfo.PlayerName);
		}
	}
}

function SavePlayerPositions ()
{
	local Pawn P;

	SavedPlayerCount=0;
	P=Level.PawnList;
JL001B:
	if ( (P != None) && P.IsA('PlayerPawn') && P.bIsPlayer )
	{
		if ( P.IsInState('PlayerSwimming') )
		{
			SavePlayerPosition(PlayerPawn(P));
		}
		P=P.nextPawn;
		goto JL001B;
	}
}

function RestorePlayerPositions ()
{
	local Pawn P;

	P=Level.PawnList;
JL0014:
	if ( (P != None) && P.IsA('PlayerPawn') && P.bIsPlayer )
	{
		RestorePlayerPosition(PlayerPawn(P));
		P=P.nextPawn;
		goto JL0014;
	}
}

function SavePlayerPosition (PlayerPawn P)
{
	if ( SavedPlayerCount >= 12 )
	{
		return;
	}
	savedPlayers[SavedPlayerCount].IP=P.GetPlayerNetworkAddress();
	savedPlayers[SavedPlayerCount].Location=P.Location;
	SavedPlayerCount++;
}

function RestorePlayerPosition (PlayerPawn P)
{
	local int i;

	i=0;
JL0007:
	if ( i < SavedPlayerCount )
	{
		if ( P.GetPlayerNetworkAddress() == savedPlayers[i].IP )
		{
			P.SetLocation(savedPlayers[i].Location);
			return;
		}
		i++;
		goto JL0007;
	}
}

defaultproperties
{
    bHidden=True
    bAlwaysTick=True
}