//================================================================================
// LeagueAS_GameReplicationInfo.
//================================================================================
class LeagueAS_GameReplicationInfo extends TournamentGameReplicationInfo;

var int StartTimeRemaining;
var int TimeElapsed;
var int TimeRemaining;
var string FortName[20];
var string FortCompleted[20];
var string MatchScore;
var bool bMatchModeEnabled;
var bool bAuthEnabled;

replication
{
	un?reliable if ( Role == 4 )
		StartTimeRemaining,TimeElapsed,TimeRemaining,FortName,FortCompleted,MatchScore,bMatchModeEnabled,bAuthEnabled;
}

simulated function string GetItemName (string FullName)
{
	local int i;

	if ( Left(FullName,17) ~= "get FortCompleted" )
	{
		i=int(Mid(FullName,17));
		return FortCompleted[i];
	}
	if ( Left(FullName,17) ~= "set FortCompleted" )
	{
		i=int(Mid(FullName,17,2));
		FortCompleted[i]=Mid(FullName,20);
		return "";
	}
	if ( FullName ~= "get MatchScore" )
	{
		return MatchScore;
	}
	if ( Left(FullName,14) ~= "set MatchScore" )
	{
		MatchScore=Mid(FullName,15);
		return "";
	}
	if ( FullName ~= "get bMatchModeEnabled" )
	{
		return string(bMatchModeEnabled);
	}
	if ( Left(FullName,21) ~= "set bMatchModeEnabled" )
	{
		if ( Mid(FullName,22) ~= "True" )
		{
			Level.ConsoleCommand("set leagueassault bMatchMode True");
			bMatchModeEnabled=True;
		}
		if ( Mid(FullName,22) ~= "False" )
		{
			Level.ConsoleCommand("set leagueassault bMatchMode False");
			bMatchModeEnabled=False;
		}
		return "";
	}
	if ( FullName ~= "get StartTimeRemaining" )
	{
		return string(StartTimeRemaining);
	}
	if ( Left(FullName,22) ~= "set StartTimeRemaining" )
	{
		StartTimeRemaining=int(Mid(FullName,23));
		return "";
	}
	return Super.GetItemName(FullName);
}

simulated function Timer ()
{
	local PlayerReplicationInfo PRI;
	local int i;
	local int FragAcc;
	local int Difference;

	if ( (TimeRemaining == 0) && bStopCountDown )
	{
		RemainingTime=0;
	}
	Difference=TimeRemaining - RemainingTime;
	if ( Difference < 0 )
	{
		RemainingTime += Difference / 2 - 1;
	} else {
		if ( Difference > 0 )
		{
			RemainingTime += Difference / 2 + 1;
		}
	}
	Difference=TimeElapsed - ElapsedTime;
	if ( Difference < 0 )
	{
		ElapsedTime += Difference / 2 - 1;
	} else {
		if ( Difference > 0 )
		{
			ElapsedTime += Difference / 2 + 1;
		}
	}
	i=0;
JL00C6:
	if ( i < 32 )
	{
		PRIArray[i]=None;
		i++;
		goto JL00C6;
	}
	i=0;
	foreach AllActors(Class'PlayerReplicationInfo',PRI)
	{
		if ( i < 32 )
		{
			PRIArray[i++ ]=PRI;
		}
	}
	UpdateTimer=0.00;
	i=0;
JL0133:
	if ( i < 32 )
	{
		if ( PRIArray[i] != None )
		{
			FragAcc += PRIArray[i].Score;
		}
		i++;
		goto JL0133;
	}
	SumFrags=FragAcc;
	if ( Level.Game != None )
	{
		NumPlayers=Level.Game.NumPlayers;
	}
}

defaultproperties
{
    NetUpdateFrequency=2.90
}