//================================================================================
// LeagueAS_HUD.
//================================================================================
class LeagueAS_HUD extends AssaultHUD
	Config(User);

enum ERenderStatus {
	ERS_None,
	ERS_pre,
	ERS_rover,
	ERS_post
};

enum EFontScheme {
	FS_Manual,
	FS_Auto,
	FS_AutoSmallest,
	FS_AutoSmall,
	FS_AutoMedium,
	FS_AutoBig,
	FS_AutoHuge
};

var string Overlord;
var string emconf;
var LeagueAS_GameReplicationInfo LeagueASGameReplicationInfo;
var config int MaxSizeEmotes;
var config bool bNoOffensiveEmotes;
var config bool bOnlyTeamSayEmotes;
var config bool bNoFormatting;
var config bool bRemoveColors;
var config bool bRemoveNonTeamColors;
var config bool bRemoveEmotes;
var config bool bRemoveUndisplayedEmotes;
var config int loadgroups[6];
var config bool bDontAnimateEmotes;
var config bool bSqueezeEmotesWhenChatFull;
var config bool bSqueezeBeforeExpand;
var config bool bChatboxFastExpand;
var config bool bNoCutLines;
var config int DefaultExpandChatboxMidgame;
var config int DefaultExpandChatboxEndgame;
var config int MaxExpandChatboxMidgame;
var config int MaxExpandChatboxEndgame;
var config bool bCriticalMessageFix;
var config int CriticalMessageLifetime;
var config bool bRemoveProgMsgsOnMapsStart;
var config bool bShowAuthInfo;
var config int FortStandardMode;
var config bool bFirstRun;
var config bool bAutoAdjustDefaultChatboxSizeToResolution;
var config float CHairScale;
var config bool bCHairResIndependent;
var config bool bAdvancedCrosshairs;
var config int CrossHairGroup[11];
var globalconfig string OpaqueCrossHairs[20];
var config bool bSaved;
var Texture OpaqueCrossHairTextures[20];
var int lastsumyl;
var bool bReinitAllMsgs;
var bool bFortModeIsOn;
var bool buntweakdone;
var bool buntweakclassesdone;
var bool bremdrawmuzzle;
var CSHPEntryActor EntryAct;
var bool bEmoticonMenuCreated;
var EmoteWindow EmotWindow;
var config EFontScheme FontScheme;
var config ERenderStatus ERStatus;
var NewMsg Newmsgqueue[128];
var int currentchatboxsize;
var int targetchatboxsize;
var int sstime;
var int sscount;

function xxPreDecrypt ()
{
}

function FirstRunOfLeagueAS ()
{
	Log("FirstRunOfLeagueAS!",'LeagueAssault');
	Class'ClientOptions'.Default.bExtHudShowTeamInfo=False;
	Class'ClientOptions'.StaticSaveConfig();
}

function PreBeginPlay ()
{
	local name SavedWP[50];
	local bool bFoundOne;
	local bool bFound;
	local int i;
	local int j;
	local int k;
	local Light Alight;
	local ZoneInfo Azoneinfo;

	Class'CriticalStringPlus'.Default.Lifetime=CriticalMessageLifetime;
	if ( Default.bFirstRun )
	{
		FirstRunOfLeagueAS();
		Default.bFirstRun=False;
		StaticSaveConfig();
	}
	Spawn(Class'LeagueAS_Tweaks').myHUD=self;
	k=50;
	j=0;
JL0053:
	if ( j < k )
	{
		SavedWP[j]=Class'PlayerPawn'.Default.WeaponPriority[j];
		j++;
		goto JL0053;
	}
	i=0;
JL0093:
	if ( i < k )
	{
		if ( (Class'PlayerPawn'.Default.WeaponPriority[i] == 'Minigun2TIW') || (Class'PlayerPawn'.Default.WeaponPriority[i] == 'pulsegunTIW') )
		{
			j=i;
JL00EB:
			if ( j < k - 1 )
			{
				Class'PlayerPawn'.Default.WeaponPriority[j]=SavedWP[j + 1];
				j++;
				goto JL00EB;
			}
			Class'PlayerPawn'.Default.WeaponPriority[k - 1]='None';
			j=0;
JL014E:
			if ( j < k )
			{
				SavedWP[j]=Class'PlayerPawn'.Default.WeaponPriority[j];
				j++;
				goto JL014E;
			}
			i--;
		}
		i++;
		goto JL0093;
	}
	i=0;
JL019F:
	if ( i < k )
	{
		if ( (Class'PlayerPawn'.Default.WeaponPriority[i] == 'minigun2') && (Class'PlayerPawn'.Default.WeaponPriority[i - 1] != 'Minigun2TIW') )
		{
			if (  !bFoundOne )
			{
				j=i;
JL0205:
				if ( j < k - 1 )
				{
					Class'PlayerPawn'.Default.WeaponPriority[j + 1]=SavedWP[j];
					j++;
					goto JL0205;
				}
				Class'PlayerPawn'.Default.WeaponPriority[i]='Minigun2TIW';
				j=0;
JL0265:
				if ( j < k )
				{
					SavedWP[j]=Class'PlayerPawn'.Default.WeaponPriority[j];
					j++;
					goto JL0265;
				}
				bFoundOne=True;
			} else {
				j=i;
JL02B4:
				if ( j < k - 1 )
				{
					Class'PlayerPawn'.Default.WeaponPriority[j]=SavedWP[j + 1];
					j++;
					goto JL02B4;
				}
				j=0;
JL02FA:
				if ( j < k )
				{
					SavedWP[j]=Class'PlayerPawn'.Default.WeaponPriority[j];
					j++;
					goto JL02FA;
				}
				i--;
			}
		}
		i++;
		goto JL019F;
	}
	bFoundOne=False;
	i=0;
JL0353:
	if ( i < k )
	{
		if ( (Class'PlayerPawn'.Default.WeaponPriority[i] == 'PulseGun') && (Class'PlayerPawn'.Default.WeaponPriority[i - 1] != 'pulsegunTIW') )
		{
			if (  !bFoundOne )
			{
				j=i;
JL03B9:
				if ( j < k - 1 )
				{
					Class'PlayerPawn'.Default.WeaponPriority[j + 1]=SavedWP[j];
					j++;
					goto JL03B9;
				}
				Class'PlayerPawn'.Default.WeaponPriority[i]='pulsegunTIW';
				j=0;
JL0419:
				if ( j < k )
				{
					SavedWP[j]=Class'PlayerPawn'.Default.WeaponPriority[j];
					j++;
					goto JL0419;
				}
				bFoundOne=True;
			} else {
				j=i;
JL0468:
				if ( j < k - 1 )
				{
					Class'PlayerPawn'.Default.WeaponPriority[j]=SavedWP[j + 1];
					j++;
					goto JL0468;
				}
				j=0;
JL04AE:
				if ( j < k )
				{
					SavedWP[j]=Class'PlayerPawn'.Default.WeaponPriority[j];
					j++;
					goto JL04AE;
				}
				i--;
			}
		}
		i++;
		goto JL0353;
	}
	Class'PlayerPawn'.StaticSaveConfig();
	if ( bSaved == False )
	{
		Class'Emotelist'.Default.binit=Class'Emotelist'.Default.binit;
		Class'Emotelist'.StaticSaveConfig();
		Class'NewMsgDeathMessagePlus'.Default.DefColorIndex=Class'NewMsgDeathMessagePlus'.Default.DefColorIndex;
		Class'NewMsgDeathMessagePlus'.StaticSaveConfig();
		Class'NewSayMessagePlus'.Default.DefColorIndex=Class'NewSayMessagePlus'.Default.DefColorIndex;
		Class'NewSayMessagePlus'.StaticSaveConfig();
		Class'NewTeamSayMessagePlus'.Default.DefColorIndex=Class'NewTeamSayMessagePlus'.Default.DefColorIndex;
		Class'NewTeamSayMessagePlus'.StaticSaveConfig();
		Class'NewStringMessagePlus'.Default.DefColorIndex=Class'NewStringMessagePlus'.Default.DefColorIndex;
		Class'NewStringMessagePlus'.StaticSaveConfig();
		if ( Class'minigun2'.Default.bDrawMuzzleFlash == False )
		{
			Class'LeagueAS_Tweaks'.Default.bNoFirstPersonMuzzleFlash=True;
		}
		if ( Class'MTracer'.Default.bHidden == True )
		{
			Class'LeagueAS_Tweaks'.Default.bNoMiniTracer=True;
		}
		if ( Class'MiniShellCase'.Default.bHidden == True )
		{
			Class'LeagueAS_Tweaks'.Default.bNoMiniShells=True;
		}
		if ( Class'UT_ShellCase'.Default.bHidden == True )
		{
			Class'LeagueAS_Tweaks'.Default.bNoSniperEnforcerShells=True;
		}
		if ( Class'EnhancedRespawn'.Default.bHidden == True )
		{
			Class'LeagueAS_Tweaks'.Default.bNoSpawnEffects=True;
		}
		if ( (Class'UT_Spark'.Default.bHidden == True) || (Class'UT_Sparks'.Default.bHidden == True) )
		{
			Class'LeagueAS_Tweaks'.Default.bNoSparks=True;
		}
		if ( Class'Chip'.Default.bHidden == True )
		{
			Class'LeagueAS_Tweaks'.Default.bNoChips=True;
		}
		if ( (Class'UTSmokeTrail'.Default.ScaleGlow != 0.80) || (Class'LightSmokeTrail'.Default.ScaleGlow != 0.80) )
		{
			Class'LeagueAS_Tweaks'.Default.blilTweakSmokeReduction=True;
		}
		if ( (Class'UT_BloodTrail'.Default.bGreenBlood == True) || (Class'UT_BloodHit'.Default.bGreenBlood == True) )
		{
			Class'LeagueAS_Tweaks'.Default.blilTweakGreenBlood=True;
		}
		if ( Class'RocketMk2'.Default.RotationRate != rot(0,0,50000) )
		{
			Class'LeagueAS_Tweaks'.Default.bNoRocketsRot=True;
		}
		if ( Class'ShockBeam'.Default.RotationRate != rot(0,0,1000000) )
		{
			Class'LeagueAS_Tweaks'.Default.bNoShockBeamRot=True;
		}
		if ( Class'UT_RingExplosion4'.Default.bHidden == True )
		{
			Class'LeagueAS_Tweaks'.Default.bSimpleCombo=True;
		}
		if ( Class'ShockBeam'.Default.DrawScale != 0.44 )
		{
			Class'LeagueAS_Tweaks'.Default.bSimpleShockBeam=True;
		}
		if ( (Class'UT_ComboRing'.Default.Skin == Texture'TLThunder') && (Class'UT_RingExplosion4'.Default.Skin == Texture'pPurpleRing') )
		{
			Class'LeagueAS_Tweaks'.Default.FreakyCombo=1;
		} else {
			if ( (Class'UT_ComboRing'.Default.Skin == Texture'TLThunder') && (Class'UT_RingExplosion4'.Default.Skin == None) )
			{
				Class'LeagueAS_Tweaks'.Default.FreakyCombo=2;
			} else {
				if ( (Class'UT_ComboRing'.Default.Skin == Texture'TLThunder') && (Class'UT_RingExplosion4'.Default.Skin == Texture'BlueBarInM') )
				{
					Class'LeagueAS_Tweaks'.Default.FreakyCombo=3;
				} else {
					if ( (Class'UT_ComboRing'.Default.Skin == FireTexture'fireeffect50') && (Class'ShockrifleWave'.Default.Texture == Texture'S_Actor') )
					{
						Class'LeagueAS_Tweaks'.Default.FreakyCombo=4;
					} else {
						if ( (Class'UT_ComboRing'.Default.Skin == FireTexture'fireeffect50') && (Class'ShockrifleWave'.Default.Texture == Texture'MuzzleFlash2') )
						{
							Class'LeagueAS_Tweaks'.Default.FreakyCombo=5;
						} else {
							if ( (Class'UT_ComboRing'.Default.Skin == FireTexture'fireeffect50') && (Class'ShockrifleWave'.Default.Texture == Texture'Flakmuz') )
							{
								Class'LeagueAS_Tweaks'.Default.FreakyCombo=6;
							} else {
								if ( (Class'UT_ComboRing'.Default.Skin == Texture'TLThunder') && (Class'UT_RingExplosion4'.Default.bHidden == True) )
								{
									Class'LeagueAS_Tweaks'.Default.FreakyCombo=7;
								} else {
									if ( (Class'UT_ComboRing'.Default.Skin == Texture'TLThunder') && (Class'UT_RingExplosion4'.Default.Skin == Texture'pPurpleRing') )
									{
										Class'LeagueAS_Tweaks'.Default.FreakyCombo=8;
									} else {
										Class'LeagueAS_Tweaks'.Default.FreakyCombo=0;
									}
								}
							}
						}
					}
				}
			}
		}
		if ( Class'ShockBeam'.Default.Mesh == LodMesh'RazorBlade' )
		{
			Class'LeagueAS_Tweaks'.Default.FreakyBeam=1;
		} else {
			if ( Class'ShockBeam'.Default.Mesh == LodMesh'PBolt' )
			{
				Class'LeagueAS_Tweaks'.Default.FreakyBeam=2;
			} else {
				Class'LeagueAS_Tweaks'.Default.FreakyBeam=0;
			}
		}
		if ( (Class'UT_Eightball'.Default.DeathMessage != "%o was smacked down by %k's %w.") || (Class'SniperRifle'.Default.DeathMessage != "%k put a bullet through %o's head.") )
		{
			Class'LeagueAS_Tweaks'.Default.EnforcerMsg=Class'enforcer'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.BioMsg=Class'ut_biorifle'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.ShockMsg=Class'ShockRifle'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.PulseMsg=Class'PulseGun'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.MiniMsg=Class'minigun2'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.RipperMsg=Class'ripper'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.FlakMsg=Class'UT_FlakCannon'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.RLMsg=Class'UT_Eightball'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.SniperMsg=Class'SniperRifle'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.HammerMsg=Class'ImpactHammer'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.WarHeadMsg=Class'WarheadLauncher'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.InstaMsg=Class'SuperShockRifle'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.TeleMsg=Class'Translocator'.Default.DeathMessage;
			Class'LeagueAS_Tweaks'.Default.KillMsgType=6;
		}
		Class'LeagueAS_Tweaks'.StaticSaveConfig();
		bSaved=True;
		SaveConfig();
	}
	Class'Emotelist'.initemotes();
	Class'LeagueAS_UnTweak'.untweakclasses();
	Class'LevelInfo'.Default.Brightness=1.00;
	Level.Brightness=1.00;
	foreach AllActors(Class'Light',Alight)
	{
		Class'LeagueAS_UnTweak'.untweak(Alight,False);
	}
	foreach AllActors(Class'ZoneInfo',Azoneinfo)
	{
		Class'LeagueAS_UnTweak'.untweak(Azoneinfo,False);
	}
	Owner.ConsoleCommand("set watertexture bInvisible false");
	Owner.ConsoleCommand("set fire.watertexture bInvisible False");
	if ( Class'AmbientSound'.Default.SoundRadius != 64 )
	{
		Owner.ConsoleCommand("set ambientsound soundradius 64");
	}
	if ( Class'AmbientSound'.Default.SoundVolume != 190 )
	{
		Owner.ConsoleCommand("set ambientsound soundvolume 190");
	}
	if ( Class'AmbientSound'.Default.SoundPitch != 64 )
	{
		Owner.ConsoleCommand("set ambientsound soundpitch 64");
	}
	Super.PreBeginPlay();
}

function bool ProcessKeyEvent (int Key, int Action, float Delta)
{
	if ( (EntryAct != None) &&  !EntryAct.bDeleteMe )
	{
		return EntryAct.ProcessKeyEvent(Key,Action,Delta);
	} else {
		return False;
	}
}

function DoShowFortStandards (Canvas Canvas)
{
	local FortStandard F;

	foreach Level.AllActors(Class'FortStandard',F)
	{
		F.bHidden=False;
		F.DrawType=2;
		if ( Default.FortStandardMode == 3 )
		{
			F.DrawScale=2.50;
		} else {
			F.DrawScale=0.60;
		}
		F.LightHue=255;
		F.LightSaturation=255;
		F.LightBrightness=255;
		F.AmbientGlow=255;
		if ( Default.FortStandardMode >= 2 )
		{
			Canvas.DrawActor(F,False,True);
		}
	}
	bFortModeIsOn=True;
}

function DoResetFortStandards ()
{
	local FortStandard F;

	foreach Level.AllActors(Class'FortStandard',F)
	{
		F.bHidden=True;
		F.DrawType=0;
		F.DrawScale=Class'FortStandard'.Default.DrawScale;
		F.LightHue=Class'FortStandard'.Default.LightHue;
		F.LightSaturation=Class'FortStandard'.Default.LightSaturation;
		F.LightBrightness=Class'FortStandard'.Default.LightBrightness;
		F.AmbientGlow=Class'FortStandard'.Default.AmbientGlow;
	}
	bFortModeIsOn=False;
}

function float DistanceFrom (Pawn P1, Pawn P2)
{
	local float DistanceX;
	local float DistanceY;
	local float ADistance;

	if ( (P1 == None) || (P2 == None) )
	{
		return -469762048.00;
	}
	if ( (P1.Location.X == 0) && (P1.Location.Y == 0) || (P2.Location.X == 0) && (P2.Location.Y == 0) )
	{
		return -1.00;
	} else {
		DistanceX=P1.Location.X - P2.Location.X;
		DistanceY=P1.Location.Y - P2.Location.Y;
		ADistance=Sqrt(Square(DistanceX) + Square(DistanceY));
		return ADistance;
	}
}

simulated function DrawAmmo (Canvas Canvas)
{
	local int X;
	local int Y;
	local int AmmoAmount;

	if ( (PawnOwner == PlayerOwner) && PlayerOwner.PlayerReplicationInfo.bIsSpectator )
	{
		return;
	}
	Canvas.Style=Style;
	Canvas.DrawColor=HUDColor;
	if ( bHideAllWeapons || (HUDScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale) )
	{
		Y=Canvas.ClipY - 63.50 * Scale;
	} else {
		Y=Canvas.ClipY - 127.50 * Scale;
	}
	if ( bHideAllWeapons )
	{
		X=0.50 * Canvas.ClipX + 128 * Scale;
	} else {
		X=Canvas.ClipX - 128 * Scale;
	}
	Canvas.SetPos(X,Y);
	Canvas.DrawTile(Texture'HudElements1',128.00 * Scale,64.00 * Scale,128.00,192.00,128.00,64.00);
	Canvas.DrawColor=WhiteColor;
	if ( PawnOwner != PlayerOwner )
	{
		if ( (PawnOwner.PlayerReplicationInfo != None) && PawnOwner.PlayerReplicationInfo.IsA('LeagueAS_ExtPlayerReplicationInfo') )
		{
			AmmoAmount=LeagueAS_ExtPlayerReplicationInfo(PawnOwner.PlayerReplicationInfo).AmmoAmount;
		} else {
			AmmoAmount=0;
		}
		DrawBigNum(Canvas,AmmoAmount,X + 4 * Scale,Y + 16 * Scale);
	} else {
		if ( (PawnOwner.Weapon == None) || (PawnOwner.Weapon.AmmoType == None) )
		{
			return;
		}
		DrawBigNum(Canvas,PawnOwner.Weapon.AmmoType.AmmoAmount,X + 4 * Scale,Y + 16 * Scale);
	}
}

simulated function PreRender (Canvas Canvas)
{
	if ( (EntryAct != None) &&  !EntryAct.bDeleteMe )
	{
		EntryAct.Init_HUD_PreRender(Canvas);
	}
	if ( (EntryAct != None) &&  !EntryAct.bDeleteMe )
	{
		EntryAct.Exit_HUD_PreRender(Canvas);
	}
}

simulated event RenderOverlays (Canvas Canvas)
{
	if ( (EntryAct != None) &&  !EntryAct.bDeleteMe )
	{
		EntryAct.Init_HUD_RenderOverlays(Canvas);
	}
	Super.RenderOverlays(Canvas);
	if ( (EntryAct != None) &&  !EntryAct.bDeleteMe )
	{
		EntryAct.Exit_HUD_RenderOverlays(Canvas);
	}
}

simulated event PostRender (Canvas C)
{
	if ( (EntryAct != None) &&  !EntryAct.bDeleteMe )
	{
		EntryAct.Init_HUD_PostRender(C);
	}
	DoPostRender(C);
	if ( (EntryAct != None) &&  !EntryAct.bDeleteMe )
	{
		EntryAct.Exit_HUD_PostRender(C);
	}
}

simulated function DoPostRender (Canvas Canvas)
{
	local float XL;
	local float YL;
	local float XPos;
	local float YPos;
	local float FadeValue;
	local string Message;
	local int M;
	local int i;
	local int j;
	local int k;
	local int XOverflow;
	local float OldOriginX;
	local Weapon myweap;
	local int TeamSize0;
	local int TeamSize1;
	local int Y;
	local int StartTop;
	local int ownerTeam;
	local int minsleft;
	local int secsleft;
	local int SelectedTime;
	local int lastmsg;
	local int firstmsg;
	local int prevmsg;
	local float FontHeight;
	local float StartRight;
	local float SumYL;
	local float cy;
	local Font CanvasFont;
	local PlayerReplicationInfo PRI;
	local LeagueAS_ExtPlayerReplicationInfo epri;
	local LeagueAS_CustomReplicationInfo cRI;
	local string OwnerName;
	local string TeamSizes;
	local string SelectedTimeString;
	local int msgspace[10];
	local int maxchatsize;
	local int defaultchatsize;
	local bool bfromtop;
	local Pawn P;
	local Actor A;
	local bool bdrawnyet;
	local bool bv;
	local int pos;
	local int Index;

	bfromtop=False;
	HUDSetup(Canvas);
	if ( Default.FortStandardMode > 0 )
	{
		DoShowFortStandards(Canvas);
	} else {
		if ( bFortModeIsOn )
		{
			DoResetFortStandards();
		}
	}
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
	{
		return;
	}
	if ( bShowInfo )
	{
		ServerInfo.RenderInfo(Canvas);
		return;
	}
	Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
	OldOriginX=Canvas.OrgX;
	Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("TEST",XL,YL);
	Canvas.SetClip(768.00 * Scale - 10,Canvas.ClipY);
	bDrawFaceArea=False;
	if (  !bHideFaces &&  !PlayerOwner.bShowScores &&  !bForceScores &&  !bHideHUD && (PawnOwner.IsA('TournamentPlayer') || PawnOwner.IsA('Bot')) &&  !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.40) )
	{
		DrawSpeechArea(Canvas,XL,YL);
		bDrawFaceArea=(FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if (  !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) ||  !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
			{
				Canvas.SetOrigin(Min(128,Default.DefaultExpandChatboxMidgame) + 7 * Scale + 6 + FaceAreaOffset,Canvas.OrgY);
			}
		}
	}
	SumYL=0.00;
	firstmsg=-1;
	lastmsg=-1;
	j=0;
	i=0;
JL02C7:
	if ( i < 128 )
	{
		if ( (Newmsgqueue[i] != None) &&  !Newmsgqueue[i].bDeleteMe )
		{
			j++;
			if ( firstmsg == -1 )
			{
				firstmsg=i;
			}
			if ( bResChanged ||  !Newmsgqueue[i].binit || bReinitAllMsgs )
			{
				if ( (PawnOwner.IsInState('GameEnded') || PawnOwner.IsInState('PlayerWaiting')) && (lastsumyl + YL > MaxExpandChatboxEndgame) && bSqueezeEmotesWhenChatFull || (PawnOwner.IsInState('GameEnded') || PawnOwner.IsInState('PlayerWaiting')) && (lastsumyl + YL > DefaultExpandChatboxEndgame) && bSqueezeBeforeExpand && bSqueezeEmotesWhenChatFull ||  !(PawnOwner.IsInState('GameEnded') || PawnOwner.IsInState('PlayerWaiting')) && (lastsumyl + YL > MaxExpandChatboxMidgame) && bSqueezeEmotesWhenChatFull ||  !(PawnOwner.IsInState('GameEnded') || PawnOwner.IsInState('PlayerWaiting')) && (lastsumyl + YL > DefaultExpandChatboxMidgame) && bSqueezeBeforeExpand && bSqueezeEmotesWhenChatFull )
				{
					Newmsgqueue[i].squeeze(Canvas,XL,YL,None);
				} else {
					Newmsgqueue[i].Initmsg(Canvas,XL,YL,None);
				}
				if ( Newmsgqueue[i].bNewMessage &&  !Newmsgqueue[i].bDeleteMe )
				{
					if ( Newmsgqueue[i].IsA('NewSayMessagePlus') || Newmsgqueue[i].IsA('NewTeamSayMessagePlus') )
					{
						if ( Newmsgqueue[i].PRI != None )
						{
							FaceTexture=Newmsgqueue[i].PRI.TalkTexture;
							if ( Newmsgqueue[i].PRI.Team < 255 )
							{
								FaceTeam=TeamColor[Newmsgqueue[i].PRI.Team];
							} else {
								FaceTeam=TeamColor[0];
							}
						}
						if ( FaceTexture != None )
						{
							FaceTime=Level.TimeSeconds + 3;
						}
					}
					Newmsgqueue[i].bNewMessage=False;
				}
			}
			SumYL += Newmsgqueue[i].YSZ;
			if ( lastmsg != -1 )
			{
				SumYL += Max(Newmsgqueue[lastmsg].bottomsize,Newmsgqueue[i].topsize);
			}
			lastmsg=i;
		}
		i++;
		goto JL02C7;
	}
	if ( lastmsg != -1 )
	{
		MessageFadeTime=1.00;
	}
	bReinitAllMsgs=False;
	if ( PawnOwner.IsInState('GameEnded') || PawnOwner.IsInState('PlayerWaiting') )
	{
		defaultchatsize=Default.DefaultExpandChatboxEndgame;
		maxchatsize=Min(Default.MaxExpandChatboxEndgame,Canvas.SizeY);
	} else {
		defaultchatsize=Default.DefaultExpandChatboxMidgame;
		maxchatsize=Min(Default.MaxExpandChatboxMidgame,Canvas.SizeY);
	}
	if ( firstmsg != -1 )
	{
		SumYL += Newmsgqueue[firstmsg].topsize;
		SumYL += Newmsgqueue[lastmsg].bottomsize;
		if ( SumYL < targetchatboxsize )
		{
			targetchatboxsize=Max(SumYL,defaultchatsize);
		}
		if ( (SumYL > currentchatboxsize) && bSqueezeEmotesWhenChatFull && (bSqueezeBeforeExpand || (currentchatboxsize >= maxchatsize)) )
		{
			i=0;
JL07EF:
			if ( i < 128 )
			{
				if ( (Newmsgqueue[i] != None) &&  !Newmsgqueue[i].bDeleteMe )
				{
					if (  !Newmsgqueue[i].bsqueeze )
					{
						Newmsgqueue[i].squeeze(Canvas,XL,YL);
					}
				}
				i++;
				goto JL07EF;
			}
			prevmsg=-1;
			SumYL=0.00;
			SumYL += Newmsgqueue[lastmsg].bottomsize;
			i=127;
JL08AA:
			if ( i >= 0 )
			{
				if ( (Newmsgqueue[i] != None) &&  !Newmsgqueue[i].bDeleteMe )
				{
					if ( (SumYL + Newmsgqueue[i].YSZ > maxchatsize) &&  !bfromtop && bNoCutLines )
					{
						Newmsgqueue[i].Destroy();
						Newmsgqueue[i]=None;
					} else {
						SumYL += Newmsgqueue[i].YSZ;
						if ( prevmsg != -1 )
						{
							SumYL += Max(Newmsgqueue[prevmsg].topsize,Newmsgqueue[i].bottomsize);
						}
						prevmsg=i;
					}
				}
				i--;
				goto JL08AA;
			}
			if ( prevmsg != -1 )
			{
				SumYL += Newmsgqueue[prevmsg].topsize;
			} else {
				SumYL += Newmsgqueue[firstmsg].topsize;
			}
		}
		if ( SumYL < targetchatboxsize )
		{
			targetchatboxsize=Max(SumYL,defaultchatsize);
		}
		if ( SumYL > targetchatboxsize )
		{
			targetchatboxsize=Min(SumYL,maxchatsize);
		}
		if ( targetchatboxsize < defaultchatsize )
		{
			targetchatboxsize=defaultchatsize;
		}
		if ( targetchatboxsize > maxchatsize )
		{
			targetchatboxsize=maxchatsize;
		}
		if ( bNoCutLines )
		{
			if ( targetchatboxsize < currentchatboxsize )
			{
				bfromtop=True;
			}
		} else {
			if ( currentchatboxsize < SumYL )
			{
				bfromtop=True;
			}
		}
		if (  !bfromtop )
		{
			if ( Newmsgqueue[firstmsg] != None )
			{
				cy=2.00 + Min(currentchatboxsize - SumYL,Newmsgqueue[firstmsg].topsize);
			} else {
				cy=2.00 + currentchatboxsize - SumYL;
			}
			bdrawnyet=False;
			i=0;
JL0B2C:
			if ( i < 128 )
			{
				if ( Newmsgqueue[i] != None )
				{
					if (  !Newmsgqueue[i].bDeleteMe )
					{
						if ( cy >= 2 )
						{
							if (  !bdrawnyet && (cy > 2) )
							{
								cy=2.00;
							}
							bdrawnyet=True;
							Newmsgqueue[i].RenderMsg(6,cy,Canvas);
						}
						cy += Newmsgqueue[i].YSZ;
						if ( lastmsg > i )
						{
							j=i + 1;
JL0BF7:
							if ( j <= lastmsg )
							{
								if ( Newmsgqueue[j] != None )
								{
									if (  !Newmsgqueue[j].bDeleteMe )
									{
										goto JL0C3E;
									}
								}
								j++;
								goto JL0BF7;
							}
JL0C3E:
							if ( j > -1 )
							{
								if ( Newmsgqueue[j] != None )
								{
									if (  !Newmsgqueue[j].bDeleteMe )
									{
										cy += Max(Newmsgqueue[i].bottomsize,Newmsgqueue[j].topsize);
									} else {
										cy += Newmsgqueue[i].bottomsize;
									}
								}
							}
						}
					}
				}
				i++;
				goto JL0B2C;
			}
		} else {
			cy=2.00 + currentchatboxsize - Newmsgqueue[lastmsg].bottomsize - Newmsgqueue[lastmsg].YSZ;
			i=lastmsg;
JL0D21:
			if ( i >= 0 )
			{
				if ( Newmsgqueue[i] != None )
				{
					if (  !Newmsgqueue[i].bDeleteMe )
					{
						Newmsgqueue[i].RenderMsg(6,cy,Canvas);
						if ( firstmsg >= 0 )
						{
							if ( firstmsg < i )
							{
								j=i - 1;
JL0DA1:
								if ( j >= firstmsg )
								{
									if ( Newmsgqueue[j] != None )
									{
										if (  !Newmsgqueue[j].bDeleteMe )
										{
											goto JL0DE8;
										}
									}
									j--;
									goto JL0DA1;
								}
JL0DE8:
								if ( j > -1 )
								{
									if ( Newmsgqueue[j] != None )
									{
										if (  !Newmsgqueue[j].bDeleteMe )
										{
											cy -= Max(Newmsgqueue[i].topsize,Newmsgqueue[j].bottomsize);
										} else {
											cy -= Newmsgqueue[i].topsize;
										}
									}
								}
							}
							if ( j > -1 )
							{
								if ( Newmsgqueue[j] != None )
								{
									if (  !Newmsgqueue[j].bDeleteMe )
									{
										cy -= Newmsgqueue[j].YSZ;
									}
								}
							}
						}
					}
				}
				i--;
				goto JL0D21;
			}
		}
	} else {
		targetchatboxsize=defaultchatsize;
	}
	lastsumyl=SumYL;
	Canvas.DrawColor=WhiteColor;
	Canvas.SetClip(OldClipX,Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX,Canvas.OrgY);
	Canvas.CurYL=0.00;
	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
		{
			PlayerOwner.Scoring=Spawn(PlayerOwner.ScoringType,PlayerOwner);
		}
		if ( PlayerOwner.Scoring != None )
		{
			PlayerOwner.Scoring.OwnerHUD=self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
			{
				DrawTypingPrompt(Canvas,PlayerOwner.Player.Console);
			}
			return;
		}
	}
	YPos=Min(128,Default.DefaultExpandChatboxMidgame);
	if ( bDrawFaceArea )
	{
		DrawTalkFace(Canvas,0,YPos);
	}
	if ( j > 0 )
	{
		bDrawMessageArea=True;
		MessageFadeCount=2;
	} else {
		bDrawMessageArea=False;
	}
	if (  !bHideCenterMessages )
	{
		pos=0;
		i=0;
JL10C0:
		if ( i < 10 )
		{
			if ( LocalMessages[i].Message != None )
			{
				if ( LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode )
				{
					Canvas.Style=3;
					FadeValue=LocalMessages[i].EndOfLife - Level.TimeSeconds;
					if ( FadeValue > 0.00 )
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.GetFontSize(LocalMessages[i].Switch) == 1 )
							{
								LocalMessages[i].StringFont=MyFonts.GetBigFont(Canvas.ClipX);
							} else {
								LocalMessages[i].StringFont=MyFonts.GetHugeFont(Canvas.ClipX);
							}
							Canvas.Font=LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage,LocalMessages[i].XL,LocalMessages[i].YL);
							LocalMessages[i].YPos=LocalMessages[i].Message.GetOffset(LocalMessages[i].Switch,LocalMessages[i].YL,Canvas.ClipY);
						}
						Canvas.Font=LocalMessages[i].StringFont;
						Canvas.DrawColor=LocalMessages[i].DrawColor * FadeValue / LocalMessages[i].Lifetime;
						if ( Default.bCriticalMessageFix && (LocalMessages[i].Message == Class'CriticalStringPlus') )
						{
							pos++;
							Canvas.SetPos(0.50 * (Canvas.ClipX - LocalMessages[i].XL),LocalMessages[i].YPos + pos * LocalMessages[i].YL * 1.20);
						} else {
							Canvas.SetPos(0.50 * (Canvas.ClipX - LocalMessages[i].XL),LocalMessages[i].YPos);
						}
						Canvas.DrawText(LocalMessages[i].StringMessage,False);
					}
				} else {
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.GetFontSize(LocalMessages[i].Switch) == 1 )
						{
							LocalMessages[i].StringFont=MyFonts.GetBigFont(Canvas.ClipX);
						} else {
							LocalMessages[i].StringFont=MyFonts.GetHugeFont(Canvas.ClipX);
						}
						Canvas.Font=LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage,LocalMessages[i].XL,LocalMessages[i].YL);
						LocalMessages[i].YPos=LocalMessages[i].Message.GetOffset(LocalMessages[i].Switch,LocalMessages[i].YL,Canvas.ClipY);
					}
					Canvas.Font=LocalMessages[i].StringFont;
					Canvas.Style=1;
					Canvas.DrawColor=LocalMessages[i].DrawColor;
					if ( Default.bCriticalMessageFix && (LocalMessages[i].Message == Class'CriticalStringPlus') )
					{
						pos++;
						Canvas.SetPos(0.50 * (Canvas.ClipX - LocalMessages[i].XL),LocalMessages[i].YPos + pos * LocalMessages[i].YL * 1.20);
					} else {
						Canvas.SetPos(0.50 * (Canvas.ClipX - LocalMessages[i].XL),LocalMessages[i].YPos);
					}
					Canvas.DrawText(LocalMessages[i].StringMessage,False);
				}
			}
			i++;
			goto JL10C0;
		}
	}
	Canvas.Style=1;
	if (  !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == 0) )
	{
		Canvas.DrawColor=WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if (  !PawnOwner.Weapon.bOwnsCrosshair )
		{
			DrawCrossHair(Canvas,0,0);
		}
	}
	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
		Canvas.bCenter=True;
		Canvas.Style=1;
		Canvas.DrawColor=CyanColor * TutIconBlink;
		Canvas.SetPos(4.00,Canvas.ClipY - 96 * Scale);
		Canvas.DrawText(LiveFeed $ PawnOwner.PlayerReplicationInfo.PlayerName,True);
		Canvas.bCenter=False;
		Canvas.DrawColor=WhiteColor;
		Canvas.Style=Style;
	}
	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage=False;
		PlayerOwner.SetProgressTime(7.00);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) &&  !bHideCenterMessages )
	{
		DisplayProgressMessage(Canvas);
	}
	if ( MOTDFadeOutTime > 0.00 )
	{
		DrawMOTD(Canvas);
	}
	if (  !bHideHUD )
	{
		if (  !PlayerOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style=Style;
			if (  !bHideAmmo )
			{
				DrawAmmo(Canvas);
			}
			DrawStatus(Canvas);
			if (  !bHideAllWeapons )
			{
				DrawWeapons(Canvas);
			} else {
				if ( Level.bHighDetailMode && (PawnOwner == PlayerOwner) && (PlayerOwner.Handedness == 2) )
				{
					if ( PawnOwner.PendingWeapon != None )
					{
						WeaponNameFade=1.00;
						Canvas.Font=MyFonts.GetBigFont(Canvas.ClipX);
						Canvas.DrawColor=PawnOwner.PendingWeapon.NameColor;
						Canvas.SetPos(Canvas.ClipX - 360 * Scale,Canvas.ClipY - 64 * Scale);
						Canvas.DrawText(PawnOwner.PendingWeapon.ItemName,False);
					} else {
						if ( (Level.NetMode == 3) && PawnOwner.IsA('TournamentPlayer') && (TournamentPlayer(PawnOwner).ClientPending != None) )
						{
							WeaponNameFade=1.00;
							Canvas.Font=MyFonts.GetBigFont(Canvas.ClipX);
							Canvas.DrawColor=TournamentPlayer(PawnOwner).ClientPending.NameColor;
							Canvas.SetPos(Canvas.ClipX - 360 * Scale,Canvas.ClipY - 64 * Scale);
							Canvas.DrawText(TournamentPlayer(PawnOwner).ClientPending.ItemName,False);
						} else {
							if ( (WeaponNameFade > 0) && (PawnOwner.Weapon != None) )
							{
								Canvas.Font=MyFonts.GetBigFont(Canvas.ClipX);
								Canvas.DrawColor=PawnOwner.Weapon.NameColor;
								if ( WeaponNameFade < 1 )
								{
									Canvas.DrawColor=Canvas.DrawColor * WeaponNameFade;
								}
								Canvas.SetPos(Canvas.ClipX - 360 * Scale,Canvas.ClipY - 64 * Scale);
								Canvas.DrawText(PawnOwner.Weapon.ItemName,False);
							}
						}
					}
				}
			}
			if (  !bAlwaysHideFrags &&  !bHideFrags )
			{
				DrawFragCount(Canvas);
			}
		} else {
			if ( (PlayerOwner.ViewTarget != None) && (PlayerOwner.ViewTarget != self) )
			{
				DrawStatus(Canvas);
				if (  !bHideAmmo )
				{
					DrawAmmo(Canvas);
				}
				if (  !bHideAllWeapons )
				{
					DrawWeapons(Canvas);
				}
				if (  !bAlwaysHideFrags &&  !bHideFrags )
				{
					DrawFragCount(Canvas);
				}
			}
		}
		if (  !bHideTeamInfo )
		{
			DrawGameSynopsis(Canvas);
		}
		if ( PawnOwner == PlayerOwner )
		{
			DrawIdentifyInfo(Canvas);
		}
		if ( HUDMutator != None )
		{
			HUDMutator.PostRender(Canvas);
		}
		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		{
			if ( TimeMessageClass == None )
			{
				TimeMessageClass=Class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage",Class'Class'));
			}
			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300) && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime=PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid=bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0);
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
					{
						TellTime(5);
					} else {
						if ( bTimeValid && (PlayerOwner.GameReplicationInfo.RemainingTime <= 10) )
						{
							TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
						}
					}
				} else {
					if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
					{
						M=PlayerOwner.GameReplicationInfo.RemainingTime / 60;
						TellTime(5 - M);
					}
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
	{
		DrawTypingPrompt(Canvas,PlayerOwner.Player.Console);
	}
	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style=1;
		Canvas.DrawColor=WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 64 * Scale,Canvas.ClipY / 2);
		Canvas.DrawIcon(Texture'DisconnectWarn',Scale);
	}
	if (  !PlayerPawn(Owner).bShowScores && Class'ClientOptions'.Default.bExtHudEnabled )
	{
		if ( PlayerPawn(Owner) == None )
		{
			return;
		}
		if ( LeagueAS_GameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo) == None )
		{
			return;
		}
		if ( PlayerPawn(Owner).PlayerReplicationInfo == None )
		{
			return;
		}
		LeagueASGameReplicationInfo=LeagueAS_GameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
		if ( LeagueASGameReplicationInfo == None )
		{
			return;
		}
		ownerTeam=PlayerPawn(Owner).PlayerReplicationInfo.Team;
		OwnerName=PlayerPawn(Owner).PlayerReplicationInfo.PlayerName;
		StartTop=Canvas.SizeY / 3;
		if ( Class'ClientOptions'.Default.bExtHudLargeFont )
		{
			Canvas.Font=Font'MedFont';
		} else {
			Canvas.Font=Font'SmallFont';
		}
		Canvas.StrLen("1",StartRight,FontHeight);
		Canvas.DrawColor=GoldColor;
		Y=StartTop;
		if ( Class'ClientOptions'.Default.bExtHudShowGameInfo )
		{
			if ( LeagueASGameReplicationInfo.bMatchModeEnabled )
			{
				Canvas.SetPos(5.00,Y);
				Canvas.DrawText("Score:" @ LeagueASGameReplicationInfo.MatchScore);
				Y=Y + FontHeight + 14;
			} else {
				Canvas.SetPos(5.00,Y);
				if ( LeagueASGameReplicationInfo.Teams[0] != None )
				{
					TeamSize0=LeagueASGameReplicationInfo.Teams[0].Size;
				} else {
					TeamSize0=0;
				}
				if ( LeagueASGameReplicationInfo.Teams[1] != None )
				{
					TeamSize1=LeagueASGameReplicationInfo.Teams[1].Size;
				} else {
					TeamSize1=0;
				}
				if ( ownerTeam == 0 )
				{
					TeamSizes=string(TeamSize0) @ "v" @ string(TeamSize1);
				} else {
					TeamSizes=string(TeamSize1) @ "v" @ string(TeamSize0);
				}
				Canvas.DrawText("Team Sizes:" @ TeamSizes);
				Y=Y + FontHeight + 14;
			}
		}
		if ( Class'ClientOptions'.Default.bExtHudShowConnInfo )
		{
			Canvas.SetPos(5.00,Y);
			Canvas.DrawText("Ping:" @ string(PlayerPawn(Owner).PlayerReplicationInfo.Ping) @ "  P/L:" @ string(PlayerPawn(Owner).PlayerReplicationInfo.PacketLoss) $ "%");
			Y=Y + FontHeight + 14;
		}
		if ( Class'ClientOptions'.Default.bExtHudShowTime )
		{
			Canvas.SetPos(5.00,Y);
			if ( LeagueASGameReplicationInfo.StartTimeRemaining == -1 )
			{
				if ( Class'ClientOptions'.Default.bExtHudShowElapsedTime )
				{
					SelectedTime=LeagueASGameReplicationInfo.ElapsedTime;
					SelectedTimeString="Elapsed Time";
				} else {
					SelectedTime=LeagueASGameReplicationInfo.RemainingTime;
					SelectedTimeString="Remaining Time";
				}
			} else {
				SelectedTime=LeagueASGameReplicationInfo.StartTimeRemaining;
				SelectedTimeString="Time until Game Start";
			}
			minsleft=SelectedTime / 60;
			secsleft=SelectedTime - SelectedTime / 60 * 60;
			if ( secsleft < 10 )
			{
				Canvas.DrawText(SelectedTimeString $ ":" @ string(minsleft) $ ":0" $ string(secsleft));
			} else {
				Canvas.DrawText(SelectedTimeString $ ":" @ string(minsleft) $ ":" $ string(secsleft));
			}
			Y=Y + FontHeight + 14;
		}
		if ( Class'ClientOptions'.Default.bExtHudShowTeamInfo )
		{
			Canvas.SetPos(5.00,Y);
			Canvas.DrawText("Team:");
			Y=Y + FontHeight + 11;
			i=0;
JL2641:
			if ( i < 32 )
			{
				if ( LeagueASGameReplicationInfo.PRIArray[i] != None )
				{
					epri=LeagueAS_ExtPlayerReplicationInfo(LeagueASGameReplicationInfo.PRIArray[i]);
					if ( epri != None )
					{
						if ( (epri.PlayerName != PlayerOwner.PlayerReplicationInfo.PlayerName) && (epri.Team == PlayerOwner.PlayerReplicationInfo.Team) )
						{
							Index=-1;
							cRI=LeagueAS_ExtPlayerReplicationInfo(PlayerOwner.PlayerReplicationInfo).cRI;
							if ( cRI != None )
							{
								j=0;
JL2728:
								if ( j < 7 )
								{
									if ( cRI.PlayerName[j] == epri.PlayerName )
									{
										Index=j;
									}
									j++;
									goto JL2728;
								}
							}
							if ( Index > -1 )
							{
								Canvas.DrawColor=GoldColor;
								Canvas.SetPos(5.00,Y);
								Canvas.DrawText(cRI.PlayerName[Index]);
								Y=Y + FontHeight + 2;
								Canvas.SetPos(5.00,Y);
								if ( DistanceFrom(Pawn(epri.Owner),Pawn(Owner)) < 1000 )
								{
									Canvas.DrawColor=GreenColor;
								} else {
									Canvas.DrawColor=WhiteColor;
								}
								Canvas.DrawText("Location:" @ cRI.Location[Index]);
								Y=Y + FontHeight + 2;
								Canvas.SetPos(5.00,Y);
								if ( cRI.Health[Index] < 25 )
								{
									Canvas.DrawColor=RedColor;
								} else {
									Canvas.DrawColor=WhiteColor;
								}
								Canvas.DrawText("Health:" @ string(cRI.Health[Index]));
								Y=Y + FontHeight + 2;
								Canvas.SetPos(5.00,Y);
								Canvas.DrawColor=WhiteColor;
								Canvas.DrawText("Armour:" @ string(epri.Armour));
								Y=Y + FontHeight + 2;
								Canvas.DrawColor=WhiteColor;
								Canvas.SetPos(5.00,Y);
								Canvas.DrawText("Weapon:" @ cRI.WeaponName[Index] @ "(" $ string(epri.AmmoAmount) $ ")");
								Y=Y + FontHeight + 6;
							}
						}
					}
				}
				i++;
				goto JL2641;
			}
		}
		if ( Class'ClientOptions'.Default.bExtHudShowObjInfo )
		{
			Canvas.DrawColor=GoldColor;
			Canvas.StrLen("Objective Listing:",StartRight,FontHeight);
			Canvas.SetPos(Canvas.SizeX - StartRight - 5,StartTop);
			Canvas.DrawText("Objective Listing:");
			Y=StartTop + FontHeight + 11;
			i=0;
JL2B08:
			if ( i < 20 )
			{
				if ( LeagueASGameReplicationInfo.FortName[i] != "" )
				{
					Canvas.DrawColor=GoldColor;
					Canvas.StrLen(LeagueASGameReplicationInfo.FortName[i],StartRight,FontHeight);
					Canvas.SetPos(Canvas.SizeX - StartRight - 5,Y);
					Canvas.DrawText(LeagueASGameReplicationInfo.FortName[i]);
					Y=Y + FontHeight + 2;
					if ( LeagueASGameReplicationInfo.FortCompleted[i] == "Not Complete!" )
					{
						Canvas.DrawColor=RedColor;
					} else {
						Canvas.DrawColor=GreenColor;
					}
					Canvas.StrLen(LeagueASGameReplicationInfo.FortCompleted[i],StartRight,FontHeight);
					Canvas.SetPos(Canvas.SizeX - StartRight - 5,Y);
					Canvas.DrawText(LeagueASGameReplicationInfo.FortCompleted[i]);
					Y=Y + FontHeight + 6;
				}
				i++;
				goto JL2B08;
			}
		}
	}
}

simulated exec function ToggleExtendedHUD ()
{
	Class'ClientOptions'.Default.bExtHudEnabled= !Class'ClientOptions'.Default.bExtHudEnabled;
	Class'ClientOptions'.StaticSaveConfig();
	LeagueAS_ExtPlayerReplicationInfo(PlayerOwner.PlayerReplicationInfo).LoadOptionsFromFile();
}

function string RS (Actor A)
{
	local string S;

	S=string(A);
	return Mid(S,InStr(S,"."),15);
}

simulated function DrawStatus (Canvas Canvas)
{
	local float StatScale;
	local float ChestAmount;
	local float ThighAmount;
	local float H1;
	local float H2;
	local float X;
	local float Y;
	local float DamageTime;
	local int ArmorAmount;
	local int CurAbs;
	local int i;
	local Inventory Inv;
	local Inventory BestArmor;
	local bool bChestArmor;
	local bool bShieldbelt;
	local bool bThighArmor;
	local bool bJumpBoots;
	local bool bHasDoll;
	local Bot BotOwner;
	local TournamentPlayer TPOwner;
	local Texture Doll;
	local Texture DollBelt;

	ArmorAmount=0;
	CurAbs=0;
	i=0;
	BestArmor=None;
	if ( (PawnOwner == PlayerOwner) && PlayerOwner.PlayerReplicationInfo.bIsSpectator )
	{
		return;
	}
	if ( PawnOwner != PlayerOwner )
	{
		if ( (PawnOwner.PlayerReplicationInfo != None) && PawnOwner.PlayerReplicationInfo.IsA('LeagueAS_ExtPlayerReplicationInfo') )
		{
			ArmorAmount=LeagueAS_ExtPlayerReplicationInfo(PawnOwner.PlayerReplicationInfo).Armour;
		} else {
			ArmorAmount=0;
		}
	} else {
		Inv=PawnOwner.Inventory;
JL00CF:
		if ( Inv != None )
		{
			if ( Inv.bIsAnArmor )
			{
				if ( Inv.IsA('UT_ShieldBelt') )
				{
					bShieldbelt=True;
				} else {
					if ( Inv.IsA('ThighPads') )
					{
						ThighAmount += Inv.Charge;
						bThighArmor=True;
					} else {
						bChestArmor=True;
						ChestAmount += Inv.Charge;
					}
				}
				ArmorAmount += Inv.Charge;
			} else {
				if ( Inv.IsA('UT_Jumpboots') )
				{
					bJumpBoots=True;
				} else {
					i++;
					if ( i > 100 )
					{
						goto JL01C2;
					}
				}
			}
			Inv=Inv.Inventory;
			goto JL00CF;
		}
	}
JL01C2:
	if (  !bHideStatus )
	{
		TPOwner=TournamentPlayer(PawnOwner);
		if ( Canvas.ClipX < 400 )
		{
			bHasDoll=False;
		} else {
			if ( TPOwner != None )
			{
				Doll=TPOwner.StatusDoll;
				DollBelt=TPOwner.StatusBelt;
				bHasDoll=True;
			} else {
				BotOwner=Bot(PawnOwner);
				if ( BotOwner != None )
				{
					Doll=BotOwner.StatusDoll;
					DollBelt=BotOwner.StatusBelt;
					bHasDoll=True;
				}
			}
		}
		if ( bHasDoll )
		{
			Canvas.Style=3;
			StatScale=Scale * StatusScale;
			X=Canvas.ClipX - 128 * StatScale;
			Canvas.SetPos(X,0.00);
			if ( PawnOwner.DamageScaling > 2.00 )
			{
				Canvas.DrawColor=PurpleColor;
			} else {
				Canvas.DrawColor=HUDColor;
			}
			Canvas.DrawTile(Doll,128.00 * StatScale,256.00 * StatScale,0.00,0.00,128.00,256.00);
			Canvas.DrawColor=HUDColor;
			if ( bShieldbelt )
			{
				Canvas.DrawColor=BaseColor;
				Canvas.DrawColor.B=0;
				Canvas.SetPos(X,0.00);
				Canvas.DrawIcon(DollBelt,StatScale);
			}
			if ( bChestArmor )
			{
				ChestAmount=FMin(0.01 * ChestAmount,1.00);
				Canvas.DrawColor=HUDColor * ChestAmount;
				Canvas.SetPos(X,0.00);
				Canvas.DrawTile(Doll,128.00 * StatScale,64.00 * StatScale,128.00,0.00,128.00,64.00);
			}
			if ( bThighArmor )
			{
				ThighAmount=FMin(0.02 * ThighAmount,1.00);
				Canvas.DrawColor=HUDColor * ThighAmount;
				Canvas.SetPos(X,64.00 * StatScale);
				Canvas.DrawTile(Doll,128.00 * StatScale,64.00 * StatScale,128.00,64.00,128.00,64.00);
			}
			if ( bJumpBoots )
			{
				Canvas.DrawColor=HUDColor;
				Canvas.SetPos(X,128.00 * StatScale);
				Canvas.DrawTile(Doll,128.00 * StatScale,64.00 * StatScale,128.00,128.00,128.00,64.00);
			}
			Canvas.Style=Style;
			if ( (PawnOwner == PlayerOwner) && Level.bHighDetailMode &&  !Level.bDropDetail )
			{
				i=0;
JL05E5:
				if ( i < 4 )
				{
					DamageTime=Level.TimeSeconds - HitTime[i];
					if ( DamageTime < 1 )
					{
						Canvas.SetPos(X + HitPos[i].X * StatScale,HitPos[i].Y * StatScale);
						if ( (HUDColor.G > 100) || (HUDColor.B > 100) )
						{
							Canvas.DrawColor=RedColor;
						} else {
							Canvas.DrawColor=(WhiteColor - HUDColor) * FMin(1.00,2.00 * DamageTime);
						}
						Canvas.DrawColor.R=255 * FMin(1.00,2.00 * DamageTime);
						Canvas.DrawTile(Texture'HudElements1',StatScale * hitdamage[i] * 25,StatScale * hitdamage[i] * 64,0.00,64.00,25.00,64.00);
					}
					i++;
					goto JL05E5;
				}
			}
		}
	}
	Canvas.DrawColor=HUDColor;
	if ( bHideStatus && bHideAllWeapons )
	{
		X=0.50 * Canvas.ClipX;
		Y=Canvas.ClipY - 64 * Scale;
	} else {
		X=Canvas.ClipX - 128 * StatScale - 140 * Scale;
		Y=64.00 * Scale;
	}
	Canvas.SetPos(X,Y);
	if ( PawnOwner.Health < 50 )
	{
		H1=1.50 * TutIconBlink;
		H2=1.00 - H1;
		Canvas.DrawColor=WhiteColor * H2 + (HUDColor - WhiteColor) * H1;
	} else {
		Canvas.DrawColor=HUDColor;
	}
	Canvas.DrawTile(Texture'HudElements1',128.00 * Scale,64.00 * Scale,128.00,128.00,128.00,64.00);
	if ( PawnOwner.Health < 50 )
	{
		H1=1.50 * TutIconBlink;
		H2=1.00 - H1;
		Canvas.DrawColor=Canvas.DrawColor * H2 + (WhiteColor - Canvas.DrawColor) * H1;
	} else {
		if ( PawnOwner.Style == 3 )
		{
			H1=1.50 * TutIconBlink;
			H2=1.00 - H1;
			Canvas.DrawColor=Canvas.DrawColor * H2 + (GoldColor - Canvas.DrawColor) * H1;
		} else {
			Canvas.DrawColor=WhiteColor;
		}
	}
	DrawBigNum(Canvas,Max(0,PawnOwner.Health),X + 4 * Scale,Y + 16 * Scale,1.00);
	Canvas.DrawColor=HUDColor;
	if ( bHideStatus && bHideAllWeapons )
	{
		X=0.50 * Canvas.ClipX - 128 * Scale;
		Y=Canvas.ClipY - 64 * Scale;
	} else {
		X=Canvas.ClipX - 128 * StatScale - 140 * Scale;
		Y=0.00;
	}
	Canvas.SetPos(X,Y);
	Canvas.DrawTile(Texture'HudElements1',128.00 * Scale,64.00 * Scale,0.00,192.00,128.00,64.00);
	if ( bHideStatus && bShieldbelt )
	{
		Canvas.DrawColor=GoldColor;
	} else {
		Canvas.DrawColor=WhiteColor;
	}
	DrawBigNum(Canvas,Min(150,ArmorAmount),X + 4 * Scale,Y + 16 * Scale,1.00);
}

simulated function Message (PlayerReplicationInfo PRI, coerce string Msg, name MsgType)
{
	local int i;
	local int pos;
	local NewMsg MessageObj;
	local string tmp;
	local Object pemote;

	if ( Msg == "" )
	{
		return;
	}
	switch (MsgType)
	{
		case 'Say':
		MessageObj=Spawn(Class'NewSayMessagePlus');
		MessageObj.PRI=PRI;
		MessageObj.Msg=Msg;
		break;
		case 'TeamSay':
		MessageObj=Spawn(Class'NewTeamSayMessagePlus');
		MessageObj.PRI=PRI;
		MessageObj.Msg=Msg;
		break;
		case 'CriticalEvent':
		LocalizedMessage(Class'CriticalStringPlus',0,None,None,None,Msg);
		return;
		case 'Pickup':
		PickupTime=Level.TimeSeconds;
		default:
		MessageObj=Spawn(Class'NewStringMessagePlus');
		MessageObj.PRI=PRI;
		MessageObj.Msg=Msg;
		break;
	}
	MessageObj.bNewMessage=True;
	MessageObj.EndOfLife=Level.TimeSeconds + MessageObj.duration;
	if ( (Newmsgqueue[127] == None) || Newmsgqueue[127].bDeleteMe )
	{
		i=126;
JL0178:
		if ( i >= 0 )
		{
			if ( (Newmsgqueue[i] != None) &&  !Newmsgqueue[i].bDeleteMe )
			{
				Newmsgqueue[i + 1]=MessageObj;
				return;
			}
			i--;
			goto JL0178;
		}
	} else {
		if ( (Newmsgqueue[0] != None) &&  !Newmsgqueue[0].bDeleteMe )
		{
			Newmsgqueue[0].Destroy();
		}
		i=0;
JL020D:
		if ( i < 127 )
		{
			Newmsgqueue[i]=Newmsgqueue[i + 1];
			i++;
			goto JL020D;
		}
		Newmsgqueue[127]=MessageObj;
		return;
	}
	Newmsgqueue[0]=MessageObj;
}

simulated function LocalizedMessage (Class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional string CriticalString)
{
	local int i;
	local NewMsg MessageObj;

	if ( ClassIsChildOf(Message,Class'PickupMessagePlus') )
	{
		PickupTime=Level.TimeSeconds;
	}
	if (  !Message.Default.bIsSpecial )
	{
		if ( Message == Class'ItemMessagePlus' )
		{
			Message=Class'NewStringMessagePlus';
			MessageObj=NewMsg(Spawn(Message));
			MessageObj.PRI=PlayerPawn(Owner).PlayerReplicationInfo;
			MessageObj.Msg=Class<Pickup>(OptionalObject).Default.ExpireMessage;
		} else {
			if ( ClassIsChildOf(Message,Class'NewMsg') )
			{
				MessageObj=NewMsg(Spawn(Message));
				MessageObj.PRI=RelatedPRI_1;
				MessageObj.PRI2=RelatedPRI_2;
				MessageObj.swit=Switch;
				MessageObj.OptionalObject=OptionalObject;
			}
		}
		if ( ClassIsChildOf(Message,Class'NewSayMessagePlus') || ClassIsChildOf(Message,Class'NewTeamSayMessagePlus') )
		{
			FaceTexture=RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
			{
				FaceTime=Level.TimeSeconds + 3;
			}
		}
		if ( (Newmsgqueue[127] == None) || Newmsgqueue[127].bDeleteMe )
		{
			i=126;
JL01A6:
			if ( i >= 0 )
			{
				if ( (Newmsgqueue[i] != None) &&  !Newmsgqueue[i].bDeleteMe )
				{
					Newmsgqueue[i + 1]=MessageObj;
					return;
				}
				i--;
				goto JL01A6;
			}
		} else {
			if ( (Newmsgqueue[0] != None) &&  !Newmsgqueue[0].bDeleteMe )
			{
				Newmsgqueue[0].Destroy();
			}
			i=0;
JL023B:
			if ( i < 127 )
			{
				Newmsgqueue[i]=Newmsgqueue[i + 1];
				i++;
				goto JL023B;
			}
			Newmsgqueue[127]=MessageObj;
			return;
		}
		Newmsgqueue[0]=MessageObj;
		MessageObj.EndOfLife=Level.TimeSeconds + MessageObj.duration;
		return;
	} else {
		if ( CriticalString == "" )
		{
			CriticalString=Message.GetString(Switch,RelatedPRI_1,RelatedPRI_2,OptionalObject);
		}
		if ( Message.Default.bIsUnique )
		{
			i=0;
JL0308:
			if ( i < 10 )
			{
				if ( LocalMessages[i].Message != None )
				{
					if ( (Message != Class'CriticalStringPlus') ||  !Default.bCriticalMessageFix )
					{
						if ( (LocalMessages[i].Message == Message) || (LocalMessages[i].Message.GetOffset(LocalMessages[i].Switch,24.00,640.00) == Message.GetOffset(Switch,24.00,640.00)) )
						{
							LocalMessages[i].Message=Message;
							LocalMessages[i].Switch=Switch;
							LocalMessages[i].RelatedPRI=RelatedPRI_1;
							LocalMessages[i].OptionalObject=OptionalObject;
							LocalMessages[i].Lifetime=Message.Default.Lifetime;
							LocalMessages[i].EndOfLife=Message.Default.Lifetime + Level.TimeSeconds;
							LocalMessages[i].StringMessage=CriticalString;
							LocalMessages[i].DrawColor=Message.GetColor(Switch,RelatedPRI_1,RelatedPRI_2);
							LocalMessages[i].XL=0.00;
							return;
						}
					} else {
						if ( LocalMessages[i].StringMessage == CriticalString )
						{
							LocalMessages[i].Message=Message;
							LocalMessages[i].Switch=Switch;
							LocalMessages[i].RelatedPRI=RelatedPRI_1;
							LocalMessages[i].OptionalObject=OptionalObject;
							LocalMessages[i].Lifetime=Message.Default.Lifetime;
							LocalMessages[i].EndOfLife=Message.Default.Lifetime + Level.TimeSeconds;
							LocalMessages[i].StringMessage=CriticalString;
							LocalMessages[i].DrawColor=Message.GetColor(Switch,RelatedPRI_1,RelatedPRI_2);
							LocalMessages[i].XL=0.00;
							return;
						}
					}
				}
				i++;
				goto JL0308;
			}
		}
		i=0;
JL05F1:
		if ( i < 10 )
		{
			if ( LocalMessages[i].Message == None )
			{
				LocalMessages[i].Message=Message;
				LocalMessages[i].Switch=Switch;
				LocalMessages[i].RelatedPRI=RelatedPRI_1;
				LocalMessages[i].OptionalObject=OptionalObject;
				LocalMessages[i].EndOfLife=Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage=CriticalString;
				LocalMessages[i].DrawColor=Message.GetColor(Switch,RelatedPRI_1,RelatedPRI_2);
				LocalMessages[i].Lifetime=Message.Default.Lifetime;
				LocalMessages[i].XL=0.00;
				return;
			}
			i++;
			goto JL05F1;
		}
		i=0;
JL0729:
		if ( i < 9 )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i + 1]);
			i++;
			goto JL0729;
		}
		LocalMessages[9].Message=Message;
		LocalMessages[9].Switch=Switch;
		LocalMessages[9].RelatedPRI=RelatedPRI_1;
		LocalMessages[9].OptionalObject=OptionalObject;
		LocalMessages[9].EndOfLife=Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage=CriticalString;
		LocalMessages[9].DrawColor=Message.GetColor(Switch,RelatedPRI_1,RelatedPRI_2);
		LocalMessages[9].Lifetime=Message.Default.Lifetime;
		LocalMessages[9].XL=0.00;
		return;
	}
}

simulated function Timer ()
{
	local int i;
	local int j;
	local Actor A;
	local FortStandard F;

	foreach AllActors(Class'FortStandard',F)
	{
		if ( (string(F.Mesh.Name) ~= "Flag1M") && (F.AnimSequence == 'Fighter') )
		{
			F.AnimSequence='Wave';
		}
	}
	if (  !buntweakdone )
	{
		foreach AllActors(Class'Actor',A)
		{
			Class'LeagueAS_UnTweak'.untweak(A,False);
		}
		buntweakdone=True;
	}
	if (  !buntweakclassesdone )
	{
		Class'LeagueAS_UnTweak'.untweakclasses();
		buntweakclassesdone=True;
	}
	if (  !bDrawMessageArea )
	{
		if ( MessageFadeCount > 0 )
		{
			MessageFadeCount--;
		}
	}
	i=0;
JL00E5:
	if ( i < 128 )
	{
		if ( (Newmsgqueue[i] != None) && (Level.TimeSeconds >= Newmsgqueue[i].EndOfLife) )
		{
			Newmsgqueue[i].Destroy();
			Newmsgqueue[i]=None;
		}
		i++;
		goto JL00E5;
	}
	i=0;
JL015B:
	if ( i < 9 )
	{
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
		{
			ClearMessage(LocalMessages[i]);
		}
		i++;
		goto JL015B;
	}
	i=0;
JL01C4:
	if ( i < 9 )
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i + 1]);
			ClearMessage(LocalMessages[i + 1]);
		}
		i++;
		goto JL01C4;
	}
	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None) || (PawnOwner.PlayerReplicationInfo == None) )
	{
		return;
	}
	UpdateRankAndSpread();
}

simulated function DrawCrossHair (Canvas Canvas, int X, int Y)
{
	local float XScale;
	local float PickDiff;
	local float XLength;
	local float cx;
	local float cy;
	local Texture t;
	local int curweap;
	local int Ch;

	if ( bAdvancedCrosshairs )
	{
		if ( PlayerOwner != None )
		{
			if ( PlayerOwner.Weapon != None )
			{
				curweap=PlayerOwner.Weapon.InventoryGroup;
			}
		}
		Ch=CrossHairGroup[curweap];
	} else {
		Ch=Crosshair;
	}
	if ( Ch >= CrosshairCount )
	{
		return;
	}
	if (  !bCHairResIndependent )
	{
		if ( Canvas.ClipX < 512 )
		{
			XScale=0.50 * Canvas.ClipX / 1280;
		} else {
			XScale=FMax(1.00,0.10 + Canvas.ClipX / 640.00);
		}
	} else {
		XScale=Canvas.ClipX / 1024;
	}
	PickDiff=Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.40 )
	{
		if ( PickDiff < 0.20 )
		{
			XScale *= 1 + 5 * PickDiff;
		} else {
			XScale *= 3 - 5 * PickDiff;
		}
	}
	XLength=XScale * 64.00 * CHairScale;
	Canvas.bNoSmooth=False;
	if ( PlayerOwner.Handedness == -1 )
	{
		Canvas.SetPos(0.50 * (Canvas.ClipX - XLength),0.50 * (Canvas.ClipY - XLength));
	} else {
		if ( PlayerOwner.Handedness == 1 )
		{
			Canvas.SetPos(0.50 * (Canvas.ClipX - XLength),0.50 * (Canvas.ClipY - XLength));
		} else {
			Canvas.SetPos(0.50 * (Canvas.ClipX - XLength),0.50 * (Canvas.ClipY - XLength));
		}
	}
	Canvas.Style=3;
	Canvas.DrawColor=15 * CrosshairColor;
	if ( (CrossHairTextures[Ch] == None) && (OpaqueCrossHairTextures[Ch] == None) )
	{
		LoadCrosshair(Ch);
	}
	cx=Canvas.CurX;
	cy=Canvas.CurY;
	t=CrossHairTextures[Ch];
	Canvas.Style=3;
	if ( t != None )
	{
		Canvas.DrawTile(t,XLength,XLength,0.00,0.00,64.00,64.00);
	}
	t=OpaqueCrossHairTextures[Ch];
	Canvas.SetPos(cx,cy);
	Canvas.Style=2;
	if ( t != None )
	{
		Canvas.DrawTile(t,XLength,XLength,0.00,0.00,64.00,64.00);
	}
	Canvas.SetPos(cx,cy);
	Canvas.Style=3;
	Canvas.bNoSmooth=True;
	Canvas.Style=Style;
}

simulated function ChangeCrosshair (int D)
{
	local int curweap;

	if ( bAdvancedCrosshairs )
	{
		if ( PlayerOwner != None )
		{
			if ( PlayerOwner.Weapon != None )
			{
				curweap=PlayerOwner.Weapon.InventoryGroup;
			}
		}
		CrossHairGroup[curweap]=CrossHairGroup[curweap] + D;
		if ( CrossHairGroup[curweap] >= CrosshairCount )
		{
			CrossHairGroup[curweap]=0;
		} else {
			if ( CrossHairGroup[curweap] < 0 )
			{
				CrossHairGroup[curweap]=CrosshairCount - 1;
			}
		}
	} else {
		Crosshair += D;
		if ( Crosshair >= CrosshairCount )
		{
			Crosshair=0;
		}
		if ( Crosshair < 0 )
		{
			Crosshair=CrosshairCount;
		}
	}
}

simulated function Texture LoadCrosshair (int C)
{
	if ( (CrossHairs[C] != "") && (CrossHairTextures[C] == None) )
	{
		CrossHairTextures[C]=Texture(DynamicLoadObject(CrossHairs[C],Class'Texture'));
	}
	if ( (OpaqueCrossHairs[C] != "") && (OpaqueCrossHairTextures[C] == None) )
	{
		OpaqueCrossHairTextures[C]=Texture(DynamicLoadObject(OpaqueCrossHairs[C],Class'Texture'));
	}
	return CrossHairTextures[C];
}

function bool DrawSpeechArea (Canvas Canvas, float XL, float YL)
{
	local float YPos;
	local float Yadj;
	local float WackNumber;
	local int paneltype;
	local int secondypos;

}

simulated function DrawTypingPrompt (Canvas Canvas, Console Console)
{
	local string TypingPrompt;
	local float XL;
	local float YL;
	local float YPos;
	local float XOffset;
	local float MyOldClipX;
	local float OldClipY;
	local float OldOrgX;
	local float OldOrgY;

	MyOldClipX=Canvas.ClipX;
	OldClipY=Canvas.ClipY;
	OldOrgX=Canvas.OrgX;
	OldOrgY=Canvas.OrgY;
	Canvas.DrawColor=GreenColor;
	TypingPrompt="(>" @ Console.TypedStr $ "_";
	Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("TEST",XL,YL);
	YPos=Min(128,Default.DefaultExpandChatboxMidgame);
	if ( PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces ||  !bDrawFaceArea )
	{
		XOffset=0.00;
	} else {
		XOffset=FMax(0.00,FaceAreaOffset + 15 * Scale + YPos - 1);
	}
	Canvas.SetOrigin(XOffset,currentchatboxsize + 4);
	Canvas.SetClip(760.00 * Scale,Canvas.ClipY);
	Canvas.SetPos(0.00,0.00);
	Canvas.DrawText(TypingPrompt,False);
	Canvas.SetOrigin(OldOrgX,OldOrgY);
	Canvas.SetClip(MyOldClipX,OldClipY);
}

simulated function Tick (float DeltaTime)
{
	if ( (Owner != None) && (PlayerPawn(Owner) != None) && (PlayerPawn(Owner).Player != None) )
	{
		if ( PlayerPawn(Owner).Player.bShowWindowsMouse )
		{
			buntweakclassesdone=False;
		}
	}
	if ( Abs(currentchatboxsize - targetchatboxsize) > 512 )
	{
		currentchatboxsize=targetchatboxsize;
	}
	if ( currentchatboxsize < targetchatboxsize )
	{
		currentchatboxsize=targetchatboxsize;
	}
	if ( currentchatboxsize > targetchatboxsize )
	{
		if ( bChatboxFastExpand )
		{
			currentchatboxsize=targetchatboxsize;
		} else {
			if ( DeltaTime < 0.01 )
			{
				currentchatboxsize--;
			} else {
				currentchatboxsize -= Max(Min(DeltaTime / 0.01,3),50);
			}
			if ( currentchatboxsize < targetchatboxsize )
			{
				currentchatboxsize=targetchatboxsize;
			}
		}
	}
	Super.Tick(DeltaTime);
}

function int modifycolor (int pcol, string opt, string varname, bool Advertise)
{
	local int ix;
	local emoticon ecolor;

	ix=int(opt);
	if ( (ix > 255) || (ix < 1) )
	{
		if ( Advertise == True )
		{
			PawnOwner.ClientMessage("Color number has to be between 1 and 255.");
			PawnOwner.ClientMessage("Type 'HUDtoggle colorlist' for a list of valid colors (by default numbers from 235 to 255)");
			if ( (varname != "ALL MessageColor") && (varname != "ALL DefaultNameColor") && (varname != "ALL RedNameColor") && (varname != "ALL BlueNameColor") )
			{
				PawnOwner.ClientMessage("Current value: " @ string(pcol));
			} else {
				PawnOwner.ClientMessage("Say: " @ string(pcol));
			}
		} else {
			PawnOwner.ClientMessage(varname @ ":" @ string(pcol));
		}
		return pcol;
	}
	ecolor=Class'Emotelist'.gete(ix);
	if ( ecolor != None )
	{
		if ( ecolor.bColor )
		{
			if ( Advertise == True )
			{
				PawnOwner.ClientMessage(varname @ "set to: " @ string(ix) @ "... color value R=" $ string(ecolor.col.R) @ "G=" $ string(ecolor.col.G) @ "B=" $ string(ecolor.col.B));
			}
			return ix;
		} else {
			if ( Advertise == True )
			{
				PawnOwner.ClientMessage("Specified number was not a valid color.");
			}
		}
	} else {
		if ( Advertise == True )
		{
			PawnOwner.ClientMessage("No entry for specified number.");
		}
	}
	if ( Advertise == True )
	{
		PawnOwner.ClientMessage("Type 'HUDtoggle colorlist' for a list of valid colors (by default numbers from 235 to 255)");
		if ( (varname != "ALL MessageColor") && (varname != "ALL DefaultNameColor") && (varname != "ALL RedNameColor") && (varname != "ALL BlueNameColor") )
		{
			PawnOwner.ClientMessage("Current value: " @ string(pcol));
		} else {
			PawnOwner.ClientMessage("Say: " @ string(pcol));
		}
	} else {
		PawnOwner.ClientMessage(varname @ ":" @ string(pcol));
	}
	return pcol;
}

exec function SShot ()
{
	local float B;
	local CSHPCheatRI aCRI;

	if ( (Level.TimeSeconds < 5) || (Level.NetMode == 0) || Owner.IsInState('PlayerWaiting') || Owner.IsInState('GameEnded') || Owner.IsA('LASCHSpectator') )
	{
		sscount=0;
	} else {
		if ( sstime + 5 > Level.TimeSeconds )
		{
			sscount++;
			if ( sscount > 2 )
			{
				foreach AllActors(Class'CSHPCheatRI',aCRI)
				{
					aCRI.xxSShotRep(sscount);
				}
			}
		} else {
			sscount=1;
		}
	}
	B=float(Owner.ConsoleCommand("get ini:Engine.Engine.ViewportManager Brightness"));
	Owner.ConsoleCommand("set ini:Engine.Engine.ViewportManager Brightness 1");
	Owner.ConsoleCommand("flush");
	Owner.ConsoleCommand("shot");
	Owner.ConsoleCommand("set ini:Engine.Engine.ViewportManager Brightness " $ string(B));
	Owner.ConsoleCommand("flush");
	sstime=Level.TimeSeconds;
}

simulated function bool TraceIdentify (Canvas Canvas)
{
	local Actor Other;
	local Vector HitLocation;
	local Vector HitNormal;
	local Vector StartTrace;
	local Vector EndTrace;
	local bool bDontDraw;
	local bool ParentTI;
	local CSHPCheatRI aCRI;

	StartTrace=PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace=StartTrace + PawnOwner.ViewRotation * 1000.00;
	Other=Trace(HitLocation,HitNormal,EndTrace,StartTrace,True);
	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer &&  !Other.bHidden )
		{
			IdentifyTarget=Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime=3.00;
		}
	} else {
		if ( (Other != None) && SpecialIdentify(Canvas,Other) )
		{
			bDontDraw=True;
		}
	}
	if (  !bDontDraw )
	{
		if ( (IdentifyFadeTime == 0.00) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		{
			bDontDraw=True;
		}
	}
	if ( FRand() < 0.05 )
	{
		ParentTI=Super.TraceIdentify(Canvas);
		if ( bDontDraw == ParentTI )
		{
			foreach AllActors(Class'CSHPCheatRI',aCRI)
			{
				aCRI.xxDoClientMsg(1,29,"CheckClient");
			}
		}
	}
	return  !bDontDraw;
}

simulated function DrawTwoColorID (Canvas Canvas, string TitleString, string ValueString, int YStart)
{
	local float XL;
	local float YL;
	local float XOffset;
	local float X1;

	Canvas.Style=Style;
	Canvas.StrLen(TitleString $ ": ",XL,YL);
	X1=XL;
	Canvas.StrLen(ValueString,XL,YL);
	XOffset=Canvas.ClipX / 2 - (X1 + XL) / 2;
	Canvas.SetPos(XOffset,YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset,YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor=WhiteColor;
}

simulated function bool DrawIdentifyInfo (Canvas Canvas)
{
	local CSHPCheatRI aCRI;
	local Font oldfont;

	Canvas.Font=MyFonts.GetACompletelyUnreadableFont(Canvas.ClipX);
	if (  !Super.DrawIdentifyInfo(Canvas) )
	{
		Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
		return False;
	}
	if ( (Pawn(IdentifyTarget.Owner) != None) && (PawnOwner.PlayerReplicationInfo.Team != IdentifyTarget.Team) && (Canvas.Font == MyFonts.GetSmallFont(Canvas.ClipX)) && (MyFonts.GetBigFont(Canvas.ClipX) != MyFonts.GetSmallFont(Canvas.ClipX)) )
	{
		foreach AllActors(Class'CSHPCheatRI',aCRI)
		{
			aCRI.xxDoClientMsg(1,30,"CheckClient");
		}
	}
	Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
	return True;
}

exec function GetWeapon (Class<Weapon> nwc)
{
	if ( nwc == Class'minigun2' )
	{
		PlayerPawn(Owner).GetWeapon(Class'Minigun2TIW');
		PlayerPawn(Owner).GetWeapon(Class'minigun2');
	} else {
		if ( nwc == Class'PulseGun' )
		{
			PlayerPawn(Owner).GetWeapon(Class'pulsegunTIW');
			PlayerPawn(Owner).GetWeapon(Class'PulseGun');
		} else {
			PlayerPawn(Owner).GetWeapon(nwc);
		}
	}
}

exec function HUDtoggle (string Command)
{
	local int SpacePos;
	local int i;
	local int clientresx;
	local int clientresy;
	local string comm1;
	local string comm2;
	local string comm3;
	local string FSstringvar;

	SpacePos=InStr(Command," ");
	if ( SpacePos != -1 )
	{
		comm1=Left(Command,SpacePos);
		Command=Mid(Command,SpacePos + 1);
		SpacePos=InStr(Command," ");
		if ( SpacePos != -1 )
		{
			comm2=Left(Command,SpacePos);
			comm3=Mid(Command,SpacePos + 1);
		} else {
			comm2=Command;
		}
	} else {
		comm1=Command;
	}
	switch (comm1)
	{
		case "colorlist":
		i=1;
JL00C4:
		if ( i < 512 )
		{
			if ( Class'Emotelist'.gete(i).bColor && (Class'Emotelist'.gete(i).Code != "") )
			{
				PawnOwner.ClientMessage("Color #" $ string(i) @ " code:" @ Class'Emotelist'.gete(i).Code @ " .... colorvalue R=" $ string(Class'Emotelist'.gete(i).col.R) @ "G=" $ string(Class'Emotelist'.gete(i).col.G) @ "B=" $ string(Class'Emotelist'.gete(i).col.B));
			}
			i++;
			goto JL00C4;
		}
		return;
		case "emotelist":
		i=1;
JL0216:
		if ( i < 512 )
		{
			if (  !Class'Emotelist'.gete(i).bColor && (Class'Emotelist'.gete(i).Code != "") )
			{
				PawnOwner.ClientMessage("Emote #" $ string(i) @ " code:" @ Class'Emotelist'.gete(i).Code);
			}
			i++;
			goto JL0216;
		}
		return;
		case "0":
		LoadPresetA();
		Class'Emotelist'.Default.binit=False;
		Class'Emotelist'.initemotes();
		Class'Emotelist'.StaticSaveConfig();
		PawnOwner.ClientMessage("PRESET 0 : Default settings restored.");
		return;
		case "1":
		if (  !LookForAnemote() )
		{
			PawnOwner.ClientMessage("Anemote1.utx not found, failed to load icons.");
			PawnOwner.ClientMessage("Download it at: www.utassault.net/leagueas");
		}
		LoadPresetB();
		Class'Emotelist'.Default.binit=False;
		Class'Emotelist'.initemotes();
		Class'Emotelist'.StaticSaveConfig();
		PawnOwner.ClientMessage("PRESET 1 : Enabled Icons & New Death Msgs");
		return;
		case "2":
		if (  !LookForAnemote() )
		{
			PawnOwner.ClientMessage("Anemote1.utx not found, failed to load icons.");
			PawnOwner.ClientMessage("Download it at: www.utassault.net/leagueas");
		}
		clientresx=UTConsole(PlayerOwner.Player.Console).Root.WinWidth;
		clientresy=UTConsole(PlayerOwner.Player.Console).Root.WinHeight;
		LoadPresetC(clientresx,clientresy);
		Class'Emotelist'.Default.binit=False;
		Class'Emotelist'.initemotes();
		Class'Emotelist'.StaticSaveConfig();
		PawnOwner.ClientMessage("PRESET 2 : Enabled Icons, New Death Msgs, Fonts & Expand Chatbox");
		PawnOwner.ClientMessage("Font size & ChatBox optimized for (" @ string(clientresx) @ "x" @ string(clientresy) @ ")");
		return;
		default:
	}
	PawnOwner.ClientMessage("Use this command to pick one of the preset configurations.");
	PawnOwner.ClientMessage("hudtoggle 0 => Restores Original Values");
	PawnOwner.ClientMessage("hudtoggle 1 => Icons + Death Msgs");
	PawnOwner.ClientMessage("hudtoggle 2 => Icons + Death Msgs + Fonts + Expand ChatBox");
	PawnOwner.ClientMessage("Also available: ColorList, EmoteList, DodgeFix, DodgeWarning");
}

static function LoadPresetA ()
{
	local string fixedsay;
	local string fixedteamsay;
	local string fixedstring;

	fixedsay="Ladderfonts.UTLadder16";
	fixedteamsay="Ladderfonts.UTLadder16";
	fixedstring="Ladderfonts.UTLadder16";
	Class'NewTeamSayMessagePlus'.Default.bUseTeamColors=False;
	Class'NewTeamSayMessagePlus'.Default.DefColorIndex=243;
	Class'NewTeamSayMessagePlus'.Default.DefNameColorIndex=237;
	Class'NewTeamSayMessagePlus'.Default.RedColorIndex=236;
	Class'NewTeamSayMessagePlus'.Default.BlueColorIndex=238;
	Class'NewTeamSayMessagePlus'.Default.LocationColorIndex=245;
	Class'NewTeamSayMessagePlus'.Default.MessageFont=fixedteamsay;
	Class'NewTeamSayMessagePlus'.Default.duration=4.00;
	Class'NewTeamSayMessagePlus'.StaticSaveConfig();
	Class'NewSayMessagePlus'.Default.bUseTeamColors=False;
	Class'NewSayMessagePlus'.Default.DefColorIndex=243;
	Class'NewSayMessagePlus'.Default.DefNameColorIndex=237;
	Class'NewSayMessagePlus'.Default.RedColorIndex=236;
	Class'NewSayMessagePlus'.Default.BlueColorIndex=238;
	Class'NewSayMessagePlus'.Default.MessageFont=fixedsay;
	Class'NewSayMessagePlus'.Default.duration=4.00;
	Class'NewSayMessagePlus'.StaticSaveConfig();
	Class'NewStringMessagePlus'.Default.DefColorIndex=235;
	Class'NewStringMessagePlus'.Default.MessageFont=fixedstring;
	Class'NewStringMessagePlus'.Default.duration=4.00;
	Class'NewStringMessagePlus'.StaticSaveConfig();
	Class'NewMsgDeathMessagePlus'.Default.bUseTeamColors=False;
	Class'NewMsgDeathMessagePlus'.Default.DefColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.DefNameColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.RedColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.BlueColorIndex=238;
	Class'NewMsgDeathMessagePlus'.Default.MessageFont=fixedsay;
	Class'NewMsgDeathMessagePlus'.Default.duration=4.00;
	Class'NewMsgDeathMessagePlus'.Default.bAlternativeDeathMsgs=False;
	Class'NewMsgDeathMessagePlus'.StaticSaveConfig();
	Class'LeagueAS_Tweaks'.Default.KillMsgType=0;
	Class'LeagueAS_Tweaks'.Default.EnforcerMsg="%k riddled %o full of holes with the %w.";
	Class'LeagueAS_Tweaks'.Default.BioMsg="%o drank a glass of %k's dripping green load.";
	Class'LeagueAS_Tweaks'.Default.ShockMsg="%k inflicted mortal damage upon %o with the %w.";
	Class'LeagueAS_Tweaks'.Default.PulseMsg="%o ate %k's burning plasma death.";
	Class'LeagueAS_Tweaks'.Default.MiniMsg="%k's %w turned %o into a leaky piece of meat.";
	Class'LeagueAS_Tweaks'.Default.RipperMsg="%k ripped a chunk of meat out of %o with the %w.";
	Class'LeagueAS_Tweaks'.Default.FlakMsg="%o was ripped to shreds by %k's %w.";
	Class'LeagueAS_Tweaks'.Default.RLMsg="%o was smacked down by %k's %w.";
	Class'LeagueAS_Tweaks'.Default.SniperMsg="%k put a bullet through %o's head.";
	Class'LeagueAS_Tweaks'.Default.HammerMsg="%o got smeared by %k's piston.";
	Class'LeagueAS_Tweaks'.Default.WarHeadMsg="%o was vaporized by %k's %w!!";
	Class'LeagueAS_Tweaks'.Default.InstaMsg="%k electrified %o with the %w.";
	Class'LeagueAS_Tweaks'.Default.TeleMsg="%k telefragged %o!";
	Class'LeagueAS_Tweaks'.StaticSaveConfig();
	Default.MaxSizeEmotes=256;
	Default.bNoOffensiveEmotes=True;
	Default.bOnlyTeamSayEmotes=False;
	Default.bNoFormatting=True;
	Default.bRemoveColors=False;
	Default.bRemoveEmotes=False;
	Default.bRemoveUndisplayedEmotes=False;
	Default.loadgroups[0]=1;
	Default.loadgroups[1]=0;
	Default.loadgroups[2]=0;
	Default.loadgroups[3]=0;
	Default.loadgroups[4]=0;
	Default.loadgroups[5]=0;
	Default.bDontAnimateEmotes=False;
	Default.bSqueezeEmotesWhenChatFull=True;
	Default.bSqueezeBeforeExpand=False;
	Default.bChatboxFastExpand=True;
	Default.bNoCutLines=True;
	Default.DefaultExpandChatboxMidgame=64;
	Default.DefaultExpandChatboxEndgame=64;
	Default.MaxExpandChatboxMidgame=64;
	Default.MaxExpandChatboxEndgame=64;
	Default.bAutoAdjustDefaultChatboxSizeToResolution=True;
	Default.CHairScale=1.00;
	Default.bCHairResIndependent=False;
	Default.bAdvancedCrosshairs=False;
	Default.FontScheme=1;
	StaticSaveConfig();
}

static function LoadPresetB ()
{
	local string fixedsay;
	local string fixedteamsay;
	local string fixedstring;

	fixedsay="Ladderfonts.UTLadder16";
	fixedteamsay="Ladderfonts.UTLadder16";
	fixedstring="Ladderfonts.UTLadder16";
	Class'NewTeamSayMessagePlus'.Default.bUseTeamColors=False;
	Class'NewTeamSayMessagePlus'.Default.DefColorIndex=243;
	Class'NewTeamSayMessagePlus'.Default.DefNameColorIndex=237;
	Class'NewTeamSayMessagePlus'.Default.RedColorIndex=236;
	Class'NewTeamSayMessagePlus'.Default.BlueColorIndex=238;
	Class'NewTeamSayMessagePlus'.Default.LocationColorIndex=245;
	Class'NewTeamSayMessagePlus'.Default.MessageFont=fixedteamsay;
	Class'NewTeamSayMessagePlus'.Default.duration=5.00;
	Class'NewTeamSayMessagePlus'.StaticSaveConfig();
	Class'NewSayMessagePlus'.Default.bUseTeamColors=False;
	Class'NewSayMessagePlus'.Default.DefColorIndex=243;
	Class'NewSayMessagePlus'.Default.DefNameColorIndex=237;
	Class'NewSayMessagePlus'.Default.RedColorIndex=236;
	Class'NewSayMessagePlus'.Default.BlueColorIndex=238;
	Class'NewSayMessagePlus'.Default.MessageFont=fixedsay;
	Class'NewSayMessagePlus'.Default.duration=5.00;
	Class'NewSayMessagePlus'.StaticSaveConfig();
	Class'NewStringMessagePlus'.Default.DefColorIndex=235;
	Class'NewStringMessagePlus'.Default.MessageFont=fixedstring;
	Class'NewStringMessagePlus'.Default.duration=5.00;
	Class'NewStringMessagePlus'.StaticSaveConfig();
	Class'NewMsgDeathMessagePlus'.Default.bUseTeamColors=True;
	Class'NewMsgDeathMessagePlus'.Default.DefColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.DefNameColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.RedColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.BlueColorIndex=238;
	Class'NewMsgDeathMessagePlus'.Default.MessageFont=fixedsay;
	Class'NewMsgDeathMessagePlus'.Default.duration=5.00;
	Class'NewMsgDeathMessagePlus'.Default.bAlternativeDeathMsgs=True;
	Class'NewMsgDeathMessagePlus'.Default.SniperEmote=0;
	Class'NewMsgDeathMessagePlus'.Default.HammerEmote=1;
	Class'NewMsgDeathMessagePlus'.Default.EnforcerEmote=2;
	Class'NewMsgDeathMessagePlus'.Default.BioEmote=3;
	Class'NewMsgDeathMessagePlus'.Default.ShockEmote=4;
	Class'NewMsgDeathMessagePlus'.Default.PulseEmote=5;
	Class'NewMsgDeathMessagePlus'.Default.RipperEmote=6;
	Class'NewMsgDeathMessagePlus'.Default.MiniEmote=7;
	Class'NewMsgDeathMessagePlus'.Default.FlakEmote=8;
	Class'NewMsgDeathMessagePlus'.Default.RocketEmote=9;
	Class'NewMsgDeathMessagePlus'.Default.WarheadEmote=10;
	Class'NewMsgDeathMessagePlus'.Default.ChainsawEmote=11;
	Class'NewMsgDeathMessagePlus'.Default.TelefragEmote=12;
	Class'NewMsgDeathMessagePlus'.Default.InstaEmote=13;
	Class'NewMsgDeathMessagePlus'.StaticSaveConfig();
	Class'LeagueAS_Tweaks'.Default.KillMsgType=5;
	Class'LeagueAS_Tweaks'.StaticSaveConfig();
	Default.MaxSizeEmotes=256;
	Default.bNoOffensiveEmotes=False;
	Default.bOnlyTeamSayEmotes=False;
	Default.bNoFormatting=False;
	Default.bRemoveColors=False;
	Default.bRemoveEmotes=False;
	Default.bRemoveUndisplayedEmotes=False;
	Default.loadgroups[0]=1;
	Default.loadgroups[1]=1;
	Default.loadgroups[2]=1;
	Default.loadgroups[3]=1;
	Default.loadgroups[4]=1;
	Default.loadgroups[5]=1;
	Default.bDontAnimateEmotes=False;
	Default.bSqueezeEmotesWhenChatFull=True;
	Default.bSqueezeBeforeExpand=True;
	Default.bChatboxFastExpand=True;
	Default.bNoCutLines=True;
	Default.DefaultExpandChatboxMidgame=64;
	Default.DefaultExpandChatboxEndgame=64;
	Default.MaxExpandChatboxMidgame=64;
	Default.MaxExpandChatboxEndgame=64;
	Default.bAutoAdjustDefaultChatboxSizeToResolution=True;
	Default.CHairScale=1.00;
	Default.bCHairResIndependent=False;
	Default.bAdvancedCrosshairs=False;
	Default.FontScheme=1;
	StaticSaveConfig();
}

static function LoadPresetC (int clientresx, int clientresy)
{
	local string fixedsay;
	local string fixedteamsay;
	local string fixedstring;

	if ( clientresx < 800 )
	{
		fixedsay="Ladderfonts.UTLadder10";
		fixedteamsay="Ladderfonts.UTLadder10";
		fixedstring="Ladderfonts.UTLadder10";
		Default.DefaultExpandChatboxMidgame=66;
		Default.MaxExpandChatboxMidgame=66;
	} else {
		if ( clientresx < 1024 )
		{
			fixedsay="Ladderfonts.UTLadder14";
			fixedteamsay="Ladderfonts.UTLadder14";
			fixedstring="Ladderfonts.UTLadder12";
			Default.DefaultExpandChatboxMidgame=64;
			Default.MaxExpandChatboxMidgame=80;
		} else {
			if ( clientresx < 1280 )
			{
				fixedsay="Ladderfonts.UTLadder16";
				fixedteamsay="Ladderfonts.UTLadder18";
				fixedstring="Ladderfonts.UTLadder14";
				Default.DefaultExpandChatboxMidgame=72;
				Default.MaxExpandChatboxMidgame=90;
			} else {
				if ( clientresx < 1600 )
				{
					fixedsay="Ladderfonts.UTLadder18";
					fixedteamsay="Ladderfonts.UTLadder20";
					fixedstring="Ladderfonts.UTLadder16";
					Default.DefaultExpandChatboxMidgame=84;
					Default.MaxExpandChatboxMidgame=105;
				} else {
					fixedsay="Ladderfonts.UTLadder20";
					fixedteamsay="Ladderfonts.UTLadder22";
					fixedstring="Ladderfonts.UTLadder18";
					Default.DefaultExpandChatboxMidgame=92;
					Default.MaxExpandChatboxMidgame=115;
				}
			}
		}
	}
	Class'NewTeamSayMessagePlus'.Default.bUseTeamColors=True;
	Class'NewTeamSayMessagePlus'.Default.DefColorIndex=240;
	Class'NewTeamSayMessagePlus'.Default.DefNameColorIndex=237;
	Class'NewTeamSayMessagePlus'.Default.RedColorIndex=236;
	Class'NewTeamSayMessagePlus'.Default.BlueColorIndex=238;
	Class'NewTeamSayMessagePlus'.Default.LocationColorIndex=252;
	Class'NewTeamSayMessagePlus'.Default.MessageFont=fixedteamsay;
	Class'NewTeamSayMessagePlus'.Default.duration=5.00;
	Class'NewTeamSayMessagePlus'.StaticSaveConfig();
	Class'NewSayMessagePlus'.Default.bUseTeamColors=True;
	Class'NewSayMessagePlus'.Default.DefColorIndex=243;
	Class'NewSayMessagePlus'.Default.DefNameColorIndex=237;
	Class'NewSayMessagePlus'.Default.RedColorIndex=236;
	Class'NewSayMessagePlus'.Default.BlueColorIndex=238;
	Class'NewSayMessagePlus'.Default.MessageFont=fixedsay;
	Class'NewSayMessagePlus'.Default.duration=5.00;
	Class'NewSayMessagePlus'.StaticSaveConfig();
	Class'NewStringMessagePlus'.Default.DefColorIndex=251;
	Class'NewStringMessagePlus'.Default.MessageFont=fixedstring;
	Class'NewStringMessagePlus'.Default.duration=5.00;
	Class'NewStringMessagePlus'.StaticSaveConfig();
	Class'NewMsgDeathMessagePlus'.Default.bUseTeamColors=True;
	Class'NewMsgDeathMessagePlus'.Default.DefColorIndex=251;
	Class'NewMsgDeathMessagePlus'.Default.DefNameColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.RedColorIndex=236;
	Class'NewMsgDeathMessagePlus'.Default.BlueColorIndex=238;
	Class'NewMsgDeathMessagePlus'.Default.MessageFont=fixedsay;
	Class'NewMsgDeathMessagePlus'.Default.duration=5.00;
	Class'NewMsgDeathMessagePlus'.Default.bAlternativeDeathMsgs=True;
	Class'NewMsgDeathMessagePlus'.Default.SniperEmote=75;
	Class'NewMsgDeathMessagePlus'.Default.HammerEmote=76;
	Class'NewMsgDeathMessagePlus'.Default.EnforcerEmote=77;
	Class'NewMsgDeathMessagePlus'.Default.BioEmote=78;
	Class'NewMsgDeathMessagePlus'.Default.ShockEmote=79;
	Class'NewMsgDeathMessagePlus'.Default.PulseEmote=80;
	Class'NewMsgDeathMessagePlus'.Default.RipperEmote=81;
	Class'NewMsgDeathMessagePlus'.Default.MiniEmote=82;
	Class'NewMsgDeathMessagePlus'.Default.FlakEmote=83;
	Class'NewMsgDeathMessagePlus'.Default.RocketEmote=84;
	Class'NewMsgDeathMessagePlus'.Default.WarheadEmote=10;
	Class'NewMsgDeathMessagePlus'.Default.ChainsawEmote=11;
	Class'NewMsgDeathMessagePlus'.Default.TelefragEmote=12;
	Class'NewMsgDeathMessagePlus'.Default.InstaEmote=13;
	Class'NewMsgDeathMessagePlus'.StaticSaveConfig();
	Class'LeagueAS_Tweaks'.Default.KillMsgType=4;
	Class'LeagueAS_Tweaks'.StaticSaveConfig();
	Default.MaxSizeEmotes=256;
	Default.bNoOffensiveEmotes=False;
	Default.bOnlyTeamSayEmotes=False;
	Default.bNoFormatting=False;
	Default.bRemoveColors=False;
	Default.bRemoveEmotes=False;
	Default.bRemoveUndisplayedEmotes=False;
	Default.loadgroups[0]=1;
	Default.loadgroups[1]=1;
	Default.loadgroups[2]=1;
	Default.loadgroups[3]=1;
	Default.loadgroups[4]=1;
	Default.loadgroups[5]=1;
	Default.bDontAnimateEmotes=False;
	Default.bSqueezeEmotesWhenChatFull=True;
	Default.bSqueezeBeforeExpand=False;
	Default.bChatboxFastExpand=True;
	Default.bNoCutLines=True;
	Default.DefaultExpandChatboxEndgame=128;
	Default.MaxExpandChatboxEndgame=128;
	Default.bAutoAdjustDefaultChatboxSizeToResolution=False;
	Default.CHairScale=1.00;
	Default.bCHairResIndependent=False;
	Default.bAdvancedCrosshairs=False;
	Default.FontScheme=0;
	StaticSaveConfig();
}

exec function ShowEmoticonMenu ()
{
	local UWindowRootWindow Root;

	if ( ClassIsChildOf(PlayerPawn(Owner).Class,Class'Spectator') )
	{
		return;
	}
	if (  !UTConsole(PlayerOwner.Player.Console).bCreatedRoot )
	{
		UTConsole(PlayerOwner.Player.Console).CreateRootWindow(None);
	}
	Root=WindowConsole(PlayerOwner.Player.Console).Root;
	if ( Root == None )
	{
		return;
	}
	if (  !bEmoticonMenuCreated )
	{
		EmotWindow=EmoteWindow(Root.CreateWindow(Class'EmoteWindow',0.00,0.00,200.00,200.00));
		assert (EmotWindow != None);
		EmotWindow.bLeaveOnscreen=True;
		EmotWindow.HideWindow();
		bEmoticonMenuCreated=True;
	}
	Root.SetMousePos(0.00,132.00 / 768 * Root.WinWidth);
	EmotWindow.SlideInWindow();
	if ( ChallengeHUD(PlayerPawn(Owner).myHUD) != None )
	{
		ChallengeHUD(PlayerPawn(Owner).myHUD).bHideCenterMessages=True;
	}
	UTConsole(PlayerOwner.Player.Console).bQuickKeyEnable=True;
	UTConsole(PlayerOwner.Player.Console).LaunchUWindow();
}

exec function ThrowWeapon ()
{
	local CSHPCheatRI cRI;
	local CSHPCheatRI CRI2;

	if ( Level.NetMode != 3 )
	{
		PlayerPawn(Owner).ThrowWeapon();
	} else {
		if (  !PlayerPawn(Owner).Weapon.IsA('dummyweapon') )
		{
			PlayerPawn(Owner).Weapon.AnimSequence='Select';
			PlayerPawn(Owner).Weapon.AnimFrame=0.00;
			PlayerPawn(Owner).Weapon.AnimRate=0.00;
			foreach AllActors(Class'CSHPCheatRI',cRI)
			{
				if ( cRI.Owner == Owner )
				{
					CRI2=cRI;
				}
			}
			if ( CRI2 != None )
			{
				CRI2.xxthrowweapon();
			} else {
				PlayerPawn(Owner).ThrowWeapon();
			}
		}
	}
}

function bool LookForAnemote ()
{
	local Texture testanemote;

	testanemote=Texture(DynamicLoadObject("anemote1.3WG2_enf",Class'Texture'));
	if ( testanemote == None )
	{
		return False;
	} else {
		return True;
	}
}

defaultproperties
{
    MaxSizeEmotes=256
    loadgroups(0)=1
    loadgroups(1)=1
    loadgroups(2)=1
    loadgroups(3)=1
    loadgroups(4)=1
    loadgroups(5)=1
    bSqueezeEmotesWhenChatFull=True
    bChatboxFastExpand=True
    bNoCutLines=True
    DefaultExpandChatboxMidgame=64
    DefaultExpandChatboxEndgame=64
    MaxExpandChatboxMidgame=64
    MaxExpandChatboxEndgame=64
    bCriticalMessageFix=True
    CriticalMessageLifetime=4
    bShowAuthInfo=True
    bFirstRun=True
    bAutoAdjustDefaultChatboxSizeToResolution=True
    CHairScale=1.00
    targetchatboxsize=64
    bAlwaysTick=True
}