//================================================================================
// LeagueAS_Mutator.
//================================================================================
class LeagueAS_Mutator extends DMMutator;

var LeagueAssault LeagueAssaultGame;

function Mutate (string MutateString, PlayerPawn Sender)
{
	local Pawn P;
	local PlayerPawn PP;

	if ( MutateString ~= "EavyAssaultPlus" )
	{
		LeagueAssaultGame.PEFChangeTeams(Sender);
	} else {
		Super.Mutate(MutateString,Sender);
	}
}

function MutatorTakeDamage (out int actualDamage, Pawn Victim, Pawn instigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	local LeagueAS_Inventory i;

	i=LeagueAS_Inventory(Victim.FindInventoryType(Class'LeagueAS_Inventory'));
	if ( i != None )
	{
		i.InventoryTakeDamage(actualDamage,Victim,instigatedBy,HitLocation,Momentum,DamageType);
	}
	if ( NextDamageMutator != None )
	{
		NextDamageMutator.MutatorTakeDamage(actualDamage,Victim,instigatedBy,HitLocation,Momentum,DamageType);
	}
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
	if ( (Killer == None) && (Killed != None) && (Killed.PlayerReplicationInfo != None) && (DamageType == 'None') )
	{
		Killed.PlayerReplicationInfo.Score=Killed.PlayerReplicationInfo.Score + 1;
	} else {
		if ( LeagueAssaultGame.bNoSuicidePenalties )
		{
			if ( (Killer == None) && (Killed != None) && (Killed.PlayerReplicationInfo != None) && (DamageType == 'Suicided') )
			{
				Killed.PlayerReplicationInfo.Score=Killed.PlayerReplicationInfo.Score + 1;
			}
		}
	}
	if ( NextMutator != None )
	{
		return NextMutator.PreventDeath(Killed,Killer,DamageType,HitLocation);
	}
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
	if ( SpawnClass == Class'CHSpectator' )
	{
		SpawnClass=Class'LeagueAS_Spectator';
	}
	if ( NextMutator != None )
	{
		NextMutator.ModifyLogin(SpawnClass,Portal,Options);
	}
}

event PreBeginPlay ()
{
	LeagueAssaultGame=LeagueAssault(Level.Game);
	Level.Game.RegisterDamageMutator(self);
	Level.Game.RegisterMessageMutator(self);
}

function bool MutatorTeamMessage (Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep)
{
	local LeagueAS_ExtPlayerReplicationInfo recEPRI;

	if ( InStr(Caps(S),"ADMINLOGIN") > -1 )
	{
		return False;
	}
	if ( (Sender != None) && (Receiver != None) )
	{
		if ( Sender.IsA('PlayerPawn') && Receiver.IsA('PlayerPawn') )
		{
			S=LeagueAssaultGame.ProcessAdvancedSay(S,PlayerPawn(Sender));
			if (  !Sender.IsA('Spectator') &&  !Receiver.IsA('Spectator') )
			{
				recEPRI=LeagueAS_ExtPlayerReplicationInfo(Receiver.PlayerReplicationInfo);
				if ( PlayerPawn(Sender).PlayerReplicationInfo.Team != PlayerPawn(Receiver).PlayerReplicationInfo.Team )
				{
					if (  !recEPRI.bMyMuteSay )
					{
						if ( NextMessageMutator != None )
						{
							if ( NextMessageMutator.MutatorTeamMessage(Sender,Receiver,PRI,S,Type,bBeep) )
							{
								Receiver.TeamMessage(PRI,S,Type,bBeep);
							}
						} else {
							Receiver.TeamMessage(PRI,S,Type,bBeep);
						}
					}
				} else {
					if (  !recEPRI.bMyMuteAll )
					{
						if ( NextMessageMutator != None )
						{
							if ( NextMessageMutator.MutatorTeamMessage(Sender,Receiver,PRI,S,Type,bBeep) )
							{
								Receiver.TeamMessage(PRI,S,Type,bBeep);
							}
						} else {
							Receiver.TeamMessage(PRI,S,Type,bBeep);
						}
					}
				}
			} else {
				if ( NextMessageMutator != None )
				{
					if ( NextMessageMutator.MutatorTeamMessage(Sender,Receiver,PRI,S,Type,bBeep) )
					{
						Receiver.TeamMessage(PRI,S,Type,bBeep);
					}
				} else {
					Receiver.TeamMessage(PRI,S,Type,bBeep);
				}
			}
			return False;
		} else {
			if ( NextMessageMutator != None )
			{
				return NextMessageMutator.MutatorTeamMessage(Sender,Receiver,PRI,S,Type,bBeep);
			} else {
				return True;
			}
		}
	}
}

function bool MutatorBroadcastMessage (Actor Sender, Pawn Receiver, out coerce string Msg, optional bool bBeep, optional out name Type)
{
	if ( InStr(Caps(Msg),"ADMINLOGIN") > -1 )
	{
		return False;
	}
	if ( NextMessageMutator != None )
	{
		return NextMessageMutator.MutatorBroadcastMessage(Sender,Receiver,Msg,bBeep,Type);
	} else {
		return True;
	}
}

function bool CheckReplacement (Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;

	bSuperRelevant=1;
	if ( MyGame.bMegaSpeed && Other.bIsPawn && Pawn(Other).bIsPlayer )
	{
		Pawn(Other).GroundSpeed *= 1.40;
		Pawn(Other).WaterSpeed *= 1.40;
		Pawn(Other).AirSpeed *= 1.40;
		Pawn(Other).AccelRate *= 1.40;
	}
	if ( Other.IsA('StationaryPawn') )
	{
		return True;
	}
	Inv=Inventory(Other);
	if ( Inv == None )
	{
		bSuperRelevant=0;
		if ( Other.IsA('TorchFlame') )
		{
			Other.NetUpdateFrequency=0.50;
		}
		return True;
	}
	if ( MyGame.bNoviceMode && MyGame.bRatedGame && (Level.NetMode == 0) )
	{
		Inv.RespawnTime *= 0.50 + 0.10 * MyGame.Difficulty;
	}
	if ( Other.IsA('Weapon') )
	{
		if ( Other.IsA('TournamentWeapon') )
		{
			return True;
		}
		if ( Other.IsA('Stinger') )
		{
			ReplaceWith(Other,"Botpack.PulseGun");
			return False;
		}
		if ( Other.IsA('Rifle') )
		{
			ReplaceWith(Other,"Botpack.SniperRifle");
			return False;
		}
		if ( Other.IsA('Razorjack') )
		{
			ReplaceWith(Other,"Botpack.Ripper");
			return False;
		}
		if ( Other.IsA('Minigun') )
		{
			ReplaceWith(Other,"Botpack.Minigun2");
			return False;
		}
		if ( Other.IsA('AutoMag') )
		{
			ReplaceWith(Other,"Botpack.Enforcer");
			return False;
		}
		if ( Other.IsA('Eightball') )
		{
			ReplaceWith(Other,"Botpack.UT_Eightball");
			return False;
		}
		if ( Other.IsA('FlakCannon') )
		{
			ReplaceWith(Other,"Botpack.UT_FlakCannon");
			return False;
		}
		if ( Other.IsA('ASMD') )
		{
			ReplaceWith(Other,"Botpack.ShockRifle");
			return False;
		}
		if ( Other.IsA('GESBioRifle') )
		{
			ReplaceWith(Other,"Botpack.UT_BioRifle");
			return False;
		}
		if ( Other.IsA('DispersionPistol') )
		{
			ReplaceWith(Other,"Botpack.ImpactHammer");
			return False;
		}
		bSuperRelevant=0;
		return True;
	}
	if ( Other.IsA('Ammo') )
	{
		if ( Other.IsA('TournamentAmmo') )
		{
			return True;
		}
		if ( Other.IsA('ASMDAmmo') )
		{
			ReplaceWith(Other,"Botpack.ShockCore");
			return False;
		}
		if ( Other.IsA('RocketCan') )
		{
			ReplaceWith(Other,"Botpack.RocketPack");
			return False;
		}
		if ( Other.IsA('StingerAmmo') )
		{
			ReplaceWith(Other,"Botpack.PAmmo");
			return False;
		}
		if ( Other.IsA('RazorAmmo') )
		{
			ReplaceWith(Other,"Botpack.BladeHopper");
			return False;
		}
		if ( Other.IsA('RifleRound') )
		{
			ReplaceWith(Other,"Botpack.RifleShell");
			return True;
		}
		if ( Other.IsA('RifleAmmo') )
		{
			ReplaceWith(Other,"Botpack.BulletBox");
			return False;
		}
		if ( Other.IsA('FlakBox') )
		{
			ReplaceWith(Other,"Botpack.FlakAmmo");
			return False;
		}
		if ( Other.IsA('Clip') )
		{
			ReplaceWith(Other,"Botpack.EClip");
			return False;
		}
		if ( Other.IsA('ShellBox') )
		{
			ReplaceWith(Other,"Botpack.MiniAmmo");
			return False;
		}
		if ( Other.IsA('Sludge') )
		{
			ReplaceWith(Other,"Botpack.BioAmmo");
			return False;
		}
		bSuperRelevant=0;
		return True;
	}
	if ( Other.IsA('Pickup') )
	{
		Pickup(Other).bAutoActivate=True;
		if ( Other.IsA('TournamentPickup') )
		{
			return True;
		}
	}
	if ( Other.IsA('TournamentHealth') )
	{
		return True;
	}
	if ( Other.IsA('JumpBoots') )
	{
		if ( MyGame.bJumpMatch )
		{
			return False;
		}
		ReplaceWith(Other,"Botpack.UT_JumpBoots");
		return False;
	}
	if ( Other.IsA('Amplifier') )
	{
		ReplaceWith(Other,"Botpack.UDamage");
		return False;
	}
	if ( Other.IsA('WeaponPowerUp') )
	{
		return False;
	}
	if ( Other.IsA('KevlarSuit') )
	{
		ReplaceWith(Other,"Botpack.ThighPads");
		return False;
	}
	if ( Other.IsA('SuperHealth') )
	{
		ReplaceWith(Other,"Botpack.HealthPack");
		return False;
	}
	if ( Other.IsA('Armor') )
	{
		ReplaceWith(Other,"Botpack.Armor2");
		return False;
	}
	if ( Other.IsA('Bandages') )
	{
		ReplaceWith(Other,"Botpack.HealthVial");
		return False;
	}
	if ( Other.IsA('Health') &&  !Other.IsA('HealthPack') &&  !Other.IsA('HealthVial') &&  !Other.IsA('MedBox') &&  !Other.IsA('NaliFruit') )
	{
		ReplaceWith(Other,"Botpack.MedBox");
		return False;
	}
	if ( Other.IsA('ShieldBelt') )
	{
		ReplaceWith(Other,"Botpack.UT_ShieldBelt");
		return False;
	}
	if ( Other.IsA('Invisibility') )
	{
		ReplaceWith(Other,"Botpack.UT_Invisibility");
		return False;
	}
	bSuperRelevant=0;
	return True;
}