//================================================================================
// LeagueAS_Scoreboard.
//================================================================================
class LeagueAS_Scoreboard extends AssaultScoreboard
	Config(User);

var Texture FlagIcon;
var config bool bEnableTournamentFlags;

function string PadOut (string InText)
{
	local string Text;

	Text=InText;
JL000B:
	if ( Len(Text) < 4 )
	{
		Text=" " $ Text;
		goto JL000B;
	}
	return Text;
}

function ShowScores (Canvas Canvas)
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount;
	local int i;
	local float LoopCountTeam[4];
	local float XL;
	local float YL;
	local float YB;
	local float XOffset;
	local float YOffset;
	local float XStart;
	local float Y;
	local float StartTop;
	local int PlayerCounts[4];
	local int LongLists[4];
	local int BottomSlot[4];
	local Font CanvasFont;
	local bool bCompressed;
	local bool Left;
	local float R;
	local int TeamPings[4];
	local int TeamPLs[4];
	local int FortCount;
	local int diff;

	OwnerInfo=Pawn(Owner).PlayerReplicationInfo;
	OwnerGame=LeagueAS_GameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( OwnerGame == None )
	{
		return;
	}
	Canvas.Style=1;
	CanvasFont=Canvas.Font;
	i=0;
JL0070:
	if ( i < 4 )
	{
		if ( (OwnerGame != None) && (OwnerGame.Teams[i] != None) )
		{
			TeamName[i]=OwnerGame.Teams[i].TeamName;
		}
		i++;
		goto JL0070;
	}
	DrawHeader(Canvas);
	i=0;
JL00E8:
	if ( i < 32 )
	{
		Ordered[i]=None;
		i++;
		goto JL00E8;
	}
	i=0;
JL0112:
	if ( i < 32 )
	{
		if ( PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None )
		{
			PRI=PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if (  !PRI.bIsSpectator || PRI.bWaitingPlayer || (PRI.Team != 255) )
			{
				Ordered[PlayerCount]=PRI;
				PlayerCount++;
				PlayerCounts[PRI.Team]++;
			}
		}
		i++;
		goto JL0112;
	}
	SortScores(PlayerCount);
	CanvasFont=Canvas.Font;
	Canvas.Font=MyFonts.GetMediumFont(Canvas.ClipX);
	Canvas.StrLen("TEXT",XL,YL);
	ScoreStart=Canvas.CurY + YL * 2;
	if ( Canvas.ClipX < 900 )
	{
		ScoreStart -= 20;
	}
	if ( ScoreStart + PlayerCount * YL + 2 > Canvas.ClipY )
	{
		bCompressed=True;
		Canvas.Font=Font'SmallFont';
		R=YL;
		Canvas.StrLen("TEXT",XL,YL);
		R=YL / R;
		Canvas.Font=CanvasFont;
	}
	i=0;
JL032D:
	if ( i < PlayerCount )
	{
		if ( Ordered[i].Team < 4 )
		{
			if ( Ordered[i].Team % 2 == 0 )
			{
				XOffset=Canvas.ClipX / 4 - Canvas.ClipX / 8;
			} else {
				XOffset=Canvas.ClipX / 4 * 3 - Canvas.ClipX / 8;
			}
			Canvas.StrLen("TEXT",XL,YL);
			Canvas.DrawColor=AltTeamColor[Ordered[i].Team];
			YOffset=ScoreStart + LoopCountTeam[Ordered[i].Team] * (YL - 6) + 2;
			if ( (Ordered[i].Team < 2) && (BottomSlot[Ordered[i].Team] == 0) && (PlayerCounts[Ordered[i].Team + 2] == 0) )
			{
				LongLists[Ordered[i].Team]=1;
				DrawNameAndPing(Canvas,Ordered[i],XOffset,YOffset,bCompressed);
				TeamPings[Ordered[i].Team] += Ordered[i].Ping;
				TeamPLs[Ordered[i].Team] += Ordered[i].PacketLoss;
			} else {
				if ( LoopCountTeam[Ordered[i].Team] < 8 )
				{
					DrawNameAndPing(Canvas,Ordered[i],XOffset,YOffset,bCompressed);
					TeamPings[Ordered[i].Team] += Ordered[i].Ping;
					TeamPLs[Ordered[i].Team] += Ordered[i].PacketLoss;
				}
			}
			if ( bCompressed )
			{
				LoopCountTeam[Ordered[i].Team] += 1;
			} else {
				LoopCountTeam[Ordered[i].Team] += 2;
			}
		}
		i++;
		goto JL032D;
	}
	i=0;
JL0673:
	if ( i < 4 )
	{
		Canvas.Font=MyFonts.GetMediumFont(Canvas.ClipX);
		if ( PlayerCounts[i] > 0 )
		{
			if ( i % 2 == 0 )
			{
				XOffset=Canvas.ClipX / 4 - Canvas.ClipX / 8;
			} else {
				XOffset=Canvas.ClipX / 4 * 3 - Canvas.ClipX / 8;
			}
			YOffset=ScoreStart - YL + 2;
			if ( i > 1 )
			{
				if ( PlayerCounts[i - 2] > 0 )
				{
					YOffset=ScoreStart + YL * 10;
				}
			}
			Canvas.DrawColor=TeamColor[i];
			Canvas.SetPos(XOffset,YOffset);
			Canvas.StrLen(TeamName[i],XL,YL);
			Canvas.DrawText(TeamName[i],False);
			Canvas.Font=Font'SmallFont';
			Canvas.DrawColor=WhiteColor;
			Canvas.StrLen("Ping:0000",XL,YB);
			Canvas.SetPos(XOffset + Canvas.ClipX / 4 - XL,YOffset);
			Canvas.DrawText("Ping:" $ PadOut(string(TeamPings[i] / PlayerCounts[i])),False);
			Canvas.SetPos(XOffset + Canvas.ClipX / 4 - XL,YOffset + 8);
			Canvas.DrawText("P/L:" $ PadOut(string(TeamPLs[i] / PlayerCounts[i])) $ "%",False);
		}
		i++;
		goto JL0673;
	}
	FortCount=0;
	i=0;
JL092A:
	if ( i < 20 )
	{
		if ( LeagueAS_GameReplicationInfo(OwnerGame).FortName[i] != "" )
		{
			FortCount++;
		}
		i++;
		goto JL092A;
	}
	if ( (Canvas.ClipX > 512) && (OwnerGame != None) )
	{
		if ( (Canvas.ClipX > 650) && (Canvas.ClipX < 900) )
		{
			StartTop=Canvas.ClipY / 5 * 3;
			if ( (PlayerCounts[0] > 6) || (PlayerCounts[1] > 6) )
			{
				StartTop=Canvas.ClipY / 5 * 3 + 20;
			}
			if ( (PlayerCounts[0] > 7) || (PlayerCounts[1] > 7) )
			{
				StartTop=Canvas.ClipY / 5 * 3 + 50;
			}
		} else {
			if ( (PlayerCounts[0] > 6) || (PlayerCounts[1] > 6) )
			{
				StartTop=Canvas.ClipY / 5 * 3 + 10;
			}
			if ( (PlayerCounts[0] > 7) || (PlayerCounts[1] > 7) )
			{
				StartTop=Canvas.ClipY / 5 * 3 + 20;
			} else {
				StartTop=Canvas.ClipY / 5 * 3;
			}
		}
		if ( FortCount <= 8 )
		{
			StartTop += 10;
		}
		Canvas.Font=MyFonts.GetMediumFont(Canvas.ClipX);
		Canvas.DrawColor=GoldColor;
		Canvas.StrLen("Objectives",XL,YL);
		Canvas.SetPos((Canvas.ClipX - XL) / 2,StartTop);
		Canvas.DrawText("Objectives");
		Y=StartTop + YL + 6;
		Left=True;
		Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
		if ( FortCount > 10 )
		{
			diff=2;
		}
		if ( FortCount > 12 )
		{
			diff=3;
		}
		i=0;
JL0C3F:
		if ( i < 20 )
		{
			if ( LeagueAS_GameReplicationInfo(OwnerGame).FortName[i] != "" )
			{
				Canvas.StrLen(LeagueAS_GameReplicationInfo(OwnerGame).FortName[i],XL,YL);
				if ( Left )
				{
					Canvas.SetPos((Canvas.ClipX / 2 - XL) / 2,Y);
				} else {
					Canvas.SetPos((Canvas.ClipX / 2 - XL) / 2 + Canvas.ClipX / 2,Y);
				}
				Canvas.DrawColor=GoldColor;
				Canvas.DrawText(LeagueAS_GameReplicationInfo(OwnerGame).FortName[i]);
				Y=Y + YL - diff;
				Canvas.StrLen(LeagueAS_GameReplicationInfo(OwnerGame).FortCompleted[i],XL,YL);
				if ( Left )
				{
					Canvas.SetPos((Canvas.ClipX / 2 - XL) / 2,Y);
				} else {
					Canvas.SetPos((Canvas.ClipX / 2 - XL) / 2 + Canvas.ClipX / 2,Y);
				}
				if ( LeagueAS_GameReplicationInfo(OwnerGame).FortCompleted[i] == "Not Complete!" )
				{
					Canvas.DrawColor=RedColor;
				} else {
					Canvas.DrawColor=GreenColor;
				}
				Canvas.DrawText(LeagueAS_GameReplicationInfo(OwnerGame).FortCompleted[i]);
				if ( Left )
				{
					Y=Y - YL + diff;
				} else {
					Y=Y + YL - diff + 1;
				}
				Left= !Left;
			}
			i++;
			goto JL0C3F;
		}
	}
	if (  !Level.bLowRes )
	{
		Canvas.Font=MyFonts.GetSmallFont(Canvas.ClipX);
		DrawTrailer(Canvas);
	}
	Canvas.Font=CanvasFont;
	Canvas.DrawColor=WhiteColor;
	AssaultHUD(OwnerHUD).DrawTimeAt(Canvas,0.50 * Canvas.ClipX - 80 * Canvas.ClipX / 1280,4.00);
}

function DrawNameAndPing (Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL;
	local float YL;
	local float YB;
	local BotReplicationInfo BRI;
	local string S;
	local string o;
	local string L;
	local Font CanvasFont;
	local bool bAdminPlayer;
	local bool bModeratorPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local int i;
	local LeagueAS_ExtPlayerReplicationInfo epri;
	local bool bSmall;

	PlayerOwner=PlayerPawn(Owner);
	epri=LeagueAS_ExtPlayerReplicationInfo(PRI);
	bAdminPlayer=PRI.bAdmin;
	if ( epri != None )
	{
		bModeratorPlayer=epri.bModerator;
	}
	if ( PRI == None )
	{
		return;
	}
	if ( PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName )
	{
		Canvas.DrawColor=GoldColor;
	}
	if ( bModeratorPlayer )
	{
		Canvas.DrawColor=GreenColor;
	}
	if ( bAdminPlayer )
	{
		Canvas.DrawColor=WhiteColor;
	}
	Canvas.SetPos(XOffset,YOffset);
	if ( (epri != None) && epri.bReadyToPlay )
	{
		if ( bEnableTournamentFlags )
		{
			Canvas.DrawColor=WhiteColor;
			Canvas.SetPos(XOffset - 11,YOffset - 1);
			Canvas.DrawIcon(FlagIcon,0.84);
			Canvas.DrawColor=TeamColor[PRI.Team];
			if ( PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName )
			{
				Canvas.DrawColor=GoldColor;
			}
			if ( bModeratorPlayer )
			{
				Canvas.DrawColor=GreenColor;
			}
			if ( bAdminPlayer )
			{
				Canvas.DrawColor=WhiteColor;
			}
			Canvas.SetPos(XOffset + 16,YOffset);
			Canvas.DrawText(PRI.PlayerName,False);
		} else {
			Canvas.DrawText("*" $ PRI.PlayerName,False);
		}
	} else {
		Canvas.DrawText(PRI.PlayerName,False);
	}
	Canvas.StrLen(PRI.PlayerName,XL,YB);
	if ( Canvas.ClipX > 512 )
	{
		CanvasFont=Canvas.Font;
		Canvas.Font=Font'SmallFont';
		Canvas.DrawColor=WhiteColor;
		if ( Level.NetMode != 0 )
		{
			if ( (epri != None) && (epri.bMuteSay || epri.bMuteAll) &&  !bCompressed && (Canvas.ClipX > 640) )
			{
				bSmall=True;
			}
			Canvas.StrLen(PingString $ ":     ",XL,YL);
			Canvas.SetPos(XOffset - XL - 6,YOffset);
			Canvas.DrawText(PingString $ ":" @ string(PRI.Ping),False);
			Canvas.StrLen(LossString $ ":    %",XL,YL);
			if (  !bSmall )
			{
				Canvas.SetPos(XOffset - XL - 6,YOffset + YL + 1);
			} else {
				Canvas.SetPos(XOffset - XL - 6,YOffset + YL + 1 - 1);
			}
			Canvas.DrawText(LossString $ ":" @ string(PRI.PacketLoss) $ "%",False);
			if (  !bCompressed && (Canvas.ClipX > 799) )
			{
				Canvas.StrLen("          ",XL,YL);
				if (  !bSmall )
				{
					Canvas.SetPos(XOffset - XL - 6,YOffset + (YL + 1) * 2);
				} else {
					Canvas.SetPos(XOffset - XL - 6,YOffset + (YL + 1) * 2 - 2);
				}
				Canvas.DrawColor=WhiteColor;
				if ( epri != None )
				{
					Canvas.DrawText("NS:" @ string(epri.NetSpeed),False);
				}
				Canvas.StrLen("          ",XL,YL);
				if (  !bSmall )
				{
					Canvas.SetPos(XOffset - XL - 6,YOffset + (YL + 1) * 3);
				} else {
					Canvas.SetPos(XOffset - XL - 6,YOffset + (YL + 1) * 3 - 3);
				}
				if ( (epri != None) && (epri.bMuteSay || epri.bMuteAll) )
				{
					Canvas.DrawColor=RedColor;
					if ( epri.bMuteAll )
					{
						Canvas.DrawText("MUTE ALL",False);
					} else {
						Canvas.DrawText("MUTE ENEMY",False);
					}
					Canvas.DrawColor=WhiteColor;
				}
				if ( (epri != None) && Class'LeagueAS_HUD'.Default.bShowAuthInfo && (epri.AuthString != "") )
				{
					Canvas.Font=Font'SmallFont';
					Canvas.DrawColor=TeamColor[PRI.Team];
					Canvas.SetPos(XOffset + 1,YOffset + YB - 2);
					Canvas.DrawText(epri.AuthString,False);
					Canvas.DrawColor=WhiteColor;
					Canvas.Font=CanvasFont;
				}
			}
		}
		Canvas.Font=CanvasFont;
	}
	if ( PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName )
	{
		Canvas.DrawColor=GoldColor;
	} else {
		Canvas.DrawColor=TeamColor[PRI.Team];
	}
	DrawScore(Canvas,PRI.Score,XOffset,YOffset);
}

defaultproperties
{
    FlagIcon=Texture'Botpack.Icons.GreenFlag'
    bEnableTournamentFlags=True
}