//================================================================================
// Menu_ClientWindow.
//================================================================================
class Menu_ClientWindow extends UWindowPageWindow;

var UWindowComboControl MuteMode;
var UWindowCheckbox ExtHudEnabled;
var UWindowCheckbox ExtHudShowGameInfo;
var UWindowCheckbox ExtHudShowConnInfo;
var UWindowCheckbox ExtHudShowTime;
var UWindowCheckbox ExtHudShowTeamInfo;
var UWindowCheckbox ExtHudShowObjInfo;
var UWindowCheckbox ExtHudLargeFont;
var UWindowCheckbox ShowAuthUserNames;
var UWindowCheckbox CriticalMessageFix;
var UWindowCheckbox RemoveProgressMsgs;
var UWindowCheckbox DisableDynamicMenuCheck;
var UWindowComboControl TimeMode;
var UWindowComboControl ShowFortStandards;
var string MuteModes[3];
var string TimeModes[2];
var string FortModes[4];

function Created ()
{
	local int ControlWidth;
	local int ControlLeft;
	local int ControlRight;
	local int CenterWidth;
	local int CenterPos;
	local int ControlOffset;

	Super.Created();
	ControlWidth=WinWidth / 2.50;
	ControlLeft=(WinWidth / 2 - ControlWidth) / 2;
	ControlRight=WinWidth / 2 + ControlLeft;
	CenterWidth=WinWidth / 4 * 3;
	CenterPos=(WinWidth - CenterWidth) / 2;
	ControlOffset=30;
	ExtHudEnabled=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ExtHudEnabled.SetText("Enable Extended HUD");
	ExtHudEnabled.SetFont(0);
	ExtHudEnabled.Align=0;
	ExtHudEnabled.bChecked=Class'ClientOptions'.Default.bExtHudEnabled;
	ControlOffset += 30;
	ExtHudShowGameInfo=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ExtHudShowGameInfo.SetText("Show Game Information");
	ExtHudShowGameInfo.SetFont(0);
	ExtHudShowGameInfo.Align=0;
	ExtHudShowGameInfo.bChecked=Class'ClientOptions'.Default.bExtHudShowGameInfo;
	ControlOffset += 20;
	ExtHudShowConnInfo=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ExtHudShowConnInfo.SetText("Show Connection Info");
	ExtHudShowConnInfo.SetFont(0);
	ExtHudShowConnInfo.Align=0;
	ExtHudShowConnInfo.bChecked=Class'ClientOptions'.Default.bExtHudShowConnInfo;
	ControlOffset += 20;
	ExtHudShowTime=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ExtHudShowTime.SetText("Show Time Information");
	ExtHudShowTime.SetFont(0);
	ExtHudShowTime.Align=0;
	ExtHudShowTime.bChecked=Class'ClientOptions'.Default.bExtHudShowTime;
	ControlOffset += 20;
	ExtHudShowTeamInfo=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ExtHudShowTeamInfo.SetText("Show Team Information");
	ExtHudShowTeamInfo.SetFont(0);
	ExtHudShowTeamInfo.Align=0;
	ExtHudShowTeamInfo.bChecked=Class'ClientOptions'.Default.bExtHudShowTeamInfo;
	ControlOffset += 20;
	ExtHudShowObjInfo=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ExtHudShowObjInfo.SetText("Show Objective Information");
	ExtHudShowObjInfo.SetFont(0);
	ExtHudShowObjInfo.Align=0;
	ExtHudShowObjInfo.bChecked=Class'ClientOptions'.Default.bExtHudShowObjInfo;
	ControlOffset += 20;
	ExtHudLargeFont=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ExtHudLargeFont.SetText("Use Large HUD Font");
	ExtHudLargeFont.SetFont(0);
	ExtHudLargeFont.Align=0;
	ExtHudLargeFont.bChecked=Class'ClientOptions'.Default.bExtHudLargeFont;
	ControlOffset += 40;
	CriticalMessageFix=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	CriticalMessageFix.SetText("Critical Message Fix");
	CriticalMessageFix.SetFont(0);
	CriticalMessageFix.Align=0;
	CriticalMessageFix.bChecked=Class'LeagueAS_HUD'.Default.bCriticalMessageFix;
	ControlOffset += 20;
	RemoveProgressMsgs=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	RemoveProgressMsgs.SetText("Remove HUD-Messages on Mapstart");
	RemoveProgressMsgs.SetFont(0);
	RemoveProgressMsgs.Align=0;
	RemoveProgressMsgs.bChecked=Class'LeagueAS_HUD'.Default.bRemoveProgMsgsOnMapsStart;
	ControlOffset += 20;
	DisableDynamicMenuCheck=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	DisableDynamicMenuCheck.SetText("Disable Dynamic Menu Check");
	DisableDynamicMenuCheck.SetFont(0);
	DisableDynamicMenuCheck.Align=0;
	DisableDynamicMenuCheck.bChecked=Class'CSHPConsole'.Default.bDisableLeagueASMenuBarItem;
	ControlOffset += 20;
	ShowAuthUserNames=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1.00));
	ShowAuthUserNames.SetText("Show Auth User in Scoreboard");
	ShowAuthUserNames.SetFont(0);
	ShowAuthUserNames.Align=0;
	ShowAuthUserNames.bChecked=Class'LeagueAS_HUD'.Default.bShowAuthInfo;
	ControlOffset += 40;
	ShowFortStandards=UWindowComboControl(CreateControl(Class'UWindowComboControl',CenterPos,ControlOffset,CenterWidth,1.00));
	ShowFortStandards.SetText("Show FortStandards");
	ShowFortStandards.SetFont(0);
	ShowFortStandards.SetEditable(False);
	ShowFortStandards.AddItem(FortModes[0]);
	ShowFortStandards.AddItem(FortModes[1]);
	ShowFortStandards.AddItem(FortModes[2]);
	ShowFortStandards.AddItem(FortModes[3]);
	ShowFortStandards.SetValue(FortModes[Class'LeagueAS_HUD'.Default.FortStandardMode]);
	ControlOffset += 40;
	TimeMode=UWindowComboControl(CreateControl(Class'UWindowComboControl',CenterPos,ControlOffset,CenterWidth,1.00));
	TimeMode.SetText("Time Display Format:");
	TimeMode.SetFont(0);
	TimeMode.SetEditable(False);
	TimeMode.AddItem(TimeModes[0]);
	TimeMode.AddItem(TimeModes[1]);
	if ( Class'ClientOptions'.Default.bExtHudShowElapsedTime )
	{
		TimeMode.SetValue(TimeModes[1]);
	} else {
		TimeMode.SetValue(TimeModes[0]);
	}
	ControlOffset += 25;
	MuteMode=UWindowComboControl(CreateControl(Class'UWindowComboControl',CenterPos,ControlOffset,CenterWidth,1.00));
	MuteMode.SetText("Mute Mode:");
	MuteMode.SetFont(0);
	MuteMode.SetEditable(False);
	MuteMode.AddItem(MuteModes[0]);
	MuteMode.AddItem(MuteModes[1]);
	MuteMode.AddItem(MuteModes[2]);
	if ( Class'ClientOptions'.Default.bMuteAll )
	{
		MuteMode.SetValue(MuteModes[2]);
	} else {
		if ( Class'ClientOptions'.Default.bMuteSay )
		{
			MuteMode.SetValue(MuteModes[1]);
		} else {
			MuteMode.SetValue(MuteModes[0]);
		}
	}
}

function Paint (Canvas C, float X, float Y)
{
	local int ControlLeft;
	local int ControlHeight;
	local Texture t;
	local Texture Tex;

	ControlLeft=436 / 2;
	ControlHeight=(WinHeight - 380 - 40) / 2 + 380;
	Super.Paint(C,X,Y);
	C.Style=1;
	C.DrawColor.R=255;
	C.DrawColor.G=255;
	C.DrawColor.B=255;
	t=GetLookAndFeelTexture();
	Tex=Texture'CSHPShield';
	DrawUpBevel(C,ControlLeft - 32 - 6,ControlHeight - 6,64.00 + 12,64.00 + 12,t);
	DrawStretchedTexture(C,ControlLeft - 32 - 3,ControlHeight - 3,64.00 + 6,64.00 + 6,Texture'BlackTexture');
	DrawStretchedTexture(C,ControlLeft - 32,ControlHeight,64.00,64.00,Tex);
	C.Style=1;
	C.DrawColor.R=0;
	C.DrawColor.G=0;
	C.DrawColor.B=0;
	C.Font=Font(DynamicLoadObject("UWindowFonts.TahomaB10",Class'Font'));
	ClipText(C,ControlLeft - 80,ControlHeight + 64 + 12 + 4,"Copyright  2004 utassault.net");
	ClipText(C,ControlLeft - 50,ControlHeight + 64 + 12 + 4 + 12,"All Rights Reserved.");
}

function Notify (UWindowDialogControl C, byte E)
{
	switch (E)
	{
		case 1:
		switch (C)
		{
			case MuteMode:
			switch (MuteMode.GetSelectedIndex())
			{
				case 0:
				Class'ClientOptions'.Default.bMuteSay=False;
				Class'ClientOptions'.Default.bMuteAll=False;
				Class'ClientOptions'.StaticSaveConfig();
				break;
				case 1:
				Class'ClientOptions'.Default.bMuteSay=True;
				Class'ClientOptions'.Default.bMuteAll=False;
				Class'ClientOptions'.StaticSaveConfig();
				break;
				case 2:
				Class'ClientOptions'.Default.bMuteSay=True;
				Class'ClientOptions'.Default.bMuteAll=True;
				Class'ClientOptions'.StaticSaveConfig();
				break;
				default:
				return;
			}
			break;
			case ExtHudEnabled:
			Class'ClientOptions'.Default.bExtHudEnabled=ExtHudEnabled.bChecked;
			Class'ClientOptions'.StaticSaveConfig();
			break;
			case ExtHudShowGameInfo:
			Class'ClientOptions'.Default.bExtHudShowGameInfo=ExtHudShowGameInfo.bChecked;
			Class'ClientOptions'.StaticSaveConfig();
			break;
			case ExtHudShowConnInfo:
			Class'ClientOptions'.Default.bExtHudShowConnInfo=ExtHudShowConnInfo.bChecked;
			Class'ClientOptions'.StaticSaveConfig();
			break;
			case ExtHudShowTime:
			Class'ClientOptions'.Default.bExtHudShowTime=ExtHudShowTime.bChecked;
			Class'ClientOptions'.StaticSaveConfig();
			break;
			case ExtHudShowTeamInfo:
			Class'ClientOptions'.Default.bExtHudShowTeamInfo=ExtHudShowTeamInfo.bChecked;
			Class'ClientOptions'.StaticSaveConfig();
			break;
			case ExtHudShowObjInfo:
			Class'ClientOptions'.Default.bExtHudShowObjInfo=ExtHudShowObjInfo.bChecked;
			Class'ClientOptions'.StaticSaveConfig();
			break;
			case ExtHudLargeFont:
			Class'ClientOptions'.Default.bExtHudLargeFont=ExtHudLargeFont.bChecked;
			Class'ClientOptions'.StaticSaveConfig();
			break;
			case ShowAuthUserNames:
			Class'LeagueAS_HUD'.Default.bShowAuthInfo=ShowAuthUserNames.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case CriticalMessageFix:
			Class'LeagueAS_HUD'.Default.bCriticalMessageFix=CriticalMessageFix.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case RemoveProgressMsgs:
			Class'LeagueAS_HUD'.Default.bRemoveProgMsgsOnMapsStart=RemoveProgressMsgs.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case DisableDynamicMenuCheck:
			Class'CSHPConsole'.Default.bDisableLeagueASMenuBarItem=DisableDynamicMenuCheck.bChecked;
			Class'CSHPConsole'.StaticSaveConfig();
			break;
			case TimeMode:
			switch (TimeMode.GetSelectedIndex())
			{
				case 0:
				Class'ClientOptions'.Default.bExtHudShowElapsedTime=False;
				Class'ClientOptions'.StaticSaveConfig();
				break;
				case 1:
				Class'ClientOptions'.Default.bExtHudShowElapsedTime=True;
				Class'ClientOptions'.StaticSaveConfig();
				break;
				default:
				return;
			}
			break;
			case ShowFortStandards:
			switch (ShowFortStandards.GetSelectedIndex())
			{
				case 0:
				case 1:
				case 2:
				case 3:
				Class'LeagueAS_HUD'.Default.FortStandardMode=ShowFortStandards.GetSelectedIndex();
				Class'LeagueAS_HUD'.StaticSaveConfig();
				break;
				default:
				return;
			}
			break;
			default:
			return;
		}
		if ( (GetPlayerOwner() != None) && (GetPlayerOwner().PlayerReplicationInfo != None) && (LeagueAS_ExtPlayerReplicationInfo(GetPlayerOwner().PlayerReplicationInfo) != None) )
		{
			LeagueAS_ExtPlayerReplicationInfo(GetPlayerOwner().PlayerReplicationInfo).LoadOptionsFromFile();
		}
		default:
	}
}

defaultproperties
{
    MuteModes(0)="No Mute"
    MuteModes(1)="Mute Enemy Messages"
    MuteModes(2)="Mute ALL Messages"
    TimeModes(0)="Show Remaining Time"
    TimeModes(1)="Show Elapsed Time"
    FortModes(0)="Off"
    FortModes(1)="On (Eavy mode)"
    FortModes(2)="Always On Top"
    FortModes(3)="Huge (UtoaP mode)"
}