//================================================================================
// Menu_CrosshairWindow.
//================================================================================
class Menu_CrosshairWindow extends UWindowPageWindow;

var UWindowEditControl CHScale;
var UWindowCheckbox CHResInd;
var UWindowCheckbox UseAdvCH;
var UMenuLabelControl Label;
var UWindowEditControl AdvCH[11];
var UWindowSmallButton AssignCH;

function Created ()
{
	local int ControlWidth;
	local int ControlWidthB;
	local int CenterPos;
	local int CenterPosB;
	local int ControlOffset;
	local int chID;

	Super.Created();
	ControlWidth=WinWidth / 4 * 3;
	ControlWidthB=WinWidth / 2;
	CenterPos=(WinWidth - ControlWidth) / 2;
	CenterPosB=(WinWidth - ControlWidthB) / 2;
	ControlOffset=16;
	CHResInd=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	CHResInd.SetText("Cross Hair Scale Independent of Resolution:");
	CHResInd.SetFont(0);
	CHResInd.Align=0;
	CHResInd.bChecked=Class'LeagueAS_HUD'.Default.bCHairResIndependent;
	ControlOffset += 20;
	CHScale=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPos,ControlOffset,ControlWidth,1.00));
	CHScale.SetText("Cross Hair Scale:");
	CHScale.SetFont(0);
	CHScale.Align=0;
	CHScale.EditBoxWidth=44.00;
	CHScale.SetMaxLength(9);
	CHScale.SetNumericOnly(True);
	CHScale.SetNumericFloat(True);
	CHScale.SetDelayedNotify(True);
	CHScale.SetValue(string(Class'LeagueAS_HUD'.Default.CHairScale));
	ControlOffset += 25;
	UseAdvCH=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	UseAdvCH.SetText("Assign Different CrossHairs to Weapons:");
	UseAdvCH.SetFont(0);
	UseAdvCH.Align=0;
	UseAdvCH.bChecked=Class'LeagueAS_HUD'.Default.bAdvancedCrosshairs;
	ControlOffset += 25;
	Label=UMenuLabelControl(CreateControl(Class'UMenuLabelControl',CenterPosB,ControlOffset,ControlWidth,1.00));
	Label.SetText("Weapon                                          CrossHair ID");
	Label.SetFont(1);
	ControlOffset += 18;
	chID=1;
JL0352:
	if ( chID < 11 )
	{
		AdvCH[chID]=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPosB,ControlOffset,ControlWidthB,1.00));
		AdvCH[chID].SetFont(0);
		AdvCH[chID].Align=0;
		AdvCH[chID].EditBoxWidth=16.00;
		AdvCH[chID].SetMaxLength(2);
		AdvCH[chID].SetNumericOnly(True);
		AdvCH[chID].SetDelayedNotify(True);
		AdvCH[chID].SetValue(string(Class'LeagueAS_HUD'.Default.CrossHairGroup[chID]));
		ControlOffset += 16;
		chID++;
		goto JL0352;
	}
	AdvCH[1].SetText("ImpachHammer, ChainSaw");
	AdvCH[2].SetText("Enforcer, Double Enforcer");
	AdvCH[3].SetText("Bio Rifle");
	AdvCH[4].SetText("Shock Rifle");
	AdvCH[5].SetText("Pulsegun");
	AdvCH[6].SetText("Ripper");
	AdvCH[7].SetText("Minigun");
	AdvCH[8].SetText("Flak Cannon");
	AdvCH[9].SetText("Rocket Launcher");
	AdvCH[10].SetText("Sniper, Redeemer");
	ControlOffset += 20;
	ShowAdvCH();
	AssignCH=UWindowSmallButton(CreateControl(Class'UWindowSmallButton',CenterPos,ControlOffset,ControlWidth,1.00));
	AssignCH.SetText("View CrossHairs ID / Add Opaque Layer");
}

function Paint (Canvas C, float X, float Y)
{
	local int ControlLeft;
	local int ControlHeight;
	local Texture t;
	local Texture Tex;

	ControlLeft=436 / 2;
	ControlHeight=(WinHeight - 380 - 40) / 2 + 380;
	Super.Paint(C,X,Y);
	C.Style=1;
	C.DrawColor.R=255;
	C.DrawColor.G=255;
	C.DrawColor.B=255;
	t=GetLookAndFeelTexture();
	Tex=Texture'CSHPShield';
	DrawUpBevel(C,ControlLeft - 32 - 6,ControlHeight - 6,64.00 + 12,64.00 + 12,t);
	DrawStretchedTexture(C,ControlLeft - 32 - 3,ControlHeight - 3,64.00 + 6,64.00 + 6,Texture'BlackTexture');
	DrawStretchedTexture(C,ControlLeft - 32,ControlHeight,64.00,64.00,Tex);
	C.Style=1;
	C.DrawColor.R=0;
	C.DrawColor.G=0;
	C.DrawColor.B=0;
	C.Font=Font(DynamicLoadObject("UWindowFonts.TahomaB10",Class'Font'));
	ClipText(C,ControlLeft - 80,ControlHeight + 64 + 12 + 4,"Copyright  2004 utassault.net");
	ClipText(C,ControlLeft - 50,ControlHeight + 64 + 12 + 4 + 12,"All Rights Reserved.");
}

function Notify (UWindowDialogControl C, byte E)
{
	local int i;
	local int q;

	i=1;
JL0007:
	if ( i < 11 )
	{
		switch (E)
		{
			case 1:
			switch (C)
			{
				case AdvCH[i]:
				Class'LeagueAS_HUD'.Default.CrossHairGroup[i]=int(AdvCH[i].GetValue());
				Class'LeagueAS_HUD'.StaticSaveConfig();
				break;
				default:
			}
			default:
		}
		i++;
		goto JL0007;
	}
	switch (E)
	{
		case 2:
		switch (C)
		{
			case AssignCH:
			q=Class'ChallengeHUD'.Default.CrosshairCount;
			if ( q > 20 )
			{
				q=20;
			}
			Root.CreateWindow(Class'Menu_CrossHairAssignFramedWindow',0.00,0.00,380.00,16.00 * q + 100);
			break;
			default:
		}
		case 1:
		switch (C)
		{
			case CHResInd:
			Class'LeagueAS_HUD'.Default.bCHairResIndependent=CHResInd.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case CHScale:
			Class'LeagueAS_HUD'.Default.CHairScale=float(CHScale.GetValue());
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case UseAdvCH:
			Class'LeagueAS_HUD'.Default.bAdvancedCrosshairs=UseAdvCH.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			ShowAdvCH();
			break;
			default:
		}
		default:
	}
}

function ShowAdvCH ()
{
	local int j;

	if ( UseAdvCH.bChecked )
	{
		Label.ShowWindow();
		j=1;
JL0028:
		if ( j < 11 )
		{
			AdvCH[j].ShowWindow();
			j++;
			goto JL0028;
		}
	} else {
		Label.HideWindow();
		j=1;
JL006C:
		if ( j < 11 )
		{
			AdvCH[j].HideWindow();
			j++;
			goto JL006C;
		}
	}
	CHResInd.HideWindow();
	CHResInd.ShowWindow();
}