//================================================================================
// Menu_FontColorListFramedWindow.
//================================================================================
class Menu_FontColorListFramedWindow extends UMenuFramedWindow;

var UWindowSmallCloseButton CloseButton;

function Created ()
{
	Super.Created();
	SetSizePos();
	CloseButton=UWindowSmallCloseButton(CreateWindow(Class'UWindowSmallCloseButton',WinWidth - 56,WinHeight - 24,48.00,16.00));
}

function SetSizePos ()
{
	local float W;
	local float H;

	GetDesiredDimensions(W,H);
	WinLeft=Root.WinWidth / 2 - WinWidth - 218;
	WinTop=Root.WinHeight / 2 - WinHeight / 2;
}

function GetDesiredDimensions (out float W, out float H)
{
	Super.GetDesiredDimensions(W,H);
	H += 30;
}

function ResolutionChanged (float W, float H)
{
	SetSizePos();
	Super.ResolutionChanged(W,H);
}

function Resized ()
{
	Super.Resized();
	ClientArea.SetSize(ClientArea.WinWidth,ClientArea.WinHeight - 24);
	CloseButton.WinLeft=ClientArea.WinLeft + ClientArea.WinWidth - 52;
	CloseButton.WinTop=ClientArea.WinTop + ClientArea.WinHeight + 4;
}

function Paint (Canvas C, float X, float Y)
{
	local Texture t;

	t=GetLookAndFeelTexture();
	DrawUpBevel(C,ClientArea.WinLeft,ClientArea.WinTop + ClientArea.WinHeight,ClientArea.WinWidth,24.00,t);
	Super.Paint(C,X,Y);
}

defaultproperties
{
    ClientClass=Class'Menu_FontColorListWindow'
    WindowTitle="Colors Code List"
}