//================================================================================
// Menu_FramedWindow.
//================================================================================
class Menu_FramedWindow extends UWindowFramedWindow;

var UWindowMessageBox InfoMessage;
var bool bShowMenuWarning;
var string DownloadLink;

function Created ()
{
	Super.Created();
	SetSizePos();
}

function AfterCreate ()
{
	local UWindowMessageBox WarningMessage;

	if ( Class'LeagueAS_HUD'.Default.FontScheme != 0 )
	{
		WarningMessage=MessageBox("WARNING","FontScheme must be set to MANUAL for changes on fonts sizes/types to make effect. Check Chatbox Tab.",2,3,3);
	}
	if ( Default.bShowMenuWarning )
	{
		InfoMessage=MessageBox("Download LeagueAS?","You do not have installed LeagueAS. Thus this Menu only appears cause you are connected to a LeagueAS Server. To get a permanent Options Menu download the actual Version of LeagueAS here: http://www.utassault.net/leagueas.   " $ "D" $ "o you want to download it now via webbrowser?",0,2,2);
	}
}

function MessageBoxDone (UWindowMessageBox W, MessageBoxResult Result)
{
	if ( (W == InfoMessage) && (Result == 1) )
	{
		GetPlayerOwner().ConsoleCommand("start " $ DownloadLink);
		GetPlayerOwner().ConsoleCommand("EndFullScreen");
	}
}

function SetSizePos ()
{
	local float W;
	local float H;

	GetDesiredDimensions(W,H);
	SetSize(436.00,Max(Root.WinHeight - 48,380));
	WinLeft=Root.WinWidth / 2 - WinWidth / 2;
	WinTop=Root.WinHeight / 2 - WinHeight / 2;
}

function ResolutionChanged (float W, float H)
{
	SetSizePos();
	Super.ResolutionChanged(W,H);
}

function Resized ()
{
	if ( WinWidth < 436 )
	{
		WinWidth=436.00;
	}
	if ( WinWidth > 726 )
	{
		WinWidth=726.00;
	}
	if ( WinHeight < 380 )
	{
		WinHeight=380.00;
	}
	if ( WinHeight > 720 )
	{
		WinHeight=720.00;
	}
	Super.Resized();
}

defaultproperties
{
    DownloadLink="http://www.utassault.net/leagueas"
    ClientClass=Class'Menu_TabWindow'
    WindowTitle="League Assault 140 Options"
    bSizable=True
}