//================================================================================
// Menu_IconWindow.
//================================================================================
class Menu_IconWindow extends UWindowPageWindow
	Localized;

var UWindowCheckbox DisableIconsALL;
var UWindowCheckbox DisableIconsWA;
var UWindowCheckbox DisableIconsWB;
var UWindowCheckbox DisableIconsWC;
var UWindowCheckbox DisableIconsSM;
var UWindowCheckbox DisableIconsEM;
var UWindowCheckbox RemoveColor;
var UWindowCheckbox RemoveNonTeamColor;
var UWindowCheckbox RemoveIcon;
var UWindowCheckbox RemoveUndisplayedIcon;
var UWindowCheckbox DontAnimateIcon;
var UWindowEditControl MaxSizeIcon;
var UWindowCheckbox NoOffensiveIcon;
var UWindowCheckbox OnlyTeamSayIcon;
var UWindowCheckbox SqueezeWhenFull;
var UWindowCheckbox SqueezeBExpandChat;
var UMenuRaisedButton EmoteBinder;
var UWindowCheckbox TournamentFlags;
var UMenuLabelControl Label;
var UWindowMessageBox ConfirmDL;
var localized string NotBound;
var UMenuRaisedButton SelectedButton;
var int Selection;
var bool bPolling;
var bool bSetReady;
var Menu_FontWindow MyFontWindow;

function Created ()
{
	local int ControlWidth;
	local int CenterPos;
	local int ControlOffset;

	Super.Created();
	ControlWidth=WinWidth / 3 * 2;
	CenterPos=(WinWidth - ControlWidth) / 2;
	ControlOffset=30;
	DisableIconsALL=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	DisableIconsALL.SetText("No Formatting (Disable ALL Icons and Colors):");
	DisableIconsALL.SetFont(0);
	DisableIconsALL.Align=0;
	DisableIconsALL.bChecked=Class'LeagueAS_HUD'.Default.bNoFormatting;
	ControlOffset += 20;
	DisableIconsWA=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	DisableIconsWA.SetText("   Disable Weapons Emoticons:");
	DisableIconsWA.SetFont(0);
	DisableIconsWA.Align=0;
	DisableIconsWA.bChecked= !Class'LeagueAS_HUD'.Default.loadgroups[1];
	ControlOffset += 16;
	DisableIconsWB=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	DisableIconsWB.SetText("   Disable Weapons/Items Simple Icons:");
	DisableIconsWB.SetFont(0);
	DisableIconsWB.Align=0;
	DisableIconsWB.bChecked= !Class'LeagueAS_HUD'.Default.loadgroups[2];
	ControlOffset += 16;
	DisableIconsWC=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	DisableIconsWC.SetText("   Disable Weapons/Items 2D Icons:");
	DisableIconsWC.SetFont(0);
	DisableIconsWC.Align=0;
	DisableIconsWC.bChecked= !Class'LeagueAS_HUD'.Default.loadgroups[4];
	ControlOffset += 16;
	DisableIconsSM=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	DisableIconsSM.SetText("   Disable Basic Smiles:");
	DisableIconsSM.SetFont(0);
	DisableIconsSM.Align=0;
	DisableIconsSM.bChecked= !Class'LeagueAS_HUD'.Default.loadgroups[3];
	ControlOffset += 16;
	NoOffensiveIcon=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	NoOffensiveIcon.SetText("   Disable Offensive Icons:");
	NoOffensiveIcon.SetFont(0);
	NoOffensiveIcon.Align=0;
	NoOffensiveIcon.bChecked=Class'LeagueAS_HUD'.Default.bNoOffensiveEmotes;
	ControlOffset += 16;
	DisableIconsEM=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	DisableIconsEM.SetText("   Disable ALL Other Icons:");
	DisableIconsEM.SetFont(0);
	DisableIconsEM.Align=0;
	DisableIconsEM.bChecked= !Class'LeagueAS_HUD'.Default.loadgroups[5];
	ControlOffset += 26;
	RemoveUndisplayedIcon=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	RemoveUndisplayedIcon.SetText("Remove Disabled Icon Codes from ChatBox:");
	RemoveUndisplayedIcon.SetFont(0);
	RemoveUndisplayedIcon.Align=0;
	RemoveUndisplayedIcon.bChecked=Class'LeagueAS_HUD'.Default.bRemoveUndisplayedEmotes;
	ControlOffset += 16;
	RemoveIcon=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	RemoveIcon.SetText("Remove ALL Icon Codes from ChatBox:");
	RemoveIcon.SetFont(0);
	RemoveIcon.Align=0;
	RemoveIcon.bChecked=Class'LeagueAS_HUD'.Default.bRemoveEmotes;
	ControlOffset += 16;
	RemoveColor=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	RemoveColor.SetText("Remove ALL color Codes from ChatBox:");
	RemoveColor.SetFont(0);
	RemoveColor.Align=0;
	RemoveColor.bChecked=Class'LeagueAS_HUD'.Default.bRemoveColors;
	ControlOffset += 16;
	RemoveNonTeamColor=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	RemoveNonTeamColor.SetText("Allow only Team color Codes in ChatBox:");
	RemoveNonTeamColor.SetFont(0);
	RemoveNonTeamColor.Align=0;
	RemoveNonTeamColor.bChecked=Class'LeagueAS_HUD'.Default.bRemoveNonTeamColors;
	ControlOffset += 26;
	DontAnimateIcon=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	DontAnimateIcon.SetText("Unanimated Icons:");
	DontAnimateIcon.SetFont(0);
	DontAnimateIcon.Align=0;
	DontAnimateIcon.bChecked=Class'LeagueAS_HUD'.Default.bDontAnimateEmotes;
	ControlOffset += 26;
	MaxSizeIcon=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPos,ControlOffset,ControlWidth,1.00));
	MaxSizeIcon.SetText("Max Icons Size:");
	MaxSizeIcon.SetFont(0);
	MaxSizeIcon.Align=0;
	MaxSizeIcon.EditBoxWidth=24.00;
	MaxSizeIcon.SetMaxLength(3);
	MaxSizeIcon.SetNumericOnly(True);
	MaxSizeIcon.SetDelayedNotify(True);
	MaxSizeIcon.SetValue(string(Class'LeagueAS_HUD'.Default.MaxSizeEmotes));
	ControlOffset += 26;
	OnlyTeamSayIcon=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	OnlyTeamSayIcon.SetText("Only TeamSay Icons:");
	OnlyTeamSayIcon.SetFont(0);
	OnlyTeamSayIcon.Align=0;
	OnlyTeamSayIcon.bChecked=Class'LeagueAS_HUD'.Default.bOnlyTeamSayEmotes;
	ControlOffset += 26;
	SqueezeWhenFull=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	SqueezeWhenFull.SetText("Squeeze Icons When Chatbox is Full:");
	SqueezeWhenFull.SetFont(0);
	SqueezeWhenFull.Align=0;
	SqueezeWhenFull.bChecked=Class'LeagueAS_HUD'.Default.bSqueezeEmotesWhenChatFull;
	ControlOffset += 26;
	SqueezeBExpandChat=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	SqueezeBExpandChat.SetText("Squeeze Icons Before Expanding Chatbox:");
	SqueezeBExpandChat.SetFont(0);
	SqueezeBExpandChat.Align=0;
	SqueezeBExpandChat.bChecked=Class'LeagueAS_HUD'.Default.bSqueezeBeforeExpand;
	ControlOffset += 26;
	Label=UMenuLabelControl(CreateControl(Class'UMenuLabelControl',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	Label.SetText("Mid Game Icons Menu Key Binder:");
	Label.SetFont(0);
	EmoteBinder=UMenuRaisedButton(CreateControl(Class'UMenuRaisedButton',CenterPos + ControlWidth - 47,ControlOffset - 3,50.00,1.00));
	EmoteBinder.Text=NotBound;
	EmoteBinder.SetFont(0);
	EmoteBinder.Align=2;
	EmoteBinder.bAcceptsFocus=False;
	EmoteBinder.bIgnoreLDoubleClick=True;
	EmoteBinder.bIgnoreMDoubleClick=True;
	EmoteBinder.bIgnoreRDoubleClick=True;
	EmoteBinder.Index=1;
	ControlOffset += 26;
	TournamentFlags=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	TournamentFlags.SetText("UTPure style Flags for Tournament Mode:");
	TournamentFlags.SetFont(0);
	TournamentFlags.Align=0;
	TournamentFlags.bChecked=Class'LeagueAS_Scoreboard'.Default.bEnableTournamentFlags;
	ControlOffset += 26;
	LoadExistingKeys();
}

function Paint (Canvas C, float X, float Y)
{
	local int ControlLeft;
	local int ControlHeight;
	local Texture t;
	local Texture Tex;

	ControlLeft=436 / 2;
	ControlHeight=(WinHeight - 380 - 40) / 2 + 380;
	Super.Paint(C,X,Y);
	C.Style=1;
	C.DrawColor.R=255;
	C.DrawColor.G=255;
	C.DrawColor.B=255;
	t=GetLookAndFeelTexture();
	Tex=Texture'CSHPShield';
	DrawUpBevel(C,ControlLeft - 32 - 6,ControlHeight - 6,64.00 + 12,64.00 + 12,t);
	DrawStretchedTexture(C,ControlLeft - 32 - 3,ControlHeight - 3,64.00 + 6,64.00 + 6,Texture'BlackTexture');
	DrawStretchedTexture(C,ControlLeft - 32,ControlHeight,64.00,64.00,Tex);
	C.Style=1;
	C.DrawColor.R=0;
	C.DrawColor.G=0;
	C.DrawColor.B=0;
	C.Font=Font(DynamicLoadObject("UWindowFonts.TahomaB10",Class'Font'));
	ClipText(C,ControlLeft - 80,ControlHeight + 64 + 12 + 4,"Copyright  2004 utassault.net");
	ClipText(C,ControlLeft - 50,ControlHeight + 64 + 12 + 4 + 12,"All Rights Reserved.");
}

function int LoadExistingKeys ()
{
	local int i;
	local string KeyName;
	local string Alias;

	i=0;
JL0007:
	if ( i < 255 )
	{
		KeyName=GetPlayerOwner().ConsoleCommand("KEYNAME " $ string(i));
		if ( KeyName != "" )
		{
			Alias=GetPlayerOwner().ConsoleCommand("KEYBINDING " $ KeyName);
			if ( Alias == "ShowEmoticonMenu" )
			{
				EmoteBinder.Text=Class'UMenuCustomizeClientWindow'.Default.LocalizedKeyName[i];
			}
		}
		i++;
		goto JL0007;
	}
}

function WindowEvent (WinMessage Msg, Canvas C, float X, float Y, int Key)
{
	if ( (Msg == 7) && bPolling )
	{
		KeyDown(Key,X,Y);
	} else {
		Super.WindowEvent(Msg,C,X,Y,Key);
	}
}

function KeyDown (int Key, float X, float Y)
{
	if ( bPolling )
	{
		ProcessMenuKey(Key,Mid(string(GetEnum(Enum'EInputKey',Key)),3));
		bPolling=False;
		SelectedButton.bDisabled=False;
	}
}

function ProcessMenuKey (int KeyNo, string KeyName)
{
	if ( (KeyName == "") || (KeyName == "Escape") || (KeyNo >= 112) && (KeyNo <= 121) || (KeyNo >= 48) && (KeyNo <= 57) )
	{
		return;
	}
	RemoveExistingKey(KeyNo,KeyName);
	SetKey(KeyNo,KeyName);
}

function RemoveExistingKey (int KeyNo, string KeyName)
{
	local int i;
	local string KeyName2;
	local string Alias;
	local string Binding;

	if ( EmoteBinder.Text == KeyName )
	{
		GetPlayerOwner().ConsoleCommand("SET Input" @ EmoteBinder.Text);
		EmoteBinder.Text="";
	}
	Binding="ShowEmoticonMenu";
	i=0;
JL0074:
	if ( i < 255 )
	{
		KeyName2=GetPlayerOwner().ConsoleCommand("KEYNAME " $ string(i));
		if ( KeyName2 != "" )
		{
			Alias=GetPlayerOwner().ConsoleCommand("KEYBINDING " $ KeyName2);
			if ( Alias ~= Binding )
			{
				GetPlayerOwner().ConsoleCommand("SET Input" @ KeyName2);
			}
		}
		i++;
		goto JL0074;
	}
}

function SetKey (int KeyNo, string KeyName)
{
	GetPlayerOwner().ConsoleCommand("SET Input" @ KeyName @ "ShowEmoticonMenu");
	SelectedButton.Text=Class'UMenuCustomizeClientWindow'.Default.LocalizedKeyName[KeyNo];
	GetPlayerOwner().SaveConfig();
}

function bool LookForAnemote ()
{
	local Texture testanemote;

	testanemote=Texture(DynamicLoadObject("anemote1.3WG2_enf",Class'Texture'));
	if ( testanemote == None )
	{
		return False;
	} else {
		return True;
	}
}

function NoAnemote ()
{
	ConfirmDL=MessageBox("Confirm Download","This feature requires Anemote1.utx which was not found on your textures folder. Download Anemote1.utx?",0,2,1);
}

function MessageBoxDone (UWindowMessageBox W, MessageBoxResult Result)
{
	if ( W == ConfirmDL )
	{
		ConfirmDL=None;
		if ( Result == 1 )
		{
			GetPlayerOwner().ConsoleCommand("start http://www.utassault.net/leagueas");
		}
	}
}

function Notify (UWindowDialogControl C, byte E)
{
	Super.Notify(C,E);
	switch (E)
	{
		case 2:
		switch (C)
		{
			case EmoteBinder:
			SelectedButton=UMenuRaisedButton(C);
			bPolling=True;
			SelectedButton.bDisabled=True;
			default:
		}
		return;
		case 1:
		switch (C)
		{
			case DisableIconsALL:
			if (  !DisableIconsALL.bChecked &&  !LookForAnemote() )
			{
				DisableIconsALL.bChecked=True;
				NoAnemote();
				return;
			}
			if ( DisableIconsALL.bChecked )
			{
				DisableIconsWA.bChecked=True;
				DisableIconsWB.bChecked=True;
				DisableIconsWC.bChecked=True;
				DisableIconsSM.bChecked=True;
				DisableIconsEM.bChecked=True;
				NoOffensiveIcon.bChecked=True;
				RemoveIcon.bChecked=False;
				RemoveUndisplayedIcon.bChecked=False;
				RemoveColor.bChecked=False;
				RemoveNonTeamColor.bChecked=False;
				Class'LeagueAS_HUD'.Default.bRemoveEmotes=False;
				Class'LeagueAS_HUD'.Default.bRemoveUndisplayedEmotes=False;
				Class'LeagueAS_HUD'.Default.bRemoveColors=False;
				Class'LeagueAS_HUD'.Default.bRemoveNonTeamColors=False;
				Class'LeagueAS_HUD'.Default.loadgroups[0]=1;
				Class'LeagueAS_HUD'.Default.loadgroups[1]=0;
				Class'LeagueAS_HUD'.Default.loadgroups[2]=0;
				Class'LeagueAS_HUD'.Default.loadgroups[3]=0;
				Class'LeagueAS_HUD'.Default.loadgroups[4]=0;
				Class'LeagueAS_HUD'.Default.loadgroups[5]=0;
				Class'LeagueAS_HUD'.Default.bNoOffensiveEmotes=True;
				if ( (Class'LeagueAS_Tweaks'.Default.KillMsgType > 2) && (Class'LeagueAS_Tweaks'.Default.KillMsgType < 6) )
				{
					Class'LeagueAS_Tweaks'.Default.KillMsgType=6;
					Class'LeagueAS_Tweaks'.StaticSaveConfig();
					MyFontWindow.DeathUseIcons.SetValue("Custom");
				}
			} else {
				DisableIconsWA.bChecked=False;
				DisableIconsWB.bChecked=False;
				DisableIconsWC.bChecked=False;
				DisableIconsSM.bChecked=False;
				DisableIconsEM.bChecked=False;
				NoOffensiveIcon.bChecked=False;
				Class'LeagueAS_HUD'.Default.loadgroups[0]=1;
				Class'LeagueAS_HUD'.Default.loadgroups[1]=1;
				Class'LeagueAS_HUD'.Default.loadgroups[2]=1;
				Class'LeagueAS_HUD'.Default.loadgroups[3]=1;
				Class'LeagueAS_HUD'.Default.loadgroups[4]=1;
				Class'LeagueAS_HUD'.Default.loadgroups[5]=1;
				Class'LeagueAS_HUD'.Default.bNoOffensiveEmotes=False;
			}
			Class'LeagueAS_HUD'.Default.bNoFormatting=DisableIconsALL.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case DisableIconsWA:
			if (  !DisableIconsWA.bChecked &&  !LookForAnemote() )
			{
				DisableIconsWA.bChecked=True;
				NoAnemote();
				return;
			}
			if (  !DisableIconsWA.bChecked )
			{
				DisableIconsALL.bChecked=False;
				Class'LeagueAS_HUD'.Default.loadgroups[1]=1;
			} else {
				Class'LeagueAS_HUD'.Default.loadgroups[1]=0;
				if ( Class'LeagueAS_Tweaks'.Default.KillMsgType == 5 )
				{
					Class'LeagueAS_Tweaks'.Default.KillMsgType=6;
					Class'LeagueAS_Tweaks'.StaticSaveConfig();
					MyFontWindow.DeathUseIcons.SetValue("Custom");
				}
			}
			Class'LeagueAS_HUD'.Default.bNoFormatting=DisableIconsALL.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case DisableIconsWB:
			if (  !DisableIconsWB.bChecked &&  !LookForAnemote() )
			{
				DisableIconsWB.bChecked=True;
				NoAnemote();
				return;
			}
			if (  !DisableIconsWB.bChecked )
			{
				DisableIconsALL.bChecked=False;
				Class'LeagueAS_HUD'.Default.loadgroups[2]=1;
			} else {
				Class'LeagueAS_HUD'.Default.loadgroups[2]=0;
				if ( (Class'LeagueAS_Tweaks'.Default.KillMsgType == 3) || (Class'LeagueAS_Tweaks'.Default.KillMsgType == 4) )
				{
					Class'LeagueAS_Tweaks'.Default.KillMsgType=6;
					Class'LeagueAS_Tweaks'.StaticSaveConfig();
					MyFontWindow.DeathUseIcons.SetValue("Custom");
				}
			}
			Class'LeagueAS_HUD'.Default.bNoFormatting=DisableIconsALL.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case DisableIconsWC:
			if (  !DisableIconsWC.bChecked &&  !LookForAnemote() )
			{
				DisableIconsWC.bChecked=True;
				NoAnemote();
				return;
			}
			if (  !DisableIconsWC.bChecked )
			{
				DisableIconsALL.bChecked=False;
				Class'LeagueAS_HUD'.Default.loadgroups[4]=1;
			} else {
				Class'LeagueAS_HUD'.Default.loadgroups[4]=0;
			}
			Class'LeagueAS_HUD'.Default.bNoFormatting=DisableIconsALL.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case DisableIconsSM:
			if (  !DisableIconsSM.bChecked &&  !LookForAnemote() )
			{
				DisableIconsSM.bChecked=True;
				NoAnemote();
				return;
			}
			if (  !DisableIconsSM.bChecked )
			{
				DisableIconsALL.bChecked=False;
				Class'LeagueAS_HUD'.Default.loadgroups[3]=1;
			} else {
				Class'LeagueAS_HUD'.Default.loadgroups[3]=0;
			}
			Class'LeagueAS_HUD'.Default.bNoFormatting=DisableIconsALL.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case DisableIconsEM:
			if (  !DisableIconsEM.bChecked &&  !LookForAnemote() )
			{
				DisableIconsEM.bChecked=True;
				NoAnemote();
				return;
			}
			if (  !DisableIconsEM.bChecked )
			{
				DisableIconsALL.bChecked=False;
				Class'LeagueAS_HUD'.Default.loadgroups[5]=1;
			} else {
				NoOffensiveIcon.bChecked=True;
				Class'LeagueAS_HUD'.Default.bNoOffensiveEmotes=True;
				Class'LeagueAS_HUD'.Default.loadgroups[5]=0;
			}
			Class'LeagueAS_HUD'.Default.bNoFormatting=DisableIconsALL.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case NoOffensiveIcon:
			if (  !NoOffensiveIcon.bChecked &&  !LookForAnemote() )
			{
				NoOffensiveIcon.bChecked=True;
				NoAnemote();
				return;
			}
			if (  !NoOffensiveIcon.bChecked )
			{
				DisableIconsALL.bChecked=False;
				DisableIconsEM.bChecked=False;
				Class'LeagueAS_HUD'.Default.loadgroups[5]=1;
			}
			Class'LeagueAS_HUD'.Default.bNoOffensiveEmotes=NoOffensiveIcon.bChecked;
			Class'LeagueAS_HUD'.Default.bNoFormatting=DisableIconsALL.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case RemoveIcon:
			Class'LeagueAS_HUD'.Default.bRemoveEmotes=RemoveIcon.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			if ( RemoveIcon.bChecked )
			{
				Class'LeagueAS_HUD'.Default.bNoFormatting=False;
				Class'LeagueAS_HUD'.Default.bRemoveUndisplayedEmotes=True;
				DisableIconsALL.bChecked=False;
				RemoveUndisplayedIcon.bChecked=True;
			}
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case RemoveColor:
			Class'LeagueAS_HUD'.Default.bRemoveColors=RemoveColor.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			if ( RemoveColor.bChecked )
			{
				Class'LeagueAS_HUD'.Default.bNoFormatting=False;
				DisableIconsALL.bChecked=False;
			}
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case RemoveNonTeamColor:
			Class'LeagueAS_HUD'.Default.bRemoveNonTeamColors=RemoveNonTeamColor.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			if ( RemoveNonTeamColor.bChecked )
			{
				Class'LeagueAS_HUD'.Default.bNoFormatting=False;
				DisableIconsALL.bChecked=False;
			}
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case RemoveUndisplayedIcon:
			Class'LeagueAS_HUD'.Default.bRemoveUndisplayedEmotes=RemoveUndisplayedIcon.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			if ( RemoveUndisplayedIcon.bChecked )
			{
				Class'LeagueAS_HUD'.Default.bNoFormatting=False;
				DisableIconsALL.bChecked=False;
			}
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case DontAnimateIcon:
			Class'LeagueAS_HUD'.Default.bDontAnimateEmotes=DontAnimateIcon.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			Class'Emotelist'.Default.binit=False;
			Class'Emotelist'.initemotes();
			Class'Emotelist'.StaticSaveConfig();
			break;
			case MaxSizeIcon:
			if ( int(MaxSizeIcon.GetValue()) > 256 )
			{
				MaxSizeIcon.SetValue("256");
			}
			Class'LeagueAS_HUD'.Default.MaxSizeEmotes=int(MaxSizeIcon.GetValue());
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case OnlyTeamSayIcon:
			Class'LeagueAS_HUD'.Default.bOnlyTeamSayEmotes=OnlyTeamSayIcon.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case SqueezeWhenFull:
			Class'LeagueAS_HUD'.Default.bSqueezeEmotesWhenChatFull=SqueezeWhenFull.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case SqueezeBExpandChat:
			Class'LeagueAS_HUD'.Default.bSqueezeBeforeExpand=SqueezeBExpandChat.bChecked;
			Class'LeagueAS_HUD'.StaticSaveConfig();
			break;
			case TournamentFlags:
			Class'LeagueAS_Scoreboard'.Default.bEnableTournamentFlags=TournamentFlags.bChecked;
			Class'LeagueAS_Scoreboard'.StaticSaveConfig();
			break;
			default:
			return;
		}
		default:
	}
}