//================================================================================
// PBoltTIW.
//================================================================================
class PBoltTIW extends PBolt;

var float nextboltTime;

simulated function CheckBeam (Vector X, float DeltaTime)
{
	local Actor HitActor;
	local Vector HitLocation;
	local Vector HitNormal;

	HitActor=Trace(HitLocation,HitNormal,Location + BeamSize * X,Instigator.Location,True);
	if ( (HitActor != None) && (HitActor != Instigator) && (HitActor.bProjTarget || (HitActor == Level) || HitActor.bBlockActors && HitActor.bBlockPlayers) && ((Pawn(HitActor) == None) || Pawn(HitActor).AdjustHitLocation(HitLocation,Velocity)) )
	{
		if ( Level.NetMode != 3 )
		{
			if ( DamagedActor == None )
			{
				AccumulatedDamage=FMin(0.50 * (Level.TimeSeconds - LastHitTime),0.10);
				HitActor.TakeDamage(Damage * AccumulatedDamage,Instigator,HitLocation,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
				AccumulatedDamage=0.00;
			} else {
				if ( DamagedActor != HitActor )
				{
					DamagedActor.TakeDamage(Damage * AccumulatedDamage,Instigator,HitLocation,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
					AccumulatedDamage=0.00;
				}
			}
			LastHitTime=Level.TimeSeconds;
			DamagedActor=HitActor;
			AccumulatedDamage += DeltaTime;
			if ( AccumulatedDamage > 0.22 )
			{
				if ( DamagedActor.IsA('Carcass') && (FRand() < 0.09) )
				{
					AccumulatedDamage=35.00 / Damage;
				}
				DamagedActor.TakeDamage(Damage * AccumulatedDamage,Instigator,HitLocation,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
				AccumulatedDamage=0.00;
			}
		}
		if ( HitActor.bIsPawn && Pawn(HitActor).bIsPlayer )
		{
			if ( WallEffect != None )
			{
				WallEffect.Destroy();
			}
		} else {
			if ( (WallEffect == None) || WallEffect.bDeleteMe )
			{
				WallEffect=Spawn(Class'PlasmaHit',,,HitLocation - 5 * X);
			} else {
				if (  !WallEffect.IsA('PlasmaHit') )
				{
					WallEffect.Destroy();
					WallEffect=Spawn(Class'PlasmaHit',,,HitLocation - 5 * X);
				} else {
					WallEffect.SetLocation(HitLocation - 5 * X);
				}
			}
		}
		if ( (WallEffect != None) && (Level.NetMode != 1) )
		{
			Spawn(ExplosionDecal,,,HitLocation,rotator(HitNormal));
		}
		if ( PlasmaBeam != None )
		{
			AccumulatedDamage += PlasmaBeam.AccumulatedDamage;
			PlasmaBeam.Destroy();
			PlasmaBeam=None;
		}
		return;
	} else {
		if ( (Level.NetMode != 3) && (DamagedActor != None) )
		{
			DamagedActor.TakeDamage(Damage * AccumulatedDamage,Instigator,DamagedActor.Location - X * 1.20 * DamagedActor.CollisionRadius,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
			AccumulatedDamage=0.00;
			DamagedActor=None;
		}
	}
	nextboltTime += DeltaTime;
	if ( (Position >= 9) || (nextboltTime < 0.05) && (PlasmaBeam == None) )
	{
		if ( (WallEffect == None) || WallEffect.bDeleteMe )
		{
			WallEffect=Spawn(Class'PlasmaCap',,,Location + (BeamSize - 4) * X);
		} else {
			if ( WallEffect.IsA('PlasmaHit') )
			{
				WallEffect.Destroy();
				WallEffect=Spawn(Class'PlasmaCap',,,Location + (BeamSize - 4) * X);
			} else {
				WallEffect.SetLocation(Location + (BeamSize - 4) * X);
			}
		}
	} else {
		if ( WallEffect != None )
		{
			WallEffect.Destroy();
			WallEffect=None;
		}
		if ( PlasmaBeam == None )
		{
			PlasmaBeam=Spawn(Class'PBoltTIW',,,Location + BeamSize * X);
			PlasmaBeam.Position=Position + 1;
			PBoltTIW(PlasmaBeam).nextboltTime=nextboltTime - 0.05;
		} else {
			PlasmaBeam.UpdateBeam(self,X,DeltaTime);
		}
	}
}