// ============================================================
// ThMenu.ThAudioClientWindow: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThAudioClientWindow expands UMenuAudioClientWindow;

var UWindowHSliderControl AnnouncerVolumeSlider;
var localized string AnnouncerVolumeText;
var localized string AnnouncerVolumeHelp;

var UWindowCheckbox AutoTauntCheck;
var localized string AutoTauntText;
var localized string AutoTauntHelp;

var UWindowCheckbox Use3DHardwareCheck;
var localized string Use3DHardwareText;
var localized string Use3DHardwareHelp;

var UWindowCheckbox UseSurroundSoundCheck;
var localized string UseSurroundSoundText;
var localized string UseSurroundSoundHelp;

var UWindowComboControl MessageSettingsCombo;
var localized string MessageSettingsText;
var localized string MessageSettingsHelp;
var localized string MessageSettings[4];

var UWindowMessageBox ConfirmHardware;
var localized string ConfirmHardwareTitle;
var localized string ConfirmHardwareText;

var UWindowMessageBox ConfirmSurround;
var localized string ConfirmSurroundTitle;
var localized string ConfirmSurroundText;

var UWindowCheckbox NoMatureLanguageCheck;
var localized string NoMatureLanguageText;
var localized string NoMatureLanguageHelp;

var UWindowCheckbox IntroCheck;
var localized string IntroText;
var localized string IntroHelp;

function Created()
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;
	local TournamentPlayer P;

	local bool bLowSoundQuality;
	local int MusicVolume, SoundVolume;
	//local int ControlWidth, ControlLeft, ControlRight;
	//local int CenterWidth, CenterPos;

	super(UMenuPageWindow).Created();

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	// Voice Messages
	VoiceMessagesCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	VoiceMessagesCheck.bChecked = !GetPlayerOwner().bNoVoices;
	VoiceMessagesCheck.SetText(VoiceMessagesText);
	VoiceMessagesCheck.SetHelpText(VoiceMessagesHelp);
	VoiceMessagesCheck.SetFont(F_Normal);
	VoiceMessagesCheck.Align = TA_Left;
	ControlOffset += 25;

	// Message Beep
	MessageBeepCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	MessageBeepCheck.bChecked = GetPlayerOwner().bMessageBeep;
	MessageBeepCheck.SetText(MessageBeepText);
	MessageBeepCheck.SetHelpText(MessageBeepHelp);
	MessageBeepCheck.SetFont(F_Normal);
	MessageBeepCheck.Align = TA_Left;
	ControlOffset += 25;

	ExtraMessageOptions();

	// Sound Quality
	SoundQualityCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	SoundQualityCombo.SetText(SoundQualityText);
	SoundQualityCombo.SetHelpText(SoundQualityHelp);
	SoundQualityCombo.SetFont(F_Normal);
	SoundQualityCombo.SetEditable(False);
	SoundQualityCombo.AddItem(Details[0]);
	SoundQualityCombo.AddItem(Details[1]);
	bLowSoundQuality = bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice LowSoundQuality"));
	if (bLowSoundQuality)
		SoundQualityCombo.SetSelectedIndex(0);
	else
		SoundQualityCombo.SetSelectedIndex(1);
	ControlOffset += 25;

	// Music Volume

	MusicVolumeSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	MusicVolumeSlider.SetRange(0, 255, 32);
	MusicVolume = int(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice MusicVolume"));
	MusicVolumeSlider.SetValue(MusicVolume);
	MusicVolumeSlider.SetText(MusicVolumeText);
	MusicVolumeSlider.SetHelpText(MusicVolumeHelp);
	MusicVolumeSlider.SetFont(F_Normal);
	ControlOffset += 25;

	IntroCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	IntroCheck.bChecked = class'ThieveryMod.ThieveryConfigClient'.default.PlayIntroSong;
	IntroCheck.SetText(IntroText);
	IntroCheck.SetHelpText(IntroHelp);
	IntroCheck.SetFont(F_Normal);
	IntroCheck.Align = TA_Left;
	ControlOffset += 25;

	// Sound Volume
	SoundVolumeSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	SoundVolumeSlider.SetRange(0, 255, 32);
	SoundVolume = int(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice SoundVolume"));
	SoundVolumeSlider.SetValue(SoundVolume);
	SoundVolumeSlider.SetText(SoundVolumeText);
	SoundVolumeSlider.SetHelpText(SoundVolumeHelp);
	SoundVolumeSlider.SetFont(F_Normal);
	ControlOffset += 25;

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	P = TournamentPlayer(GetPlayerOwner());
/*
	MessageSettingsCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	MessageSettingsCombo.SetText(MessageSettingsText);
	MessageSettingsCombo.SetHelpText(MessageSettingsHelp);
	MessageSettingsCombo.SetFont(F_Normal);
	MessageSettingsCombo.SetEditable(False);
	MessageSettingsCombo.AddItem(MessageSettings[0]);
	MessageSettingsCombo.AddItem(MessageSettings[1]);
	MessageSettingsCombo.AddItem(MessageSettings[2]);
	MessageSettingsCombo.AddItem(MessageSettings[3]);
	if(P.bNoVoiceMessages)
		MessageSettingsCombo.SetSelectedIndex(3);
	else
	if(P.bNoVoiceTaunts)
		MessageSettingsCombo.SetSelectedIndex(2);
	else
	if(P.bNoAutoTaunts)
		MessageSettingsCombo.SetSelectedIndex(1);
	else
		MessageSettingsCombo.SetSelectedIndex(0);
	ControlOffset += 25;

	NoMatureLanguageCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	NoMatureLanguageCheck.bChecked = TournamentPlayer(GetPlayerOwner()).bNoMatureLanguage;
	NoMatureLanguageCheck.SetText(NoMatureLanguageText);
	NoMatureLanguageCheck.SetHelpText(NoMatureLanguageHelp);
	NoMatureLanguageCheck.SetFont(F_Normal);
	NoMatureLanguageCheck.Align = TA_Left;
	ControlOffset += 25;

	// Announcer Volume
	AnnouncerVolumeSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	AnnouncerVolumeSlider.SetRange(0, 4, 1);
	AnnouncerVolumeSlider.SetValue(P.AnnouncerVolume);
	AnnouncerVolumeSlider.SetText(AnnouncerVolumeText);
	AnnouncerVolumeSlider.SetHelpText(AnnouncerVolumeHelp);
	AnnouncerVolumeSlider.SetFont(F_Normal);
	ControlOffset += 25;
*/

	// 3DHardware.
	Use3DHardwareCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	Use3DHardwareCheck.bChecked = bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice Use3dHardware"));
	Use3DHardwareCheck.SetText(Use3DHardwareText);
	Use3DHardwareCheck.SetHelpText(Use3DHardwareHelp);
	Use3DHardwareCheck.SetFont(F_Normal);
	Use3DHardwareCheck.Align = TA_Left;
	ControlOffset += 25;

	// Surround Sound.
	UseSurroundSoundCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	UseSurroundSoundCheck.bChecked = bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice UseSurround"));
	UseSurroundSoundCheck.SetText(UseSurroundSoundText);
	UseSurroundSoundCheck.SetHelpText(UseSurroundSoundHelp);
	UseSurroundSoundCheck.SetFont(F_Normal);
	UseSurroundSoundCheck.Align = TA_Left;
	ControlOffset += 25;
}

function ExtraMessageOptions()
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;

	Super.ExtraMessageOptions();

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	VoiceMessagesCheck.HideWindow();
/*
	AutoTauntCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, VoiceMessagesCheck.WinTop, CenterWidth, 1));
	AutoTauntCheck.bChecked = TournamentPlayer(GetPlayerOwner()).bAutoTaunt;
	AutoTauntCheck.SetText(AutoTauntText);
	AutoTauntCheck.SetHelpText(AutoTauntHelp);
	AutoTauntCheck.SetFont(F_Normal);
	AutoTauntCheck.Align = TA_Left;
	*/
}

function BeforePaint(Canvas C, float X, float Y)
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;

	Super.BeforePaint(C, X, Y);

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

/*
	AutoTauntCheck.SetSize(CenterWidth-90+16, 1);
	AutoTauntCheck.WinLeft = CenterPos;

	AnnouncerVolumeSlider.SetSize(CenterWidth, 1);
	AnnouncerVolumeSlider.SliderWidth = 90;
	AnnouncerVolumeSlider.WinLeft = CenterPos;

	MessageSettingsCombo.SetSize(CenterWidth, 1);
	MessageSettingsCombo.WinLeft = CenterPos;
	MessageSettingsCombo.EditBoxWidth = 90;
*/
	Use3DHardwareCheck.SetSize(CenterWidth-90+16, 1);
	Use3DHardwareCheck.WinLeft = CenterPos;

	UseSurroundSoundCheck.SetSize(CenterWidth-90+16, 1);
	UseSurroundSoundCheck.WinLeft = CenterPos;

	//NoMatureLanguageCheck.SetSize(CenterWidth-90+16, 1);
	//NoMatureLanguageCheck.WinLeft = CenterPos;

	IntroCheck.SetSize(CenterWidth-90+16, 1);
	IntroCheck.WinLeft = CenterPos;
}

function Notify(UWindowDialogControl C, byte E)
{
	Super.Notify(C, E);

	switch(E)
	{
	case DE_Change:
		switch(C)
		{/*
		case AutoTauntCheck:
			AutoTauntChecked();
			break;
		case AnnouncerVolumeSlider:
			AnnouncerVolumeChanged();
			break;
		case MessageSettingsCombo:
			MessageSettingsChanged();
			break;*/
		case Use3DHardwareCheck:
			Hardware3DChecked();
			break;
		case UseSurroundSoundCheck:
			SurroundSoundChecked();
			break;
		case IntroCheck:
			IntroChecked();
			break;
		/*
		case NoMatureLanguageCheck:
			NoMatureLanguageChanged();
			break;*/
		}
	}
}

function MessageSettingsChanged()
{
	local TournamentPlayer P;
	P = TournamentPlayer(GetPlayerOwner());

	switch(MessageSettingsCombo.GetSelectedIndex())
	{
	case 1:
		P.bNoVoiceMessages = False;
		P.bNoVoiceTaunts = False;
		P.bNoAutoTaunts = True;
		break;
	case 2:
		P.bNoVoiceMessages = False;
		P.bNoVoiceTaunts = True;
		P.bNoAutoTaunts = True;
		break;
	case 3:
		P.bNoVoiceMessages = True;
		P.bNoVoiceTaunts = True;
		P.bNoAutoTaunts = True;
		break;
	default:
		P.bNoVoiceMessages = False;
		P.bNoVoiceTaunts = False;
		P.bNoAutoTaunts = False;
		break;
	}
}

function Hardware3DChecked()
{
	Hardware3DSet();

	if(Use3DHardwareCheck.bChecked)
		ConfirmHardware = MessageBox(ConfirmHardwareTitle, ConfirmHardwareText, MB_YesNo, MR_No, MR_None);
}

function Hardware3DSet()
{
	GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.AudioDevice Use3dHardware "$Use3DHardwareCheck.bChecked);
}

function SurroundSoundChecked()
{
	SurroundSoundSet();
	if(UseSurroundSoundCheck.bChecked)
		ConfirmSurround = MessageBox(ConfirmSurroundTitle, ConfirmSurroundText, MB_YesNo, MR_No, MR_None);
}

function IntroChecked()
{
	class'ThieveryMod.ThieveryConfigClient'.default.PlayIntroSong=IntroCheck.bChecked;
}

function SurroundSoundSet()
{
	GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.AudioDevice UseSurround "$UseSurroundSoundCheck.bChecked);
}

function MessageBoxDone(UWindowMessageBox W, MessageBoxResult Result)
{
	if(Result != MR_Yes)
	{
		switch(W)
		{
		case ConfirmHardware:
			Use3DHardwareCheck.bChecked = False;
			Hardware3DSet();
			ConfirmHardware = None;
			break;
		case ConfirmSurround:
			UseSurroundSoundCheck.bChecked = False;
			SurroundSoundSet();
			ConfirmSurround = None;
			break;
		}
	}
}

function VoiceMessagesChecked()
{
}

function AutoTauntChecked()
{
	TournamentPlayer(GetPlayerOwner()).SetAutoTaunt(AutoTauntCheck.bChecked);
}

function AnnouncerVolumeChanged()
{
	TournamentPlayer(GetPlayerOwner()).AnnouncerVolume = AnnouncerVolumeSlider.GetValue();
}

function NoMatureLanguageChanged()
{
	TournamentPlayer(GetPlayerOwner()).bNoMatureLanguage = NoMatureLanguageCheck.bChecked;
}

function SaveConfigs()
{
	Super.SaveConfigs();
	GetPlayerOwner().SaveConfig();
}

defaultproperties
{
     AnnouncerVolumeText="Announcer Volume"
     AnnouncerVolumeHelp="Adjusts the volume of the in-game announcer."
     AutoTauntText="Auto Taunt"
     AutoTauntHelp="If checked, your player will send automatic taunts to your victims, whenever you score a frag."
     Use3DHardwareText="Use Hardware 3D Sound"
     Use3DHardwareHelp="If checked, UT will use your 3D audio hardware for richer environmental effects."
     UseSurroundSoundText="Use Surround Sound"
     UseSurroundSoundHelp="If checked, UT will use your digital receiver for better surround sound."
     MessageSettingsText="Play Voice Messages"
     MessageSettingsHelp="This setting controls which voice messages sent from other players will be heard."
     MessageSettings(0)="All"
     MessageSettings(1)="No Auto-Taunts"
     MessageSettings(2)="No Taunts"
     MessageSettings(3)="None"
     ConfirmHardwareTitle="Confirm Use 3D Sound Hardware"
     ConfirmHardwareText="The hardware 3D sound feature requires you have a 3D sound card supporting A3D or EAX.  Enabling this option can also cause your performance to degrade severely in some cases."
     ConfirmSurroundTitle="Confirm Use Surround Sound"
     ConfirmSurroundText="The surround sound feature requires you have a compatible surround sound receiver connected to your sound card.  Enabling this option without the appropriate receiver can cause anomalies in sound performance."
     NoMatureLanguageText="No Mature Taunts"
     NoMatureLanguageHelp="If checked, voice taunts with mature language will not be played."
     IntroText="Play menu music"
     IntroHelp="If checked, title music will play when Thievery starts"
}
