/* ============================================================================
:: ThBrowserIRCWindow ::
:: ============================================================================
:: Thievery  2002
============================================================================= */
class ThBrowserIRCTextArea expands UBrowserIRCTextArea;

// SW --
function TextAreaClipText(Canvas C, float DrawX, float DrawY, coerce string S, optional bool bCheckHotkey)
{
	local float X, Y, W, H;
	local float ClickX, ClickY;
	local string Text, NextBlock;
	local byte bLink;
	local bool bOverLink;

	Text = S;
	X = DrawX;
	Y = DrawY;
	while(Text != "")
	{
		ProcessText(C, Text, NextBlock, W, H, bLink);
		if(bLink != 0)
		{
			C.DrawColor.R = 0;
			C.DrawColor.G = 0;
			C.DrawColor.B = 255;
		}
		else
		{
			C.DrawColor.R = 255;
			C.DrawColor.G = 255;
			C.DrawColor.B = 255;
		}

		GetMouseXY(ClickX, ClickY);
		bOverLink = bLink != 0 && DrawX < ClickX && DrawX + W > ClickX && DrawY < ClickY && DrawY + H > ClickY;

		if(bOverLink)
			Cursor = Root.HandCursor;

		if(bOverLink && (bMouseDown || bReleased))
		{
			if(bReleased)
			{
				Log("Clicked URL: >>"$NextBlock$"<<");
				if( Left(NextBlock, 7) ~= "http://" )
					GetPlayerOwner().ConsoleCommand("start "$NextBlock);
				if( Left(NextBlock, 6) ~= "ftp://" )
					GetPlayerOwner().ConsoleCommand("start "$NextBlock);
				if( Left(NextBlock, 9) ~= "telnet://" )
					GetPlayerOwner().ConsoleCommand("start "$NextBlock);
				if( Left(NextBlock, 9) ~= "gopher://" )
					GetPlayerOwner().ConsoleCommand("start "$NextBlock);
				if( Left(NextBlock, 4) ~= "www." )
					GetPlayerOwner().ConsoleCommand("start http://"$NextBlock);
				if( Left(NextBlock, 4) ~= "ftp." )
					GetPlayerOwner().ConsoleCommand("start ftp://"$NextBlock);
				else
				if( Left(NextBlock, 11) ~= "thievery://" )
					LaunchUnrealURL(NextBlock);
			}
			else
			{
				C.DrawColor.R = 255;
				C.DrawColor.G = 0;
				C.DrawColor.B = 0;
			}
			if(bReleased)
				bReleased = False;
		}

		if(bLink != 0)
			DrawStretchedTexture(C, DrawX, DrawY+H-1, W, 1, Texture'WhiteTexture');
		ClipText(C, DrawX, DrawY, NextBlock);
		DrawX += W;
	}
}
// -- SW

// SW --
function ProcessText(Canvas C, out string Text, out string NextBlock, out float W, out float H, out byte bLink)
{
	local int i, j;
	local string Temp;

	i = InStr(Text, "http://");

	j = InStr(Text, "www.");
	if(i == -1 || j == -1)
		i = Max(i, j);
	else
		i = Min(i, j);

	j = InStr(Text, "thievery://");
	if(i == -1 || j == -1)
		i = Max(i, j);
	else
		i = Min(i, j);

	j = InStr(Text, "ftp://");
	if(i == -1 || j == -1)
		i = Max(i, j);
	else
		i = Min(i, j);

	j = InStr(Text, "ftp.");
	if(i == -1 || j == -1)
		i = Max(i, j);
	else
		i = Min(i, j);

	j = InStr(Text, "telnet://");
	if(i == -1 || j == -1)
		i = Max(i, j);
	else
		i = Min(i, j);

	j = InStr(Text, "gopher://");
	if(i == -1 || j == -1)
		i = Max(i, j);
	else
		i = Min(i, j);

	bLink = 0;

	if(i == -1)
	{
		NextBlock = Text;
		Text = "";
	}
	else
	if(i == 0)
	{
		bLink = 1;

		i = InStr(Text, " ");
		if(i == -1)
		{
			NextBlock = Text;
			Text = "";
		}
		else
		{
			NextBlock = Left(Text, i);
			Text = Mid(Text, i);
		}
	}
	else
	{
		NextBlock = Left(Text, i);
		Text = Mid(Text, i);
	}

	TextAreaTextSize(C, NextBlock, W, H);
}
// -- SW

defaultproperties
{
}
