// ============================================================
// ThMenu.ThBrowserMainClientWindow: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThBrowserMainClientWindow expands UBrowserMainClientWindow;

function Created()
{
	local int i, f, j;
	local UWindowPageControlPage P;
	local UBrowserServerListWindow W;
	local class<UBrowserServerListWindow> C;
	local class<UBrowserFavoriteServers> FC;
	local class<UBrowserUpdateServerWindow> MC;
	local string NextWindowClass, NextWindowDesc;

	super(UWindowClientWindow).Created();
	LANTabName="UBrowserLAN";
	ServerListNames[0]='UBrowserThievery';
	ServerListNames[1]='UBrowserPopulatedThievery';
	ServerListNames[2]='UBrowserAll';
	ServerListNames[3]='UBrowserLAN';
	ServerListNames[4]='UBrowserThieveryCoop';
	ServerListNames[5]='UBrowserThieveryThiefmatch';
	ServerListNames[6]='';
	ServerListNames[7]='';
	ServerListNames[8]='';
	ServerListNames[9]='';

	InfoWindow = UBrowserInfoWindow(Root.CreateWindow(class'ThBrowserInfoWindow', 10, 40, 310, 170));
	InfoWindow.HideWindow();

	PageControl = UWindowPageControl(CreateWindow(class'UWindowPageControl', 0, 0, WinWidth, WinHeight));
	PageControl.SetMultiLine(True);

	// Add MOTD
	MC = class<UBrowserUpdateServerWindow>(DynamicLoadObject(UpdateServerClass, class'Class'));
	MOTD = PageControl.AddPage(MOTDName, MC);

	// SW --
	IRC = PageControl.AddPage(IRCName, class'ThBrowserIRCWindow');
	// -- SW

	// Add favorites
	FC = class<UBrowserFavoriteServers>(DynamicLoadObject(FavoriteServersClass, class'Class'));
	Favorites = PageControl.AddPage(FavoritesName, FC);

	C = class<UBrowserServerListWindow>(DynamicLoadObject(ServerListWindowClass, class'Class'));

	for(i=0; i<50; i++)
	{
		if(ServerListNames[i] == '')
			break;

		log("[thbrowserclient] adding page["$i$"] "$ServerListNames[i]);
		P = PageControl.AddPage("", C, ServerListNames[i]);
		if(string(ServerListNames[i]) ~= LANTabName)
			LANPage = P;

		W = UBrowserServerListWindow(P.Page);
		if(W.bHidden)
			PageControl.DeletePage(P);

		if (ServerListNames[i]=='UBrowserThievery') W.ServerListTitle="Thievery";
		if (ServerListNames[i]=='UBrowserLANThievery') W.ServerListTitle="Thievery LAN";
		if (ServerListNames[i]=='UBrowserPopulatedThievery') W.ServerListTitle="Thievery Populated";
		if (ServerListNames[i]=='UBrowserThieveryCoop') W.ServerListTitle="Thievery Co-op";
		if (ServerListNames[i]=='UBrowserThieveryThiefmatch') W.ServerListTitle="Thiefmatch";

		if(W.ServerListTitle != "")
			P.SetCaption(W.ServerListTitle);
		else
			P.SetCaption(Localize("ServerListTitles", string(ServerListNames[i]), "UBrowser"));

		FactoryWindows[i] = W;
	}

	// Load custom UBrowser pages
	if(i < 50)
	{
		j = 0;
		GetPlayerOwner().GetNextIntDesc(ServerListWindowClass, j, NextWindowClass, NextWindowDesc);
		while( NextWindowClass != "" && i < 50 )
		{
			C = class<UBrowserServerListWindow>(DynamicLoadObject(NextWindowClass, class'Class'));
			if( C != None )
			{
				ServerListNames[i] = '';
				P = PageControl.AddPage("", C);
				W = UBrowserServerListWindow(P.Page);
				if(W.bHidden)
					PageControl.DeletePage(P);
				if(W.ServerListTitle != "")
					P.SetCaption(W.ServerListTitle);
				else
					P.SetCaption(NextWindowDesc);
				FactoryWindows[i] = W;
				i++;
			}
			j++;
			GetPlayerOwner().GetNextIntDesc(ServerListWindowClass, j, NextWindowClass, NextWindowDesc);
		}
	}
}

function NewMasterServer(string M)
{
	local int i, j;
	local string NewServers[10];
	local string T;
	local bool bHadNewServer;

	i = 0;
	while(M != "")
	{
		j = InStr(M, Chr(13));
		log("* M="$M$" j="$j);
		if(j != -1)
		{
			T = Left(M, j);
			M = Mid(M, j+1);
		}
		else
		{
			T = M;
			M = "";
		}
		log("* T="$T$" i="$i);
		if(T != "")
			NewServers[i++] = T;
	}

	if(!bKeepMasterServer)
	{
		for(i=0; i<20; i++)
		{
			if(ServerListNames[i] == 'UBrowserAll')
			{
				bHadNewServer = False;
				for(j=0; j<9; j++)
				{
					if(FactoryWindows[i].ListFactories[j] != NewServers[j])
					{
						Log("Received new master server ["$j$"] from UpdateServer: "$NewServers[j]);
						FactoryWindows[i].ListFactories[j] = NewServers[j];
						FactoryWindows[i].ListFactories[j+1] = "";
						bHadNewServer = True;
					}
				}
				if(bHadNewServer)
				{
					if(FactoryWindows[i].bHadInitialRefresh)
						FactoryWindows[i].Refresh(False, True);
					FactoryWindows[i].SaveConfig();
				}
			}
		}
	}
}

defaultproperties
{
     ServerListWindowClass="ThMenu.ThBrowserServerListWindow"
     FavoriteServersClass="ThMenu.ThBrowserFavoriteServers"
     UpdateServerClass="ThMenu.ThBrowserUpdateServerWindow"
}
