// ============================================================
// ThieveryMod.ThBrowserServerPing: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThBrowserServerPing expands UBrowserServerPing;

var string	ThGameVersionText;

state GetStatus
{
	event ReceivedText( IpAddr Addr, string Text )
	{
		local string Value;
		local string In;
		local string Out;
		local byte ID;
		local bool bOK;
		local UBrowserPlayerList PlayerEntry;

		ValidateServer();

		In = Text;
		do
		{
			bOK = GetNextValue(In, Out, Value);
			In = Out;
			if(Left(Value, 7) == "player_")
			{
				ID = Int(Right(Value, Len(Value) - 7));

				PlayerEntry = Server.PlayerList.FindID(ID);
				if(PlayerEntry == None)
					PlayerEntry = UBrowserPlayerList(Server.PlayerList.Append(class'UBrowserPlayerList'));
				PlayerEntry.PlayerID = ID;

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry.PlayerName = Value;
			}
			else if(Left(Value, 6) == "frags_")
			{
				ID = Int(Right(Value, Len(Value) - 6));

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry = Server.PlayerList.FindID(ID);
				PlayerEntry.PlayerFrags = Int(Value);
			}
			else if(Left(Value, 5) == "ping_")
			{
				ID = Int(Right(Value, Len(Value) - 5));

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry = Server.PlayerList.FindID(ID);
				PlayerEntry.PlayerPing = Int(Right(Value, len(Value) - 1));  // leading space
			}
			else if(Left(Value, 5) == "team_")
			{
				ID = Int(Right(Value, Len(Value) - 5));

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry = Server.PlayerList.FindID(ID);
				PlayerEntry.PlayerTeam = LocalizeTeam(Value);
			}
			else if(Left(Value, 5) == "skin_")
			{
				ID = Int(Right(Value, Len(Value) - 5));

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry = Server.PlayerList.FindID(ID);
				PlayerEntry.PlayerSkin = LocalizeSkin(Value);
			}
			else if(Left(Value, 5) == "face_")
			{
				ID = Int(Right(Value, Len(Value) - 5));

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry = Server.PlayerList.FindID(ID);
				PlayerEntry.PlayerFace = GetItemName(Value);
			}
			else if(Left(Value, 5) == "mesh_")
			{
				ID = Int(Right(Value, Len(Value) - 5));

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry = Server.PlayerList.FindID(ID);
				PlayerEntry.PlayerMesh = Value;
			}
			else if(Left(Value, 9) == "ngsecret_")
			{
				ID = Int(Right(Value, Len(Value) - 9));

				bOK = GetNextValue(In, Out, Value);
				In = Out;
				PlayerEntry = Server.PlayerList.FindID(ID);
				PlayerEntry.PlayerStats = Value;
			}
			else if(Value == "final")
			{
				Server.StatusDone(True);
				return;
			}
			else if(Value ~= "gamever")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(GameVersionText, Value);
			}
			else if(Value ~= "minnetver")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(MinNetVersionText, Value);
			}
			else if(Value ~= "gametype")
			{
				bOK = GetNextValue(In, Out, Value);
				if (Value~="ThieveryDeathMatchPlus")
					Value="Thieves vs Guards";
				AddRule(GameTypeText, Value);
			}
/*			else if(Value ~= "gamemode") // "openplaying"
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(GameModeText, Value);
			}*/
			else if(Value ~= "timelimit")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(TimeLimitText, Value);
			}
			//else if(Value ~= "fraglimit")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(FragLimitText, Value);
			//}
			//else if(Value ~= "MultiplayerBots")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(MultiplayerBotsText, LocalizeBoolValue(Value));
			//}
			else if(Value ~= "AdminName")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(AdminNameText, Value);
			}
			else if(Value ~= "AdminEMail")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(AdminEmailText, Value);
			}
			//else if(Value ~= "WantWorldLog")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(WorldLogText, LocalizeBoolValue(Value));
			//}
			//else if(Value ~= "WorldLog")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//if( Server.GameVer >= 406 )
				//{
					//if( Value ~= "True" )
						//AddRule(WorldLogWorkingText, WorldLogWorkingTrue);
					//else
						//AddRule(WorldLogWorkingText, WorldLogWorkingFalse);
				//}
				//else
					//AddRule(WorldLogText, LocalizeBoolValue(Value));
			//}
			else if(Value ~= "mutators")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(MutatorsText, Value);
			}
			//else if(Value ~= "goalteamscore")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(GoalTeamScoreText, Value);
			//}
			//else if(Value ~= "minplayers")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//if(Value == "0")
					//AddRule(MultiplayerBotsText, FalseString);
				//else
					//AddRule(MinPlayersText, Value@PlayersText);
			//}
			else if(Value ~= "changelevels")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule(ChangeLevelsText, LocalizeBoolValue(Value));
			}
			//else if(Value ~= "botskill")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(BotSkillText, Value);
			//}
			//else if(Value ~= "maxteams")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(MaxTeamsText, Value);
			//}
			//else if(Value ~= "balanceteams")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(BalanceTeamsText, LocalizeBoolValue(Value));
			//}
			//else if(Value ~= "playersbalanceteams")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(PlayersBalanceTeamsText, LocalizeBoolValue(Value));
			//}
			//else if(Value ~= "friendlyfire")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(FriendlyFireText, Value);
			//}
			//else if(Value ~= "gamestyle")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(GameModeText, Value);
			//}
			//else if(Value ~= "tournament")
			//{
				//bOK = GetNextValue(In, Out, Value);
				//AddRule(TournamentText, LocalizeBoolValue(Value));
			//}
			else if(Value ~= "listenserver")
			{
				bOK = GetNextValue(In, Out, Value);
				if(bool(Value))
					AddRule(ServerModeText, NonDedicatedText);
				else
					AddRule(ServerModeText, DedicatedText);
			}
			else if(Value ~= "maxthiefcount")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("Thief team lives", Value);
			}
			else if(Value ~= "maxguardcount")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("Guard team lives", Value);
			}
			else if(Value ~= "thiefplayers")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("Thief players", Value);
			}
			else if(Value ~= "Guardplayers")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("Guard players", Value);
			}
			else if(Value ~= "thgamever")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("Thievery version", Value);
			}
			else if(Value ~= "thaiskill")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("AI skill", Value);
			}
			else if(Value ~= "thbalanceteams")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("Balance teams", LocalizeBoolValue(Value));
			}
			else if(Value ~= "thlootdrop")
			{
				bOK = GetNextValue(In, Out, Value);
				AddRule("% Loot dropped", Value);
			}
		} until(!bOK);
	}

	event Timer()
	{
		if(AttemptNumber < PingAttempts)
		{
			Log("Timed out getting player replies.  Attempt "$AttemptNumber);
			AttemptNumber++;
			GotoState(QueryState);
		}
		else
		{
			Server.StatusDone(False);
			Log("Timed out getting player replies.  Giving Up");
		}
	}
Begin:
	// Player info

	ValidateServer();
	if(Server.PlayerList != None)
	{
		Server.PlayerList.DestroyList();
	}
	Server.PlayerList = New(None) class'UBrowserPlayerList';
	Server.PlayerList.SetupSentinel();

	if(Server.RulesList != None)
	{
		Server.RulesList.DestroyList();
	}
	Server.RulesList = New(None) class'UBrowserRulesList';
	Server.RulesList.SetupSentinel();
	AddRule(ServerAddressText, "thievery://"$Server.IP$":"$string(Server.GamePort)); /* SW */

	SendText( ServerIPAddr, "\\status\\" );
	SetTimer(PingTimeout + FRand(), False);
}


state GetInfo
{
	event ReceivedText(IpAddr Addr, string Text)
	{
		local string Temp;
		local float ElapsedTime;

		// Make sure this packet really is for us.
		Temp = IpAddrToString(Addr);
		if(Server.IP != Left(Temp, InStr(Temp, ":")))
			return;

		ValidateServer();
		ElapsedTime = (Level.TimeSeconds - RequestSentTime) * Level.TimeDilation;
		Server.Ping = Max(1000*ElapsedTime - (0.5*LastDelta) - 10, 4); // subtract avg client and server frametime from ping.
		if(!Server.bKeepDescription)
			Server.HostName = Server.IP;
		Server.GamePort = 0;
		Server.MapName = "";
		Server.MapTitle = "";
		Server.MapDisplayName = "";
		Server.GameType = "";
		Server.GameMode = "";
		Server.NumPlayers = 0;
		Server.MaxPlayers = 0;
		Server.GameVer = 0;
		Server.MinNetVer = 0;

		Temp = ParseReply(Text, "hostname");
		if(Temp != "" && !Server.bKeepDescription)
			Server.HostName = Temp;

		Temp = ParseReply(Text, "hostport");
		if(Temp != "")
			Server.GamePort = Int(Temp);

		Temp = ParseReply(Text, "mapname");
		if(Temp != "")
			Server.MapName = Temp;

		Temp = ParseReply(Text, "maptitle");
		if(Temp != "")
		{
			Server.MapTitle = Temp;
			Server.MapDisplayName = Server.MapTitle;
			if(Server.MapTitle == "" || Server.MapTitle ~= "Untitled" || bUseMapName)
				Server.MapDisplayName = Server.MapName;
		}

		Temp = ParseReply(Text, "gametype");
		if(Temp != "")
			Server.GameType = Temp;

		Temp = ParseReply(Text, "numplayers");
		if(Temp != "")
			Server.NumPlayers = Int(Temp);

		Temp = ParseReply(Text, "maxplayers");
		if(Temp != "")
			Server.MaxPlayers = Int(Temp);

		Temp = ParseReply(Text, "gamemode");
		if(Temp != "")
			Server.GameMode = Temp;

		Temp = ParseReply(Text, "gamever");
		if(Temp != "")
			Server.GameVer = Int(Temp);

		Temp = ParseReply(Text, "minnetver");
		if(Temp != "")
			Server.MinNetVer = Int(Temp);

		Temp = ParseReply(Text, "maxthiefcount");
		if(Temp != "")
			ThBrowserServerList(Server).ThiefLives = Int(Temp);

		Temp = ParseReply(Text, "maxguardcount");
		if(Temp != "")
			ThBrowserServerList(Server).GuardLives = Int(Temp);

		Temp = ParseReply(Text, "thiefplayers");
		if(Temp != "")
			ThBrowserServerList(Server).ThiefPlayers = Int(Temp);

		Temp = ParseReply(Text, "guardplayers");
		if(Temp != "")
			ThBrowserServerList(Server).GuardPlayers = Int(Temp);

		Temp = ParseReply(Text, "thgamever");
		if(Temp != "")
			ThBrowserServerList(Server).ThGameVersion = Temp;

		if( Server.DecodeServerProperties(Text) )
		{
			Server.PingDone(bInitial, bJustThisServer, True, bNoSort);
			Disable('Tick');
		}
	}

	event Tick(Float DeltaTime)
	{
		LastDelta = DeltaTime;
	}

	event Timer()
	{
		ValidateServer();
		if(AttemptNumber < PingAttempts)
		{
			Log("Ping Timeout from "$Server.IP$".  Attempt "$AttemptNumber);
			AttemptNumber++;
			GotoState(QueryState);
		}
		else
		{
			Log("Ping Timeout from "$Server.IP$" Giving Up");

			Server.Ping = 9999;
			Server.GamePort = 0;
			Server.MapName = "";
			Server.MapDisplayName = "";
			Server.MapTitle = "";
			Server.GameType = "";
			Server.GameMode = "";
			Server.NumPlayers = 0;
			Server.MaxPlayers = 0;

			Disable('Tick');

			Server.PingDone(bInitial, bJustThisServer, False, bNoSort);
		}
	}

Begin:
	Enable('Tick');
	SendText( ServerIPAddr, "\\info\\" );
	RequestSentTime = Level.TimeSeconds;
	SetTimer(PingTimeout + FRand(), False);
}

defaultproperties
{
}
