// ============================================================
// ThMenu.ThGameMenu: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThGameMenu expands UWindowPulldownMenu;

var UWindowPulldownMenuItem Newgame, Training, Botmatch, Quit, ReturnToGame;

var localized string TrainingName;
var localized string TrainingHelp;
var localized string NewgameName;
var localized string NewgameHelp;
var localized string BotmatchName;
var localized string BotmatchHelp;
var localized string ReturnToGameName;
var localized string ReturnToGameHelp;
var localized string QuitName;
var localized string QuitHelp;
var localized string QuitTitle;
var localized string QuitText;
var localized string DemoQuitText;

var UWindowMessageBox ConfirmQuit;

function Created()
{
	Super.Created();

	// Add menu items.
	//Training = AddMenuItem(TrainingName, None);
	Botmatch = AddMenuItem(BotmatchName, None);
	AddMenuItem("-", None);
	ReturnToGame = AddMenuItem(ReturnToGameName, None);
	AddMenuItem("-", None);
	Quit = AddMenuItem(QuitName, None);
}


function ShowWindow()
{
	Super.ShowWindow();
	//ReturnToGame.bDisabled = GetLevel().Game != None && GetLevel().Game.IsA('SFIntro');
	ReturnToGame.bDisabled = GetLevel().Game == none;
}

function MessageBoxDone(UWindowMessageBox W, MessageBoxResult Result)
{
	if(W == ConfirmQuit && Result == MR_Yes)
		Root.QuitGame();
}

function ExecuteItem(UWindowPulldownMenuItem I)
{
	local string StartMap;
	local int EmptySlot, j;

	switch(I)
	{
	//case Training:
		// load up the training map
		//GetPlayerOwner().ClientTravel( "TH-Training.unr", TRAVEL_Absolute, False );
		//Root.Console.CloseUWindow();
		//break;
	case Botmatch:
		// Create botmatch dialog.
		Root.CreateWindow(class'ThMenuBotmatchWindow', 100, 100, 200, 200, Self, True);
		break;
	case Quit:
		ConfirmQuit = MessageBox(QuitTitle, QuitText, MB_YesNo, MR_No, MR_Yes);
		break;
	case ReturnToGame:
		Root.Console.CloseUWindow();
		break;
	}

	Super.ExecuteItem(I);
}

function Select(UWindowPulldownMenuItem I)
{
	switch(I)
	{
	//case Training:
//		ThMenuBar(GetMenuBar()).SetHelp(TrainingHelp);
//		break;
	case Botmatch:
		ThMenuBar(GetMenuBar()).SetHelp(BotmatchHelp);
		break;
	case Quit:
		ThMenuBar(GetMenuBar()).SetHelp(QuitHelp);
		break;
	case ReturnToGame:
		ThMenuBar(GetMenuBar()).SetHelp(ReturnToGameHelp);
		break;
	}

	Super.Select(I);
}

defaultproperties
{
     TrainingName="Start &Training"
     TrainingHelp="Learn how to control your thief"
     BotmatchName="&Start Solo Game"
     BotmatchHelp="Select to play a single player game"
     ReturnToGameName="Return to &Current Game"
     ReturnToGameHelp="Leave the menus and return to your current game.  Pressing the ESC key also returns you to the current game."
     QuitName="&Quit"
     QuitHelp="Select to save preferences and exit."
     QuitTitle="Confirm Quit"
     QuitText="Are you sure you want to Quit?"
}
