// ============================================================
// ThMenu.ThHelpMenu: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThHelpMenu expands UWindowPulldownMenu;

var UWindowPulldownMenuItem Context, Site, Credits;

var localized string ContextName;
var localized string ContextHelp;

var localized string SiteName;
var localized string SiteHelp;

var localized string CreditsName;
var localized string CreditsHelp;

function Created()
{
	Super.Created();

	Context = AddMenuItem(ContextName, None);
	AddMenuItem("-", None);
	Site = AddMenuItem(SiteName, None);
	Credits = AddMenuItem(CreditsName, None);
}

function ExecuteItem(UWindowPulldownMenuItem I)
{
	local ThMenuBar MenuBar;

	MenuBar = ThMenuBar(GetMenuBar());

	switch(I)
	{
	case Context:
		Context.bChecked = !Context.bChecked;
		MenuBar.ShowHelp = !MenuBar.ShowHelp;
		if (Context.bChecked)
		{
			if(ThRootWindow(Root) != None)
				if(ThRootWindow(Root).StatusBar != None)
					ThRootWindow(Root).StatusBar.ShowWindow();
		} else {
			if(ThRootWindow(Root) != None)
				if(ThRootWindow(Root).StatusBar != None)
					ThRootWindow(Root).StatusBar.HideWindow();
		}
		MenuBar.SaveConfig();
		break;
	case Site:
		GetPlayerOwner().ConsoleCommand("start http://www.thieveryut.com/");
		break;
	case Credits:
		GetPlayerOwner().ClientTravel( "UT-Thievery-Logo-Map.unr", TRAVEL_Absolute, False );
		Root.Console.CloseUWindow();
		break;
	}

	Super.ExecuteItem(I);
}

function Select(UWindowPulldownMenuItem I)
{
	switch(I)
	{
	case Context:
		ThMenuBar(GetMenuBar()).SetHelp(ContextHelp);
		break;
	case Site:
		ThMenuBar(GetMenuBar()).SetHelp(SiteHelp);
		break;
	case Credits:
		ThMenuBar(GetMenuBar()).SetHelp(CreditsHelp);
		break;
	}

	Super.Select(I);
}

defaultproperties
{
     ContextName="&Context Help"
     ContextHelp="Enable and disable this context help area at the bottom of the screen."
     SiteName="Thievery Site"
     SiteHelp="Display the Thievery website"
     CreditsName="Thievery Credits"
     CreditsHelp="Show credits"
}
