// ============================================================
// ThMenu.ThMenuNetworkClientWindow: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThMenuNetworkClientWindow expands UMenuNetworkClientWindow;

// Instant Rocket
var UWindowCheckbox	ClientInventoryCheck;
var localized string ClientInventoryText;
var localized string ClientInventoryHelp;

function Created()
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;

	Super.Created();

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	ClientInventoryCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, ControlWidth, 1));
	ClientInventoryCheck.bChecked = class'ThieveryMod.ThieveryConfigClient'.default.bClientsideInventory;
	ClientInventoryCheck.SetText(ClientInventoryText);
	ClientInventoryCheck.SetHelpText(ClientInventoryHelp);
	ClientInventoryCheck.SetFont(F_Normal);
	ClientInventoryCheck.Align = TA_Left;
	ControlOffset += 25;
}


function BeforePaint(Canvas C, float X, float Y)
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	ClientInventoryCheck.SetSize(ControlWidth, 1);
	ClientInventoryCheck.WinLeft = CenterPos;

	Super.BeforePaint(C, X, Y);
}

function Notify(UWindowDialogControl C, byte E)
{
	Super.Notify(C, E);

	switch(E)
	{
	case DE_Change:
		switch(C)
		{
		case ClientInventoryCheck:
			ClientInventoryChanged();
			break;
		}
	}
}

function ClientInventoryChanged() {
	class'ThieveryMod.ThieveryConfigClient'.default.bClientsideInventory=ClientInventoryCheck.bChecked;
	ThieveryPPawn(GetPlayerOwner()).SetClientSideInventory(class'ThieveryMod.ThieveryConfigClient'.default.bClientsideInventory);
}

function SaveConfigs()
{
	Super.SaveConfigs();
	class'ThieveryMod.ThieveryConfigClient'.static.StaticSaveConfig();
}

defaultproperties
{
     ClientInventoryText="Clientside Inventory"
     ClientInventoryHelp="The player scrolls though his items clientside, so is lag free.  Maybe be unstable."
}
