// ============================================================
// ThMenu.ThMenuOptionsClientWindow: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

#exec OBJ LOAD FILE=..\System\ThieveryMod.u PACKAGE=ThieveryMod

class ThMenuOptionsClientWindow expands UWindowDialogClientWindow
	config;

var UMenuPageControl Pages;
var UWindowSmallCloseButton CloseButton;

var localized string GamePlayTab, InputTab, ControlsTab, AudioTab, VideoTab, NetworkTab, HUDTab, DevTab;
var UWindowPageControlPage Network;

function Created() 
{
	Pages = UMenuPageControl(CreateWindow(class'UMenuPageControl', 0, 0, WinWidth, WinHeight - 48));
	Pages.SetMultiLine(True);
	Pages.AddPage(VideoTab, class'ThMenuVideoScrollClient');
	Pages.AddPage(AudioTab, class'ThMenuAudioScrollClient');
	
	//Pages.AddPage(GamePlayTab, class'UMenuGameOptionsScrollClient');
	// set defaults the game tab
	GetLevel().Game.SetGameSpeed(1.0);
	class'GameInfo'.default.bLowGore = false;
	class'GameInfo'.default.bVeryLowGore = false;
	GetPlayerOwner().UpdateBob(0);
	GetPlayerOwner().ChangeSetHand("Right");
	GetPlayerOwner().ChangeDodgeClickTime(-1.0);
	GetPlayerOwner().bNoFlash = true;
	GetLevel().Game.bLocalLog = false;
	
	Pages.AddPage(ControlsTab, class'ThMenuCustomizeScrollClient');
	Pages.AddPage(InputTab, class'ThMenuInputOptionsScrollClient');
	//Pages.AddPage(HUDTab, class'UMenuHUDConfigScrollClient');
	//Pages.AddPage(DevTab, class'ThieveryMod.ThieveryConfigClient');
	Network = Pages.AddPage(NetworkTab, class'ThMenuNetworkScrollClient');
	CloseButton = UWindowSmallCloseButton(CreateControl(class'UWindowSmallCloseButton', WinWidth-56, WinHeight-24, 48, 16));
	Super.Created();
}

function ShowNetworkTab()
{
	Pages.GotoTab(Network, True);
}

function Resized()
{
	Pages.WinWidth = WinWidth;
	Pages.WinHeight = WinHeight - 24;	// OK, Cancel area
	CloseButton.WinLeft = WinWidth-52;
	CloseButton.WinTop = WinHeight-20;
}

function Paint(Canvas C, float X, float Y)
{
	local Texture T;

	T = GetLookAndFeelTexture();
	DrawUpBevel( C, 0, LookAndFeel.TabUnselectedM.H, WinWidth, WinHeight-LookAndFeel.TabUnselectedM.H, T);
}

function GetDesiredDimensions(out float W, out float H)
{	
	Super(UWindowWindow).GetDesiredDimensions(W, H);
	H += 30;
}

defaultproperties
{
     GamePlayTab="Game"
     InputTab="Input"
     ControlsTab="Controls"
     AudioTab="Audio"
     VideoTab="Video"
     NetworkTab="Network"
     HUDTab="HUD"
     DevTab="Dev"
}
