// ============================================================
// ThMenu.ThMenuServerGameOptionsCW: rules tab

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThMenuServerGameOptionsCW expands UMenuPageWindow;

var UMenuBotmatchClientWindow BotmatchParent;

var bool Initialized;

// Time Limit
var UWindowEditControl TimeEdit;
var localized string TimeText;
var localized string TimeHelp;

var UWindowEditControl ThievesStartingLoot;
var localized string ThievesStartingLootText;
var localized string ThievesStartingLootHelp;

var UWindowEditControl GuardsStartingLoot;
var localized string GuardsStartingLootText;
var localized string GuardsStartingLootHelp;

var UWindowCheckbox OverrideMapSettingsCheck;
var localized string OverrideMapSettingsText;
var localized string OverrideMapSettingsHelp;

var UWindowComboControl AICombo;
var localized string AIText;
var localized string AIHelp;

var float ControlOffset;
var bool bControlRight;

var UWindowCheckbox UseTimeModCheck;
var localized string UseTimeModText;
var localized string UseTimeModHelp;

var UWindowCheckbox BalanceTeamsCheck;
var localized string BalanceTeamsText;
var localized string BalanceTeamsHelp;

var UWindowHSliderControl LootDroppedSlider;
var localized string LootDroppedText;
var localized string LootDroppedHelp;

var UWindowCheckbox DeadChatCheck;
var localized string DeadChatText;
var localized string DeadChatHelp;

var UWindowHSliderControl VotePercentSlider;
var localized string VotePercentText;
var localized string VotePercentHelp;

var UWindowHSliderControl MaxOrderedBotsSlider;
var localized string MaxOrderedBotsText;
var localized string MaxOrderedBotsHelp;

var UWindowCheckbox ThiefStyleBlindnessCheck;
var localized string ThiefStyleBlindnessText;
var localized string ThiefStyleBlindnessHelp;

var UWindowCheckbox SupplyChestCheck;
var localized string SupplyChestText;
var localized string SupplyChestHelp;

var UWindowEditControl PregameWaitTime;
var localized string PregameWaitText;
var localized string PregameWaitHelp;

function Created()
{
	local int S;
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos, ButtonWidth, ButtonLeft;

	Super.Created();

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	ButtonWidth = WinWidth - 140;
	ButtonLeft = WinWidth - ButtonWidth - 40;

	BotmatchParent = UMenuBotmatchClientWindow(GetParent(class'UMenuBotmatchClientWindow'));
	if (BotmatchParent == None)
		Log("Error: UMenuStartMatchClientWindow without UMenuBotmatchClientWindow parent.");



	// Time Limit
	TimeEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', ControlRight, ControlOffset, ControlWidth, 1));
	TimeEdit.SetText(TimeText);
	TimeEdit.SetHelpText(TimeHelp);
	TimeEdit.SetFont(F_Normal);
	TimeEdit.SetNumericOnly(True);
	TimeEdit.SetMaxLength(3);
	TimeEdit.Align = TA_Right;
	ControlOffset += 25;

	UseTimeModCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	UseTimeModCheck.SetText(UseTimeModText);
	UseTimeModCheck.SetHelpText(UseTimeModHelp);
	UseTimeModCheck.SetFont(F_Normal);
	UseTimeModCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bUseTimeModifier;
	UseTimeModCheck.Align = TA_Right;
	ControlOffset += 35;

	BalanceTeamsCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	BalanceTeamsCheck.SetText(BalanceTeamsText);
	BalanceTeamsCheck.SetHelpText(BalanceTeamsHelp);
	BalanceTeamsCheck.SetFont(F_Normal);
	BalanceTeamsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bBalanceTeams;
	BalanceTeamsCheck.Align = TA_Right;
	//ControlOffset += 25;
	BalanceTeamsCheck.HideWindow();

	DeadChatCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	DeadChatCheck.SetText(DeadChatText);
	DeadChatCheck.SetHelpText(DeadChatHelp);
	DeadChatCheck.SetFont(F_Normal);
	DeadChatCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bNoDeadChat;
	DeadChatCheck.Align = TA_Right;
	ControlOffset += 25;


	// AI Skill
	AICombo=UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	AICombo.SetButtons(True);
	AICombo.SetText(AIText);
	AICombo.SetHelpText(AIHelp);
	AICombo.SetFont(F_Normal);
	AICombo.SetEditable(False);
	AICombo.AddItem("Genius");
	AICombo.AddItem("Clever");
	AICombo.AddItem("Normal");
	AICombo.AddItem("Stupid");
	AICombo.AddItem("Benny");
	AICombo.SetSelectedIndex(int(4.0-(class'ThieveryMod.ThieveryGameSettings'.default.AISkill*4.0)));
	ControlOffset += 25;

	//MaxOrderedBots
	MaxOrderedBotsSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', ControlLeft, ControlOffset, ControlWidth*2, 1));
	MaxOrderedBotsSlider.SetRange(-1,20, 1);
	MaxOrderedBotsSlider.SetValue(int(GetPlayerOwner().ConsoleCommand("GET ThieveryAI.TBot MaxOrderedBots")));
	MaxOrderedBotsSlider.Align = TA_Right;
	MaxOrderedBotsSlider.SetFont(F_Normal);
	if (MaxOrderedBotsSlider.Value<0) {
		MaxOrderedBotsSlider.SetText("Infinite - "$MaxOrderedBotsText);
	} else if (MaxOrderedBotsSlider.Value==0) {
		MaxOrderedBotsSlider.SetText("None - "$MaxOrderedBotsText);
	} else {
		MaxOrderedBotsSlider.SetText(int(MaxOrderedBotsSlider.Value)$" - "$MaxOrderedBotsText);
	}
	MaxOrderedBotsSlider.SetHelpText(MaxOrderedBotsHelp);
	ControlOffset += 25;

	ThiefStyleBlindnessCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	ThiefStyleBlindnessCheck.SetText(ThiefStyleBlindnessText);
	ThiefStyleBlindnessCheck.SetHelpText(ThiefStyleBlindnessHelp);
	ThiefStyleBlindnessCheck.SetFont(F_Normal);
	ThiefStyleBlindnessCheck.bChecked = bool(GetPlayerOwner().ConsoleCommand("GET ThieveryAI.TBot bThiefStyleBlinded"));
	ThiefStyleBlindnessCheck.Align = TA_Right;

	ControlOffset += 35;

		OverrideMapSettingsCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	OverrideMapSettingsCheck.SetText(OverrideMapSettingsText);
	OverrideMapSettingsCheck.SetHelpText(OverrideMapSettingsHelp);
	OverrideMapSettingsCheck.SetFont(F_Normal);
	OverrideMapSettingsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bOverrideMapSettings;
	OverrideMapSettingsCheck.Align = TA_Right;
	ControlOffset += 25;

	// loot
	ThievesStartingLoot = UWindowEditControl(CreateControl(class'UWindowEditControl', ControlLeft, ControlOffset, ControlWidth, 1));
	ThievesStartingLoot.SetText(ThievesStartingLootText);
	ThievesStartingLoot.SetHelpText(ThievesStartingLootHelp);
	ThievesStartingLoot.SetFont(F_Normal);
	ThievesStartingLoot.SetNumericOnly(True);
	ThievesStartingLoot.SetMaxLength(4);
	ThievesStartingLoot.Align = TA_Right;
	ControlOffset += 25;

	GuardsStartingLoot = UWindowEditControl(CreateControl(class'UWindowEditControl', ControlLeft, ControlOffset, ControlWidth, 1));
	GuardsStartingLoot.SetText(GuardsStartingLootText);
	GuardsStartingLoot.SetHelpText(GuardsStartingLootHelp);
	GuardsStartingLoot.SetFont(F_Normal);
	GuardsStartingLoot.SetNumericOnly(True);
	GuardsStartingLoot.SetMaxLength(4);
	GuardsStartingLoot.Align = TA_Right;
	ControlOffset += 25;

	LootDroppedSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', ControlLeft, ControlOffset, ControlWidth*2, 1));
	LootDroppedSlider.SetRange(0,100, 5);
	LootDroppedSlider.SetValue(int(class'ThieveryMod.ThieveryGameSettings'.default.PercentageLootDropped*100));
	LootDroppedSlider.Align = TA_Right;
	LootDroppedSlider.SetFont(F_Normal);
	LootDroppedSlider.SetText(int(LootDroppedSlider.Value)$LootDroppedText);
	LootDroppedSlider.SetHelpText(LootDroppedHelp);
	ControlOffset += 25;

	VotePercentSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', ControlLeft, ControlOffset, ControlWidth*2, 1));
	VotePercentSlider.SetRange(0,100, 5);
	VotePercentSlider.SetValue(int(class'ThieveryMod.ThieveryGameSettings'.default.PercentageToPassVote*100));
	VotePercentSlider.Align = TA_Right;
	VotePercentSlider.SetFont(F_Normal);
	VotePercentSlider.SetText(int(VotePercentSlider.Value)$VotePercentText);
	VotePercentSlider.SetHelpText(VotePercentHelp);

	ControlOffset += 25;


	SupplyChestCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	SupplyChestCheck.SetText(SupplyChestText);
	SupplyChestCheck.SetHelpText(SupplyChestHelp);
	SupplyChestCheck.SetFont(F_Normal);
	SupplyChestCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bUseSupplyChest;
	SupplyChestCheck.Align = TA_Right;

	ControlOffset += 25;

	// pregame wait
	PregameWaitTime = UWindowEditControl(CreateControl(class'UWindowEditControl', ControlLeft, ControlOffset, ControlWidth, 1));
	PregameWaitTime.SetText(PregameWaitText);
	PregameWaitTime.SetHelpText(PregameWaitHelp);
	PregameWaitTime.SetFont(F_Normal);
	PregameWaitTime.SetNumericOnly(True);
	PregameWaitTime.SetMaxLength(2);
	PregameWaitTime.Align = TA_Right;
	ControlOffset += 25;

}

function AfterCreate()
{
	Super.AfterCreate();

	DesiredWidth = 270;
	DesiredHeight = ControlOffset + 50;

	LoadCurrentValues();
	Initialized = True;
}


function LoadCurrentValues()
{
	ThievesStartingLoot.SetValue(string(class'ThieveryMod.ThieveryGameSettings'.default.ThievesStartMoney));
	GuardsStartingLoot.SetValue(string(class'ThieveryMod.ThieveryGameSettings'.default.GuardStartMoney));

	TimeEdit.SetValue(string(class'ThieveryMod.ThieveryGameSettings'.default.TimeLimit));

	OverrideMapSettingsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bOverrideMapSettings;
	UseTimeModCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bUseTimeModifier;
	BalanceTeamsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bBalanceTeams;
	DeadChatCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bNoDeadChat;
	LootDroppedSlider.Value=int(FClamp(class'ThieveryMod.ThieveryGameSettings'.default.PercentageLootDropped,0,1.0)*100);
	VotePercentSlider.Value=int(FClamp(class'ThieveryMod.ThieveryGameSettings'.default.PercentageToPassVote,0,1.0)*100);
	MaxOrderedBotsSlider.Value=int(GetPlayerOwner().ConsoleCommand("GET ThieveryAI.TBot MaxOrderedBots"));
	ThiefStyleBlindnessCheck.bChecked=bool(GetPlayerOwner().ConsoleCommand("GET ThieveryAI.TBot bThiefStyleBlinded"));
	SupplyChestCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bUseSupplyChest;
	PregameWaitTime.SetValue(string(class'ThieveryMod.ThieveryGameSettings'.default.nPregameWaitTime));
}

function BeforePaint(Canvas C, float X, float Y)
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos, ButtonWidth, ButtonLeft;

	Super.BeforePaint(C, X, Y);

	ControlWidth = WinWidth/1.3;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	ThievesStartingLoot.SetSize(ControlWidth, 1);
	ThievesStartingLoot.WinLeft = CenterPos;
	ThievesStartingLoot.EditBoxWidth = 33;


	GuardsStartingLoot.SetSize(ControlWidth, 1);
	GuardsStartingLoot.WinLeft = CenterPos;
	GuardsStartingLoot.EditBoxWidth = 33;

	PregameWaitTime.SetSize(ControlWidth, 1);
	PregameWaitTime.WinLeft = CenterPos;
	PregameWaitTime.EditBoxWidth = 33;

	TimeEdit.SetSize(ControlWidth, 1);
	TimeEdit.WinLeft = CenterPos;
	TimeEdit.EditBoxWidth = 25;

	OverrideMapSettingsCheck.SetSize(ControlWidth, 1);
	OverrideMapSettingsCheck.WinLeft = CenterPos;

	SupplyChestCheck.SetSize(ControlWidth, 1);
	SupplyChestCheck.WinLeft = CenterPos;

	UseTimeModCheck.SetSize(ControlWidth, 1);
	UseTimeModCheck.WinLeft = CenterPos;

	AICombo.SetSize(ControlWidth, 1);
	AICombo.WinLeft = CenterPos;

	MaxOrderedBotsSlider.SetSize(ControlWidth, 1);
	MaxOrderedBotsSlider.WinLeft=CenterPos;

	BalanceTeamsCheck.SetSize(ControlWidth, 1);
	BalanceTeamsCheck.WinLeft = CenterPos;

	DeadChatCheck.SetSize(ControlWidth, 1);
	DeadChatCheck.WinLeft = CenterPos;

	LootDroppedSlider.SetSize(ControlWidth, 1);
	LootDroppedSlider.WinLeft=CenterPos;

	VotePercentSlider.SetSize(ControlWidth, 1);
	VotePercentSlider.WinLeft=CenterPos;

	ThiefStyleBlindnessCheck.SetSize(ControlWidth, 1);
	ThiefStyleBlindnessCheck.WinLeft=CenterPos;
}

function Notify(UWindowDialogControl C, byte E)
{
	if (!Initialized)
		return;

	Super.Notify(C, E);

	switch(E)
	{
	case DE_Change:
		switch(C)
		{
			case ThievesStartingLoot:
				ThievesLootChanged();
				break;
			case TimeEdit:
				TimeChanged();
				break;
			case GuardsStartingLoot:
				GuardsLootChanged();
				break;
			case OverrideMapSettingsCheck:
				OverrideMapChecked();
				break;
			case SupplyChestCheck:
				SupplyChestChecked();
				break;
			case UseTimeModCheck:
				TimeModChecked();
				break;
			case AICombo:
				AIComboChanged();
				break;
			case BalanceTeamsCheck:
				BalanceTeamsChanged();
				break;
			case DeadChatCheck:
				DeadChatChanged();
				break;
			case LootDroppedSlider:
				LootDroppedChanged();
				break;
			case VotePercentSlider:
				VotePercentChanged();
				break;
			case MaxOrderedBotsSlider:
				MaxOrderedBotsChanged();
				break;
			case ThiefStyleBlindnessCheck:
				ThiefStyleBlindnessChanged();
				break;
			case PregameWaitTime:
				PregameWaitTimeChanged();
		}
	}
}

function PregameWaitTimeChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.nPregameWaitTime=int(PregameWaitTime.GetValue());
}

function ThievesLootChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.ThievesStartMoney=int(ThievesStartingLoot.GetValue());
}

function TimeChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.TimeLimit=int(TimeEdit.GetValue());
}

function GuardsLootChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.GuardStartMoney=int(GuardsStartingLoot.GetValue());
}

function OverrideMapChecked() {
	class'ThieveryMod.ThieveryGameSettings'.default.bOverrideMapSettings=OverrideMapSettingsCheck.bChecked;
}

function SupplyChestChecked()
{
	class'ThieveryMod.ThieveryGameSettings'.default.bUseSupplyChest=SupplyChestCheck.bChecked;
}

function TimeModChecked()
{
	class'ThieveryMod.ThieveryGameSettings'.default.bUseTimeModifier=UseTimeModCheck.bChecked;
}

function AIComboChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.AISkill=((4.0-AICombo.GetSelectedIndex())/4.0);
}

function BalanceTeamsChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.bBalanceTeams=BalanceTeamsCheck.bChecked;
}

function DeadChatChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.bNoDeadChat=DeadChatCheck.bChecked;
}

function LootDroppedChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.PercentageLootDropped=LootDroppedSlider.Value/100.0;
	LootDroppedSlider.SetText(int(LootDroppedSlider.Value)$LootDroppedText);
}


function VotePercentChanged()
{
	class'ThieveryMod.ThieveryGameSettings'.default.PercentageToPassVote=VotePercentSlider.Value/100.0;
	VotePercentSlider.SetText(int(VotePercentSlider.Value)$VotePercentText);
}

function MaxOrderedBotsChanged() {
  GetPlayerOwner().ConsoleCommand("SET ThieveryAI.TBot MaxOrderedBots "$MaxOrderedBotsSlider.Value);
	if (MaxOrderedBotsSlider.Value<0) {
		MaxOrderedBotsSlider.SetText("Infinite - "$MaxOrderedBotsText);
	} else if (MaxOrderedBotsSlider.Value==0) {
		MaxOrderedBotsSlider.SetText("None - "$MaxOrderedBotsText);
	} else {
		MaxOrderedBotsSlider.SetText(int(MaxOrderedBotsSlider.Value)$" - "$MaxOrderedBotsText);
	}
}

function ThiefStyleBlindnessChanged() {
	GetPlayerOwner().ConsoleCommand("SET ThieveryAI.TBot bThiefStyleBlinded "$ThiefStyleBlindnessCheck.bChecked);
}

function SaveConfigs()
{
	Super.SaveConfigs();
	if (BotmatchParent!=none && BotMatchParent.GameClass!=none) BotmatchParent.GameClass.static.StaticSaveConfig();
	if (GetPlayerOwner()!=none) GetPlayerOwner().SaveConfig();
	class'ThieveryMod.ThieveryGameSettings'.static.StaticSaveConfig();
}

defaultproperties
{
     TimeText="Time Limit"
     TimeHelp="The game will end if after this many minutes. A value of 0 sets no time limit."
     ThievesStartingLootText="Thieves Start Gold"
     ThievesStartingLootHelp="How much loot the thieves start the game with"
     GuardsStartingLootText="Guard Start Gold"
     GuardsStartingLootHelp="How much loot the guards start the game with"
     OverrideMapSettingsText="Override Map's Gold Settings"
     OverrideMapSettingsHelp="If checked, these server settings will override any set by the mapper"
     AIText="AI Skill"
     AIHelp="How clever and strong the AI controlled guards are"
     ControlOffset=20.000000
     UseTimeModText="Use Map's Time Modifier"
     UseTimeModHelp="Mappers can set a modifier to the time limit, so that bigger maps last longer then smaller ones"
     BalanceTeamsText="Balance Teams"
     BalanceTeamsHelp="Makes sure there are an equal number of thief/guard human players"
     LootDroppedText="% loot dropped on death"
     LootDroppedHelp="What % of the thief's loot is dropped when he dies"
     DeadChatText="No dead to live chat"
     DeadChatHelp="Stops dead people from speaking to live people"
     VotePercentText="% to pass votes"
     VotePercentHelp="The required % of human place to vote yes for a particular vote to pass"
     MaxOrderedBotsText="Max following bots"
     MaxOrderedBotsHelp="The maximum number of bots that a player can have following him"
     ThiefStyleBlindnessText="AI stand still when blinded"
     ThiefStyleBlindnessHelp="If checked, the AI will stand still when blinded"
     SupplyChestText="Supply chest"
     SupplyChestHelp="If checked, the guards get a supply chest to recover flares and bolts"
     PregameWaitText="Pregame wait time"
     PregameWaitHelp="How long to wait while people pick teams before starting the round"
}
